document.addEventListener("DOMContentLoaded", function () {
    const filterButtons = document.querySelectorAll("#filter-buttons button");
    const filterableCards = document.querySelectorAll("#filterable-cards .card");

    // Function to filter cards based on filter buttons
    const filterCards = (filter) => {
        filterableCards.forEach(card => {
            if (card.dataset.name === filter || filter === "all") {
                card.classList.remove("hide");
            } else {
                card.classList.add("hide");
            }
        });
    }

    // Set the default filter to "videos"
    filterCards("videos");

    filterButtons.forEach(button => button.addEventListener("click", function () {
        // Remove "active" class from all buttons
        filterButtons.forEach(btn => btn.classList.remove("active"));
        // Add "active" class to the clicked button
        button.classList.add("active");

        // Call filterCards with the selected filter
        filterCards(button.dataset.filter);
    }));
});