<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'te', version '4.3'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'చర్యలు';
$string['activate'] = 'ఎనేబుల్  యాక్సెస్';
$string['activatesuccess'] = 'విజయవంతంగా బ్యాడ్జెస్  సౌలభ్యం ఎనేబుల్ చేయబడింది.';
$string['addbadgecriteria'] = 'బ్యాడ్జ్ క్రైటీరియాను జోడించండి';
$string['addcourse'] = 'కోర్సులు జోడించండి';
$string['addcourse_help'] = 'ఈ బ్యాడ్జ్ అవసరాన్ని జోడించిన ఉండాలని అన్ని కోర్సులు ఎంచుకోండి. బహుళ అంశాలను ఎంచుకోండి CTRL కీని నొక్కి ఉంచండి.';
$string['addcriteria'] = 'ప్రమాణాన్ని జోడించండి';
$string['addcriteriatext'] = 'ప్రమాణం జోడించడం ప్రారంభించడానికి, డ్రాప్-డౌన్ మెను నుండి ఎంపికలు ఒకటి ఎంచుకోండి దయచేసి';
$string['addtobackpack'] = 'బ్యాగ్ ప్యాక్ కి   జోడించండి';
$string['adminonly'] = 'ఈ పేజీని సైట్ నిర్వాహకులు మాత్రమే పరిమితం.';
$string['after'] = 'ఇష్యూ చేసిన తేది తర్వాత.';
$string['aggregationmethod'] = 'అగ్రిగేషన్ పద్ధతి';
$string['all'] = 'అన్నీ';
$string['allmethod'] = 'ఎంచుకున్న అన్ని నింబంధనలు / షరతులు నెరవేరాయి.';
$string['allmethodactivity'] = 'ఎంచుకున్న అన్ని యాక్టివిటీస్ పూర్తయ్యాయి.';
$string['allmethodcourseset'] = 'ఎంచుకున్న అన్ని కోర్సులు పూర్తయ్యాయి.';
$string['allmethodmanual'] = 'ఎంపిక చేసుకున్న రోల్స్ అన్నీ  బ్యాడ్జ్  బహుకరిస్తాయి.';
$string['allmethodprofile'] = 'ఎంపిక చేసుకున్న అన్ని ప్రొఫైల్ ఫీల్డ్స్ ను పూర్తి చేయడం జరిగింది';
$string['allowcoursebadges'] = 'కోర్సు  బ్యాడ్జెస్ ను ఎనేబుల్  చెయ్యండి.';
$string['allowcoursebadges_desc'] = 'అనుమతించు బ్యాడ్జ్లు రూపొందించినవారు మరియు కోర్సు సందర్భంలో పురస్కారం పొందిన.';
$string['allowexternalbackpack'] = 'ఎక్స్ టర్నల్ బ్యాక్ బ్యాక్  కు  అనుసంధానించడాన్ని అనుమతించు';
$string['allowexternalbackpack_desc'] = 'వినియోగదారులు వారి బాహ్య బ్యాక్ ప్రొవైడర్ల నుండి కనెక్షన్లను సెటప్ చేయడానికి మరియు బ్యాడ్జ్లను ప్రదర్శించడానికి అనుమతించండి.

గమనిక: ఇంటర్నెట్ నుండి ఇంటర్నెట్ను యాక్సెస్ చేయలేకపోతే (ఉదా: ఫైర్వాల్ కారణంగా) ఈ ఎంపికను నిలిపివేయడం మంచిది.';
$string['any'] = 'ఏవైనా / ఏదైనా';
$string['anymethod'] = 'ఎంచుకున్న నిబంధనలు / షరతుల్లో ఏవైనా అంగీకార పూర్వకంగా ఉన్నాయా';
$string['anymethodactivity'] = 'ఎంచుకున్న యాక్టివిటీస్ ఏవైనా పూర్తయ్యాయా';
$string['anymethodcourseset'] = 'ఎంచుకున్న కోర్సులు ఏవైనా పూర్తయ్యాయా';
$string['anymethodmanual'] = 'ఎంచుకున్న రోల్స్  ఏవైనా బ్యాడ్జ్ బహూకరిస్తాయా';
$string['anymethodprofile'] = 'ఎంచుకున్న ప్రొఫైల్ రంగాలలో ఏ పూర్తయ్యాయి';
$string['archivebadge'] = 'మీరు \'{$ a}\', కానీ ఉంచేందుకు జారీ బ్యాడ్జ్లు ఇప్పటికే బ్యాడ్జ్ తొలగించాలనుకుంటున్నారా?';
$string['archiveconfirm'] = 'తొలగించు మరియు ఇప్పటికే జారీ బ్యాడ్జ్లు ఉంచడానికి';
$string['archivehelp'] = '<p> ఈ ఐచ్చికము బ్యాడ్జ్ "రిటైర్డ్" గుర్తించబడతాయి మరియు ఇకపై బ్యాడ్జ్లు జాబితాలో కనిపిస్తుంది అర్థం. వినియోగదారులు ఇకపై అయితే ఇప్పటికే బ్యాడ్జ్ గ్రహీతలు ఇప్పటికీ వారి ప్రొఫైల్ పేజీలో ఈ బ్యాడ్జ్ ప్రదర్శించడానికి మరియు వారి బాహ్య బ్యాక్ దానిని తోస్తాయి చెయ్యగలరు, ఈ బ్యాడ్జ్ సంపాదించడానికి చెయ్యగలరు. </ P>
మీరు సంపాదించారు బ్యాడ్జ్లు యాక్సెస్ పొందగలిగేలా మీ వినియోగదారులు కావాలనుకుంటే <p> ఇది పూర్తిగా బ్యాడ్జ్లు తొలగించడం బదులుగా ఈ ఎంపికను ఎంచుకోండి ముఖ్యం. </ p>';
$string['attachment'] = 'సందేశానికి బ్యాడ్జ్ అటాచ్ చేసుకోండీ';
$string['attachment_help'] = 'ప్రారంభించబడితే, జారీ బ్యాడ్జ్ ఫైలు డౌన్ లోడ్ కోసం గ్రహీత యొక్క ఇమెయిల్ జత చేయబడుతుంది. (అటాచ్మెంట్లు> ప్లగిన్లు> సందేశ ఉద్గాతాలు> ఇమెయిల్ ఈ ఎంపికను ఉపయోగించడానికి సైట్ పరిపాలనలో ఎనేబుల్ చెయ్యాలి.)';
$string['award'] = 'బ్యాడ్జ్ ను బహూకరించు';
$string['awardedtoyou'] = 'నాకు జారీ చేయబడింది';
$string['awardoncron'] = 'బ్యాడ్జ్లు యాక్సెస్ విజయవంతంగా కల్పించబడింది. చాలా మంది వినియోగదారులను తక్షణమే ఈ బ్యాడ్జ్ సంపాదించవచ్చు. సైట్ పనితీరు నిర్ధారించడానికి, ఈ చర్య ప్రాసెస్ కొంత సమయం పడుతుంది.';
$string['awards'] = 'స్వీకర్తలు';
$string['backpackavailability'] = 'బయటి బ్యాడ్జ్ ధృవీకరణ';
$string['backpackavailability_help'] = '';
$string['backpackcannotsendverification'] = 'ధృవీకరణ ఇమెయిల్ పంపలేరు';
$string['backpackconnection'] = 'బ్యాక్ ప్యాక్ కనెక్షన్';
$string['backpackconnection_help'] = '';
$string['backpackconnectioncancelattempt'] = 'విభిన్న ఇమెయిల్ చిరునామాను ఉపయోగించి కనెక్ట్ చేయండి';
$string['backpackconnectionconnect'] = 'బ్యాక్ప్యాక్కు కనెక్ట్ చేయండి';
$string['backpackconnectionresendemail'] = 'ధృవీకరణ ఇమెయిల్ను మళ్ళీ పంపు';
$string['backpackconnectionunexpectedresult'] = 'బ్యాక్ప్యాక్కు కనెక్ట్ చేయడంలో సమస్య ఉంది. దయచేసి మళ్ళీ ప్రయత్నించండి. <br><br> సమస్య కొనసాగితే, మీ నిర్వాహకుడిని సంప్రదించండి.';
$string['backpackdetails'] = 'బ్యాక్ ప్యాక్ సెట్టింగ్స్ / అమరికలు';
$string['backpackemail'] = 'ఈమెయిల్';
$string['backpackemail_help'] = 'మీ బ్యాక్ ప్యాక్ తో అనుసంధానించబడిన ఈమెయిల్. మీరు కనెక్ట్ అయ్యి ఉన్నపుడు, ఈ సైట్ లో సంపాదించిన ఏ బ్యాడ్జ్ అయినా  ఈ ఇమెయిల్ తో అనుసంధానించబడి ఉంటుంది.';
$string['backpackemailverificationpending'] = 'ధృవీకరణ పెండింగ్లో ఉంది';
$string['backpackemailverifyemailbody'] = 'హి

మీ OpenBadges backpack కు క్రొత్త కనెక్షన్ మీ ఇమెయిల్ చిరునామాను ఉపయోగించి \'{$a->sitename}\' నుండి అభ్యర్థించబడింది.

బ్యాక్ప్యాక్కు కనెక్షన్ను నిర్ధారించి సక్రియం చేయడానికి, దయచేసి వెళ్లండి

{$a->link}

చాలా మెయిల్ కార్యక్రమాలలో, ఇది నీలం లింక్గా కనిపిస్తుంది, మీరు క్లిక్ చెయ్యవచ్చు. అది పనిచేయకపోతే, మీ వెబ్ బ్రౌసర్ ఎగువ చిరునామా అడ్రసుకు కత్తిరించండి మరియు అతికించండి.

మీరు సహాయం కావాలనుకుంటే, దయచేసి సైట్ నిర్వాహకుడిని సంప్రదించండి,
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: OpenBadges బ్యాక్ ఇమెయిల్ ధృవీకరణ';
$string['backpackemailverifypending'] = 'ధృవీకరణ ఇమెయిల్ <strong> {$a} </ strong> కు పంపబడింది. మీ Backpack కనెక్షన్ను సక్రియం చేయడానికి ఇమెయిల్లోని ధృవీకరణ లింక్పై క్లిక్ చేయండి.';
$string['backpackemailverifysuccess'] = 'మీ ఇమెయిల్ చిరునామాను ధృవీకరించినందుకు ధన్యవాదాలు. మీరు ఇప్పుడు మీ బ్యాక్ప్యాక్కు కనెక్ట్ చేయబడ్డారు.';
$string['backpackemailverifytokenmismatch'] = 'మీరు క్లిక్ చేసిన లింక్లో టోకెన్ నిల్వ టోకెన్తో సరిపోలడం లేదు. మీరు అందుకున్న తాజా ఇమెయిల్లో లింక్ను క్లిక్ చేసారని నిర్ధారించుకోండి.';
$string['backpackimport'] = 'బ్యాడ్జ్ దిగుమతి సెట్టింగ్స్';
$string['backpackimport_help'] = '';
$string['badgedetails'] = 'బ్యాడ్జ్ వివరాలు';
$string['badgeimage'] = 'చిత్రం';
$string['badgeimage_help'] = 'ఈ బ్యాడ్జ్ జారీ చేసినప్పుడు ఉపయోగపడే ఒక చిత్రం ఉంది.

ఒక కొత్త చిత్రాన్ని జోడించండి బ్రౌజ్ మరియు (JPG లేదా PNG ఫార్మాట్ లో) ఒక చిత్రాన్ని ఎంచుకోండి, ఆపై "మార్పులను సేవ్ చెయ్యి" క్లిక్ చేయండి. చిత్రం ఒక చదరపు కత్తిరించే మరియు బ్యాడ్జ్ చిత్రం అవసరాలు మ్యాచ్ పరిమాణం చేయబడుతాయి.';
$string['badgeprivacysetting'] = 'బ్యాడ్జ్ గోప్యతా సెట్టింగ్లను';
$string['badgeprivacysetting_help'] = 'మీరు సంపాదిస్తారు Badges మీ ఖాతా ప్రొఫైల్ పేజీలో ప్రదర్శించబడతాయి. ఈ సెట్టింగ్ మీరు స్వయంచాలకంగా కొత్తగా సంపాదించారు బ్యాడ్జ్లను ప్రత్యక్షతను సెట్ అనుమతిస్తుంది.

మీరు ఇప్పటికీ మీ Badges పేజీలో వ్యక్తిగత బ్యాడ్జ్ గోప్యతా సెట్టింగ్లను నియంత్రించడానికి చేయవచ్చు.';
$string['badgeprivacysetting_str'] = 'ఆటోమేటిక్గా  నా ప్రొఫైల్ పేజీలో  బ్యాడ్జ్లను చూపించు.';
$string['badges'] = 'బ్యాడ్జ్లు';
$string['badgesalt'] = 'గ్రహీత యొక్క ఇమెయిల్ చిరునామాను హాషింగ్ చేయడానికి ఉప్పు';
$string['badgesalt_desc'] = 'తగిలించుకునే బ్యాగులో సేవలు హాష్ అనుమతిస్తుంది ఉపయోగించి వారి ఇమెయిల్ చిరునామా బహిర్గతం చేయకుండా బ్యాడ్జ్ ఆదాయం నిర్ధారించడానికి. ఈ సెట్టింగ్ సంఖ్యలు మరియు అక్షరాలు వాడాలి.

గమనిక:  దయచేసి  మీరు బ్యాడ్జ్లను జారీ మొదలు ఒకసారి గ్రహీత ధృవీకరణ ప్రయోజనాల కోసం, ఈ సెట్టింగ్ని మార్చడాన్ని నివారించేందుకు';
$string['badgesdisabled'] = 'Badges ఈ సైట్  ప్రారంభించకపోవడం.';
$string['badgesearned'] = 'ఇప్పటివరకు సంపాదించిన / పొందిన బ్యాడ్జ్ ల సంఖ్య : {$a}';
$string['badgesettings'] = 'బ్యాడ్జ్లు సెట్టింగ్స్';
$string['badgestatus_0'] = 'యూజర్ల కు అందుబాటులో లేదు';
$string['badgestatus_1'] = 'యూజర్లకు అందుబాటులో ఉంది';
$string['badgestatus_2'] = 'యూజర్ల కు అందుబాటులో లేదు';
$string['badgestatus_3'] = 'వినియోగదారులకు అందుబాటులో';
$string['badgestatus_4'] = 'భధ్రపరచబడింది';
$string['badgestoearn'] = 'అందుబాటులో ఉన్న బ్యాడ్జ్ ల సంఖ్య : {$a}';
$string['badgesview'] = 'కోర్సు బ్యాడ్జ్ లు';
$string['badgeurl'] = 'జారీ చేసిన బ్యాడ్జ్ లంకె';
$string['bawards'] = 'స్వీకర్తలు ({$a})';
$string['bcriteria'] = 'క్రైటీరియా';
$string['bdetails'] = 'వివరాలు సవరించు';
$string['bmessage'] = 'సందేశం';
$string['boverview'] = 'వివరణ';
$string['bydate'] = 'పూర్తిచేసినవారు';
$string['clearsettings'] = 'సెట్టింగ్స్ ను క్లియర్ చెయ్యి';
$string['completioninfo'] = 'పూర్తి చేయడానికి ఈ బ్యాడ్జ్ జారీ చేయబడింది:';
$string['completionnotenabled'] = 'ఈ కోర్సు కోసం కోర్స్ పూర్తయింది ప్రారంభించబడదు, కనుక ఇది బ్యాడ్జ్ ప్రమాణంలో చేర్చబడదు. కోర్సు సెట్టింగులలో కోర్సు పూర్తయింది.';
$string['configenablebadges'] = 'ప్రారంభించబడినప్పుడు, ఈ లక్షణం మీరు బ్యాడ్జ్లను సృష్టించడానికి మరియు సైట్ వినియోగదారులకు వారికి వీలు కల్పిస్తుంది.';
$string['configuremessage'] = 'బ్యాడ్జ్ సందేశం';
$string['connect'] = 'కనెక్ట్';
$string['connected'] = 'కనెక్ట్ చేయబడింది';
$string['connecting'] = 'కనెక్ట్ అవుతోంది ...';
$string['contact'] = 'కాంటాక్ట్';
$string['contact_help'] = 'బ్యాడ్జ్ జారీచేసినవారితో అనుబంధించబడిన ఒక ఇమెయిల్ చిరునామా.';
$string['copyof'] = '{$a}యొక్క కాపీ';
$string['coursebadges'] = 'బ్యాడ్జ్లు';
$string['coursebadgesdisabled'] = 'ఈ సైట్ లో కోర్సు బ్యాడ్జ్ లు ఎనేబుల్ చేసి లేవు';
$string['coursecompletion'] = 'యూజర్లు తప్పక ఈ కోర్సు పూర్తి చేయాలి.';
$string['create'] = 'కొత్త బ్యాడ్జ్';
$string['createbutton'] = 'బ్యాడ్జ్ సృష్టించు';
$string['creatorbody'] = '<p> {$a->user} అన్ని బ్యాడ్జ్ అవసరాలు పూర్తి చేసి, బ్యాడ్జ్ను బహుకరించారు. {$a->link}} వద్ద జారీ చేసిన బ్యాడ్జ్ ను చూడండి';
$string['creatorsubject'] = '\'{$a}\' కు బహూకరించబడింది!';
$string['criteria_0'] = 'ఈ బ్యాడ్జ్ ఇస్తారు ...';
$string['criteria_1'] = 'కార్యాచరణ పూర్తి';
$string['criteria_1_help'] = 'ఒక కోర్సులో కార్యకలాపాల సమితి పూర్తి చేసిన తర్వాత వినియోగదారులకు ఒక బ్యాడ్జ్ను అనుమతిస్తుంది.';
$string['criteria_2'] = 'పాత్ర ద్వారా మాన్యువల్ సమస్య';
$string['criteria_2_help'] = 'సైట్ లేదా కోర్సులో ప్రత్యేక పాత్ర ఉన్న వినియోగదారులచే ఒక బ్యాడ్జ్ను మాన్యువల్గా ఇవ్వడానికి అనుమతిస్తుంది.';
$string['criteria_3'] = 'సంఘ పాల్గొనడం';
$string['criteria_3_help'] = 'సోషల్';
$string['criteria_4'] = 'కోర్సు పూర్తి';
$string['criteria_4_help'] = 'కోర్సును పూర్తి చేసిన వినియోగదారులకు బ్యాడ్జ్ను అనుమతిస్తుంది. ఈ ప్రమాణం కనీస గ్రేడ్ మరియు కోర్సు పూర్తి అయిన అదనపు పారామితులను కలిగి ఉంటుంది.';
$string['criteria_5'] = 'కోర్సులు సమితి పూర్తి చేసినందుకు';
$string['criteria_5_help'] = 'కోర్సుల సమితిని పూర్తి చేసిన వినియోగదారులకు బ్యాడ్జ్ను అనుమతిస్తుంది. ప్రతి కోర్సు కోర్సు యొక్క కనీస గ్రేడ్ మరియు తేదీ వంటి అదనపు పారామితులను కలిగి ఉంటుంది.';
$string['criteria_6'] = 'ప్రొఫైల్ పూర్తి';
$string['criteria_6_help'] = 'కోర్సుల సమితిని పూర్తి చేసిన వినియోగదారులకు బ్యాడ్జ్ను అనుమతిస్తుంది. ప్రతి కోర్సు కోర్సు యొక్క కనీస గ్రేడ్ మరియు తేదీ వంటి అదనపు పారామితులను కలిగి ఉంటుంది.';
$string['criteria_descr'] = 'కింది అవసరాన్ని పూర్తి చేసినప్పుడు వినియోగదారులు ఈ బ్యాడ్జ్ను ప్రదానం చేస్తారు:';
$string['criteria_descr_0'] = 'జాబితా చేయబడిన అవసరాల యొక్క <strong>{$a}</strong> ను పూర్తి చేసేటప్పుడు వినియోగదారులు ఈ బ్యాడ్జ్ను ప్రదానం చేస్తారు.';
$string['criteria_descr_1'] = 'క్రింది చర్యల యొక్క <strong>{$a}</strong> పూర్తయింది:';
$string['criteria_descr_2'] = 'క్రింది పాత్రల యొక్క <strong>{$a}</strong> తో వినియోగదారులు ఈ బ్యాడ్జ్ను ప్రదానం చేయాలి:';
$string['criteria_descr_4'] = 'వినియోగదారులు కోర్సు పూర్తి చేయాలి';
$string['criteria_descr_5'] = 'క్రింది కోర్సులు <strong>{$a}</strong> పూర్తి అవ్వాలి:';
$string['criteria_descr_6'] = 'కింది వినియోగదారు ప్రొఫైల్ క్షేత్రాలలో <strong>{$a}</ strong> పూర్తవుతుంది:';
$string['criteria_descr_bydate'] = '<em>{$a}</em> ద్వారా';
$string['criteria_descr_grade'] = 'కనీస గ్రేడ్ <em>{$a}</em> తో';
$string['criteria_descr_short0'] = 'యొక్క పూర్తి <strong>{$a}</strong>:';
$string['criteria_descr_short1'] = 'యొక్క పూర్తి <strong>{$a}</strong>:';
$string['criteria_descr_short2'] = 'దీని యొక్క <strong>{$a}</strong> ద్వారా ఇవ్వబడింది:';
$string['criteria_descr_short4'] = 'కోర్సును పూర్తి చేయండి';
$string['criteria_descr_short5'] = 'యొక్క పూర్తి <strong>{$a}</ strong>:';
$string['criteria_descr_short6'] = 'యొక్క పూర్తి <strong>{$a}</ strong>:';
$string['criteria_descr_single_1'] = 'క్రింది కార్యాచరణ పూర్తవుతుంది:';
$string['criteria_descr_single_2'] = 'ఈ బ్యాడ్జ్ ఈ క్రింది పాత్రతో ఒక యూజర్ చేత ఇవ్వాలి:';
$string['criteria_descr_single_4'] = 'వినియోగదారులు కోర్సును పూర్తి చేయాలి';
$string['criteria_descr_single_5'] = 'కింది కోర్సును పూర్తి అవ్వాల్సి వుంటుంది';
$string['criteria_descr_single_6'] = 'క్రింది వినియోగదారు ప్రొఫైల్ ఫీల్డ్ పూర్తయింది:';
$string['criteria_descr_single_short1'] = 'పూర్తి చేయండి:';
$string['criteria_descr_single_short2'] = 'బహూకరింబడిన';
$string['criteria_descr_single_short4'] = 'కోర్సును పూర్తి చేయండి';
$string['criteria_descr_single_short5'] = 'పూర్తి చేయండి:';
$string['criteria_descr_single_short6'] = 'పూర్తి చేయండి:';
$string['criteriacreated'] = 'బ్యాడ్జ్ ప్రమాణాలు విజయవంతంగా సృష్టించబడ్డాయి';
$string['criteriadeleted'] = 'బ్యాడ్జ్ ప్రమాణాలు విజయవంతంగా తొలగించబడ్డాయి';
$string['criteriasummary'] = 'ప్రమాణం సారాంశం';
$string['criteriaupdated'] = 'బ్యాడ్జ్ ప్రమాణాలు విజయవంతంగా నవీకరించబడ్డాయి';
$string['criterror'] = 'ప్రస్తుత పారామితులు సమస్యలు';
$string['criterror_help'] = 'ఈ ఫీడ్సెట్ ఈ బ్యాడ్జ్ అవసరానికి మొదట చేర్చబడిన అన్ని పారామీటర్లను చూపిస్తుంది కానీ ఇక అందుబాటులో లేదు. భవిష్యత్తులో ఈ బ్యాడ్జ్ను వినియోగదారులు సంపాదించవచ్చని నిర్ధారించుకోవడానికి మీరు అటువంటి పారామితులను అన్-చెక్ చేయాలని సిఫార్సు చేయబడింది.';
$string['currentimage'] = 'ప్రస్తుతపు చిత్రం';
$string['currentstatus'] = 'ప్రస్తుత పరిస్థితి:';
$string['dateawarded'] = 'తేదీ జారీ చేసిన';
$string['dateearned'] = 'తేదీ: (s)';
$string['day'] = 'రోజు (లు)';
$string['deactivate'] = 'యాక్సెస్  డిసేబుల్ చెయ్యి';
$string['deactivatesuccess'] = 'బ్యాడ్జ్లకు ప్రాప్యత విజయవంతంగా నిలిపివేయబడింది.';
$string['defaultissuercontact'] = 'డిఫాల్ట్ బ్యాడ్జ్ జారీదారు సంప్రదింపు వివరాలు';
$string['defaultissuercontact_desc'] = 'బ్యాడ్జ్ జారీచేసినవారితో అనుబంధించబడిన ఒక ఇమెయిల్ చిరునామా.';
$string['defaultissuername'] = 'డిఫాల్ట్ బ్యాడ్జ్ జారీచేసే పేరు';
$string['defaultissuername_desc'] = 'జారీ చేసే ఏజెంట్ లేదా అధికారం యొక్క పేరు.';
$string['delbadge'] = 'మీరు బ్యాడ్జ్ని \'{$a}\' తొలగించి ఉన్న అన్ని జారీ చేసిన బ్యాడ్జ్లను తీసివేయాలనుకుంటున్నారా?';
$string['delconfirm'] = 'ఇప్పటికే ఉన్న జారీ చేసిన బ్యాడ్జీలను తొలగించి తీసివేయండి';
$string['delcritconfirm'] = 'మీరు ఈ ప్రమాణాన్ని తొలగించాలనుకుంటున్నారా?';
$string['deletehelp'] = '<p> ఒక బ్యాడ్జ్ను పూర్తిగా తొలగిస్తే, దాని మొత్తం సమాచారం మరియు ప్రమాణం రికార్డులు శాశ్వతంగా తీసివేయబడతాయి. ఈ బ్యాడ్జ్ను సంపాదించిన వినియోగదారులు దీన్ని ఇకపై ప్రాప్యత చేయలేరు మరియు వారి ప్రొఫైల్ పేజీల్లో దీన్ని ప్రదర్శించగలరు. </ P>
<p> గమనిక: ఈ బ్యాడ్జ్ను సంపాదించిన వినియోగదారులు ఇప్పటికే వారి బాహ్య తగిలించుకునే బ్యాక్కి పిలుపునిచ్చారు, ఈ బ్యాడ్జ్ ఇప్పటికీ వారి బాహ్య తగిలించుకునే బ్యాగ్లో ఉంటుంది. అయినప్పటికీ, ఈ వెబ్ సైట్కు తిరిగి లింక్ చేయగల ప్రమాణాలు మరియు సాక్ష్యపు పేజీలను వారు అందుకోలేరు. </ P>';
$string['delparamconfirm'] = 'మీరు ఈ పారామితిని తొలగించాలనుకుంటున్నారా?';
$string['description'] = 'వివరణ';
$string['disconnect'] = 'విడదీయు';
$string['donotaward'] = 'ప్రస్తుతం, ఈ బ్యాడ్జ్ సక్రియంగా లేదు, కాబట్టి ఇది వినియోగదారులకు ఇవ్వబడదు. మీరు ఈ బ్యాడ్జ్ను ఇవ్వాలనుకుంటే, దాని స్థితిని చురుకుగా సెట్ చేయండి.';
$string['enablebadges'] = 'బ్యాడ్జీలను ప్రారంభించండి';
$string['error:backpackdatainvalid'] = 'బ్యాక్ప్యాక్ నుండి డేటా తిరిగి చెల్లనిది.';
$string['error:backpackemailnotfound'] = '\'{$a}\' ఇమెయిల్ బ్యాక్ప్యాక్తో అనుబంధించబడలేదు. మీరు ఆ ఖాతా కోసం <a href="http://backpack.openbadges.org"> బ్యాక్ప్యాక్ను సృష్టించాలి </a> లేదా మరొక ఇమెయిల్ చిరునామాతో సైన్ ఇన్ చేయాలి.';
$string['error:badgeawardnotfound'] = 'ఈ ప్రదానం బ్యాడ్జ్ను ధృవీకరించలేరు. ఈ బ్యాడ్జ్ రద్దు చేయబడి ఉండవచ్చు.';
$string['error:badgenotfound'] = 'బ్యాడ్జ్ కనుగొనబడలేదు';
$string['error:cannotact'] = 'బ్యాడ్జ్ను సక్రియం చేయలేరు.';
$string['error:cannotawardbadge'] = 'వినియోగదారుకు బ్యాడ్జ్ను అందించలేము.';
$string['error:cannotdeletecriterion'] = 'ఈ ప్రమాణం తొలగించబడదు.';
$string['error:cannotrevokebadge'] = 'వినియోగదారు నుండి బ్యాడ్జ్ను ఉపసంహరించలేరు.';
$string['error:clone'] = 'బ్యాడ్జ్ క్లోన్ కాదు.';
$string['error:connectionunknownreason'] = 'కనెక్షన్ విజయవంతం కాలేదు కానీ ఏ కారణం ఇవ్వలేదు.';
$string['error:duplicatename'] = 'అటువంటి పేరుతో బ్యాడ్జ్ ఇప్పటికే వ్యవస్థలో ఉంది.';
$string['error:externalbadgedoesntexist'] = 'బ్యాడ్జ్ కనుగొనబడలేదు';
$string['error:guestuseraccess'] = 'మీరు ప్రస్తుతం అతిథి ప్రాప్తిని ఉపయోగిస్తున్నారు. బ్యాడ్జ్లను చూడడానికి మీరు మీ యూజర్ ఖాతాతో లాగిన్ అవ్వాలి.';
$string['error:invalidcriteriatype'] = 'చెల్లని ప్రమాణ రకం.';
$string['error:invalidexpiredate'] = 'గడువు తేదీ భవిష్యత్తులో ఉండాలి.';
$string['error:invalidexpireperiod'] = 'గడువు కాలం ప్రతికూల లేదా సమాన 0 కాదు.';
$string['error:noactivities'] = 'ఈ కోర్సులో పూర్తి చేయబడిన పూర్తి ప్రమాణాలతో ఎటువంటి కార్యకలాపాలు లేవు.';
$string['error:nocourses'] = 'ఈ సైట్లోని ఏదైనా కోర్సుల కోసం కోర్సు పూర్తయింది కాదు, కాబట్టి ఎవరూ ప్రదర్శించబడరు. కోర్సు సెట్టింగులలో కోర్సు పూర్తయింది.';
$string['error:nopermissiontoview'] = 'బ్యాడ్జ్ గ్రహీతలను వీక్షించడానికి మీకు అనుమతులు లేవు';
$string['error:nosuchbadge'] = 'Id {$a} తో బ్యాడ్జ్ ఉనికిలో లేదు.';
$string['error:nosuchcourse'] = 'హెచ్చరిక: ఈ కోర్సు అందుబాటులో లేదు.';
$string['error:nosuchfield'] = 'హెచ్చరిక: ఈ వినియోగదారు ప్రొఫైల్ ఫీల్డ్ అందుబాటులో లేదు.';
$string['error:nosuchmod'] = 'హెచ్చరిక: ఈ కార్యాచరణ అందుబాటులో లేదు.';
$string['error:nosuchrole'] = 'హెచ్చరిక: ఈ పాత్ర అందుబాటులో లేదు.';
$string['error:nosuchuser'] = 'ఈ ఇమెయిల్ చిరునామాతో వినియోగదారు ప్రస్తుత బ్యాక్ ప్రొపేరుతో ఖాతాను కలిగి లేరు.';
$string['error:notifycoursedate'] = 'హెచ్చరిక: కోర్సు ప్రారంభ తేదీ వరకు కోర్సు మరియు కార్యకలాపాలు పూర్తి చేసిన బాడ్జీలు జారీ చేయబడవు.';
$string['error:parameter'] = 'హెచ్చరిక: వర్క్ఫ్లో జారీ చేసే సరైన బ్యాడ్జ్ను నిర్ధారించడానికి కనీసం ఒక పారామితి ఎంచుకోవాలి.';
$string['error:requesterror'] = 'కనెక్షన్ అభ్యర్థన విఫలమైంది (లోపం కోడ్ {$a}).';
$string['error:requesttimeout'] = 'కనెక్షన్ అభ్యర్థన పూర్తి కావడానికి ముందే ముగిసింది.';
$string['error:save'] = 'బ్యాడ్జ్ను సేవ్ చేయలేరు.';
$string['error:userdeleted'] = '{$a->user} (ఈ వాడుకరి ఇకపై {$a->site} లో లేదు)';
$string['eventbadgearchived'] = 'బ్యాడ్జ్ ఆర్కైవ్ చేయబడింది';
$string['eventbadgeawarded'] = 'బ్యాడ్జ్ ప్రదానం';
$string['eventbadgecreated'] = 'బ్యాడ్జ్ సృష్టించబడింది';
$string['eventbadgecriteriacreated'] = 'బ్యాడ్జ్ ప్రమాణాలు సృష్టించబడ్డాయి';
$string['eventbadgecriteriadeleted'] = 'బ్యాడ్జ్ ప్రమాణాలు తొలగించబడ్డాయి';
$string['eventbadgecriteriaupdated'] = 'బ్యాడ్జ్ ప్రమాణాలు నవీకరించబడ్డాయి';
$string['eventbadgedeleted'] = 'బ్యాడ్జ్ తొలగించబడింది';
$string['eventbadgedisabled'] = 'బ్యాడ్జ్ నిలిపివేయబడింది';
$string['eventbadgeduplicated'] = 'బ్యాడ్జ్ నకిలీ చేయబడింది';
$string['eventbadgeenabled'] = 'బ్యాడ్జ్ ప్రారంభించబడింది';
$string['eventbadgelistingviewed'] = 'బ్యాడ్జ్ జాబితా వీక్షించబడింది';
$string['eventbadgerevoked'] = 'బ్యాడ్జ్ రద్దు చేయబడింది';
$string['eventbadgeupdated'] = 'బ్యాడ్జ్ నవీకరించబడింది';
$string['eventbadgeviewed'] = 'బ్యాడ్జ్ వీక్షించబడింది';
$string['evidence'] = 'సాక్ష్యం';
$string['existingrecipients'] = 'ఇప్పటికే బ్యాడ్జ్ గ్రహీతలు';
$string['expired'] = 'గడువు ముగిసింది';
$string['expiredate'] = 'ఈ బ్యాడ్జ్ {$a} లో ముగుస్తుంది.';
$string['expireddate'] = 'ఈ బ్యాడ్జ్ {$a} లో గడువు ముగిసింది.';
$string['expireperiod'] = 'ఈ బ్యాడ్జ్ జారీ చేయబడిన తర్వాత {$a} రోజు(లు) గడువు ముగిస్తుంది.';
$string['expireperiodh'] = 'ఈ బ్యాడ్జ్ జారీ చేయబడిన తర్వాత {$a} గంట (లు) గడువు.';
$string['expireperiodm'] = 'ఈ బ్యాడ్జ్ జారీ అయిన తర్వాత {$a} నిమిషం (లు) గడువు ముగిస్తుంది.';
$string['expireperiods'] = 'ఈ బ్యాడ్జ్ జారీ అయిన తర్వాత {$a} సెకండ్ (లు) గడువు.';
$string['expirydate'] = 'గడువు తేదీ';
$string['expirydate_help'] = 'ఐచ్ఛికంగా, బ్యాడ్జ్లు నిర్దిష్ట తేదీన గడువు చేయవచ్చు, లేదా తేదీకి ఆధారంగా తేదీని లెక్కించవచ్చు, బ్యాడ్జ్ వినియోగదారుకు జారీ చేయబడినప్పుడు.';
$string['externalbadges'] = 'ఇతర వెబ్ సైట్ల నుండి నా బ్యాడ్జ్లు';
$string['externalbadges_help'] = 'ఈ ప్రాంతం మీ బాహ్య బ్యాక్ ప్యాడ్ నుండి బ్యాడ్జ్లను ప్రదర్శిస్తుంది.';
$string['externalbadgesp'] = 'ఇతర వెబ్సైట్ల నుండి బ్యాడ్జ్లు:';
$string['externalconnectto'] = 'మీరు బాహ్య Badges ను ప్రదర్శించడానికి <a href="{$a}"> బ్యాక్ప్యాక్కు కనెక్ట్ చేయాలి </a>.';
$string['fixed'] = 'నిర్ణీత తేది';
$string['hidden'] = 'దాచిపెట్టిన';
$string['hiddenbadge'] = 'దురదృష్టవశాత్తు, బ్యాడ్జ్ యజమాని ఈ సమాచారం అందుబాటులో లేదు.';
$string['imageauthorurl'] = 'ఇమేజ్ సృష్టికర్త యొక్క URL';
$string['imagecaption'] = 'ఇమేజ్ యొక్క క్యాప్షన్';
$string['issuancedetails'] = 'బ్యాడ్జ్ గడువు';
$string['issuedbadge'] = 'జారీ చేసిన బ్యాడ్జ్ సమాచారం';
$string['issuerdetails'] = 'జారీ చేసినవారి  వివరాలు';
$string['issueremail'] = 'ఇమెయిల్';
$string['issuername'] = 'జారీ చేసినవారి పేరు';
$string['issuername_help'] = 'జారీ చేసే ఏజెంట్ లేదా అధికారం యొక్క పేరు.';
$string['issuerurl'] = 'జారీ చేసినవారి URL ని';
$string['language'] = 'భాష';
$string['localbadges'] = '{$a} వెబ్ సైట్ నుండి నా బ్యాడ్జ్లు';
$string['localbadgesh'] = 'ఈ వెబ్ సైట్ నుండి నా బ్యాడ్జ్లు';
$string['localbadgesh_help'] = 'కోర్సులు, కోర్సు కార్యకలాపాలు మరియు ఇతర అవసరాలు పూర్తి చేయడం ద్వారా ఈ వెబ్ సైట్లో అన్ని బ్యాడ్జ్లు సంపాదించబడ్డాయి.

మీరు మీ బ్యాడ్జ్లను మీ ప్రొఫైల్ పేజీ కోసం పబ్లిక్ లేదా ప్రైవేట్గా చేయడం ద్వారా ఇక్కడ నిర్వహించవచ్చు.

మీరు మీ బ్యాడ్జ్లను లేదా ప్రతి బ్యాడ్జ్ని విడివిడిగా డౌన్లోడ్ చేసుకోవచ్చు మరియు వాటిని మీ కంప్యూటర్లో సేవ్ చేయవచ్చు. డౌన్ లోడ్ చేయబడిన బాడ్జీలు మీ బ్యాక్ప్యాక్ సేవకు జోడించబడతాయి.';
$string['localbadgesp'] = '{$a} నుండి బ్యాడ్జ్లు:';
$string['localconnectto'] = 'ఈ వెబ్ సైట్ వెలుపల ఈ బ్యాడ్జ్లను భాగస్వామ్యం చేయడానికి మీరు <a href="{$a}"> బ్యాక్ప్యాక్కు కనెక్ట్ చేయాలి</a>.';
$string['makeprivate'] = 'వ్యక్తిగత చేయండి';
$string['makepublic'] = 'పబ్లిక్గా చేయండి';
$string['managebadges'] = 'బ్యాడ్జ్లను నిర్వహించండి';
$string['message'] = 'సందేశ భాగాన్ని';
$string['messagebody'] = '<p>మీకు "% badgename%" బ్యాడ్జ్ లభించింది! </ p>
<p>ఈ బ్యాడ్జ్ గురించి మరింత సమాచారం% badgelink% badge information page లో కనుగొనవచ్చు. </p>
<p> మీ {$a} పేజీ నుండి బ్యాడ్జ్ ను నిర్వహించవచ్చు మరియు డౌన్లోడ్ చేసుకోవచ్చు. </p>';
$string['messagesubject'] = 'అభినందనలు! మీరు బ్యాడ్జ్ను సంపాదించారు!';
$string['method'] = 'ఈ ప్రమాణం పూర్తి అయినప్పుడు ...';
$string['mingrade'] = 'కనీస గ్రేడ్ అవసరం';
$string['month'] = 'నెల (లు)';
$string['mybackpack'] = 'నా బ్యాక్ప్యాక్ సెట్టింగులు';
$string['mybadges'] = 'నా బ్యాడ్జ్లు';
$string['never'] = 'ఎప్పటికీ';
$string['newbadge'] = 'క్రొత్త బ్యాడ్జ్ని జోడించండి';
$string['newimage'] = 'కొత్త చిత్రం';
$string['noawards'] = 'ఈ బ్యాడ్జ్ ఇంకా సంపాదించబడలేదు.';
$string['nobackpack'] = 'ఈ ఖాతాకు కనెక్ట్ చేయబడిన బ్యాక్ ప్యాక్ సేవ లేదు. <br/>';
$string['nobadges'] = 'బ్యాడ్జ్లు అందుబాటులో లేవు.';
$string['nocriteria'] = 'ఈ బ్యాడ్జ్ కోసం ప్రమాణాలు ఇంకా అమర్చబడలేదు.';
$string['noexpiry'] = 'ఈ బ్యాడ్జ్ గడువు తేదీ లేదు.';
$string['noparamstoadd'] = 'ఈ బ్యాడ్జ్ అవసరానికి జోడించడానికి అదనపు పారామితులు అందుబాటులో లేవు.';
$string['notacceptedrole'] = 'మీ ప్రస్తుత పాత్ర అప్పగింత ఈ బ్యాడ్జ్ను మానవీయంగా విడుదల చేసే పాత్రలలో లేదు. <br/>
మీరు ఇప్పటికే ఈ బ్యాడ్జ్ను సంపాదించిన వినియోగదారులను చూడాలనుకుంటే, మీరు {$a} పేజీని సందర్శించవచ్చు.';
$string['notconnected'] = 'కనెక్ట్ చెయ్యలేదు';
$string['nothingtoadd'] = 'జోడించడానికి అందుబాటులో ఉన్న ప్రమాణాలు లేవు.';
$string['notification'] = 'బ్యాడ్జ్ సృష్టికర్తకు తెలియజేయండి';
$string['notification_help'] = 'బ్యాడ్జ్ జారీ చేయబడిందని వారికి తెలియజేయడానికి బ్యాడ్జ్ సృష్టికర్తకు పంపిన నోటిఫికేషన్లను ఈ సెట్టింగ్ నిర్వహిస్తుంది.

క్రింది ఎంపికలు అందుబాటులో ఉన్నాయి:

** ఎప్పుడు కాదు ** - నోటిఫికేషన్లను పంపవద్దు.

** ప్రతిసారీ ** - ఈ బ్యాడ్జ్ ఇవ్వబడిన ప్రతిసారి ఒక ప్రకటనను పంపండి.

*** ప్రతి రోజూ ** - రోజుకు ఒకసారి నోటిఫికేషన్లను పంపండి.

*** వీక్లీ ** - వారానికి ఒకసారి నోటిఫికేషన్లను పంపండి.

* ** నెలవారీ ** - నెలకు ఒకసారి నోటిఫికేషన్లను పంపండి.';
$string['notifydaily'] = 'రోజూ';
$string['notifyevery'] = 'ప్రతి సమయాన్ని';
$string['notifymonthly'] = 'నెలవారీ';
$string['notifyweekly'] = 'వారపు';
$string['numawards'] = 'ఈ బ్యాడ్జ్ <a href="{$a->link}">{$a->count}</a> వినియోగదారు (s) కి జారీ చేయబడింది.';
$string['numawardstat'] = 'ఈ బ్యాడ్జ్ {$a} వినియోగదారు (s) జారీ చేయబడింది.';
$string['overallcrit'] = 'ఎంచుకున్న ప్రమాణం పూర్తి.';
$string['potentialrecipients'] = 'సంభావ్య బ్యాడ్జ్ గ్రహీతలు';
$string['preferences'] = 'బ్యాడ్జ్ ప్రాధాన్యత';
$string['recipientdetails'] = 'గ్రహీత వివరాలు';
$string['recipientidentificationproblem'] = 'ఇప్పటికే ఉన్న వినియోగదారుల మధ్య ఈ బ్యాడ్జ్ గ్రహీతను కనుగొనలేకపోయాము.';
$string['recipients'] = 'బ్యాడ్జ్ గ్రహీతలు';
$string['recipientvalidationproblem'] = 'ప్రస్తుత బ్యాడ్జ్ గ్రహీతగా ప్రస్తుత యూజర్ను ధృవీకరించలేరు.';
$string['relatedbages'] = 'సంబంధించిన బ్యాడ్జ్ లు';
$string['relative'] = 'సంబంధిత తేది';
$string['requiredcourse'] = 'కనీసం ఒక కోర్సు , కోర్సెట్ ప్రమాణంకు జోడించాలి.';
$string['reviewbadge'] = 'బ్యాడ్జ్ యాక్సెస్లో మార్పులు';
$string['reviewconfirm'] = '<p> ఇది మీ బ్యాడ్జ్ వినియోగదారులకు కనిపించేలా చేస్తుంది మరియు వాటిని సంపాదించడం ప్రారంభించడాన్ని అనుమతిస్తుంది.</p>

<p> కొంతమంది వినియోగదారులు ఇప్పటికే ఈ బ్యాడ్జ్ యొక్క ప్రమాణాలను కలిగించే అవకాశం ఉంది మరియు మీరు దీన్ని ప్రారంభించిన వెంటనే ఈ బ్యాడ్జ్ జారీ చేయబడతారు.</p>

<p> ఒక బ్యాడ్జ్ జారీ చేసిన తర్వాత అది <strong>
లాక్ చేయబడుతుంది </ strong> - ప్రమాణాలు మరియు గడువు అమర్పులతో సహా కొన్ని సెట్టింగ్లు ఇకపై మార్చబడవు.</p>

<p>మీరు ఖచ్చితంగా \'{$a}\' బ్యాడ్జ్కు ప్రాప్యతను ప్రారంభించాలనుకుంటున్నారా?</p>';
$string['revoke'] = 'బ్యాడ్జ్ని ఉపసంహరించుకోండి';
$string['save'] = 'సేవ్ చేయి';
$string['searchname'] = 'పెరుతో శోధించండి';
$string['selectaward'] = 'దయచేసి ఈ బ్యాడ్జ్ను అందించడానికి మీరు ఉపయోగించాలనుకుంటున్న పాత్రను ఎంచుకోండి:';
$string['selectgroup_end'] = 'పబ్లిక్ సేకరణలు మాత్రమే చూపబడతాయి, మరింత పబ్లిక్ సేకరణలను సృష్టించడానికి <a href="http://backpack.openbadges.org"> మీ బ్యాక్ ప్యాక్ను సందర్శించండి</a>.';
$string['selectgroup_start'] = 'ఈ సైట్లో ప్రదర్శించడానికి మీ బ్యాక్ ప్యాక్ నుండి సేకరణలను ఎంచుకోండి:';
$string['selecting'] = 'ఎంచుకున్న బ్యాడ్జ్లతో ...';
$string['setup'] = 'అనుసంధానాన్ని అమర్చడం';
$string['sitebadges'] = 'సైట్ బ్యాడ్జ్లు';
$string['sitebadges_help'] = 'సైట్-సంబంధిత కార్యకలాపాల కోసం సైట్ బ్యాడ్జ్లను మాత్రమే వినియోగదారులకు ఇవ్వవచ్చు. వీటిలో ఒక కోర్సు కోర్సులు లేదా యూజర్ ప్రొఫైల్స్ యొక్క భాగాలను పూర్తి చేస్తాయి. సైట్ బ్యాడ్జ్లను ఒక వినియోగదారు మరొకరికి మానవీయంగా జారీ చేయవచ్చు.

కోర్సు సంబంధిత కార్యక్రమాల కోసం బ్యాడ్జ్లను కోర్సు స్థాయిలో సృష్టించాలి. కోర్సు బ్యాడ్జీలు కోర్సు అడ్మినిస్ట్రేషన్> బ్యాడ్జ్ల ద్వారా కనుగొనవచ్చు.';
$string['status'] = 'బ్యాడ్జ్ స్థితి';
$string['status_help'] = 'బ్యాడ్జ్ యొక్క స్థితి వ్యవస్థలో దాని ప్రవర్తనను నిర్ణయిస్తుంది:

* ** లభ్యత ** - ఈ బ్యాడ్జ్ను వినియోగదారులు సంపాదించవచ్చని అర్థం. బ్యాడ్జ్ వినియోగదారులకు అందుబాటులో ఉన్నప్పటికీ, దాని ప్రమాణాలు సవరించబడవు.

** అందుబాటులో లేదు ** - ఈ బ్యాడ్జ్ వినియోగదారులకు అందుబాటులో ఉండదు మరియు సంపాదించబడదు లేదా మానవీయంగా జారీ చేయబడదు. అటువంటి బ్యాడ్జ్ ముందు ఎన్నడూ జారీ చేయకపోతే, దాని ప్రమాణాలు మార్చవచ్చు.

కనీసం ఒక వినియోగదారుకు బ్యాడ్జ్ జారీ చేయబడిన తర్వాత, అది స్వయంచాలకంగా ** లాక్డ్ అవుతుంది **. లాక్డ్ బ్యాడ్జ్లను ఇప్పటికీ వినియోగదారులు సంపాదించవచ్చు, కానీ వారి ప్రమాణాలు ఇకపై మార్చబడవు. మీరు లాక్ బ్యాడ్జ్ వివరాలను లేదా ప్రమాణాలను సవరించాలంటే, మీరు ఈ బ్యాడ్జ్ని నకిలీ చేసి, అవసరమైన అన్ని మార్పులను చేయవచ్చు.

* మనము బ్యాడ్జ్లను ఎందుకు లాక్ చేస్తాము? *

మనము ఒక బ్యాడ్జ్ సంపాదించడానికి అన్ని వినియోగదారులూ ఒకే అవసరాన్ని పూర్తి చేస్తారని నిర్ధారించుకోవాలి. ప్రస్తుతం, బ్యాడ్జ్లను రద్దు చేయడానికి సాధ్యం కాదు. మనము బ్యాడ్జ్ల అవసరాలను అన్ని సమయాల్లో మార్పు చేయడాన్ని అనుమతించినట్లయితే, మనము పూర్తిగా భిన్నమైన అవసరాలను తీర్చడానికి ఒకే బ్యాడ్జ్ కలిగి ఉన్న వినియోగదారులతో ముగుస్తుంది.';
$string['statusmessage_0'] = 'ఈ బ్యాడ్జ్ ప్రస్తుతం వినియోగదారులకు అందుబాటులో లేదు. వినియోగదారులు ఈ బ్యాడ్జ్ను సంపాదించాలనుకుంటే మీరు ప్రాప్యతను ప్రారంభించండి.';
$string['statusmessage_1'] = 'ఈ బ్యాడ్జ్ ప్రస్తుతం వినియోగదారులకు అందుబాటులో ఉంది. ఏదైనా మార్పులు చేయడానికి ప్రాప్యతను నిలిపివేయి.';
$string['statusmessage_2'] = 'ఈ బ్యాడ్జ్ ప్రస్తుతం వినియోగదారులకు అందుబాటులో లేదు, దాని ప్రమాణాలు లాక్ చెయ్యబడ్డాయి. వినియోగదారులు ఈ బ్యాడ్జ్ను సంపాదించాలనుకుంటే మీరు ప్రాప్యతను ప్రారంభించండి.';
$string['statusmessage_3'] = 'ఈ బ్యాడ్జ్ ప్రస్తుతం వినియోగదారులకు అందుబాటులో ఉంది మరియు దాని ప్రమాణాలు లాక్ చెయ్యబడ్డాయి.';
$string['statusmessage_4'] = 'ఈ బ్యాడ్జ్ ప్రస్తుతం ఆర్కైవ్ చేయబడింది.';
$string['subject'] = 'సందేశ విషయం';
$string['variablesubstitution'] = 'సందేశాలు లో వేరియబుల్ ప్రత్యామ్నాయం.';
$string['variablesubstitution_help'] = 'బ్యాడ్జ్ సందేశాల్లో, సందేశాన్ని పంపుతున్నప్పుడు నిజ విలువలతో భర్తీ చేయబడే విధంగా కొన్ని అంశాలని ఒక సందేశం యొక్క విషయం మరియు / లేదా శరీరం లోకి చేర్చవచ్చు. వేరియబుల్స్ టెక్స్ట్ లో చేర్చబడతాయి, అవి క్రింద చూపిన విధంగా. కింది వేరియబుల్స్ ఉపయోగించవచ్చు:

% Badgename%
: ఇది బ్యాడ్జ్ యొక్క పూర్తి పేరుతో భర్తీ చేయబడుతుంది.

% వాడుకరిపేరు%
: ఇది గ్రహీత యొక్క పూర్తి పేరు ద్వారా భర్తీ చేయబడుతుంది.

% Badgelink%
: ఇది జారీ చేసిన బ్యాడ్జ్ గురించి సమాచారంతో పబ్లిక్ URL ద్వారా భర్తీ చేయబడుతుంది.';
$string['version'] = 'సంస్కరణ';
$string['viewbadge'] = 'జారీ చేసిన బ్యాడ్జ్ వీక్షించండి';
$string['visible'] = 'కనిపిస్తాయి';
$string['warnexpired'] = '(ఈ బ్యాడ్జ్ గడువు ముగిసింది!)';
$string['year'] = 'సంవత్సరాల (లు)';
