<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'vpl', language 'te', version '4.3'.
 *
 * @package     vpl
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['VPL_COMPILATIONFAILED'] = 'కంపైలేషన్ లేదా ఉరితీత తయారీ విఫలమైంది';
$string['about'] = 'గురించి';
$string['acceptcertificates'] = 'స్వీయ సంతకం సర్టిఫికేట్లను అంగీకరించండి';
$string['acceptcertificates_description'] = 'అమలు సర్వర్లు స్వీయ సంతకం సర్టిఫికేట్లను ఉపయోగించకపోతే ఈ ఎంపికను అన్చెక్ చేయండి';
$string['acceptcertificatesnote'] = '<p> మీరు ఎన్క్రిప్టెడ్ కనెక్షన్ను ఉపయోగిస్తున్నారు. <p />
<p> అమలు సర్వర్లతో ఎన్క్రిప్ట్ చేయబడిన కనెక్షన్ను ఉపయోగించడానికి మీరు దాని సర్టిఫికెట్లు అంగీకరించాలి. </ p>
<p> మీరు ఈ ప్రాసెస్తో సమస్యలను కలిగి ఉంటే, మీరు http (ఎన్క్రిప్ట్ చేయబడిన) కనెక్షన్ లేదా ఇతర బ్రౌజర్ను ఉపయోగించడానికి ప్రయత్నించవచ్చు. </ p>
<p> దయచేసి, క్రింది లింకులను (సర్వర్ #) క్లిక్ చేసి, ఇచ్చిన సర్టిఫికెట్ను అంగీకరించండి. </ p>';
$string['addfile'] = 'ఫైల్ను జోడించు';
$string['advanced'] = 'ఆధునిక';
$string['allfiles'] = 'అన్ని ఫైళ్ళు';
$string['allsubmissions'] = 'అన్ని సమర్పణలు';
$string['always_use_ws'] = 'ఎల్లప్పుడూ ఎన్క్రిప్ట్ చేయని (ws) వెబ్సర్వెట్ ప్రోటోకాల్ ఉపయోగించండి';
$string['always_use_wss'] = 'ఎల్లప్పుడూ ఎన్క్రిప్టెడ్ (wss) వెబ్సర్వెట్ ప్రోటోకాల్ ఉపయోగించండి';
$string['anyfile'] = 'ఏదైనా ఫైల్';
$string['attemptnumber'] = 'నంబర్ {$ a} ప్రయత్నం';
$string['autodetect'] = 'స్వయం పరిశోధన';
$string['automaticevaluation'] = 'స్వయంచాలక మూల్యాంకనం';
$string['automaticgrading'] = 'స్వయంచాలక గ్రేడ్';
$string['averageperiods'] = 'సగటు కాలాలు {$ a}';
$string['averagetime'] = 'సగటు సమయం {$ a}';
$string['basedon'] = 'ఆధారంగా';
$string['basic'] = 'ప్రాథమిక';
$string['binaryfile'] = 'బైనరీ ఫైలు';
$string['browserupdate'] = 'దయచేసి మీ బ్రౌజర్ను గత సంస్కరణకు నవీకరించండి <br /> <br /> లేదా వెబ్సకెట్కు మద్దతు ఇచ్చే మరొకదాన్ని ఉపయోగించండి.';
$string['calculate'] = 'లెక్కించు';
$string['changesNotSaved'] = 'మార్పులు సేవ్ కాలేదు';
$string['check_jail_servers'] = 'అమలు సర్వర్లు తనిఖీ';
$string['check_jail_servers_help'] = '<p> ఈ పేజి చెక్ మరియు ఉపయోగించిన అమలు సర్వర్లు యొక్క స్థితిని చూపుతుంది
ఈ చర్య కోసం. </ p>';
$string['clipboard'] = 'క్లిప్బోర్డ్కు';
$string['closed'] = 'ముగించబడినది';
$string['comments'] = 'వ్యాఖ్యలు';
$string['compilation'] = 'సంగ్రహం';
$string['connected'] = 'కనెక్ట్';
$string['connecting'] = 'కనెక్ట్';
$string['connection_closed'] = 'కనెక్షన్ మూసివేయబడింది';
$string['connection_fail'] = 'కనెక్షన్ విఫలమైంది';
$string['console'] = 'కన్సోల్';
$string['copy'] = 'కాపీ';
$string['create_new_file'] = 'క్రొత్త ఫైల్ను సృష్టించండి';
$string['currentstatus'] = 'ప్రస్తుత స్థితి';
$string['cut'] = 'Cut';
$string['datesubmitted'] = 'సమర్పించిన తేదీ';
$string['debug'] = 'డీబగ్';
$string['debugging'] = 'డీబగ్గింగ్';
$string['debugscript'] = 'డీబగ్ స్క్రిప్ట్';
$string['debugscript_help'] = 'ఈ కార్యాచరణలో ఉపయోగించడానికి డీబగ్ స్క్రిప్ట్ను ఎంచుకోండి';
$string['defaultexefilesize'] = 'గరిష్ట డిఫాల్ట్ అమలు ఫైలు పరిమాణం';
$string['defaultexememory'] = 'ఉపయోగించిన గరిష్ఠ డిఫాల్ట్ మెమరీ';
$string['defaultexeprocesses'] = 'ప్రక్రియల గరిష్ఠ డిఫాల్ట్ సంఖ్య';
$string['defaultexetime'] = 'గరిష్ట డిఫాల్ట్ అమలు సమయం';
$string['defaultfilesize'] = 'డిఫాల్ట్ గరిష్ట అప్లోడ్ ఫైల్ పరిమాణం';
$string['defaultresourcelimits'] = 'డిఫాల్ట్ అమలు వనరులు పరిమితులు';
$string['delete'] = 'తొలగించు';
$string['delete_file_fq'] = '\'{$a}\' ఫైల్ను తొలగించాలా?';
$string['delete_file_q'] = 'ఫైలు తొలగించండి?';
$string['deleteallsubmissions'] = 'అన్ని సమర్పణలను తొలగించండి';
$string['depends_on_https'] = 'Http లేదా https ఉపయోగిస్తుంటే బట్టి ws లేదా wss ను వాడండి';
$string['description'] = 'వివరణ';
$string['diff'] = 'తేడాలు';
$string['discard_submission_period'] = 'సమర్పణ వ్యవధిని విస్మరించండి';
$string['discard_submission_period_description'] = 'ప్రతి విద్యార్థి మరియు అప్పగించిన కోసం, సిస్టమ్ సమర్పణలను విస్మరించడానికి ప్రయత్నిస్తుంది. వ్యవస్థ చివరి మరియు ప్రతి కాలానికి కనీసం ఒక సమర్పణ ఉంచండి';
$string['download'] = 'డౌన్లోడ్';
$string['downloadallsubmissions'] = 'అన్ని సమర్పణలను డౌన్లోడ్ చేయండి';
$string['downloadsubmissions'] = 'సమర్పణలను డౌన్లోడ్ చేయండి';
$string['duedate'] = 'గడువు తేది';
$string['edit'] = 'మార్చు';
$string['editing'] = 'ఎడిటింగ్';
$string['editortheme'] = 'ఎడిటింగ్';
$string['evaluate'] = 'పరీక్షించు';
$string['evaluateonsubmission'] = 'కేవలం సమర్పణపై విశ్లేషించండి';
$string['evaluating'] = 'మూల్యాంకనం';
$string['evaluation'] = 'మూల్యాంకనం';
$string['examples'] = 'ఉదాహరణలు';
$string['execution'] = 'అమలు';
$string['executionfiles'] = 'అమలు ఫైళ్లు';
$string['executionfiles_help'] = '<H2> పరిచయం </ h2>
<p> ఇక్కడ అమలును సిద్ధం చేయడానికి అవసరమైన ఫైళ్ళను మీరు సెట్ చేస్తారు,
ఒక సమర్పణ డీబగ్ లేదా అంచనా. ఇందులో స్క్రిప్టింగ్ ఫైల్స్,
ప్రోగ్రామ్ పరీక్ష ఫైళ్లు మరియు డేటా ఫైళ్లు. </ p>
<h2> రన్ స్క్రీన్ను డీబగ్ చేయుటకు డీబగ్ చేయు </ h2>
<p> రన్ లేదా డీబగ్ సమర్పణల కోసం మీరు స్క్రిప్ట్ ఫైల్స్ సెట్ చేయకపోతే, సిస్టమ్
మీరు ఉపయోగించే భాష (ఫైల్ పేరు పొడిగింపుల ఆధారంగా) పరిష్కరించవచ్చు మరియు ఒక
ముందే స్క్రిప్ట్.
<h2> స్వయంచాలక మూల్యాంకనం </ h2>
<p> విద్యార్థుల సమర్పణల యొక్క అంచనాను సులభతరం చేయడానికి లక్షణాలను కలిగి ఉంటుంది.
ఈ లక్షణం విద్యార్థి ప్రోగ్రామ్ను అమలు చేయడానికి మరియు ఇచ్చిన ఇన్పుట్ కోసం దాని అవుట్పుట్ను తనిఖీ చేయడానికి అనుమతిస్తుంది.
మూల్యాంకనం కేసులను ఏర్పాటు చేసేందుకు మీరు ఫైల్ & quot; vpl_evaluate.cases & quot;
<p> ఫైలు "vpl_evaluate.cases" కింది ఫార్మాట్ ఉంది:
<Ul>
<li> "<strong> కేసు </ strong> = కేస్ వివరణ": ఐచ్ఛికం. పరీక్ష కేసు నిర్వచనాన్ని ప్రారంభించండి. </ Li>
<li> "<strong> ఇన్పుట్ </ strong> = టెక్స్ట్": అనేక పంక్తులను ఉపయోగించవచ్చు. ఇతర సూచనలతో ముగుస్తుంది. </ Li>
<li> "<strong> అవుట్పుట్ </ strong> = టెక్స్ట్": అనేక పంక్తులను ఉపయోగించవచ్చు. ఇతర సూచనలతో ముగుస్తుంది. ఒక కేసు diffentts సరైన ఉత్పత్తిని కలిగి ఉంటుంది. అవుట్పుట్ యొక్క మూడు రకాలు ఉన్నాయి: సంఖ్యలు, టెక్స్ట్ మరియు ఖచ్చితమైన పరీక్ష:
<Ul>
<li> <strong> సంఖ్య </ strong>: సంఖ్యల శ్రేణి (పూర్ణాంకాల మరియు ఫ్లోట్ లు) గా నిర్వచించబడింది. అవుట్పుట్లో సంఖ్యలు మాత్రమే తనిఖీ చేయబడతాయి, ఇతర వచనం విస్మరించబడుతుంది. ఫ్లోట్లలు సహనంతో తనిఖీ చేయబడతాయి </ li>
<li> <strong> వచనం </ strong>: డబుల్ కోట్ లేకుండా వచనం వలె నిర్వచించబడింది. పదాలను మాత్రమే తనిఖీ చేస్తారు మరియు మిగిలిపోయిన అక్షరాలు విస్మరించబడతాయి, కంపేర్ కేస్ ఇన్సెన్సిటివ్గా ఉంది </ li>
<li> <strong> ఖచ్చితమైన వచనం </ strong>: వచనం వలె డబుల్ కోట్గా నిర్వచించబడింది. అవుట్పుట్ను పరీక్షించడానికి ఖచ్చితమైన మ్యాచ్ ఉపయోగించబడుతుంది. </ Li>
</ Ul>
</ Li>
<li> "<strong> గ్రేడ్ తగ్గింపు </ strong> = [విలువ | శాతము%]": అప్రమేయంగా, లోపం విద్యార్ధి యొక్క గ్రేడ్ను తగ్గిస్తుంది
(maxgrade తో మొదలవుతుంది) (గ్రేడ్_రేంజ్ / కేసులు సంఖ్య) ద్వారా కానీ ఈ సూచనతో మీరు మార్చవచ్చు
తగ్గింపు విలువ లేదా శాతం. </ li>
</ Ul>
</ P>
<h2> సాధారణ ఉపయోగం </ h2>
<p> ఒక క్రొత్త ఫైల్ను దాని పేరును పెట్టెను & quot; <b> ఫైల్ను జోడించు </ b> & quot;
ఆపై బటన్పై క్లిక్ చేయడం & quot; <b> ఫైల్ను జోడించు </ b> & quot;. </ p>
<p> ఇప్పటికే ఉన్న ఫైలు & quot; <b> అప్లోడ్ ఫైల్ </ b> & quot; </ p> ద్వారా అప్లోడ్ చేయబడుతుంది.
మూడు స్క్రిప్టింగ్ ఫైల్స్ మినహాయించి, వాటిలో అన్నింటిని సవరించవచ్చు
క్రింద, పేరు మార్చవచ్చు లేదా తొలగించవచ్చు. </ p>
<h2> మాన్యువల్ పరుగు, అమలు లేదా మూల్యాంకనం </ h2>

<h2> సాధారణ ఉపయోగం </ h2>
<p> ఒక క్రొత్త ఫైల్ను దాని పేరును పెట్టెను & quot; <b> ఫైల్ను జోడించు </ b> & quot;
ఆపై బటన్పై క్లిక్ చేయడం & quot; <b> ఫైల్ను జోడించు </ b> & quot;. </ p>
<p> ఇప్పటికే ఉన్న ఫైలు & quot; <b> అప్లోడ్ ఫైల్ </ b> & quot; </ p> ద్వారా అప్లోడ్ చేయబడుతుంది.
మూడు స్క్రిప్టింగ్ ఫైల్స్ మినహాయించి, వాటిలో అన్నింటిని సవరించవచ్చు
క్రింద, పేరు మార్చవచ్చు లేదా తొలగించవచ్చు. </ p>
<h2> మాన్యువల్ పరుగు, అమలు లేదా మూల్యాంకనం </ h2>
<p> ప్రతి చర్యలను సిద్ధం చేయడానికి మూడు స్క్రిప్టింగ్ ఫైల్స్ సెట్ చేయబడవచ్చు.
ఈ ఫైల్స్ పూర్వనిర్వచిత పేర్లను కలిగి ఉంటాయి: <b> vpl_run.sh </ b> (అమలు),
<b> vpl_debug.sh </ b> (డీబగ్) మరియు <b> vpl_evaluate.sh </ b> (అంచనా). </ p>
<p> స్క్రిప్టింగ్ ఫైళ్ళలో ఏదైనా అమలు చేయాలి a
ఫైల్ పేరు <b> vpl_execution </ b>.
ఈ ఫైల్ తప్పనిసరిగా & quot; #! / Bin / sh & quot; తో మొదలయ్యే బైనరీ ఎక్జిక్యూటబుల్ లేదా స్క్రిప్ట్ అయి ఉండాలి.
ఎంచుకున్న చర్యను అమలు చేయడానికి ఈ ఫైల్ యొక్క తరంతర తరం అడ్డుతుంది. </ P>
<p> మీరు ఆకృతీకరించిన కార్యాచరణ ఇతర కార్యాచరణ ఆధారంగా "
బేస్ కార్యాచరణ యొక్క ఫైల్లు స్వయంచాలకంగా జోడించబడతాయి.
Vpl_run.sh, vpl_debug.sh మరియు vpl_evaluate.sh ఫైల్స్ యొక్క విషయాలు
ప్రస్తుత "పై ఆధారపడి" యొక్క లోతైన స్థాయి నుండి కలుపబడినవి. </ P>
<p> చివరగా, ఫైల్ <b> vpl_environment.sh </ b> స్వయంచాలకంగా జోడించబడుతుంది.
ఈ స్క్రిప్టింగ్ ఫైల్లో సమర్పణ గురించి సమాచారం ఉంటుంది.
సమాచారం ఎన్విరాన్మెంట్ వేరియబుల్స్గా వస్తాయి: </ p>
<ul> <li> LANG: ఉపయోగించిన భాష. </ Li>
<li> LC_ALL: LANG లాంటి విలువ. </ Li>
<li> VPL_MAXTIME: గరిష్ట అమలు సమయం సెకన్లలో. </ Li>
<li> VPL_FILEBASEURL: కోర్సు యొక్క ఫైల్లను యాక్సెస్ చేయడానికి URL. </ Li>
<li> VPL_SUBFILE #: విద్యార్థి సమర్పించిన ప్రతి పేరు. సమర్పించిన ఫైల్ల సంఖ్య నుండి 0 వరకు # శ్రేణులు. </ Li>
<li> VPL_SUBFILES: సమర్పించిన అన్ని ఫైళ్ళ జాబితా. </ Li>
<li> VPL_VARIATION + id: where id అనేది 0 తో మొదలయ్యే వైవిధ్య క్రమంలో మరియు విలువ వైవిధ్య విలువ. </ Li>
</ Ul>';
$string['executionoptions'] = 'అమలు ఎంపికలు';
$string['executionoptions_help'] = '<p> వివిధ అమలు ఎంపికలు ఈ పేజీలో సెట్ చేయబడ్డాయి </ p>
<Ul>
<li> <b> ఆధారంగా </ b>: కొన్ని విశేషణాలకు దిగుమతి చేయబడిన ఇతర VPL ఉదాహరణలను అమర్చండి:
<ul> <li> ఎగ్జిక్యూషన్ ఫైల్స్ (ముందే నిర్వచించిన స్క్రిప్టింగ్ ఫైళ్ళను అనుసంధానించడం) </ li>
<li> అమలు వనరులకు పరిమితులు. </ li>
<li> వ్యత్యాసాలు, బహువిభజనలను ఉత్పత్తి చేయడానికి అనుసంధానించేవి. </ li>
<li> సమర్పణతో ప్రతి ఫైల్ కోసం మాగ్జిమ్యున్ పొడవు అప్లోడ్ చేయబడుతుంది </ li>
</ Ul>
</ Li>
<b> రన్ </ b>, <b> డీబగ్ </ b> మరియు <b> Evalaute </ b>: సమర్పణను సవరిస్తున్నప్పుడు సంబంధిత చర్య అమలు చేయబడితే \'అవును\' కు అమర్చాలి. ఇది విద్యార్థులకు మాత్రమే ప్రభావితం చేస్తుంది, గ్రేడింగ్ సామర్ధ్యం ఉన్న వినియోగదారులు ఎల్లప్పుడూ ఈ చర్యలను అమలు చేయవచ్చు. </ Li>
<li> <b> కేవలం సమర్పణపై విశ్లేషించు </ b>: ఇది అప్లోడ్ చేయబడినప్పుడు సమర్పణ స్వయంచాలకంగా విశ్లేషించబడుతుంది. </ li>
<li> <b> ఆటోమేటిక్ గ్రేడింగ్ </ b>: మూల్యాంకనం ఫలితంగా గ్రేడింగ్ కోడ్లను కలిగి ఉంటే, వారు గ్రేడ్ను స్వయంచాలకంగా సెట్ చేయడానికి ఉపయోగిస్తారు. </ li>
</ Ul>';
$string['file'] = 'ఫైలు';
$string['fileNotChanged'] = 'ఫైల్ మార్చబడలేదు';
$string['file_name'] = 'ఫైల్ పేరు';
$string['fileadded'] = '\'{$A}\' ఫైల్ జోడించబడింది';
$string['filedeleted'] = '\'{$A}\' ఫైల్ తొలగించబడింది';
$string['filelist'] = 'ఫైల్ జాబితా';
$string['filenotadded'] = 'ఫైల్ జోడించబడలేదు';
$string['filenotdeleted'] = '\'{$A}\' ఫైల్ తొలగించబడలేదు';
$string['filenotrenamed'] = '\'{$A}\' పేరు మార్చబడలేదు';
$string['filerenamed'] = '{$A-> to}}\' పేరు మార్చబడింది \'{$->from}';
$string['filesChangedNotSaved'] = 'ఫైల్లు మారాయి కాని అవి సేవ్ చేయబడలేదు';
$string['filesNotChanged'] = 'ఫైళ్ళు మారలేదు';
$string['filestoscan'] = 'స్కాన్ చేయడానికి ఫైళ్ళు';
$string['fileupdated'] = '\'{$A}\' ఫైల్ నవీకరించబడింది';
$string['finalreduction'] = 'తుది తగ్గింపు';
$string['finalreduction_help'] = '<b> FR [NE / FE R] </ b> <br>
<b> FR </ b> తుది గ్రేడ్ తగ్గింపు. <br>
విద్యార్థి ద్వారా అభ్యర్ధించిన <b> NE </ b> స్వయంచాలక మూల్యాంకనలు. <br>
<b> FE </ b> ఉచిత పరిశీలనలు అనుమతించబడ్డాయి
విశ్లేషణ ద్వారా గ్రేడ్ తగ్గింపు <b> R </ b>. అది ఒక శాతం అయితే, అది మునుపటి ఫలితం మీద వర్తిస్తుంది. <br>';
$string['find'] = 'కనుగొనండి';
$string['find_replace'] = 'వెతుకు / భర్తీ';
$string['freeevaluations'] = 'ఉచిత పరిశీలనలు';
$string['freeevaluations_help'] = 'తుది గణనను తగ్గించని స్వయంచాలక అంచనాల సంఖ్య';
$string['fulldescription'] = 'పూర్తి వివరణ';
$string['fulldescription_help'] = '<p> మీరు ఇక్కడ సూచించే పూర్తి వివరణను రాయాలి. </ p>
<p> మీరు ఇక్కడ ఏదైనా వ్రాసినట్లయితే, చిన్న వివరణ బదులుగా చూపబడుతుంది. </ p>
<p> మీరు స్వయంచాలకంగా విశ్లేషించాలనుకుంటే, అసైన్మెంట్ల కోసం ఇంటర్ఫేస్లు వివరణాత్మక మరియు అస్పష్టంగా ఉండాలి. </ p>';
$string['fullscreen'] = 'పూర్తి స్క్రీన్';
$string['getjails'] = 'అమలు సర్వర్లు పొందండి';
$string['gradeandnext'] = 'గ్రేడ్ & తదుపరి';
$string['graded'] = 'గ్రేడెడ్';
$string['gradedbyuser'] = 'వినియోగదారుచే గ్రేడు చెయ్యబడింది';
$string['gradedon'] = 'అంచనా వేయబడింది';
$string['gradedonby'] = '{$ a-> gradername} ద్వారా {$ a-> date} పై సమీక్షించబడింది';
$string['gradenotremoved'] = 'గ్రేడ్ తొలగించబడలేదు. గ్రేడ్బుక్లో కార్యాచరణ కార్యాచరణను తనిఖీ చేయండి.';
$string['gradenotsaved'] = 'గ్రేడ్ సేవ్ చేయబడలేదు. గ్రేడ్బుక్లో కార్యాచరణ కార్యాచరణను తనిఖీ చేయండి.';
$string['gradeoptions'] = 'గ్రేడ్ ఎంపికలు';
$string['grader'] = 'పరీక్షకుడు';
$string['gradercomments'] = 'అసెస్మెంట్ రిపోర్ట్';
$string['graderemoved'] = 'గ్రేడ్ తీసివేయబడింది';
$string['groupwork'] = 'సముహ పని';
$string['inconsistentgroup'] = 'మీరు ఒక సమూహం యొక్క సభ్యుడు కాదు (0 o> 1)';
$string['incorrect_file_name'] = 'తప్పు ఫైల్ పేరు';
$string['individualwork'] = 'వ్యక్తిగత పని';
$string['instanceselection'] = 'VPL ఎంపిక';
$string['isexample'] = 'ఈ చర్య ఉదాహరణకు పనిచేస్తుంది';
$string['jail_servers'] = 'అమలు సర్వర్లు జాబితా';
$string['jail_servers_config'] = 'అమలు సర్వర్లు config';
$string['jail_servers_description'] = 'ప్రతి సర్వర్ కోసం ఒక లైన్ వ్రాయండి';
$string['joinedfiles'] = 'ఎంచుకున్న ఫైళ్లలో చేరింది';
$string['keepfiles'] = 'అమలు చేసేటప్పుడు ఉంచడానికి ఫైళ్ళు';
$string['keepfiles_help'] = '<p> భద్రతా సమస్యల కారణంగా, & quot; అమలు ఫైళ్లు & quot; ఫైలు vpl_execution నడుస్తున్న ముందు తొలగించబడతాయి. </ p>
అమలులో ఉన్న ఫైళ్ళలో ఏదైనా అవసరమైతే (ఉదాహరణకు, పరీక్ష డేటాగా ఉపయోగించడం), అది ఇక్కడ గుర్తించబడాలి.';
$string['keyboard'] = 'కీబోర్డ్';
$string['lasterror'] = 'చివరి లోపం సమాచారం';
$string['lasterrordate'] = 'చివరి దోషం తేదీ';
$string['listofcomments'] = 'వ్యాఖ్యల జాబితా';
$string['listsimilarity'] = 'సారూప్యతల జాబితా కనుగొనబడింది';
$string['listwatermarks'] = 'నీటి గుర్తులు జాబితా';
$string['load'] = 'లోడ్';
$string['loading'] = 'లోడ్';
$string['local_jail_servers'] = 'స్థానిక అమలు సర్వర్లు';
$string['local_jail_servers_help'] = '<p> ఇక్కడ మీరు ఈ కార్యాచరణకు మరియు వాటికి జోడించిన స్థానిక కార్యనిర్వహణ సర్వర్లను సెట్ చేయవచ్చు
అది ఆధారపడి ఉంటుంది. </ p>
<p> ప్రతి పంక్తిలోని సర్వర్ యొక్క పూర్తి URL ను ఎంటర్ చెయ్యండి. మీరు ఖాళీ పంక్తులు ఉపయోగించవచ్చు
మరియు "#" తో లైన్ మొదలుకొని వ్యాఖ్యలు. </ p>
<p> ఈ కార్యాచరణ అమలు సర్వర్ జాబితాగా ఉపయోగించబడుతుంది: సర్వర్లు ఇక్కడ సెట్ చేయబడతాయి
"ఆధారంగా" సూచించే సెట్ సర్వర్ జాబితా
ప్లస్ సాధారణ అమలు సర్వర్లు జాబితా.
మీరు ఈ చర్యను మరియు ఉత్పన్నమైన వాటిని నిరోధించాలనుకుంటే
ఇతర సర్వర్లను ఉపయోగించకుండా, అప్పుడు మీరు ఒక పంక్తిని జోడించాలి
సర్వర్ జాబితా చివరిలో "end_of_jails" కలిగి ఉంటుంది.
</ P>';
$string['manualgrading'] = 'మాన్యువల్ గ్రేడింగ్';
$string['maxexefilesize'] = 'గరిష్ట అమలు ఫైలు పరిమాణం';
$string['maxexememory'] = 'ఉపయోగించిన గరిష్ఠ మెమరీ';
$string['maxexeprocesses'] = 'గరిష్ట సంఖ్యల ప్రక్రియలు';
$string['maxexetime'] = 'గరిష్ట ఉరి సమయం';
$string['maxfiles'] = 'గరిష్ట సంఖ్యల ఫైల్లు';
$string['maxfilesexceeded'] = 'గరిష్ట సంఖ్యల ఫైల్లు మించిపోయాయి';
$string['maxfilesize'] = 'గరిష్టంగా అప్లోడ్ ఫైలు పరిమాణం';
$string['maxfilesizeexceeded'] = 'గరిష్ట ఫైల్ పరిమాణం మించిపోయింది';
$string['maximumperiod'] = 'గరిష్ట కాలం {$ a}';
$string['maxresourcelimits'] = 'గరిష్ట అమలు వనరులు పరిమితులు';
$string['maxsimilarityoutput'] = 'సారూప్యత ద్వారా గరిష్ఠ అవుట్పుట్';
$string['menucheck_jail_servers'] = 'అమలు సర్వర్లు తనిఖీ';
$string['menuexecutionfiles'] = 'అమలు ఫైళ్లు';
$string['menuexecutionoptions'] = 'ఎంపికలు';
$string['menukeepfiles'] = 'ఉంచడానికి ఫైళ్ళు';
$string['menulocal_jail_servers'] = 'స్థానిక అమలు సర్వర్లు';
$string['menuresourcelimits'] = 'వనరుల పరిమితులు';
$string['minsimlevel'] = 'చూపించడానికి కనీస సారూప్యత స్థాయి';
$string['moduleconfigtitle'] = 'VPL మాడ్యూల్ కాన్ఫిగర్';
$string['modulename'] = 'వర్చువల్ ప్రోగ్రామింగ్ ప్రయోగశాల';
$string['modulename_help'] = '<p> VPL అనేది ప్రోగ్రామింగ్ అసైన్మెంట్స్ని నిర్వహించగల Moodle కోసం ఒక కార్యాచరణ మాడ్యూల్ మరియు దీని ప్రధాన లక్షణాలు:
</ P>
<Ul>
<li> బ్రౌజర్లో ప్రోగ్రామ్ సోర్స్ కోడ్ని సవరించడానికి ప్రారంభించండి </ li>
<li> విద్యార్థులు బ్రౌజర్లో ఇంటరాక్టివ్ ప్రోగ్రామ్లను అమలు చేయగలరు </ li>
<li> మీరు ప్రోగ్రామ్లను సమీక్షించటానికి పరీక్షలను అమలు చేయవచ్చు. </ li>
<li> ఫైళ్ళ మధ్య సారూప్యత కోసం శోధించడానికి అనుమతిస్తుంది. </ li>
<li> సవరణ పరిమితులను సెట్ చేయడాన్ని మరియు బాహ్య వచన అతికింపుని నివారించడానికి అనుమతిస్తుంది. </ li>
</ Ul>
<p> <a href="http://vpl.dis.ulpgc.es"> వర్చువల్ ప్రోగ్రామింగ్ ల్యాబ్ హోమ్ పేజ్ </a> </ p>';
$string['modulename_link'] = 'mod/vpl/view';
$string['modulenameplural'] = 'వర్చువల్ ప్రోగ్రామింగ్ లాబ్స్';
$string['multidelete'] = 'బహుళ తొలగింపు';
$string['nevaluations'] = '{$ a} స్వయంచాలక మూల్యాంకనం పూర్తి';
$string['new'] = 'న్యూ';
$string['new_file_name'] = 'క్రొత్త ఫైల్ పేరు';
$string['next'] = 'తరువాత';
$string['nojailavailable'] = 'అమలు సర్వర్ అందుబాటులో లేదు';
$string['noright'] = 'మీకు ప్రాప్యత హక్కు లేదు';
$string['nosubmission'] = 'సమర్పణ అందుబాటులో లేదు';
$string['notexecuted'] = 'అమలు చేయబడలేదు';
$string['notgraded'] = 'శ్రేణింప పడని';
$string['notsaved'] = 'సేవ్ చేయబడలేదు';
$string['novpls'] = 'వర్చువల్ ప్రోగ్రామింగ్ లాబ్ నిర్వచించలేదు';
$string['nowatermark'] = 'సొంత నీటి గుర్తులు {$ a}';
$string['nsubmissions'] = '{$ a} సమర్పణలు';
$string['numcluster'] = 'క్లస్టర్ {$ a}';
$string['open'] = 'ఓపెన్';
$string['opnotallowfromclient'] = 'ఈ మెషీన్ నుండి చర్య అనుమతించబడదు';
$string['options'] = 'ఎంపికలు';
$string['optionsnotsaved'] = 'ఐచ్ఛికాలు సేవ్ చేయబడలేదు';
$string['optionssaved'] = 'ఐచ్ఛికాలు సేవ్ చేయబడ్డాయి';
$string['origin'] = 'మూలం';
$string['othersources'] = 'స్కాన్కు జోడించడానికి ఇతర మూలాలు';
$string['outofmemory'] = 'జ్ఞాపక లోపము';
$string['paste'] = 'అతికించు';
$string['pluginadministration'] = 'VPL పరిపాలన';
$string['pluginname'] = 'వర్చువల్ ప్రోగ్రామింగ్ ప్రయోగశాల';
$string['previoussubmissionslist'] = 'మునుపటి సమర్పణల జాబితా';
$string['print'] = 'ప్రింట్';
$string['proposedgrade'] = 'ప్రతిపాదిత గ్రేడ్: {$ a}';
$string['proxy'] = 'ప్రాక్సీ';
$string['proxy_description'] = 'Moodle నుండి అమలు సర్వర్లకు ప్రాక్సీ';
$string['redo'] = 'చర్య పునరావృతం';
$string['reductionbyevaluation'] = 'స్వయంచాలక మూల్యాంకనం ద్వారా తగ్గింపు';
$string['reductionbyevaluation_help'] = 'విద్యార్థి అభ్యర్థించిన ప్రతి ఆటోమేటిక్ మూల్యాంకనం కోసం విలువ లేదా శాతం ద్వారా తుది గణనను తగ్గించండి';
$string['regularscreen'] = 'రెగ్యులర్ స్క్రీన్';
$string['removegrade'] = 'గ్రేడ్ తొలగించండి';
$string['rename'] = 'పేరుమార్చు';
$string['rename_file'] = 'ఫైల్ పేరు మార్చండి';
$string['replace_find'] = 'పునఃస్థాపించుము / వెతుకుము';
$string['requestedfiles'] = 'అభ్యర్థించిన ఫైల్లు';
$string['requestedfiles_help'] = '<p> ఇక్కడ మీరు సూచించిన ఫైళ్ళకు పేర్లు మరియు దాని ప్రాథమిక కంటెంట్ను అప్డేట్ చేసారు, ఇది కార్యాచరణ యొక్క ప్రాధమిక వివరణలో సెట్ చేయబడిన గరిష్ట సంఖ్యల ఫైళ్ళకు. </ p>
<p> మీరు మొత్తం ఫైళ్ళకు పేర్లను సెట్ చేయకపోతే, పేరులేని ఫైల్లు వైకల్పికం మరియు ఏదైనా పేరు కలిగి ఉంటాయి. </ p>
<p> మీరు కోరిన ఫైళ్ళకు విషయాలను కూడా చేర్చవచ్చు, అందువల్ల మునుపటి కంటెంట్ ఎప్పటికప్పుడు సమర్పించనట్లయితే, ఈ ఎడిటర్లు మొదటిసారి ఎడిటర్తో తెరవబడతాయి. </ p>';
$string['requirednet'] = 'నికర నుండి సమర్పణ అనుమతించబడింది';
$string['requiredpassword'] = 'ఒక పాస్వర్డ్ అవసరం';
$string['resetfiles'] = 'ఫైళ్లను రీసెట్ చేయండి';
$string['resetvpl'] = '{$a} రీసెట్ చేయండి';
$string['resourcelimits'] = 'వనరుల పరిమితులు';
$string['resourcelimits_help'] = '<p> మీరు అమలు సమయము, మెమొరీ వాడకం, అమలు ఫైళ్ళ పరిమాణాలు మరియు ఏకకాలంలో అమలుపరచవలసిన ప్రక్రియల సంఖ్యల కొరకు మీరు పరిమితులను అమర్చవచ్చు. </ p>
<p> ఈ పరిమితులు స్క్రిప్టింగ్ ఫైల్స్ vpl_run.sh, vpl_debug.sh మరియు vpl_evaluate.sh నడుస్తున్నప్పుడు మరియు వాటిని నిర్మించిన ఫైల్ vpl_execution. </ p>
<p> ఈ కార్యాచరణ ఇతర కార్యాచరణ ఆధారంగా ఉంటే, బేస్ కార్యాచరణ మరియు దాని పూర్వీకుల సెట్ లేదా మాడ్యూల్ యొక్క గ్లోబల్ కాన్ఫిగరేషన్లో పరిమితులు ప్రభావితమవుతాయి. </ p>';
$string['restrictededitor'] = 'తొలగించదగిన బాహ్య ఫైలు అప్లోడ్, పేస్ట్ మరియు బాహ్య కంటెంట్ డ్రాప్';
$string['retrieve'] = 'ఫలితాలను తిరిగి పొందండి';
$string['run'] = 'రన్';
$string['running'] = 'రన్నింగ్';
$string['runscript'] = 'లిపిని అమలు చేయండి';
$string['runscript_help'] = 'ఈ కార్యాచరణలో ఉపయోగించడానికి రన్ స్క్రిప్ట్ను ఎంచుకోండి';
$string['save'] = 'సేవ్';
$string['savecontinue'] = 'సేవ్ చేసి కొనసాగించండి';
$string['saved'] = 'సేవ్';
$string['savedfile'] = '\'{\\$a}\' ఫైల్ సేవ్ చెయ్యబడింది';
$string['saveoptions'] = 'ఎంపికలను సేవ్ చేయండి';
$string['saving'] = 'సేవ్';
$string['scanactivity'] = 'కార్యాచరణ';
$string['scandirectory'] = 'డైరెక్టరీ';
$string['scanningdir'] = 'డైరెక్టరీని స్కాన్ చేస్తోంది ...';
$string['scanoptions'] = 'స్కాన్ ఎంపికలు';
$string['scanother'] = 'జోడించిన మూలాలలో సారూప్యతలను స్కాన్ చేయండి';
$string['scanzipfile'] = 'జిప్ ఫైల్';
$string['sebkeys'] = 'SEB పరీక్ష కీ/లు';
$string['sebkeys_help'] = 'SEB ఫైలు నుండి పొందిన SEB పరీక్ష కీ (లు) (గరిష్టంగా 3) <br> ఇది మాత్రమే బ్రౌజర్ చెక్ కంటే నమ్మదగినది. <br> https://safeexambrowser.org';
$string['sebrequired'] = 'SEB బ్రౌజర్ అవసరం';
$string['sebrequired_help'] = 'సరిగా ఆకృతీకరించిన SEB బ్రౌజర్ని ఉపయోగించడం అవసరం';
$string['select_all'] = 'అన్ని ఎంచుకోండి';
$string['server'] = 'సర్వర్';
$string['serverexecutionerror'] = 'సర్వర్ అమలు లోపం';
$string['shortcuts'] = 'కీబోర్డు సత్వరమార్గాలు';
$string['shortdescription'] = 'చిన్న వివరణ';
$string['similarity'] = 'సారూప్యత';
$string['similarto'] = 'ఒకేలా';
$string['startdate'] = 'నుండి అందుబాటులో';
$string['submission'] = 'సమర్పణ';
$string['submissionperiod'] = 'సమర్పణ కాలం';
$string['submissionrestrictions'] = 'సమర్పణ పరిమితులు';
$string['submissions'] = 'సమర్పణలు';
$string['submissionselection'] = 'సమర్పణ ఎంపిక';
$string['submissionslist'] = 'సమర్పణల జాబితా';
$string['submissionview'] = 'సమర్పణ వీక్షణ';
$string['submittedby'] = '{$a} ద్వారా సమర్పించబడింది';
$string['submittedon'] = 'సమర్పించిన';
$string['submittedonp'] = '{$a} లో సమర్పించబడింది';
$string['sureresetfiles'] = 'మీరు మీ మొత్తం పనిని కోల్పోయి దాని అసలు స్థితికి రీసెట్ చేయాలనుకుంటున్నారా?';
$string['test'] = 'టెస్ట్ చర్య';
$string['testcases'] = 'పరీక్ష కేసులు';
$string['testcases_help'] = 'ఈ లక్షణం విద్యార్థి ప్రోగ్రామ్ను అమలు చేయడానికి మరియు ఇచ్చిన ఇన్పుట్ కోసం దాని అవుట్పుట్ను తనిఖీ చేయడానికి అనుమతిస్తుంది. మూల్యాంకన కేసులను ఏర్పాటు చేసేందుకు మీరు ఫైల్ను & quot; vpl_evaluate.cases & quot ;.
ఫైలు "vpl_evaluate.cases" కింది ఫార్మాట్ ఉంది: <br>
<ul>
<li> "<b> కేసు </ b> = కేస్ వివరణ": పరీక్ష కేసు నిర్వచనం ప్రారంభించండి. </li>
<li> "<b> ఇన్పుట్ </ b> = టెక్స్ట్": అనేక పంక్తులను ఉపయోగించవచ్చు. ఇతర సూచనలతో ముగుస్తుంది. </li>
<li> "<b> అవుట్పుట్ </ b> = టెక్స్ట్": అనేక పంక్తులను ఉపయోగించవచ్చు. ఇతర సూచనలతో ముగుస్తుంది. ఒక కేసుకు వివిధ సరైన ఉత్పత్తిని కలిగి ఉంటుంది. అవుట్పుట్ యొక్క మూడు రకాలు ఉన్నాయి: సంఖ్యలు, టెక్స్ట్ మరియు ఖచ్చితమైన పరీక్ష:
<ul>
<li> <b> సంఖ్య </ b>: సంఖ్యల శ్రేణి (పూర్ణాంకాల మరియు ఫ్లోట్ లు) గా నిర్వచించబడింది. అవుట్పుట్లో సంఖ్యలు మాత్రమే తనిఖీ చేయబడతాయి, ఇతర వచనం విస్మరించబడుతుంది. ఫ్లోట్లలు సహనంతో తనిఖీ చేయబడతాయి </ li>
<li> <b> వచనం </ b>: డబుల్ కోట్ లేకుండా వచనంగా నిర్వచించబడింది. పదాలను మాత్రమే తనిఖీ చేస్తారు మరియు మిగిలిపోయిన అక్షరాలు విస్మరించబడతాయి, కంపేర్ కేస్ ఇన్సెన్సిటివ్గా ఉంది </ li>
<li> <b> ఖచ్చితమైన వచనం </ b>: వచనం వలె డబుల్ కోట్గా నిర్వచించబడింది. అవుట్పుట్ను పరీక్షించడానికి ఖచ్చితమైన మ్యాచ్ ఉపయోగించబడుతుంది. </li>
</ul>
</li>
</ p> = "విలువ తగ్గింపు </ b> = [విలువ | శాతము%]": అప్రమేయంగా, లోపం (గ్రేడ్_ఆరంగం / కేసులు సంఖ్య) చేత విద్యార్ధి యొక్క గ్రేడ్ (maxgrade తో ప్రారంభమవుతుంది)
మీరు తగ్గింపు విలువ లేదా శాతాన్ని మార్చవచ్చు. </li>
</ul>';
$string['timeleft'] = 'మిగిలి వున్న సమయం';
$string['timelimited'] = 'సమయం తక్కువగా ఉంది';
$string['timeout'] = 'సమయం ముగిసినది';
$string['timeunlimited'] = 'అపరిమిత సమయం';
$string['totalnumberoferrors'] = 'లోపాలు';
$string['undo'] = 'అన్డు';
$string['unexpected_file_name'] = 'సరికాని ఫైల్ పేరు: ఊహించినది \'{\\$a->expected} మరియు దొరికింది\' {\\$a->found}';
$string['unzipping'] = 'అన్జ్పిపింగ్ ...';
$string['uploadfile'] = 'ఫైల్ను అప్లోడ్ చేయండి';
$string['usevariations'] = 'వైవిధ్యాలు ఉపయోగించండి';
$string['usewatermarks'] = 'వాటర్మార్క్లను ఉపయోగించండి';
$string['usewatermarks_description'] = 'విద్యార్థి ఫైళ్ళకు వాటర్మార్క్లను జోడిస్తుంది (మద్దతు ఉన్న భాషలకు మాత్రమే)';
$string['variation_options'] = 'వేరియేషన్ ఎంపికలు';
$string['variations'] = 'బేధాలు';
$string['variations_help'] = '<p> ఒక చర్య కోసం వ్యత్యాసాల సమితి నిర్వచించబడవచ్చు. ఈ వ్యత్యాసాలు యాదృచ్ఛికంగా విద్యార్థులకు కేటాయించబడ్డాయి. </ P>
<p> ఇక్కడ ఈ సూచీ వైవిధ్యాలు ఉన్నట్లయితే, వైవిధ్యాల సమితి కోసం శీర్షికను ఉంచండి మరియు కావలసిన వైవిధ్యాలను చేర్చడానికి ఇక్కడ మీరు సూచించవచ్చు. </ p>
<p> ప్రతి వ్యత్యాసం గుర్తింపు కోడ్ మరియు వివరణ ఉంటుంది. గుర్తింపు కోడ్ పాస్ చేయడానికి <b> vpl_enviroment.sh </ b> ఫైల్ ద్వారా ఉపయోగించబడుతుంది
స్క్రిప్ట్ ఫైల్స్ ప్రతి విద్యార్థి కేటాయించిన వైవిధ్యం. HTML లో ఆకృతీకరించిన వివరణ, కేటాయించిన విద్యార్థులకు చూపబడుతుంది
సంబంధిత వైవిధ్యం. </ p>';
$string['variations_unused'] = 'ఈ కార్యాచరణ వ్యత్యాసాలు ఉన్నాయి, కానీ నిలిపివేయబడ్డాయి';
$string['variationtitle'] = 'వేరియేషన్ టైటిల్';
$string['varidentification'] = 'గుర్తింపు';
$string['visiblegrade'] = 'కనిపించే';
$string['vpl'] = 'వర్చువల్ ప్రోగ్రామింగ్ లాబ్';
$string['vpl:addinstance'] = 'కొత్త VPL సంఘటనలను జోడించండి';
$string['vpl:grade'] = 'గ్రేడ్ VPL అప్పగింత';
$string['vpl:manage'] = 'VPL అప్పగింతని నిర్వహించండి';
$string['vpl:setjails'] = 'ప్రత్యేక VPL సందర్భాల్లో అమలు సర్వర్లను సెట్ చేయండి';
$string['vpl:similarity'] = 'VPL కేటాయింపు సారూప్యతను శోధించండి';
$string['vpl:submit'] = 'VPL అప్పగింత సమర్పించండి';
$string['vpl:view'] = 'పూర్తి VPL కేటాయింపు వివరణను వీక్షించండి';
$string['vpl_debug.sh'] = 'ఈ స్క్రిప్ట్ డీబగ్గింగ్ను సిద్ధం చేస్తుంది';
$string['vpl_evaluate.cases'] = 'మూల్యాంకనం కోసం పరీక్ష కేసులు';
$string['vpl_evaluate.sh'] = 'ఈ స్క్రిప్ట్ విశ్లేషణను సిద్ధం చేస్తుంది';
$string['vpl_run.sh'] = 'ఈ స్క్రిప్ట్ అమలు చేయడానికి సిద్ధం చేస్తుంది';
$string['websocket_protocol'] = 'WebSocket ప్రోటోకాల్';
$string['websocket_protocol_description'] = 'అమలు సర్వర్లకు కనెక్ట్ చేయడానికి బ్రౌజర్ ఉపయోగించే వెబ్సాకెట్ ప్రోటోకాల్ రకం (ws: // or wss: //).';
$string['workingperiods'] = 'వర్కింగ్ కాలాలు';
$string['worktype'] = 'రకమైన పని';
