<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'te', version '4.3'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'వాస్తవ';
$string['accept'] = 'యాక్సెప్ట్ / అంగీకరించు';
$string['action'] = 'క్రియ';
$string['actionchoice'] = 'మీరు ఫైల్ ను ఏమి చెయ్యాలనుకుంటున్నారు';
$string['actions'] = 'చర్యలు';
$string['actionsfor'] = '{$a}కై చర్యలు.';
$string['actionsmenu'] = 'యాక్షన్ మెను';
$string['active'] = 'యాక్టివ్';
$string['activeusers'] = 'యాక్టివ్ యూజర్లు';
$string['activities'] = 'యాక్టివిటీస్';
$string['activities_help'] = 'క్విజ్, వికీల వంటి యాక్టివిటీస్, కోర్సుకు ఇంటరాక్టివ్ కంటెంటును చేర్చడంలో దోహదపడతాయి.';
$string['activity'] = 'యాక్టివిటీ';
$string['activityclipboard'] = 'ఈ యాక్టివిటీని తరలిస్తున్నాం:
<b>{$a}</b>';
$string['activityheader'] = 'యాక్టివిటీ పట్టిక';
$string['activityiscurrentlyhidden'] = 'ప్రస్తుతం ఈ  యాక్టివిటీని  దాచి ఉంచాం';
$string['activitymodule'] = 'యాక్టివిటీ మాడ్యూలు';
$string['activitymodules'] = 'యాక్టివిటీ మాడ్యూళ్ళు';
$string['activityreport'] = 'యాక్టివిటీ నివేదిక';
$string['activityreports'] = 'యాక్టివిటీ నివేదికలు';
$string['activityselect'] = 'వేరేచోటికి తరలించడం కోసం ఈ    యాక్టివిటీని ఎంచుకోండి';
$string['activitysince'] = '{$a} తరువాత జరిగిన యాక్టివిటీలు';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'వాడుకరి వారీగా  యాక్టివిటీలు';
$string['add'] = 'జోడించు';
$string['addactivity'] = 'ఒక యాక్టివిటీని చేర్చండి';
$string['addactivitytosection'] = 'ఈ విభాగానికి ఒక యాక్టివిటీని జోడించు';
$string['addadmin'] = 'అడ్మిన్  న్ని  జోడించండి';
$string['addblock'] = 'ఒక బ్లాకును చేర్చండి';
$string['addcomment'] = 'ఒక వ్యాఖ్యను జోడించు ...';
$string['addcountertousername'] = 'వినియోగదారు పేరుకు సంఖ్య జోడించడం ద్వారా యూజర్ ను సృష్టించండి';
$string['addcreator'] = 'కోర్స్ రూపకర్త ను జోడించండి';
$string['adddots'] = 'జోడించండి ...';
$string['added'] = 'చేర్చబడింది {$a}';
$string['addedtogroup'] = 'గ్రూపుకి చేర్చబడింది';
$string['addedtogroupnot'] = 'గ్రూపుకు చెర్చబదలేదు';
$string['addedtogroupnotenrolled'] = 'గ్రూపుకు చెర్చబదలేదు ఎందుకంటే కోర్స్ లో నమోదు
కలేదు';
$string['addfilehere'] = 'ఇక్కడ  ఫైల్ ను (s) జోడించండి';
$string['addinganew'] = 'ఒక కొత్త  {$a} జోడించడం';
$string['addinganewto'] = 'ఒక కొత్త {$a->what} కు {$a->to} జోడించడం';
$string['addingdatatoexisting'] = 'ఇప్పటికే ఉన్న  డేటా ను  జోడించడం';
$string['additionalnames'] = 'అదనపు పేర్లు';
$string['addlinkhere'] = 'ఇక్కడ లింక్ను జోడించండి';
$string['addnew'] = 'కొత్త {$a} ను జోడించుము';
$string['addnewcategory'] = 'కొత్త వర్గాన్ని జోడించండి';
$string['addnewcourse'] = 'ఒక కొత్త కోర్సును జోడించండి';
$string['addnewuser'] = 'ఒక క్రొత్త వినియోగదారుని జోడించండి';
$string['addnousersrecip'] = 'స్వీకర్త జాబితాలో ఈ {$a} యాక్సెస్ చేయని యూజర్లను జోడించడం';
$string['addpagehere'] = 'ఇక్కడ టేక్ష్ట్ ను జోడించండి';
$string['addresource'] = 'ఒక రిసోర్స్ ను  జోడించండి ...';
$string['addresourceoractivity'] = 'ఒక చర్య లేదా రిసోర్స్  లను  జోడించండి';
$string['addresourcetosection'] = 'ఒక విభాగం నికి  రిసోర్స్ జోడించండి';
$string['address'] = 'అడ్రస్';
$string['addsections'] = 'విభాగాలను జోడించండి';
$string['addstudent'] = 'స్టూడెంట్ ని  జోడించండి';
$string['addsubcategory'] = 'ఒక సబ్ క్యాటగరీ ని జోడించండి';
$string['addteacher'] = 'టీచర్ ని జోడించండి';
$string['admin'] = 'అడ్మిన్';
$string['adminhelpaddnewuser'] = 'మాన్యువల్ గా ఒక న్యూ యూజర్ అకౌంట్ ని సృష్టించడానికి';
$string['adminhelpassignadmins'] = 'నిర్వాహకులు ఏదైనా చెయ్యచు  మరియు సైట్ లో ఎక్కడికైనా వెళ్ళవచ్చు';
$string['adminhelpassigncreators'] = 'కోర్స్ రూపకర్తలు క్రొత్త కోర్సులను సృష్టించగలరు';
$string['adminhelpassignsiteroles'] = 'ప్రత్యేక వినియోగదారులకు నిర్వచించిన సైట్ పాత్రలు వర్తిస్తాయి';
$string['adminhelpassignstudents'] = 'ఒక కోర్స్ లోకి వెళ్ళి అడ్మిన్ మెను నుండి విద్యార్థులను జోడించండి';
$string['adminhelpauthentication'] = 'మీరు ఇంటర్నల్ యూజర్ ఖాతాలను లేదా ఎక్స్టర్నల్ డేటాబేస్లను ఉపయోగించవచ్చు';
$string['adminhelpbackup'] = 'కన్ఫిగర్ ఆటోమేటెడ్ బ్యాకప్ లు మరియు వారి షెడ్యూల్ను';
$string['adminhelpconfiguration'] = 'కన్ఫిగర్  సైట్ ఏలా  కనిపించే ది అండ్ ఎలా పనిచేస్తుంది';
$string['adminhelpconfigvariables'] = 'సైట్లో యొక్క జనరల్ ఆపరేషన్ ఏ విధంగా ప్రభావితం చేస్తున్నాయో వేరియబుల్స్ కన్ఫిగర్ చెయ్యి';
$string['adminhelpcourses'] = 'కోర్సులను అండ్ కేతగిరీలు నిర్వచించండి అండ్ వాటిని ప్రజలు కేటాయించాలని పెండింగ్ కోర్సులను సవరించడానికి';
$string['adminhelpeditorsettings'] = 'HTML ఎడిటర్ కోసం బేసిక్ సెట్టింగులు నిర్వచించండి';
$string['adminhelpedituser'] = 'యూజర్ ఖాతాల జాబితాను బ్రౌజ్ చేయండి అండ్  వాటి ని సవరించండి';
$string['adminhelpenvironment'] = 'మీ సర్వర్ కరెంట్ అండ్ భవిష్యత్తులో సంస్థాపనా అవసరాల సరయినది ఎలా పరిశీలించండి';
$string['adminhelpfailurelogs'] = 'విఫలమైన లాగిన్లు అఫ్ లాగ్లు బ్రౌజ్ చెయ్యండి';
$string['adminhelplanguage'] = 'తనిఖీ అండ్ కరెంట్ భాష ప్యాక్ సవరించడం కోసం';
$string['adminhelplogs'] = 'ఈ సైట్లో లో అన్ని కార్యకలాపాల లాగ్లు బ్రౌజ్ చెయ్యండి';
$string['adminhelpmanageblocks'] = 'సంస్థాపించిన బ్లాక్లను అండ్ వారి సెట్టింగులను నిర్వహించండి';
$string['adminhelpmanagedatabase'] = 'సూటిగా డేటా బేస్ యాక్సెస్ (జాగ్రత్తగా!)';
$string['adminhelpmanagefilters'] = 'టెక్స్ట్ను ఫిల్టర్లను అండ్ సంభందిత అమర్పులను ఎంచుకోండి';
$string['adminhelpmanagemodules'] = 'సంస్థాపించిన మాడ్యూల్స్ అండ్ వారి సెట్టింగులను నిర్వహించండి';
$string['adminhelpmanageroles'] = 'యూజర్లు వర్తించబడింది ఉండవచ్చు ఆ పాత్రలు సృష్టించండి మరియు నిర్వచించటానికి';
$string['adminhelpmymoodle'] = 'యూజర్లు కోసం నా మూడ్లె బ్లాక్లను కన్ఫిగర్';
$string['adminhelpreports'] = 'సైట్ స్థాయి నివేదికలు';
$string['adminhelpsitefiles'] = 'సామాన్య దస్త్రాలను ప్రచురించేందుకు, బయటి బ్యాకప్పులను ఎక్కించేందుకు';
$string['adminhelpsitesettings'] = 'సైటు మొదటిపేజీ ఎలా కనబడాలో నిర్వచించండి';
$string['adminhelpstickyblocks'] = 'Moodle వ్యాప్త బ్లాకులను అమర్చుకోండి';
$string['adminhelpthemes'] = 'సైటు కనిపించే విధానాన్ని ఎంచుకోండి (రంగులు, ఖతులు మొదలైనవి)';
$string['adminhelpuploadusers'] = 'టెక్స్టు దస్త్రం నుండి కొత్త వాడుకరి ఖాతాలను దిగుమతి చేసుకోండి';
$string['adminhelpusers'] = 'మీ వాడుకరులను నిర్వచించి, ధ్రువీకరణను అమర్చుకోండి';
$string['adminhelpxmldbeditor'] = 'XMLDB దస్త్రాలను సవరించేందుకు ఇంటరుఫేసు. డెవలపర్లకు మాత్రమే.';
$string['administration'] = 'పరిపాలన';
$string['administrationsite'] = 'సైట్ పరిపాలన';
$string['administrator'] = 'నిర్వాహకులు';
$string['administratordescription'] = 'నిర్వాహకులు సాధారణంగా అన్ని కోర్సుల్లో, సైట్లో  ఏదైనా చేయవచ్చు.';
$string['administrators'] = 'నిర్వాహకులు';
$string['administratorsall'] = 'నిర్వాహకులు  మొత్తం';
$string['administratorsandteachers'] = 'నిర్వాహకులు మరియు ఉపాధ్యాయులు';
$string['advanced'] = 'ఆధునిక';
$string['advancedfilter'] = 'అధునాతన శోధన';
$string['advancedsettings'] = 'అధునాతన సెట్టింగ్లు';
$string['afterresource'] = 'వనరుల తర్వాత "{$a}"';
$string['aftersection'] = 'తరువాత విభాగం "{$a}"';
$string['again'] = 'మళ్ళీ';
$string['agelocationverification'] = 'వయస్సు మరియు స్థాన ధృవీకరణ';
$string['ajaxuse'] = 'AJAX మరియు జావాస్క్రిప్ట్';
$string['all'] = 'అన్ని';
$string['allactions'] = 'అన్ని చర్యలు';
$string['allactivities'] = 'అన్ని కార్యక్రమాలు';
$string['allcategories'] = 'అన్ని వర్గములు';
$string['allchanges'] = 'అన్ని మార్పులు';
$string['alldays'] = 'అన్ని రోజులు';
$string['allfiles'] = 'దస్త్రాలన్నీ';
$string['allgroups'] = 'అన్ని గుంపులూ';
$string['alllogs'] = 'అన్ని లాగ్‍లూ';
$string['allmods'] = 'అన్ని {$a}';
$string['allow'] = 'అనుమతించు';
$string['allowinternal'] = 'అంతర్గత పద్ధతులను కూడా అనుమతించు';
$string['allownone'] = 'ఎవరినీ అనుమతించవద్దు';
$string['allownot'] = 'అనుమతించవద్దు';
$string['allowstealthmodules'] = 'రహస్య కార్యకలాపాలను అనుమతించండి';
$string['allowstealthmodules_help'] = 'ప్రారంభించబడితే, కార్యకలాపాలు అందుబాటులో ఉంటాయి కానీ కోర్సు పేజీలోని కనిపించే విభాగాలలో చూపబడవు. అలా అయితే, రహస్య వనరులకి లింక్లు తప్పనిసరిగా ఒక పేజీ వనరు నుండి అందించబడతాయి. స్టెల్త్ కార్యకలాపాలు ఇప్పటికీ గ్రంప్ బుక్ మరియు ఇతర నివేదికలలో ఇవ్వబడ్డాయి.';
$string['allparticipants'] = 'పాల్గొనువారందరూ';
$string['allteachers'] = 'ఉపాధ్యాయులందరూ';
$string['alphanumerical'] = 'అంకెలు, అక్షరాలు, హైఫను (-), చుక్క (.) మాత్రమే ఉండవచ్చు';
$string['alreadyconfirmed'] = 'నమోదు ఈసరికే ధ్రువీకరించబడింది';
$string['alternatename'] = 'ప్రత్యామ్నాయ పేరు';
$string['always'] = 'ఎల్లప్పుడూ';
$string['and'] = '{$a->one} మరియు {$a->two}';
$string['answer'] = 'సమాధానం';
$string['any'] = 'ఏదైనా';
$string['appearance'] = 'రూపురేఖలు';
$string['approve'] = 'ఆమోదించు';
$string['areyousure'] = 'నీవు చేసింది సరైనదేనా';
$string['areyousuretorestorethis'] = 'కొనసాగించమంటారా?';
$string['areyousuretorestorethisinfo'] = 'ఈ ప్రాసెస్ లోనే తరువాత, ఈ బ్యాకప్పును ఏదైనా ఒక కోర్సుకు చేర్చడానికి లేదా దీన్ని వాడి, ఓ కొత్త కోర్సును సృష్టించడానికీ మీకు అవకాశం ఉంటుంది.';
$string['asc'] = 'ఆరోహణ';
$string['assessment'] = 'అంచనా';
$string['assignadmins'] = 'నిర్వాహకులకు జోడించు';
$string['assigncreators'] = 'రూపకర్తలకు జోడించు';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'సైటు వ్యాప్త పాత్రలను జోడించు';
$string['authenticateduser'] = 'అధీకృత వాడుకరి';
$string['authenticateduserdescription'] = 'లాగినై ఉన్న వాడుకరులందరూ';
$string['authentication'] = 'ధ్రువీకరణ';
$string['authenticationplugins'] = 'ధ్రువీకరణ ప్లగిన్‍లు';
$string['autosubscribe'] = 'వేదికకు ఆటో-చందా ';
$string['autosubscribeno'] = 'వద్దు: వేదికల్లో నన్ను ఆటోమాటిగ్గా చేర్చవద్దు';
$string['autosubscribeyes'] = 'సరే: నేను టపా రాసినపుడు, ఆ వేదికలో నన్ను చేర్చు';
$string['availability'] = 'అందుబాటు';
$string['availablecourses'] = 'అందుబాటులో ఉన్న కోర్సులు';
$string['back'] = 'వెనక్కు';
$string['backto'] = 'తిరిగి {$a} కు';
$string['backtocourselisting'] = 'తిరిగి కోర్సు జాబితాకు';
$string['backtohome'] = 'సైట్ ఇంటికి తిరిగి వెళ్ళు';
$string['backtopageyouwereon'] = 'తిరిగి ఇంతకు ముందు మీరున్న పేజీకి';
$string['backup'] = 'బ్యాకప్పు';
$string['backupactivehelp'] = 'ఆటోమాటిక్ బ్యాకప్పులు తియ్యాలో లేదో ఎంచుకోండి';
$string['backupadhocpending'] = 'కోర్సు బ్యాకప్ తాత్కాలిక పని వాయిదా';
$string['backupcancelled'] = 'బ్యాకప్పును రద్దు చేసాం';
$string['backupcoursefileshelp'] = 'చేతనం చేస్తే, కోర్సు దస్త్రాలు ఆటోమాటిక్ బ్యాకప్పుల్లో ఉంటాయి ';
$string['backupdate'] = 'బ్యాకప్పు తేదీ';
$string['backupdatenew'] = '&nbsp; {$a->TAG} ఇప్పుడు {$a->year}{$a->month} {$a->mday},{$a->weekday}<br />';
$string['backupdateold'] = '&nbsp; {$a->TAG} అప్పుడు {$a->year}{$a->month} {$a->mday},{$a->weekday}<br />';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'బ్యాకప్పు వివరాలు';
$string['backuperrorinvaliddestination'] = 'బ్యాకప్ గమ్యం ఫోల్డర్ ఉనికిలో లేదు లేదా వ్రాయదగినది కాదు.';
$string['backupexecuteathelp'] = 'ఆటోమాటిక్ బ్యాకప్పులు ఏ సమయానికి నడపాలో ఎంచుకోండి.';
$string['backupfailed'] = 'మీవి కొన్ని కోర్సులు భద్రం కాలేదు';
$string['backupfilename'] = 'బ్యాకప్పు చెయ్యి';
$string['backupfinished'] = 'బ్యాకప్పు జయప్రదంగా పూర్తయింది';
$string['backupfromthissite'] = 'బ్యాకప్పును ఈ సైటులో చేసారా?';
$string['backupgradebookhistoryhelp'] = 'దీన్ని చేతనం చేస్తే, గ్రేడ్‍బుక్ చరితాన్ని ఆటోమాటిక్ బ్యాకప్పుల్లో కలుపుతాం. ఇది పని చెయ్యాలంటే సర్వరు అమరికల్లో గ్రేడ్ చరితం అచేతనమై ఉండకూడదని (disablegradehistory) గుర్తుంచుకోండి.';
$string['backupincludemoduleshelp'] = 'ఆటోమాటిక్ బ్యాకప్పుల్లో, కోర్సు మాడ్యూళ్ళను ఉంచాలా లేదా - వాడుకరుల డేటాతోగానీ, అది లేకుండాగానీ  - అనేది ఎంచుకోండి';
$string['backupincludemoduleuserdatahelp'] = 'ఆటోమాటిక్ బ్యాకప్పుల్లో, మాడ్యూలు వాడుకరి డేటాను ఉంచాలా లేదా  అనేది ఎంచుకోండి';
$string['backuplogdetailed'] = 'వివరమైన ఎక్జిక్యూషన్ లాగ్';
$string['backuploglaststatus'] = 'చిట్టచివరి ఎక్జిక్యూషన్ లాగ్';
$string['backupmissinguserinfoperms'] = 'గమనిక: ఈ బ్యాకప్పులో వాడుకరి డేటా ఏమీ లేదు. అభ్యాసము, వర్కుషాపు పనుల మాడ్యూళ్ళు ఈ రకపు బ్యాకప్పుతో ఒప్పవు కాబట్టి అవి ఈ బ్యాకప్పులో ఉండవు.';
$string['backupnext'] = 'తరువాతి బ్యాకప్పు';
$string['backupnonisowarning'] = 'హెచ్చరిక: ఈ బ్యాకప్పు నాన్-యూనికోడ్ Moodle వెర్షనుకు (1.6 కు ముందు) చెందినది. ఒకవేళ ఈ బ్యాకప్పులో non-ISO-8859-1 పాఠ్యాలుంటే, వాటిని ఈ యూనికోడు వెర్షనుకు రీస్టోరు చేసే ప్రయత్నం చేసినపుడు, అవి చెడిపోతాయి. ఈ బ్యాకప్పును సరిగ్గా రీస్టోరు చేసే విధానం గురించి మరింత సమాచారం కోసం <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> చూడండి.';
$string['backupnotyetrun'] = 'స్వయంచాలక బ్యాకప్ పెండింగ్';
$string['backuporiginalname'] = 'బ్యాకప్పు పేరు';
$string['backuproleassignments'] = 'ఈ పాత్రలకు ఆదేశాలను బ్యాకప్పు చెయ్యి';
$string['backupsavetohelp'] = 'బ్యాకప్పు దస్త్రాలను భద్రం చేసే స్థలం యొక్క పూర్తి పాత్<br />(కోర్సు డిఫాల్టు డైరెక్టరీలోనే భద్రపరచేందుకు, ఖాళీగా వదిలెయ్యండి)';
$string['backupsitefileshelp'] = 'చేతనం చేస్తే కోర్సుల్లో వాడిన సైటు దస్త్రాలు ఆటోమాటిక్ బ్యాకప్పులో చేర్చబడతాయి';
$string['backuptakealook'] = 'ఇక్కడ మీ బ్యాకప్పు లాగ్‍లను ఓ మారు చూడండి:
{$a} ';
$string['backupuserfileshelp'] = 'ఆటోమాటిక్ బ్యాకప్పుల్లో వాడుకరి దస్త్రాలను (ఉదా: ప్రవర బొమ్మలు) చేర్చాలో లేదో ఎంచుకోండి';
$string['backupversion'] = 'బ్యాకప్పు వెర్షను';
$string['badges'] = 'చిహ్నములు';
$string['block'] = 'బ్లాకు';
$string['blockconfiga'] = '{$a} బ్లాకును కాన్ఫిగరు చెయ్యడం';
$string['blockconfigbad'] = 'ఈ బ్లాకును సరిగ్గా అమలు చెయ్యలేదు. అంచేత కాన్ఫిగరు ఇంటరుఫేసును ఇవ్వలేం. ';
$string['blocks'] = 'బ్లాకులు';
$string['blocksaddedit'] = 'బ్లాకులను చేర్చు/సవరించు';
$string['blockseditoff'] = 'బ్లాకుల సవరింపులు ఆఫ్';
$string['blocksediton'] = 'బ్లాకుల సవరింపులు ఆన్';
$string['blocksetup'] = 'బ్లాకు టేబుళ్ళను అమర్చుకోవడం';
$string['blocksuccess'] = '{$a} టేబుళ్ళను సరిగ్గా అమర్చాం ';
$string['brief'] = 'క్లుప్తంగా';
$string['bulkactions'] = 'సమూహ చర్యలు';
$string['bulkactionselect'] = '{$a} సమూహ చర్య ఎంపిక';
$string['bulkmovecoursessuccess'] = '{$a->category} లోకి విజయవంతంగా తరలించబడింది {$a->courses} కోర్సులు';
$string['bycourseorder'] = 'కోర్సువారీగా';
$string['byname'] = '{$a} వారీగా';
$string['bypassed'] = 'తప్పించబడింది';
$string['cachecontrols'] = 'క్యాషె నియంత్రణలు';
$string['calltofeedback'] = 'ఈ సాఫ్ట్ వేర్ రూపకర్తలు దీనిపై మీ అభిప్రాయము తెలుసుకోవాలనుకుంటున్నారు';
$string['calltofeedback_give'] = 'ఈ  సాఫ్ట్ వేర్  పై మీ అభిప్రాయం తెలియచేయండి.';
$string['calltofeedback_remind'] = 'తరువాత గుర్తు చేయుము';
$string['cancel'] = 'రద్దు చెయ్యి';
$string['cancelled'] = 'రద్దు చేసాం';
$string['categories'] = 'కోర్సు వర్గాలు';
$string['categoriesandcourses'] = 'కోర్సు వర్గాలు మరియు కోర్సులు';
$string['category'] = 'వర్గం';
$string['categoryadded'] = '’{$a}’ వర్గాన్ని చేర్చాం';
$string['categorybulkaction'] = 'ఎంచుకున్న వర్గముల కోసం సమూహ చర్యలు';
$string['categorycontents'] = 'ఉపవర్గాలు, కోర్సులూ';
$string['categorycurrentcontents'] = '{$a} లోని అంశాలు';
$string['categorydeleted'] = '’{$a}’ వర్గాన్ని తొలగించాం';
$string['categoryduplicate'] = '’{$a}’ అనే వర్గం ఈసరికే ఉంది!';
$string['categoryhidden'] = 'గుప్థము/దాచబడినది.';
$string['categorymodifiedcancel'] = 'వర్గంలో మార్పుచేర్పులు చేసారు! రద్దు చేసి మళ్ళీ ప్రయత్నించండి.';
$string['categoryname'] = 'వర్గం పేరు';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory} యొక్క ఉపవర్గం';
$string['categoryupdated'] = '\'{$a}\' వర్గాన్ని తాజాకరించాం';
$string['changedpassword'] = 'సంకేతపదాన్ని మార్చాం';
$string['changepassword'] = 'సంకేతపదాన్ని మార్చు';
$string['changesmadereallygoaway'] = 'మీరు మార్పులను చేశారు. మీరు పేజీ నుండి వెళ్ళిపోతే మీరు చేసిన మార్పులు కోల్పోతారు ఫర్వాలేదా?';
$string['changessaved'] = 'మార్పులను భద్రపరచాం';
$string['check'] = 'పరిశీలించు';
$string['checkactual'] = 'వాస్తవం';
$string['checkall'] = 'అన్నిటినీ పరిశీలించు';
$string['checkexpected'] = 'ఊహించబడినది';
$string['checkingbackup'] = 'బ్యాకప్పును పరిశీలిస్తున్నాం';
$string['checkingcourse'] = 'కోర్సును పరిశీలిస్తున్నాం';
$string['checkingforbbexport'] = 'బ్లాక్‍బోర్డు ఎగుమతి కొరకు పరిశిలిస్తున్నాం';
$string['checkinginstances'] = 'ఇన్‍స్టన్సులను పరిశిలిస్తున్నాం';
$string['checkingsections'] = 'విభాగాలను పరిశిలిస్తున్నాం';
$string['checklanguage'] = 'భాషను పరిశీలించు';
$string['checknone'] = 'ఏమీ పరిశీలించవద్దు';
$string['checks'] = 'తనిఖీ';
$string['checksok'] = 'అన్ని\'{$a}\' తనిఖీలు సరి.';
$string['childcoursenotfound'] = 'చైల్డు కోర్సు కనబడలేదు!';
$string['childcourses'] = 'చైల్డు కోర్సులు';
$string['choose'] = 'ఎంచుకోండి';
$string['choosecourse'] = 'కోర్సును ఎంచుకోండి';
$string['choosedots'] = 'ఎంచుకోండి...';
$string['chooselivelogs'] = 'లేదా వర్తమాన పనులను గమనించండి';
$string['chooselogs'] = 'మీరు చూడదలచిన లాగ్‍లను ఎంచుకోండి';
$string['choosereportfilter'] = 'నివేదిక కొరకు వడపోతను ఎంచుకోండి';
$string['choosetheme'] = 'థీమును ఎంచుకోండి';
$string['chooseuser'] = 'వాడుకరిని ఎంచుకోండి';
$string['city'] = 'నగరం/పట్టణం';
$string['cleaningtempdata'] = 'టెంప్ డేటాను తీసేస్తున్నాం';
$string['clear'] = 'తీసెయ్యి';
$string['clearsearch'] = 'సెర్చ్ ఇన్ పుట్ క్లియర్ చెయ్యి';
$string['clickhelpiconformoreinfo'] = '... ఇంకా ఉంది ... వ్యాసాన్ని పూర్తిగా చదివేందుకు, సహాయం బొమ్మ మీద నొక్కండి';
$string['clickhere'] = 'ఇక్కడ నొక్కండి ...';
$string['clicktochangeinbrackets'] = '{$a} (మార్చడానికి క్లిక్ చెయ్యండి)';
$string['clicktohideshow'] = 'పరచాలన్నా, మడవాలన్నా నొక్కండి';
$string['closebuttontitle'] = 'మూసెయ్యి';
$string['closewindow'] = 'ఈ విండోను మూసెయ్యి';
$string['collapse'] = 'ముడుచుకునిపోవు';
$string['collapseall'] = 'అన్నిటినీ మడిచెయ్యి';
$string['collapsecategory'] = '{$a} ముడుచుకునిపోవు';
$string['commentincontext'] = 'ఈ వ్యాఖ్యను సంబంధిత సందర్భంలో చూడండి';
$string['comments'] = 'వ్యాఖ్యలు';
$string['commentscount'] = 'వ్యాఖ్యలు ({$a})';
$string['commentsnotenabled'] = 'వ్యాఖ్యల సదుపాయం ఎనేబుల్ లేదు';
$string['commentsrequirelogin'] = 'మీరు వ్యాఖ్యలు వీక్షించడానికి లాగిన్ అవసరం';
$string['comparelanguage'] = 'వర్తమాన భాషను పోల్చు, సవరించు';
$string['complete'] = 'సంపూర్ణం';
$string['completed'] = 'సంపూర్ణం / పూర్తి అయ్యింది';
$string['completereport'] = 'పూర్తి నివేదిక';
$string['configuration'] = 'కాన్ఫిగరేషను';
$string['confirm'] = 'నిర్ధారించు';
$string['confirmcheckfull'] = '{$a} ను నిర్ధారించాలని మీరు ఖచ్చితంగా నిశ్చయించుకున్నారా?';
$string['confirmcoursemove'] = 'ఈ కోర్సును ({$a-> course}) వర్గము ({$a->category}) లోనికి నీవు ఖచితంగా తరలించాలనుకుంటున్నారా?';
$string['confirmdeletesection'] = 'మీరు "{$ a}" ను పూర్తిగా తొలగించాలని మరియు అది కలిగి ఉన్న అన్ని కార్యాచరణలను ఖచ్చితంగా మీరు ఖచ్చితంగా భావిస్తున్నారా?';
$string['confirmed'] = 'మీ నమోదు నిర్ధారించబడింది';
$string['confirmednot'] = 'మీ నమోదు ఇంకా నిర్ధారింపబడలేదు';
$string['considereddigitalminor'] = 'మీరు ఒక డిజిటల్ మైనర్ గా పరిగణించబడ్డారు.';
$string['content'] = 'కంటెంటు';
$string['contentbank'] = 'కంటెంట్ బాంక్';
$string['contentexport_aboutthiscourse'] = 'కోర్సు సారంశం';
$string['contentexport_coursesummary'] = 'ఈ ఫైల్  <a href="{$a->courselink}">{$a->coursename}</a> నుంచి దిగుమతి అయిన కంటెంట్ లో భాగం.';
$string['contentexport_viewfilename'] = '{$a} ఫైల్ ని వీక్షించండి.';
$string['continue'] = 'కొనసాగించు';
$string['continuetocourse'] = 'మీ కోర్సులోకి ప్రవేశించేందుకు ఇక్కడ నొక్కండి';
$string['convertingwikitomarkdown'] = 'వికీని మార్క్‍డౌనుకు మారుస్తున్నాం';
$string['cookiesenabled'] = 'మీ బ్రౌజరులో కూకీలను చేతనం చెయ్యాలి';
$string['cookiesenabled_help'] = 'ఈ సైటు రెండు కూకీలను వాడుతుంది:

తప్పనిసరిగా అవద్సరమైనది సెషను కూకీ. దీన్నే  MoodleSession అని అంటారు. సైటులో మీరున్నంత సేపూ, పేజీ నుండి పేజీకి వెళ్ళినపుడు మీ లాగిన్ను తీసుకెళ్ళేందుకూ అవసరమైన ఈ కూకీని మీరు తప్పనిసరిగా అనుమతించాలి. లాగౌటైనప్పుడు గానీ, బ్రౌజరును మూసేసినప్పుడు గానీ ఈ కూకీని నశింపజేస్తాం (మీ బ్రౌజరులోనూ, సర్వరులోనూ కూడా).

ఇక రెండో కూకీ కేవలం సౌకర్యం కోసం ఉద్దేశించినది. దీన్ని సాధారణంగా  MOODLEID అని అంటాం. అది మీ బ్రౌజరు పరధిలోపల  మీ వాడుకరిపేరును గుర్తుంచుకుంటుంది. అంటే ఈ సైటుకు తిరిగివచ్చినపుడు లాగిన్ పేజీలో మీ వాడుకరిపేరు ముందే నింపేసి ఉంటుంది. ఈ కూకీని అనుమతించకపోవడం భద్రత పరంగా మంచిదే - ఏముందీ.. లాగినవదలచినప్పుడు మీ వాడుకరిపేరును టైపించవలసి ఉంటుందంతే.';
$string['cookiesenabledonlysession'] = 'మీ బ్రౌజరులో కూకీలను చేతనం చెయ్యాలి';
$string['cookiesnotenabled'] = 'ప్రస్తుతం మీ బ్రౌజరులో కూకీలు చేతనమై లేవు';
$string['copy'] = 'కాపీ';
$string['copyasnoun'] = 'కాపీ';
$string['copyingcoursefiles'] = 'కోర్సు దస్త్రాలను కాపీ చెయ్యి';
$string['copyingsitefiles'] = 'కోర్సులో వాడే సైటు దస్త్రాలను కాపీ చేస్తున్నాం';
$string['copyinguserfiles'] = 'వాడుకరుల దస్త్రాలను కాపీ చేస్తున్నాం';
$string['copyingzipfile'] = 'zip దస్త్రాన్ని కాపీ చేస్తున్నాం';
$string['copyrightnotice'] = 'కాపీహక్కుల గమనిక';
$string['coresystem'] = 'సిస్టము';
$string['cost'] = 'ఖరీదు';
$string['costdefault'] = 'డిఫాల్టు ఖరీదు';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'దేశం';
$string['course'] = 'కోర్సు';
$string['courseadministration'] = 'కోర్సు నిర్వహణ';
$string['courseapprovedemail'] = 'మీరడిగిన కోర్సు {$a->name}, ఆమోదించబడింది. మిమ్మల్ని అందులో ఒక {$a->teacher} గా చేసాం. మీ కొత్త కోర్సుకు వెళ్ళేందుకు, {$a->url} కు వెళ్ళండి';
$string['courseapprovedemail2'] = 'మీరడిగిన కోర్సు {$a->name}, ఆమోదించబడింది. మీ కొత్త కోర్సుకు వెళ్ళేందుకు, {$a->url} కు వెళ్ళండి';
$string['courseapprovedfailed'] = 'కోర్సు అమోదించబడినట్లుగా భద్రపరచలేకపోయాం';
$string['courseapprovedsubject'] = 'మీ కోర్సు ఆమోదించబడింది';
$string['courseavailable'] = 'ఈ కోర్సు విద్యార్థులకు అందుబాటులో ఉంది';
$string['courseavailablenot'] = 'ఈ కోర్సు విద్యార్థులకు అందుబాటులో లేదు';
$string['coursebackup'] = 'కోర్సు బ్యాకప్పు';
$string['coursebulkaction'] = 'ఎంపిక కోర్సులు కోసం సమూహ చర్యలు';
$string['coursecategories'] = 'కోర్సు వర్గాలు';
$string['coursecategory'] = 'కోర్సు వర్గం';
$string['coursecategory_help'] = 'ఈ సెట్టింగు, ఏదైనా కోర్సు కోర్సుల జాబితాలో ఏ వర్గంలో కనిపిస్తుందో నిర్ణయిస్తుంది.';
$string['coursecategorydeleted'] = 'తొలగించబడిన కోర్సు వర్గం {$a}';
$string['coursecatmanagement'] = 'కోర్సు మరియు వర్గం నిర్వహణ';
$string['coursecompletion'] = 'కోర్సు సంపూర్ణం';
$string['coursecompletions'] = 'కోర్సు సంపూర్ణాలు';
$string['coursecreators'] = 'కోర్సు రూపకర్త';
$string['coursecreatorsdescription'] = 'కోర్సు రూపకర్తలు కొత్త కోర్సులను రూపొందించగలరు';
$string['coursedeleted'] = 'తొలగించబడిన కోర్సు {$a} ';
$string['coursedetails'] = 'కోర్సు వివరాలు';
$string['coursedisplay'] = 'కోర్సు నమూనా';
$string['coursedisplay_help'] = 'ఈ సెట్టింగ్ మొత్తం ఒక్క పేజీలో ప్రదర్శించబడిన లేదా అనేక పేజీలను విభజించబడింది అన్నది నిర్ణయిస్తుంది.';
$string['coursedisplay_multi'] = 'ఒక పేజీలో ఒక్క విభాగం చూపించు';
$string['coursedisplay_single'] = 'ఒకే పేజీలో అన్ని విభాగాలు చూపించు';
$string['courseduration'] = 'కోర్సు వ్యవధి';
$string['courseduration_desc'] = 'కోర్సు వ్యవధి డిఫాల్ట్ కోర్సు ముగింపు తేదీని లెక్కించడానికి ఉపయోగించబడుతుంది. కోర్సు ముగింపు తేదీ కోర్సు యొక్క వినియోగదారుల జాబితాలో ఒక కోర్సును చేర్చాలా వద్దా అని నిర్ణయించడానికి ఉపయోగిస్తారు. ఇది కస్టమ్ నివేదికల ద్వారా కూడా ఉపయోగించబడుతుంది. ముగింపు తేదీ తర్వాత వినియోగదారులు ఇప్పటికీ కోర్సులో ప్రవేశించవచ్చు.';
$string['courseenddateenabled'] = 'కోర్సు ముగింపు తేదీ డిఫాల్ట్గా ప్రారంభించబడింది';
$string['courseenddateenabled_desc'] = 'కొత్త కోర్సుల కోసం కోర్సు ముగింపు తేదీ ఎప్పటికప్పుడు ఎనేబుల్ చేయబడిందో మరియు కోర్సు వ్యవధి నుండి లెక్కించిన తేదీకి అమర్చినట్లయితే ఈ సెట్టింగ్ నిర్ణయిస్తుంది.';
$string['courseextendednamedisplay'] = '{$a->చిన్న పేరు} {$a->పూర్తి పేరు}';
$string['coursefiles'] = 'లెగసీ కోర్సు ఫైళ్లు';
$string['coursefilesedit'] = 'లెగసీ కోర్సు ఫైళ్ళను సవరించడానికి';
$string['coursefileswarning'] = 'కోర్సు ఫైళ్లు తక్కువ చేయబడ్డాయి';
$string['coursefileswarning_help'] = 'కోర్సు ఫైళ్లు మూడ్లె 2.0 నుండి తక్కువ చేయబడ్డాయి, సాధ్యమైనంత వరకు బదులుగా బాహ్య రిపోజిటరీ ఉపయోగించండి.';
$string['courseformatdata'] = 'కోర్సు ఫార్మాటు డేటా';
$string['courseformatoptions'] = '{$ A} కోసం ఆకృతీకరణ ఎంపికలు';
$string['courseformats'] = 'కోర్సు ఫార్మాట్లు';
$string['courseformatudpate'] = 'ఫార్మాట్ అప్డేట్';
$string['coursegrades'] = 'కోర్సు గ్రేడ్లు';
$string['coursehelpcategory'] = 'కోర్సు జాబితాలో కోర్సును పెట్టండి. కోర్సును తొందరగా గుర్తించడంలో విద్యార్థులకు ఇది తోడ్పడుతుంది.';
$string['coursehelpforce'] = 'కోర్సులోని ప్రతీ పనికీ గుంపు మోడ్ ను బలవంతంగా అమలు చెయ్యి';
$string['coursehelpformat'] = 'కోర్సు ప్రధానపేజీ ఈ ఆకృతిలో కనిపిస్తుంది.';
$string['coursehelphiddensections'] = 'దాగి ఉన్న విభాగాలు విద్యార్థులకు ఎలా కనిపిస్తాయి.';
$string['coursehelpmaximumupload'] = 'ఈ కోర్సుకు సంబంధించినంతవరకూ గరిష్ఠ దస్త్రం ఎక్కింపు  సైజు ఇవ్వండి. ఈ సైజు సైటు సెట్టింగుకు లోబడి ఉండాలి.';
$string['coursehelpnewsitemsnumber'] = 'కోర్సు హోమ్ పేజీలో చూపించవలసిన ఇటీవలి ఐటముల సంఖ్య. వీటిని కుడివైపు కింద వార్తల పెట్టెలో చూపిస్తాం<br />(0 అంటే వార్తల పెట్టె అసలు కనబడకూడదని అర్థం)';
$string['coursehelpnumberweeks'] = 'కోర్సు ప్రధాన పేజీలో చూపించవలసిన వారాలు/టాపిక్కుల సంఖ్య.';
$string['coursehelpshowgrades'] = 'గ్రేడ్‍బుక్ చూపించడాన్ని చేతనం చెయ్యండి. వివిధ పనులకు సంబంధించినంతవరకూ  గ్రేడ్లను చూపించడాన్ని ఇదేమీ అడ్డుకోదు.';
$string['coursehidden'] = 'ప్రస్తుతం ఈ కోర్సు విద్యార్థులకు అందుబాటులో లేదు';
$string['courseinfo'] = 'కోర్సు సమాచారం';
$string['courselegacyfiles'] = 'పూర్వ (లెగసీ) కోర్సు దస్త్రాలు ';
$string['courselegacyfiles_help'] = '';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'లెగసీ కోర్సు ఫైళ్లు: {$a}';
$string['coursenotaccessible'] = 'ఈ కోర్సులోకి సార్వజనిక ప్రవేశానుమతి లేదు';
$string['courseoverview'] = 'కోర్సు స్థూలదృష్టి';
$string['courseoverviewfiles'] = 'కోర్సు చిత్రం';
$string['courseoverviewfiles_help'] = 'చిత్రాలు వంటి కోర్సు సారాంశం ఫైళ్లు,  కోర్సులు జాబితాలో సారాంశంతో ప్రదర్శించబడతాయి.';
$string['courseoverviewfilesext'] = 'కోర్సు సారాంశం ఫైళ్లు పొడిగింపులు';
$string['courseoverviewfileslimit'] = 'కోర్సు సారాంశం ఫైళ్లు పరిమితం';
$string['courseoverviewgraph'] = 'కోర్సు స్థూలదృష్టి గ్రాఫు';
$string['courseprofiles'] = 'కోర్సు ప్రవరలు';
$string['coursereasonforrejecting'] = 'ఈ అభ్యర్ధనను తిరస్కరించటానికి మీ కారణాలు';
$string['coursereasonforrejectingemail'] = 'దీన్ని అభ్యర్ధించినవారికి దీన్ని ఈమెయిలు చేస్తాం';
$string['coursereject'] = 'కోర్సు అభ్యర్ధనను తిరస్కరించండి';
$string['courserejected'] = 'కోర్సును తిరస్కరించాం, అభ్యర్ధకునికి తెలియజేసాం.';
$string['courserejectemail'] = 'సారీ, మీరు అడిగిన కోర్సు తిరస్కరించబడింది. దానికి ఈయబడిన కారణం ఇది:

{$a}';
$string['courserejectreason'] = 'ఈ కోర్సును తిరస్కరించటానికి కారణాలను స్థూలంగా రాయండి<br />(దీన్ని అభ్యర్ధకునికి ఈమెయిలు చేస్తాం)';
$string['courserejectsubject'] = 'కోర్సు తిరస్కరించబడింది';
$string['coursereport'] = 'కోర్సు నివేదిక';
$string['coursereports'] = 'కోర్సు నివేదికలు';
$string['courserequest'] = 'కోర్సు అభ్యర్ధన';
$string['courserequestdetails'] = 'మీరు అభ్యర్ధిస్తున్న కోర్సు వివరాలు';
$string['courserequestfailed'] = 'ఏ కారణం చేతనోగానీ, మీ కోర్సు అభ్యర్ధన భద్రం కాలేదు';
$string['courserequestintro'] = 'మీకోసం ఒక కోర్సును సృష్టించమని అడిగేందుకు ఈ ఫారాన్ని వాడండి.<br />సాధ్యమైనంత ఎక్కువ సమాచారాన్ని విపులంగా ఇవ్వండి<br />దాంతో ఆ కోర్సును మీరెండుకు అడుగుతున్నారో నిర్వాహకులకు అర్థం అవుతుంది.';
$string['courserequestreason'] = 'ఈ కోర్సు అడగడానికి కారణాలు';
$string['courserequestsuccess'] = 'మీ కోర్సు అభ్యర్ధనను జయపరదంగా భద్రపరచాం. ఫలితంతో కూడిన ఈమెయిలు కొద్ది రోజుల్లో మీకు వస్తుంది';
$string['courserequestsupport'] = 'ఈ అభ్యర్ధనను పరిశీలించేందుకుగాను నిర్వాహకునికి ఉపయోగపడగల అదనపు సమాచారం';
$string['courserequestwarning'] = 'ఈ కోర్సు అభ్యర్ధించే వినియోగదారు స్వయంచాలకంగా నమోదు చేయబడతాడు మరియు {$a} పాత్రను కేటాయించబడతాడు';
$string['courserestore'] = 'కోర్సు రీస్టోరు';
$string['courses'] = 'కోర్సులు';
$string['coursesearch_help'] = 'ఏకకాలంలో అనేక పదాల కోసం వెతకవచ్చు.<br /><br />పదం: పాఠ్యంలో ఈ పదానికి సరిపోలే దాని కోసం వెతుకు<br />+పదం:ఖచ్చితంగా సరిపోలే పదాలను మాత్రమే వెతుకు.<br />-పదం: ఈ పదం కలిగిన వాటిని ఫలితాల్లో చూపించొద్దు.';
$string['coursesectionsummaries'] = 'కోర్సు విభాగ సారాంశాలు';
$string['coursesectiontitle'] = 'కోర్సు: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'కోర్సు డిఫాల్టు సెట్టింగులు';
$string['coursesmovedout'] = '{$a} నుంచి బయటికి తరలించబడిన కోర్సులు';
$string['coursespending'] = 'ఆమోదముద్ర కోసం వేచిఉన్న కోర్సులు';
$string['coursestart'] = 'కోర్సు మొదలు';
$string['coursesummary'] = 'కోర్సు సారాంశం';
$string['coursesummary_help'] = 'కోర్సు సారాంశం కోర్సుల జాబితాలో చూపిస్తాం. కోర్సుల కోసం వెతికేటపుడు కోర్సుల పేర్లతో పాటు, కోర్సు సారాంశంలో కూడా వెతుకుతాం.';
$string['coursetitle'] = 'కోర్సు: {$a->course}';
$string['courseupdates'] = 'కోర్సు తాజాకరణలు';
$string['coursevisibility'] = 'కోర్సు దృశ్యమానత';
$string['coursevisibility_help'] = 'ఈ కోర్సు కోర్సులు జాబితాలో మరియు విద్యార్థులను యాక్సెస్ చేయగలరో లేదో నిర్ణయిస్తుంది. దాచడానికి సెట్ చేస్తే, దాచిన దాచిన (అటువంటి ఉపాధ్యాయులు) వీక్షించే సామర్ధ్యం ఉన్న వినియోగదారులకు యాక్సెస్ పరిమితం చేయబడింది.';
$string['create'] = 'సృష్టించు';
$string['createaccount'] = 'నా కొత్త ఖాతాను సృష్టించు';
$string['createcategory'] = 'వర్గాన్ని సృష్టించు';
$string['createfolder'] = '{$a} లో ఒక ఫోల్డరును సృష్టించు';
$string['createnew'] = 'కొత్తది సృష్టించు';
$string['createnewcategory'] = 'కొత్త వర్గం సృష్టించు';
$string['createnewcourse'] = 'కొత్త కోర్సు సృష్టించు';
$string['createnewsubcategory'] = 'కొత్త ఉపవర్గం సృష్టించు';
$string['createsubcategoryof'] = '{$a} యొక్క ఉపవర్గం సృష్టించు';
$string['createuser'] = 'వినియోగదారుని సృష్టించు';
$string['createuserandpass'] = 'మీ వాడుకరిపేరు, సంకేతపదాన్ని ఎంచుకోండి';
$string['createziparchive'] = 'zip భాండారాన్ని సృష్టించు';
$string['creatingblocks'] = 'బ్లాకులను సృష్టిస్తున్నాం';
$string['creatingblocksroles'] = 'బ్లాకు స్థాయి పాత్రధారణలను, ఓవర్‍రైడ్లనూ సృష్టిస్తున్నాం ';
$string['creatingblogsinfo'] = 'బ్లాగు సమాచారాన్ని సృష్టిస్తున్నాం';
$string['creatingcategoriesandquestions'] = 'వర్గాలు, ప్రశ్నలను సృష్టిస్తున్నాం';
$string['creatingcoursemodules'] = 'కోర్సు మాడ్యూళ్ళను సృష్టిస్తున్నాం';
$string['creatingcourseroles'] = 'కోర్సు స్థాయి పాత్రధారణలను, ఓవర్‍రైడ్లనూ సృష్టిస్తున్నాం ';
$string['creatingevents'] = 'ఘటనలను సృష్టిస్తున్నాం';
$string['creatinggradebook'] = 'గ్రేడ్‍బుక్ ను సృష్టిస్తున్నాం';
$string['creatinggroupings'] = 'గ్రూపింగులను సృష్టిస్తున్నాం';
$string['creatinggroupingsgroups'] = 'గుంపులను గ్రూపింగులకు చేరుస్తున్నాం';
$string['creatinggroups'] = 'గుంపులను సృష్టిస్తున్నాం';
$string['creatinglogentries'] = 'లాగ్ ఎంట్రీలను సృష్టిస్తున్నాం';
$string['creatingmessagesinfo'] = 'సందేశాల సమాచారాన్ని సృష్టిస్తున్నాం';
$string['creatingmodroles'] = 'మాడ్యూలు స్థాయి పాత్రల నిర్దేశాన్ని, ఓవర్‍రైడులనూ సృష్టిస్తున్నాం';
$string['creatingnewcourse'] = 'కొత్త కోర్సును సృష్టిస్తున్నాం';
$string['creatingrolesdefinitions'] = 'పాత్రల నిర్వచనాలను సృష్టిస్తున్నాం';
$string['creatingscales'] = 'కొలమానాలను సృష్టిస్తున్నాం';
$string['creatingsections'] = 'విభాగాలను సృష్టిస్తున్నాం';
$string['creatingtemporarystructures'] = 'తాత్కాలిక నిర్మాణాలను సృష్టిస్తున్నాం';
$string['creatinguserroles'] = 'వాడుకరి స్థాయి పాత్రధారణలను, ఓవర్‍రైడ్లను సృష్టిస్తున్నాం';
$string['creatingusers'] = 'వాడుకరులను సృష్టిస్తున్నాం';
$string['creatingxmlfile'] = 'XML దస్త్రాన్ని సృష్టిస్తున్నాం';
$string['currency'] = 'ద్రవ్యం';
$string['currentcourse'] = 'ప్రస్తుత కోర్సు';
$string['currentcourseadding'] = 'వర్తమాన కోర్సు, దానికి డేటాను చేరుస్తున్నాం';
$string['currentcoursedeleting'] = 'వర్తమాన కోర్సు, మూమ్దు దాన్ని తొలగిస్తున్నాం';
$string['currentlanguage'] = 'వర్తమాన భాష';
$string['currentlocaltime'] = 'ప్రస్తుత మీ స్థానిక సమయం';
$string['currentpicture'] = 'ప్రస్తుత బొమ్మ';
$string['currentrelease'] = 'ప్రస్తుత విడుదల సమాచారం';
$string['currentversion'] = 'ప్రస్తుత వెర్షను';
$string['databasechecking'] = 'Moodle డేటాబేసును {$a->oldversion} వెర్షను నుండి {$a->newversion} కు ఉన్నతీకరిస్తున్నాం...';
$string['databaseperformance'] = 'డేటాబేసు పనితీరు';
$string['databasesetup'] = 'డేటాబేసును తయారుచేస్తున్నాం';
$string['databasesuccess'] = 'డేటాబేసును జయప్రదంగా ఉన్నతీకరించాం';
$string['databaseupgradebackups'] = 'ఇప్పటి బ్యాకప్పు వెర్షను {$a}';
$string['databaseupgradeblocks'] = 'ఇప్పటి బ్లాకుల వెర్షను {$a}';
$string['databaseupgradegroups'] = 'ఇప్పటి గుంపుల వెర్షను {$a}';
$string['databaseupgradelocal'] = 'ఇప్పటి స్థానిక డేటాబేసు కస్టమైజేషనుల వెర్షను {$a}';
$string['databaseupgrades'] = 'డేటాబేసును ఉన్నతీకరిస్తున్నాం';
$string['dataformats'] = 'డేటా ఫార్మాట్లు';
$string['date'] = 'తేదీ';
$string['datechanged'] = 'తేదీని మార్చాం';
$string['datemostrecentfirst'] = 'తేదీ - ఇట్టీవలిది ముందుగా';
$string['datemostrecentlast'] = 'తేదీ - ఇట్టీవలిది చివరిగా';
$string['day'] = 'రోజు';
$string['days'] = 'రోజులు';
$string['decodinginternallinks'] = 'అంతర్గత లింకులను డీకోడు చేస్తున్నాం';
$string['default'] = 'డిఫాల్టు';
$string['defaultcompetencescale'] = 'డిఫాల్ట్ పోటీతత్వ స్థాయి';
$string['defaultcompetencescaledesc'] = 'బైనరీ రేటింగ్ స్థాయి ఎవరైనా అందించిన నైపుణ్యానికి లేదా లేదో దానికి మరింత సమాచారం అందించదు.';
$string['defaultcompetencescalenotproficient'] = 'ఇంకా సమర్థ లేదు';
$string['defaultcompetencescaleproficient'] = 'సమర్థ';
$string['defaultcoursestudent'] = 'విద్యార్థి';
$string['defaultcoursestudentdescription'] = 'సాధారణంగా కోర్సులో విద్యార్థులకు తక్కువ అనుమతులు ఉంటాయి.';
$string['defaultcoursestudents'] = 'విద్యార్థులు';
$string['defaultcoursesummary'] = 'ఈ కోర్సు దేని గురించో తెలుపుతూ ఒక చిన్న పేరాగ్రాఫును ఆసక్తికరంగా ఉండేలా రాయండి';
$string['defaultcourseteacher'] = 'ఉపాధ్యాయుడు';
$string['defaultcourseteacherdescription'] = 'కోర్సులోపల ఉపాధ్యాయులు ఏమైనా చెయ్యవచ్చు -పనులను మార్చడం, విద్యార్థులకు గ్రేడ్లు ఇవ్వడంతో సహా.';
$string['defaultcourseteachers'] = 'ఉపాధ్యాయులు';
$string['defaulteditor'] = 'Default ఎడిటర్';
$string['delete'] = 'తొలగించు';
$string['deleteablock'] = 'బ్లాకును తొలగించండి';
$string['deleteall'] = 'అన్నిటినీ తొలగించండి';
$string['deleteallcannotundo'] = 'అన్నిటినీ తొలగించడం - వెనక్కి తిప్పలేరు';
$string['deleteallcomments'] = 'వ్యాఖ్యలన్నిటినీ తొలగించు';
$string['deleteallratings'] = 'రేటింగలన్నిటినీ తొలగించు';
$string['deletecategory'] = 'వర్గాన్ని తొలగించు: {$a}';
$string['deletecategorycheck'] = 'ఈ వర్గాన్ని పూర్తిగా తొలగించాలనె మీరు నిశ్చయించుకున్నారా<b>\'{$a}\'</b>?<br />ఇక్కడున్న కోర్సులన్నీ మాతృవర్గం అంటూ ఒకటుంటే అందులోకి పోతాయి. లేదా ఇతరాలు లొకి పోతాయి.';
$string['deletecategorycheck2'] = 'వర్గాన్ని తొలగించేటపుడు, దానిలో ఉన్న కోర్సులు, ఉపవర్గాలను ఏంచెయ్యాలో మీరు ఎంచుకోవాలి';
$string['deletecategoryempty'] = 'ఈ వర్గంణ్ ఖాళీగా ఉంది.';
$string['deletecheck'] = '{$a} ను తొలగించమంటారా?';
$string['deletecheckfiles'] = 'ఈ దస్త్రాలను తొలగించాలనే మీ నిశ్చయమా?';
$string['deletecheckfull'] = '{$a} ను పూర్తిగా తొలగించాలనేదే మీ నిశ్చయమా?';
$string['deletechecktype'] = 'మీరు ఈ  {$a->type} ని తొలగించడానికి నిశ్చయించుకున్నారా?';
$string['deletechecktypename'] = 'మీరు "{$ a-> name}" {$ a-> type} తొలగించడానికి నిశ్చయించుకున్నారా?';
$string['deletecheckwarning'] = 'ఈ దస్త్రాలను మీరు తొలగించబోతున్నారు';
$string['deletecommentbyon'] = 'పోస్ట్ చేసిన వ్యాఖ్యను తొలగించండి {$a->user} on {$a->time}';
$string['deletecompletely'] = 'పూర్తిగా తొలగించు';
$string['deletecourse'] = 'కోర్సును తొలగించండి';
$string['deletecoursecheck'] = 'ఈ కోర్సునూ, అందులో ఉన్న డేటానూ పూర్తిగా తొలగించాలన్నదే మీ నిశ్చయమా?';
$string['deleted'] = 'తొలగించాం';
$string['deletedactivity'] = '{$a} ను తొలగించాం';
$string['deletedcourse'] = '{$a} నూ పూర్తిగా తొలగించాం';
$string['deletednot'] = '{$a} ను తొలగించలేకపోయాం !';
$string['deletepicture'] = 'తొలగించు';
$string['deletesection'] = 'విభాగాన్ని తొలగించండి';
$string['deleteselected'] = 'ఎంచుకున్నవాటిని తొలగించు';
$string['deleteselectedkey'] = 'ఎంచుకున్న కీని తొలగించు';
$string['deletingcourse'] = '{$a} ను తొలగిస్తున్నాం';
$string['deletingexistingcoursedata'] = 'ప్రస్తుతమున్న కోర్సు డేటాను తొలగిస్తున్నాం';
$string['deletingolddata'] = 'పాత డేటాను తొలగిస్తున్నాం';
$string['department'] = 'శాఖ';
$string['deprecatedeventname'] = '{$a} (వినియోగంలో లేదు)';
$string['desc'] = 'అవరోహణ';
$string['description'] = 'వివరణ';
$string['deselectall'] = 'దేన్నీ ఎంచుకోవద్దు';
$string['detailedless'] = 'తక్కువ వివరంగా';
$string['detailedmore'] = 'మరింత వివరంగా';
$string['digitalminor'] = 'డిజిటల్ మైనర్';
$string['digitalminor_desc'] = 'ఈ సైట్లో ఒక ఖాతాను సృష్టించడానికి, దయచేసి మీ పేరెంట్ / గార్డియన్ కింది వ్యక్తిని సంప్రదించండి';
$string['directory'] = 'డైరెక్టరీ';
$string['disable'] = 'అచేతనం చెయ్యి';
$string['disabledcomments'] = 'వ్యాఖ్యలను అచేతనం చేసాం';
$string['displayingfirst'] = 'మొదటి {$a->count} {$a->things} లను మాత్రమే చూపిస్తున్నాం';
$string['displayingrecords'] = '{$a} రికార్డులను చూపిస్తున్నాం';
$string['displayingusers'] = '{$a->start} నుండి {$a->end} వరకూ వాడుకరులను చూపిస్తున్నాం';
$string['displayonpage'] = 'పేజీలో చూపించు';
$string['dndcourse'] = 'ఈ కొర్సును డ్రాగ్ మరియు డ్రాప్ ద్వార సార్టింగ్ లేదా మరొక వర్గానికి తరలించవఛ్చు';
$string['dndenabled_inbox'] = 'మీరు ఫైళ్ళను జతచేయుటకు ఇక్కడ డ్రాగ్ మరియు డ్రాప్ చెయ్యవచ్చు';
$string['dndnotsupported'] = 'డ్రాగ్ మరియు డ్రాప్ అప్లోడ్ మద్దతు లేదు';
$string['dndnotsupported_help'] = 'మీ బ్రౌజర్ డ్రాగ్ మరియు డ్రాప్ మద్దతు చేయదు.
<br/> ఈ ఫీచర్ Chrome, Firefox మరియు సఫారి, అలాగే Internet Explorer V10 మరియు పైన అన్ని ఇటీవల వెర్షన్లలో అందుబాటులో ఉంది.';
$string['dndnotsupported_insentence'] = 'డ్రాగ్ మరియు డ్రాప్ మద్దతు లేదు';
$string['dnduploadwithoutcontent'] = 'ఈ అప్లోడ్ లో ఏ కంటెంట్ లేదు';
$string['dndworkingfile'] = 'ఫైళ్ళు అప్లోడ్ చేయుటకు వాటిని కోర్సు విభాగాలు లో
డ్రాగ్ మరియు డ్రాప్ చేయండి';
$string['dndworkingfilelink'] = 'ఫైళ్ళు లేదా లింకులు అప్లోడ్ చేయుటకు వాటిని కోర్సు విభాగాలు లో డ్రాగ్ మరియు డ్రాప్ చేయండి';
$string['dndworkingfiletext'] = 'ఫైళ్ళను లేదా టెక్స్ట్ అప్లోడ్ చేయుటకు వాటిని కోర్సు విభాగాలు లో డ్రాగ్ మరియు డ్రాప్ చేయండి';
$string['dndworkingfiletextlink'] = 'ఫైళ్ళు, టెక్స్ట్ లేదా లింకులు అప్లోడ్ చేయుటకు వాటిని కోర్సు విభాగాలు లో డ్రాగ్ మరియు డ్రాప్ చేయండి';
$string['dndworkinglink'] = 'లింకులు అప్లోడ్ చేయుటకు వాటిని కోర్సు విభాగాలు లో డ్రాగ్ మరియు డ్రాప్ చేయండి';
$string['dndworkingtext'] = 'టెక్స్ట్ అప్లోడ్ చేయుటకు దానిని  కోర్సు విభాగాలు మీదకు డ్రాగ్ మరియు డ్రాప్ చేయండి';
$string['dndworkingtextlink'] = 'టెక్స్ట్ లేదా లింకులు అప్లోడ్ చేయుటకు వాటిని కోర్సు విభాగాలు మీదకు డ్రాగ్ మరియు డ్రాప్ చేయండి';
$string['documentation'] = 'Moodle డాక్యుమెంటేషను';
$string['dontsortcategories'] = 'వర్గములను క్రమముగా ఏర్పర్చవద్దు';
$string['dontsortcourses'] = 'కోర్సులను క్రమముగా ఏర్పర్చవద్దు';
$string['down'] = 'కిందికి';
$string['download'] = 'దించు';
$string['downloadall'] = 'అన్నిటినీ దించు';
$string['downloadexcel'] = 'Excel రూపంలో దించు';
$string['downloadfile'] = 'దస్త్రాన్ని దించు';
$string['downloadods'] = 'ODS రూపంలో దించు';
$string['downloadtext'] = 'టెక్స్టు రూపంలో దించు';
$string['doyouagree'] = 'ఈ నిబంధనలను చదివి అర్థం చేసుకున్నారా?';
$string['droptoupload'] = 'అప్లోడ్ చెయ్యడానికి ఫైళ్ళను ఇక్కడ డ్రాప్ చేయండి';
$string['duplicate'] = 'నకలు';
$string['edhelpaspellpath'] = 'ఎడిటర్లో ఇంగ్లీషు స్పెల్-చెకింగును వాడాలంటే మీ సర్వరులో <strong>aspell 0.50</strong> గానీ, ఆ తరువాతది గానీ స్థాపించుకుని ఉండాలి. దాన్ని వాడుకునేందుకు వీలుగా aspell బైనరీ పాత్‍ను కూడా సరిగ్గా సూచించాలి. Unix/Linux కంప్యూటర్లలోనైతే, సాధారణంగా ఈ పాత్ usually <strong>/usr/bin/aspell</strong> అని ఉంటుంది. అయితే ఇలా కాకుండా వేరేగా ఉండే అవకాశం కూడా ఉంది.';
$string['edhelpbgcolor'] = 'ఎడిట్ ప్రాంతపు నేపథ్యపు రంగును నిర్వచించండి.<br />సరైన విలువలు మచ్చుకు:  #FFFFFF లేదా  white';
$string['edhelpcleanword'] = 'ఈ సెట్టింగు, Word-కు ప్రత్యేకించిన ఆకృతి వడపోతను చేతనం లేదా అచేతనం చేస్తుంది.';
$string['edhelpenablespelling'] = 'ఇంగ్లీషు స్పెల్-చెకింగును చేతనం, అచేతనం చెయ్యండి. చేతనం చేసినపుడు, <strong>aspell</strong> ను సర్వరులో తప్పనిసరిగా స్థాపించాలి. రెండో విలువ, <strong>default dictionary</strong>. వాడుకరి స్వంత భాషలో నిఘంటువు aspell దగ్గర లేకపోతే, ఈ విలువను వాడుతుంది. ';
$string['edhelpfontfamily'] = 'font-family గుణం అనేది ఖతి కుటుంబాల జాబితా, మరియు/లేదా జెనెరిక్ కుటుంబం పేరు. కుటుంబాల పేర్లకు మధ్య కామా ఉండాలి. ';
$string['edhelpfontlist'] = 'ఎదిటరు డ్రాప్ డౌన్ మెనూలో వాడే ఖతులను నిర్వచించండి ';
$string['edhelpfontsize'] = 'డిఫాల్టు ఖతి-సైజు, ఖతి సైజును నిర్ణయిస్తుంది.<br />మచ్చుకు కొన్ని విలువలు: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'సవరించు';
$string['edita'] = '{$a} ను సవరించు';
$string['editcategorysettings'] = 'వర్గాల సెట్టింగులను సవరించు';
$string['editcategorythis'] = 'ఈ వర్గాన్ని సవరించండి';
$string['editcoursesettings'] = 'కోర్సు సెట్టింగులను సవరించు';
$string['editfiles'] = 'దస్త్రాలను సవరించు';
$string['editgroupprofile'] = 'గుంపు ప్రవరను సవరించు';
$string['editinga'] = '{$a} ను సవరిస్తున్నారు';
$string['editingteachershort'] = 'ఎడిటరు';
$string['editlock'] = 'ఈ విలువన సవరించజాలరు!';
$string['editmyprofile'] = 'ప్రవరను సవరించు';
$string['editorbgcolor'] = 'నేపథ్యపు రందు';
$string['editorcleanonpaste'] = 'పేస్టు చేసినపుడు Word HTML ను శుభ్రం చెయ్యి';
$string['editorcommonsettings'] = 'సామాన్య సెట్టింగులు';
$string['editordefaultfont'] = 'డిఫాల్టు ఖతి';
$string['editorenablespelling'] = 'స్పెల్‍చెకింగును చేతనం చెయ్యి';
$string['editorfontlist'] = 'ఖతుల జాబితా';
$string['editorfontsize'] = 'డిఫాల్టు ఖతి పరిమాణం';
$string['editorpreferences'] = 'ఎడిటర్ ప్రాధాన్యతలు';
$string['editorresettodefaults'] = 'డిఫాల్టు విలువలు ఇవ్వు';
$string['editorsettings'] = 'ఎడిటరు సెట్టింగులు';
$string['editorshortcutkeys'] = 'ఎడిటరు అడ్డుదారి కీలు';
$string['editsection'] = 'విభాగాన్ని సవరించండి';
$string['editsectionname'] = 'విభాగం పేరును సవరించండి';
$string['editsettings'] = 'సెట్టింగులను సవరించు';
$string['editsummary'] = 'సవరణ సారాంశం';
$string['editthisactivity'] = 'ఈ పనిని సవరించు';
$string['editthiscategory'] = 'ఈ వర్గాన్ని సవరించు';
$string['edittitle'] = 'టైటిల్ను సవరించు';
$string['edittitleinstructions'] = 'రద్దు చేయడానికి ఎస్కేప్, పూర్తవగానే ఎంటర్';
$string['edituser'] = 'వాడుకరి ఖాతాలను సవరించు';
$string['edulevel'] = 'విద్యా స్థాయి';
$string['edulevel_help'] = '*టీచింగ్ - టీచర్చే చేయబడిన చర్యలు, ఉదా. వనరును నవీకరిస్తోంది
* పాల్గొనే - ఒక విద్యార్థి చేత చేయబడిన చర్యలు, ఉదా. ఒక ఫోరమ్ లో పోస్టింగ్
* ఇతర - ఉపాధ్యాయుని లేదా విద్యార్ధిని కాకుండా వేరే పాత్రను నిర్వహిస్తున్న చర్యలు';
$string['edulevelother'] = 'మరొక';
$string['edulevelparticipating'] = 'పాల్గొనే';
$string['edulevelteacher'] = 'బోధన';
$string['email'] = 'ఈమెయిలు చిరునామా';
$string['emailactive'] = 'ఈమెయిలును చేతనం చేసాం';
$string['emailagain'] = 'ఈమెయిలు (మళ్ళీ)';
$string['emailalreadysent'] = 'పాస్వర్డ్ రీసెట్ ఇమెయిల్ ఇప్పటికే పంపబడింది. మీ ఇమెయిల్ తనిఖీ చేయండి.';
$string['emailcharset'] = 'ఈమెయిలు charset';
$string['emailconfirm'] = 'మీ ఖాతాను నిర్ధారించండి';
$string['emailconfirmation'] = 'గారూ,

మీ ఈమెయిలు అడ్రసు వాడి \'{$a->sitename}\'  సైటులో ఒక కొత్త ఖాతా కావాలని అడిగారు.

మీ ఖాతాను ధ్రువీకరించేందుకు, కింది అడ్రసుకు వెళ్ళండి:

{$a->link}

ఇది, చాలా మెయిలు ప్రోగ్రాముల్లో నొక్కేందుకు వీలయ్యే నీలపు లింకులాగా కనిపిస్తుంది. అది పనిచెయ్యకపోతే, పై లింకును కాపీ చేసి, మీ బ్రౌజరు అడ్రసు పట్టీలో అతికించండి.

సాయం కావాలంటే, సైటు నిర్వాహకుడు, {$a->admin} ను సంప్రదించండి';
$string['emailconfirmationsubject'] = '{$a}: ఖాతా సమాచారం';
$string['emailconfirmsent'] = '<p>మీ ఈ అడ్రసుకు ఈమెయిలును పంపించి ఉండాలి: <b>{$a}</b></p>
<p>అందులో మీ నమోదును పూర్తి చేసేందుకు అవసరమైన సులువైన సూచనలుంటాయి.</p>
<p>ఇబ్బంది అలాగే ఉంటే, సైటు నిర్వాహకుణ్ణి సంప్రదించండి.</p>';
$string['emaildigest'] = 'సంక్షిప్తంగా ఒకే ఈమెయిలు ';
$string['emaildigest_help'] = 'ఈ ఫోరంలు రోజువారీ అప్రమేయంగా ఉపయోగించే సెట్.

* డైజెస్ట్  - పూర్తి పోస్ట్ - మీరు ఒక ప్రతి ఫోరమ్ పోస్ట్ యొక్క పూర్తి సారములను రోజుకు ఒక మెయిల్ ద్వార అందుకుంటారు;

మీరు ఫోరమ్ పోస్ట్ ఒకొక్క మెయిల్ అందుకుంటారు

డైజెస్ట్ - విషయాలను మాత్రమే - మీరు ఒక ప్రతి ఫోరమ్ పోస్ట్ యొక్క కేవలం విషయం మాత్రమే రోజుకు మెయిల్ ద్వార అందుకుంటారు;

మీరు అనుకుంటే మీరు ప్రతి ఫోరం కొరకు విభిన్నమైన అమరిక ఎంచుకోవచ్చు';
$string['emaildigestcomplete'] = 'సంపూర్ణ (పూర్తి టపాలతో రోజుకో ఈమెయిలు)';
$string['emaildigestoff'] = 'ఒకే ఈమెయిలు వద్దు (టపాకో ఈమెయిలు చొప్పున)';
$string['emaildigestsubjects'] = 'విషయాలు (రోజుకో ఈమెయిలు, విషయాలతో మాత్రమే)';
$string['emaildisable'] = 'ఈ ఈమెయిలు చిరునామాను అచేతనం చేసాం';
$string['emaildisableclick'] = 'ఈ చిరునామాకు అసలు ఈమెయిలేదీ పంపకుండా ఉండేందుకు ఇక్కడ నొక్కండి';
$string['emaildisplay'] = 'ఈ మెయిలు ప్రదర్శన';
$string['emaildisplaycourse'] = 'ఇతర కోర్సుసభ్యులను మాత్రమే నా ఈమెయిలు చిరునామాను చూడనివ్వు';
$string['emaildisplayno'] = 'నా ఈమెయిలు చిరునామాను ఎవరికీ కనబడనివ్వద్దు';
$string['emaildisplayyes'] = 'నా ఈమెయిలు చిరునామాను అందరినీ చూడనివ్వు';
$string['emailenable'] = 'ఈమెయిలు చిరునామాను చేతనం చేసాం';
$string['emailenableclick'] = 'ఈ చిరునామాకు తిరిగి ఈమెయిలు పంపడాన్ని చేతనం చేసేందుకు ఇక్కడ నొక్కండి';
$string['emailexists'] = 'ఈ ఈమెయిలు చిరునామా ఈసరికే నమోదై ఉంది';
$string['emailexistshintlink'] = 'మర్చిపోయి యూజర్ పేరు లేదా పాస్ వర్డ్ పునరుద్ధరించండి';
$string['emailexistssignuphint'] = 'బహుశా మీరు గతంలో ఒక ఖాతాను సృష్టించారా? {$a}';
$string['emailformat'] = 'ఈమెయిలు ఆకృతి';
$string['emailmustbereal'] = 'గమనిక: మీ ఈమెయిలు చిరునామా వాస్తవంగా ఉండి ఉండాలి';
$string['emailnotallowed'] = 'ఈ డొమయిను లోని ఈమెయిలు చిరునామాలకు అనుమతి లేదు ({$a})';
$string['emailnotfound'] = 'ఈమెయిలు చిరునామా డేటాబేసులో కనబడలేదు';
$string['emailonlyallowed'] = 'ఈ ఈమెయిలు అనుమతించినవాటిలో లేదు ({$a})';
$string['emailpasswordchangeinfo'] = '{$a->firstname} గారూ,

\'{$a->sitename}\' సైటులో ఉన్న మీ ఖాతాకు కొత్త సంకేతపదం కావాలని ఎవరో (బహుశా మీరే) అడిగారు.

మీ సంకేతపదాన్ని మార్చుకొనేందుకు, కింది అడ్రసుకు వెళ్ళండి:

{$a->link}

చాలా మెయిలు ప్రోగ్రాముల్లో ఇది నీలం రంగు లింకులా, నొక్కగలిగేలా  కనిపిస్తుంది. అది పనిచెయ్యకపోతే, ఈ అడ్రసును కాపీ చేసి, మీ బ్రౌజరులోని అడ్రసు పట్టీలో పేస్టు చెయ్యండి

సాయం కావాలంటే, సైటు నిర్వాకుణ్ణి సంప్రదించండి: {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = '{$a->firstname} గారూ,

\'{$a->sitename}\' సైటులోని మీ ఖాతాకు కొత్త సంకేతపదం కావాలని ఎవరో (బహుశా మీరే) అడిగారు..

దురదృష్టవశాత్తూ, ఈ సైటులోని మీ ఖాతా అచేతనం చెయ్యబడి ఉంది, అంచేత సంకేతపదం మార్చడానికి లేదు. సైటు నిర్వాహకుణ్ణి సంప్రదించండి: {$a->admin}';
$string['emailpasswordchangeinfofail'] = '{$a->firstname} గారూ,

\'{$a->sitename}\' సైటులో ఉన్న మీ ఖాతాకు కొత్త సంకేతపదం కావాలని ఎవరో (బహుశా మీరే) అడిగారు.

అయితే, దురదృష్టవశాత్తూ, సంకేతపదాన్ని మార్చుకునే వీలు ఈ సైటులో లేదు. సైటు నిర్వాహకుణ్ణి సంప్రదించండి: {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: సంకేతపదం మార్పు సమాచారం';
$string['emailpasswordconfirmation'] = '{$a->firstname} గారూ,

\'{$a->sitename}\' సైటులోని మీ ఖాతాకు కొత్త సంకేతపదం కావాలని ఎవరో (బహుశా మీరే) అడిగారు..

దీన్ని నిర్ధారించడానికీ, కొత్త సంకేతపదాన్ని మీకు ఈమెయిలు చేసేందుకు వీలు కలిగిస్తూనూ, కింది అడ్రసుకు వెళ్ళండి:

{$a->link}

ఇది, చాలా మెయిలు ప్రోగ్రాముల్లో నొక్కేందుకు వీలయ్యే నీలపు లింకులాగా కనిపిస్తుంది. అది పనిచెయ్యకపోతే, పై లింకును కాపీ చేసి, మీ బ్రౌజరు అడ్రసు పట్టీలో అతికించండి.

సాయం కావాలంటే, సైటు నిర్వాహకుడు, {$a->admin} ను సంప్రదించండి';
$string['emailpasswordconfirmationsubject'] = '{$a}: సంకేతపదం మార్పు నిర్ధారణ';
$string['emailpasswordconfirmmaybesent'] = '<p>మీరు సరైన వాడుకరిపేరు లేదా ఈమెయిలు చిరునామా ఇచ్చి ఉంటే, ఈపాటికి మీకు ఈమెయిలు వచ్చి ఉండాలి.</p>
 <p>సంకేతపదం మార్పును పూర్తి చేసేందుకు అవసరమైన సూచనలు అందులో ఉంటాయి. మీకు ఇంకా ఇబ్బంది ఏమైనా ఉంటే, సైటు నిర్వాహకుణ్ణి సంప్రదించండి.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> మీరు పేర్కొన్న యూజర్ ఖాతాకి ఇమెయిల్ చిరునామా లేదు. </p><p> సైట్ నిర్వాహకుడిని సంప్రదించండి. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> మీరు పంపిణీ యూజర్ వివరాలు ఉన్న యూజర్ ఖాతా గుర్తించడానికి లేదు. </p>

<p> మీరు నమోదు చేసిన సమాచారాన్ని తనిఖీ చేయండి, ఆపై మళ్ళీ ప్రయత్నించండి. మీరు ఇబ్బంది కొనసాగుతుంటే, సైట్ నిర్వాహకుడిని సంప్రదించండి. </p';
$string['emailpasswordconfirmsent'] = 'మీ అడ్రసు, <b>{$a}</b> కు ఒక ఈమెయిలు వచ్చి ఉండాలి. <br />అందులో ఈ సంకేతపదం మార్పును నిర్ధారించేందుకు, పూర్తి చేసేందుకూ సూచనలుంటాయి.
ఇంకా మీకు ఇబ్బందులు ఉంటే సైటు నిర్వాహకుని సంప్రదించండి.';
$string['emailpasswordsent'] = 'సంకేతపదం మార్పును నిర్ధారించినందుకు నెనరులు. కింది అడ్రసుకు ఈమెయిలు పంపించాము<br /><b>{$a->email}</b>.<br />
ఆ కొత్త సంకేతపదాన్ని ఆటోమాటిక్ పద్ధతుల ద్వారా సృష్టించాము - అది గుర్తుంచుకొనేందుకు తేలిగ్గా ఉండేలా దాన్ని మీరు <a href="{$a->link}">మార్చుకోవచ్చు</a>';
$string['emailresetconfirmation'] = 'Hi {$a->firstname},

మీ ఖాతా \'{$a->username}\' కోసం పాస్వర్డ్ రీసెట్ ను {$a->sitename}. దగ్గర అభ్యర్థించారు.

ఈ అభ్యర్థనను నిర్ధారించడానికి, మరియు మీ ఖాతాకి కొత్త పాస్వర్డ్ను సెట్ చేసేందుకు, కింది వెబ్ చిరునామాకు వెళ్ళండి
{$a->link}

అడిగిన సమయం నుంచి {$a->resetminutes} వరకు మాత్రమే చెల్లుతుంది

ఈ పాస్ వర్డ్ రీసెట్ మీరు అభ్యర్దించకపోతె ఏ చర్య అవసరంలేదు

మీకు సహాయం అవసరమైతే, సైట్ నిర్వాహకుడును, {$a->admin} సంప్రదించండి';
$string['emailresetconfirmationsubject'] = 'పాస్వర్డ్ పున:పరిష్కార అభ్యర్థన';
$string['emailresetconfirmsent'] = 'ఒక ఇమెయిల్ <b>{$a}</b> అనే మీ చిరునామా పంపబడింది. <br />

ఈ పాస్వర్డ్ మార్పు ధృవీకరిస్తూ పూర్తి సులభం సూచనలను కలిగి ఉంటుంది.

మీరు ఇబ్బంది కొనసాగుతుంటే, సైట్ నిర్వాహకుడిని సంప్రదించండి.';
$string['emailtoprivatefiles'] = 'మీ వ్యక్తిగత ఫైల్స్ స్థలానికి నేరుగా అటాచ్మెంట్లుగా కూడా ఇ-మెయిల్ ఫైల్స్ కూడా చేయవచ్చు. మీ ఫైళ్ళను ఒక ఇ-మెయిల్కు అటాచ్ చేసి, {$a}';
$string['emailtoprivatefilesdenied'] = 'మీ స్వంత ప్రైవేట్ ఫైళ్ళను అప్లోడ్ చెయ్యడానికి మీ నిర్వాహకుడు ఎంపికను నిలిపివేశారు.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emptydragdropregion'] = 'ఖాళీ ప్రాంతం';
$string['enable'] = 'చేతనం చెయ్యి';
$string['encryptedcode'] = 'ఎన్‍క్రిప్టు కోడ్';
$string['enddate'] = 'కోర్సు ముగింపు తేదీ';
$string['enddate_help'] = 'కోర్సు ముగింపు తేదీ కోర్సు యొక్క వినియోగదారుల జాబితాలో ఒక కోర్సును చేర్చాలా వద్దా అని నిర్ణయించడానికి ఉపయోగిస్తారు. ముగింపు తేదీ గడువు ముగిసినప్పుడు, కోర్సు ఇకపై నావిగేషన్లో జాబితా చేయబడదు మరియు కోర్సు అవలోకనం వలె గత జాబితాలో ఉంది. కోర్సు ముగింపు తేదీని కూడా అనుకూల నివేదికల ద్వారా ఉపయోగించవచ్చు. ముగింపు తేదీ తర్వాత వినియోగదారులు ఇప్పటికీ కోర్సులో ప్రవేశించవచ్చు; ఇతర మాటలలో తేదీ యాక్సెస్ పరిమితం లేదు.';
$string['english'] = 'ఇంగ్లీషు';
$string['enrolmentmethods'] = 'చేర్చుకొను పద్దతులు';
$string['entercourse'] = 'ఈ కోర్సులో ప్రవేశించేందుకు నొక్కండి';
$string['enteremail'] = 'మీ ఈమెయిలు చిరునామా ఇవ్వండి';
$string['enteremailaddress'] = 'మీ సంకేతపదాన్ని మార్చేందుకు, కొత్త సంకేతపదాన్ని మీ ఈమెయిలుకు పంపించేందుకూ మీ ఈమెయిలు చిరునామా ఇవ్వండి.';
$string['enterusername'] = 'మీ వాడుకరిపేరు ఇవ్వండి';
$string['entries'] = 'ఎంట్రీలు';
$string['error'] = 'లోపం';
$string['errorcreatingactivity'] = 'కార్యకలాపాలకు ఒక సందర్భం \'{$ a}\' సృష్టించడం సాధ్యం కాలేదు';
$string['errorfiletoobig'] = 'ఫైలు {$a} bytes పరిమితిని దాటింది';
$string['errornouploadrepo'] = 'ఈ సైట్ కొరకు అప్లోడ్ రిపోజిటరీ ఎనేబుల్ లేదు';
$string['errorwhenconfirming'] = 'ఏదో లోపం తలెత్తడం వలన మిమ్మల్ని ఇంకా నిర్ధారించలేదు. ఏదైనా ఈమెయిల్లో ఉన్న లింకును నొక్కి మీరిక్కడికి వచ్చి ఉంటే, మీరు నొక్కిన ఆ లింకు లైను సగంలో తెగిపోయి ఉందేమో, లేక తరువాతి లైనులోకి కొనసాగి ఉందేమో   చూడండి. అలా ఉంటే, మీరా లింకును కాపీ చేసి మీ బ్రౌజరులో పేస్టు చెయ్యాల్సి ఉంటుందేమో చూడండి.';
$string['eventcommentcreated'] = 'వ్యాఖ్య సృష్టించబడింది';
$string['eventcommentdeleted'] = 'వ్యాఖ్య తొలగించబడింది';
$string['eventcommentsviewed'] = '';
$string['eventconfiglogcreated'] = 'కాన్ఫిగర్ లాగ్ సృష్టించబడింది';
$string['eventcontentviewed'] = 'విషయం చూచుట';
$string['eventcoursebackupcreated'] = 'కోర్సు బ్యాకప్ సృష్టించబడింది';
$string['eventcoursecategorycreated'] = 'వర్గం సృష్టించబడింది';
$string['eventcoursecategorydeleted'] = 'వర్గమును తొలగించారు';
$string['eventcoursecategoryupdated'] = 'వర్గం నవీకరించబడింది';
$string['eventcoursecategoryviewed'] = 'వర్గం వీక్షించబడింది';
$string['eventcoursecontentdeleted'] = 'కోర్సు కంటెంట్ ను తొలగించారు';
$string['eventcoursecreated'] = 'కోర్సు సృస్టింపబడింది';
$string['eventcoursedeleted'] = 'కోర్సు ను తొలగించారు';
$string['eventcourseinformationviewed'] = 'కోర్సు సారాంశం వీక్షించబడింది';
$string['eventcoursemodulecreated'] = 'కోర్సు మాడ్యూల్ సృస్టింపబడింది';
$string['eventcoursemoduledeleted'] = 'కోర్సు మాడ్యూల్ తొలగించారు';
$string['eventcoursemoduleinstancelistviewed'] = 'కోర్సు మాడ్యూల్ ఉదాహరణకు జాబితా వీక్షించబడింది';
$string['eventcoursemoduleupdated'] = 'కోర్సు మాడ్యూల్ నవీకరించబడింది';
$string['eventcoursemoduleviewed'] = 'కోర్సు మాడ్యూల్ వీక్షించబడింది';
$string['eventcourseresetended'] = 'కోర్సు రీసెట్ ముగిసింది';
$string['eventcourseresetstarted'] = 'కోర్సు రీసెట్ ప్రారంభించారు';
$string['eventcourserestored'] = 'కోర్సు పునరుద్ధరించబడింది';
$string['eventcoursesectioncreated'] = 'కోర్సు విభాగం సృష్టించబడింది';
$string['eventcoursesectiondeleted'] = 'కోర్సు విభాగం తొలగించబడింది';
$string['eventcoursesectionupdated'] = 'కోర్సు విభాగం నవీకరించబడింది';
$string['eventcoursessearched'] = 'కోర్సులు శోధించిన';
$string['eventcourseupdated'] = 'కోర్సు నవీకరించబడింది';
$string['eventcourseuserreportviewed'] = 'కోర్సు వినియోగదారు నివేదిక వీక్షించబడింది';
$string['eventcourseviewed'] = 'కోర్సు వీక్షించబడింది';
$string['eventdashboardreset'] = 'డాష్బోర్డ్ రీసెట్';
$string['eventdashboardsreset'] = 'డాష్బోర్డ్లను రీసెట్ చేయండి';
$string['eventdashboardviewed'] = 'డాష్బోర్డ్ వీక్షించబడింది';
$string['eventemailfailed'] = 'మెయిల్ పంపడం విఫలమైంది';
$string['eventname'] = 'ఈవెంట్ పేరు';
$string['eventrecentactivityviewed'] = 'ఇటీవలి కార్యాచరణ వీక్షించబడింది';
$string['eventsearchindexed'] = 'శోధన డేటా ఇండెక్స్ చేయబడింది';
$string['eventsearchresultsviewed'] = 'శోధన ఫలితాలు చూసారు';
$string['eventunknownlogged'] = 'తెలియని ఈవెంట్';
$string['eventusercreated'] = 'వాడుకరి సృస్టింపబడింది';
$string['eventuserdeleted'] = 'వాడుకరిని తొలగించారు';
$string['eventuserinfocategorycreated'] = 'వినియోగదారు ప్రొఫైల్ ఫీల్డ్ వర్గం సృష్టించబడింది';
$string['eventuserinfocategorydeleted'] = 'వినియోగదారు ప్రొఫైల్ విభాగం వర్గం తొలగించబడింది';
$string['eventuserinfocategoryupdated'] = 'వాడుకరి ప్రొఫైల్ రంగంలో వర్గం నవీకరించబడింది';
$string['eventuserinfofieldcreated'] = 'వినియోగదారు ప్రొఫైల్ ఫీల్డ్ సృష్టించబడింది';
$string['eventuserinfofielddeleted'] = 'వినియోగదారు ప్రొఫైల్ ఫీల్డ్ తొలగించబడింది';
$string['eventuserinfofieldupdated'] = 'వినియోగదారు ప్రొఫైల్ ఫీల్డ్ నవీకరించబడింది';
$string['eventuserlistviewed'] = 'వాడుకరి జాబిత చూచుట';
$string['eventuserloggedout'] = 'వాడుకరి లాగ్ అవుట్';
$string['eventuserpasswordupdated'] = 'యూజర్ పాస్వర్డ్ను నవీకరించబడెను';
$string['eventuserprofileviewed'] = 'వాడుకరి ప్రొఫైల్ చూచుట';
$string['eventuserupdated'] = 'వాడుకరి నవీకరించబడింది';
$string['everybody'] = 'ప్రతీ ఒక్కరూ';
$string['executeat'] = 'ఈ సమయానికి ఎక్జిక్యూటు చెయ్యి';
$string['existing'] = 'ప్రస్తుతం ఉన్న';
$string['existingadmins'] = 'ప్రస్తుతం ఉన్న నిర్వాహకులు';
$string['existingcourse'] = 'ప్రస్తుతం ఉన్న కోర్సు';
$string['existingcourseadding'] = 'ప్రస్తుతం ఉన్న కోర్సు, దానికి డేటాను చేరుస్తున్నారు';
$string['existingcoursedeleting'] = 'ప్రస్తుతం ఉన్న కోర్సు, ముందు దాన్ని తొలగిస్తున్నారు';
$string['existingcreators'] = 'ప్రస్తుతం ఉన్న కోర్సు రూపకర్తలు';
$string['existingstudents'] = 'చేరిన విద్యార్థులు';
$string['existingteachers'] = 'ప్రస్తుతం ఉన్న ఉపాధ్యాయులు';
$string['expand'] = 'విస్తరించు';
$string['expandall'] = 'ఎన్నిటినీ విడదీయి';
$string['expandcategory'] = '{$a} విస్తరించు';
$string['explanation'] = 'వివరణ';
$string['explanationdigitalminor'] = 'మీ వయస్సు సమ్మతి యొక్క డిజిటల్ యుగానికి చెందినది కాదా అని తెలుసుకోవడానికి ఈ సమాచారం అవసరం. ఒక వ్యక్తి నిబంధనలు మరియు షరతులకు మరియు వారి డేటా చట్టబద్ధంగా నిల్వ చేయబడి మరియు ప్రాసెస్ చేయటానికి అనుమతిస్తున్నప్పుడు ఇది వయస్సు.';
$string['extendperiod'] = 'వ్యవధిని పొడిగించండి';
$string['failedloginattempts'] = 'మీ గత లాగిన్ తరువాత, {$a->attempts}  విఫల లాగిన్ ప్రయత్నాలు';
$string['feedback'] = 'అభిప్రాయం';
$string['file'] = 'దస్త్రం';
$string['fileexists'] = '{$a} అనే ఫైలు ఇప్పటికే ఉంది';
$string['filemissing'] = '{$a} కనబడటం లేదు';
$string['files'] = 'దస్త్రాలు ';
$string['filesanduploads'] = 'ఫైల్స్ మరియు  అప్లోడ్లు';
$string['filesfolders'] = 'దస్త్రాలు /ఫోల్డర్లు';
$string['fileuploadwithcontent'] = 'ఫైలు అప్లోడ్లు కంటెంట్ పారామీటర్ కలిగి ఉండకూడదు';
$string['filloutallfields'] = 'ఈ ఫారములోని అన్ని ఫీల్డులనూ నింపండి';
$string['filter'] = 'వడపోత';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filters'] = 'వడపోతలు';
$string['findmorecourses'] = 'మరిన్ని కోర్సులు చూడండి';
$string['first'] = 'మొదటి';
$string['firstaccess'] = 'మొదటి యాక్సెస్';
$string['firstname'] = 'మీ పేరు';
$string['firstnamephonetic'] = 'మొదటి పేరు - శబ్ద';
$string['firstsiteaccess'] = 'సైట్కు మొదటి ప్రాప్తి';
$string['firsttime'] = 'ఇక్కడకు రావటం మీకిదే మొదటిసారా?';
$string['folder'] = 'ఫోల్డరు';
$string['folderclosed'] = 'మూసేసిన ఫోల్డరు';
$string['folderopened'] = 'తెరచిన ఫోల్డరు';
$string['followingoptional'] = 'కింది ఐటములు ఐచ్ఛికం';
$string['followingrequired'] = 'కింది ఐటములు తప్పనిసరి';
$string['for'] = 'కొరకు';
$string['force'] = 'బలవంతంగా చెయ్యి';
$string['forcelanguage'] = 'భాషను బలవంతంగా అమలు చెయ్యి';
$string['forceno'] = 'బలవంతం చెయ్యొద్దు';
$string['forcepasswordchange'] = 'సంకేతపదం మార్పును తప్పనిసరి చెయ్యండి';
$string['forcepasswordchange_help'] = 'ఈ చెక్‍బాక్సును టిక్కు చేస్తే, వాడుకరి తరువాతి లాగినయినపుడు సంకేతపదాన్ని మార్చమని అడుగుతుంది';
$string['forcepasswordchangecheckfull'] = 'సంకేతపదం మార్పును {$a} కు తప్పనిసరి చెయ్యాలనే నిశ్చయంతో ఉన్నారా? ';
$string['forcepasswordchangenot'] = '{$a} కు సంకేతపదం మార్పు కోసం బలవంతం చెయ్యలేపోయాం';
$string['forcepasswordchangenotice'] = 'ముందుకు సాగాలంటే మీరు సంకేతపదాన్ని మార్చడం తప్పనిసరి';
$string['forcetheme'] = 'థీమును బలిమి చెయ్యి';
$string['forgotaccount'] = 'సంకేతపదం పోగొట్టుకున్నారా?';
$string['forgotten'] = 'మీ వాడుకరిపేరు, సంకేతపదం మర్చిపోయారా?';
$string['forgottenduplicate'] = 'ఈ ఈమెయిలు చిరునామా అనేక ఖాతాలతో సంధానమై ఉంది. వాడుకరిపేరు ఇవ్వండి.';
$string['forgotteninvalidurl'] = 'సంకేతపదాన్ని మార్చుకునే ఈ URL తప్పుడుది';
$string['format'] = 'ఆకృతి';
$string['format_help'] = 'కోర్సు పేజీ లేఔటు ఎలా ఉండాలో కోర్సు అకృతి నిర్ణయిస్తుంది.

* SCORM అకృతి - కోర్సు మొదటి విభాగంలో ఓ SCORM ప్యాకేజీని చూపించేందుకు (SCORM/AICC మాడ్యూలుకు బదులుగా)
* సామాజిక అకృతి - కోర్సు పేజీలో చర్చావేదికను చూపిస్తాం
* టాపిక్కుల అకృతి - కోర్సు పేజీ టాపిక్కుల విభాగాలుగా ఏర్పరచనబడి ఉంటుంది.
* వారపు అకృతి - కోర్సు పేజీ వారాలుగా విభజించబడి ఉంటుంది. మొదటి వారం కోర్సు మొదలైన తేదీతో మొదలౌతుంది.';
$string['formathtml'] = 'HTML ఆకృతి';
$string['formatmarkdown'] = 'Markdown ఆకృతి';
$string['formatplain'] = 'ప్లెయిన్ టెక్స్టు ఆకృతి';
$string['formattext'] = 'Moodle ఆటో-ఆకృతి';
$string['forumpreferences'] = 'ఫోరం ప్రాధాన్యతలు';
$string['framesetinfo'] = 'ఈ ఫ్రేమ్‍సెట్ డాక్యుమెంటులో ఇవి ఉన్నాయి:';
$string['from'] = 'నుండి';
$string['frontpagecategorycombo'] = 'కాంబో లిస్ట్';
$string['frontpagecategorynames'] = 'వర్గాల జాబితా';
$string['frontpagecourselist'] = 'కోర్సుల జాబితా';
$string['frontpagecoursesearch'] = 'కోర్సు శోధన పెట్టె';
$string['frontpagedescription'] = 'మొదటిపేజీ వివరం';
$string['frontpagedescriptionhelp'] = 'సైటు వివరాన్ని మొదటిపేజీలో చూపిస్తాం';
$string['frontpageenrolledcourselist'] = 'నమోదు చేసిన కోర్సులు';
$string['frontpageformat'] = 'మొదటిపేజీ ఆఆఖ్రూటీ';
$string['frontpageformatloggedin'] = 'లాగిన్ అయినపుడు మొదటి పేజీ ఆకృతి';
$string['frontpagenews'] = 'వార్తాంశాలు';
$string['frontpagesettings'] = 'మొదటి పేజీ సెట్టింగులు';
$string['fulllistofcourses'] = 'అన్ని కోర్సులూ';
$string['fullname'] = 'పూర్తి పేరు';
$string['fullnamecourse'] = 'కోర్సు పూర్తి పేరు';
$string['fullnamecourse_help'] = 'కోర్సులో ఉండాగాను, కోర్సుల జాబితాలోను, కోర్సు పూర్తి పేరు ప్రతీ పేజీకి పైన చూపించబడుతుంది.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'వాడుకరి పూర్తి పేరు';
$string['fullprofile'] = 'పూర్తి ప్రవర';
$string['fullsitename'] = 'సైటు పూర్తి పేరు';
$string['functiondisabled'] = 'ఈ విశషం ప్రస్తుతం అచేతనం చేయబడి ఉంది';
$string['general'] = 'సాధారణం';
$string['geolocation'] = 'అక్షాంశం - రేఖాంశం';
$string['gettheselogs'] = 'ఈ లాగ్‍లను తీసుకురా';
$string['go'] = 'వెళ్ళు';
$string['gpl'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details: http://docs.moodle.org/en/License';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the Moodle License information page for full details: http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL లైసెన్సు';
$string['gradenoun'] = 'గ్రేడు';
$string['grades'] = 'గ్రేడ్లు';
$string['gradeverb'] = 'గ్రేడు';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/"> Gravatar </ a> ఈ సైట్ కు ఎనేబుల్ చెయ్యబడింది.
మీరు ప్రొఫైల్ చిత్రం అప్లోడ్ చెయ్యకపోతే moodle మీ కొరకు ఒక ప్రొఫైల్ చిత్రాన్ని Gravatar నుండి  లోడ్ చెయ్యడానికి ప్రయత్నిస్తుంది.';
$string['group'] = 'గుంపు';
$string['groupadd'] = 'కొత్త గుంపును చేర్చు';
$string['groupaddusers'] = 'ఎంచుకున్న గుంపును చేర్చు';
$string['groupfor'] = 'గుంపు కోసం';
$string['groupinfo'] = 'ఎంచుకున్న గుంపు గురించిన సమాచారం';
$string['groupinfoedit'] = 'గుంపు సెట్టింగులను సవరించు';
$string['groupinfomembers'] = 'ఎంచుకున్న సభ్యుల సమాచారం';
$string['groupinfopeople'] = 'ఎంచుకున్న ప్రజల సమాచారం';
$string['groupmembers'] = 'గుంపు సభ్యులు';
$string['groupmemberssee'] = 'గంపు సభ్యులను చూడండి';
$string['groupmembersselected'] = 'ఎంచుకున్న గుంపు సభ్యులు';
$string['groupmode'] = 'గుంపు మోడ్';
$string['groupmodeforce'] = 'గుంపు మోడ్‍ను బలిమి చెయ్యి';
$string['groupmy'] = 'నా గుంపు';
$string['groupnonmembers'] = 'ఏ గుంపులోనూ లేని వాళ్ళు';
$string['groupnotamember'] = 'సారీ, మీరీ గుంపులో సభ్యులు కాదు';
$string['grouprandomassign'] = 'అందరినీ గుంపులకు ఎడాపెడా చేర్చు';
$string['groupremove'] = 'ఎంచకున్న గుంపును తీసెయ్యి';
$string['groupremovemembers'] = 'ఎంచుకున్న సభ్యులను తీసెయ్యి';
$string['groups'] = 'గుంపులు';
$string['groupsnone'] = 'గుంపుల్లేవు';
$string['groupsseparate'] = 'విడివిడి గుంపులు';
$string['groupsvisible'] = 'కనబడే గుంపులు';
$string['guest'] = 'అతిథి';
$string['guestdescription'] = 'అతిథులకు అతి తక్కువ అనుమతులుంటాయి. ఎక్కడా టెక్స్టు రాయలేరు.';
$string['guestskey'] = 'కీ ఉన్న అతిథులను అనుమతించు';
$string['guestsno'] = 'అతిథులను రానివ్వకు';
$string['guestsnotallowed'] = 'సారీ, \'{$a}\' అతిథులకు అనుమతించదు';
$string['guestsyes'] = 'కీ లేని అతిథులను అనుమతించు';
$string['guestuser'] = 'అతిథి వాడుకరి';
$string['guestuserinfo'] = 'ఈ వాడుకరి కొన్ని కోర్సులకు వాదివే అనుమతులు మాత్రమే ఉన్న ఒక ప్రత్యేక వాడుకరి';
$string['help'] = 'సహాయం';
$string['helpprefix2'] = '{$a} కు సహాయం';
$string['helpwiththis'] = 'దీనికి సహాయం';
$string['hiddenassign'] = 'దాచి ఉంచిన ఎసైనుమెంటు';
$string['hiddenfromstudents'] = 'విద్యార్థులకు కనబడకుండా దాచాం';
$string['hiddenoncoursepage'] = 'అందుబాటులో ఉంది కానీ కోర్సు పేజీలో చూపబడదు';
$string['hiddensections'] = 'దాచిన విభాగాలు';
$string['hiddensections_help'] = 'కొలాప్సు చేసినపుడు, దాచిన విభాగాలు విద్యార్థులకు కనబడతాయా లేక పూర్తిగా దాచబడి ఉంటాయా (వారపు ఆకృతిలో సెలవులను చూపించడానికి) అనేది ఈ సెట్టింగు నిర్ణయిస్తుంది. ';
$string['hiddensectionscollapsed'] = 'దాచిన విభాగాలు మూసేసి కనబడతాయి';
$string['hiddensectionsinvisible'] = 'దాచిన విభాగాలు పూర్తిగా కనబడవు';
$string['hiddenwithbrackets'] = '(దాచిన)';
$string['hide'] = 'దాచు';
$string['hideadvancedsettings'] = 'ఉన్నత సెట్టింగులను దాచు';
$string['hidechartdata'] = 'చార్ట్ డేటాను దాచు';
$string['hidefromstudents'] = 'విద్యార్థుల నుండి దాచు';
$string['hideoncoursepage'] = 'కోర్సు పేజీలో అందుబాటులో ఉండండి కాని చూపించవద్దు';
$string['hidepopoverwindow'] = 'Popover window ను దాచు';
$string['hidesection'] = '{$a} విభాగాన్ని దాచు';
$string['hidesettings'] = 'సెట్టింగులను దాచు';
$string['hideshowblocks'] = 'బ్లాకులను దాచు లేదా చూపించు';
$string['highlight'] = 'హైలైట్';
$string['highlightoff'] = 'హైలైట్ తొలగించండి';
$string['hits'] = 'హిట్లు';
$string['hitsoncourse'] = '{$a->username} ద్వారా  {$a->coursename} కు వచ్చిన హిట్లు ';
$string['hitsoncoursetoday'] = '{$a->username} ద్వారా  {$a->coursename} కు ఈరోజు వచ్చిన హిట్లు ';
$string['home'] = 'హోమ్';
$string['hour'] = 'గంట';
$string['hours'] = 'గంటలు';
$string['howtomakethemes'] = 'కొత్త థీములను తయారుచెయ్యడం ఎలా';
$string['htmleditor'] = 'HTML ఎడిటరు వాడు (కొన్ని బ్రౌజర్లు మాత్రమే)';
$string['htmleditoravailable'] = 'HTML  ఎడిటరు ఉంది';
$string['htmleditordisabled'] = 'మీ వాడుకరి ప్రవర్లో HTML  బ్రౌజరును అచేతనం చేసారు';
$string['htmleditordisabledadmin'] = 'నిర్వాహకుడు ఈ సైటులో HTML ఎడిటరును అచేతనం చేసారు';
$string['htmleditordisabledbrowser'] = 'మీ వెబ్ బ్రౌజరు పని చెయ్యదు కాబట్టి, HTML ఎడిటరు అందుబాటులో లేదు.';
$string['htmlfilesonly'] = 'HTML  ైళ్ళు మాత్రమె';
$string['htmlformat'] = 'ముచ్చటైన HTML  ఆకృతి';
$string['icon'] = 'ఐకాన్';
$string['idnumber'] = 'ID నంబరు';
$string['idnumbercourse'] = 'కోర్సు ఐడీ నంబరు';
$string['idnumbercourse_help'] = 'ID నంబరనేది కోర్సును బయటి వ్యవస్థలతో పోల్చేటపుడు వాడుతాం తప్ప, సైటులో ఎక్కడా అది కనబడదు. కోర్సుకు ఏదైనా అధికారిక సంకేత నామం ఉంటే దాన్ని ఇవ్వండి. లేదా ఈ ఫీళ్డును ఖాళీగా వదిలెయ్యవచ్చు..';
$string['idnumbercoursecategory'] = 'కేటగిరి ID సంఖ్య';
$string['idnumbercoursecategory_help'] = 'ID నంబరనేది కోర్సును బయటి వ్యవస్థలతో పోల్చేటపుడు వాడుతాం తప్ప, సైటులో ఎక్కడా అది కనబడదు. కోర్సుకు ఏదైనా అధికారిక సంకేత నామం ఉంటే దాన్ని ఇవ్వండి. లేదా ఈ ఫీళ్డును ఖాళీగా వదిలెయ్యవచ్చు.';
$string['idnumbergroup'] = 'గ్రూప్ ID సంఖ్య';
$string['idnumbergroup_help'] = 'ID నంబరనేది కోర్సును బయటి వ్యవస్థలతో పోల్చేటపుడు వాడుతాం తప్ప, సైటులో ఎక్కడా అది కనబడదు. కోర్సుకు ఏదైనా అధికారిక సంకేత నామం ఉంటే దాన్ని ఇవ్వండి. లేదా ఈ ఫీళ్డును ఖాళీగా వదిలెయ్యవచ్చు.';
$string['idnumbergrouping'] = 'ID సంఖ్యను గ్రూపింగ్ చేయబడును';
$string['idnumbergrouping_help'] = 'ID నంబరనేది కోర్సును బయటి వ్యవస్థలతో పోల్చేటపుడు వాడుతాం తప్ప, సైటులో ఎక్కడా అది కనబడదు. కోర్సుకు ఏదైనా అధికారిక సంకేత నామం ఉంటే దాన్ని ఇవ్వండి. లేదా ఈ ఫీళ్డును ఖాళీగా వదిలెయ్యవచ్చు.';
$string['idnumbermod'] = 'ఐడీ నంబరు';
$string['idnumbermod_help'] = 'ID నంబరు ఇవ్వడం వలన గ్రేడు లెక్కించడంలో పనిని గుర్తించడానికి మార్గం వేస్తుంది. ఆ పని గ్రేడు లెక్కింపులో ఎక్కడా వాడకపోతే, దీన్ని ఖాళీగా వదిలెయ్యవచ్చు.

ID నంబరును గ్రేడుబుక్కులో కూడా సెట్ చెయ్యవచ్చు. అయితే దాన్ని పని సెట్టింగుల పేజీలో మాత్రమే సవరించవచ్చు.';
$string['idnumbertaken'] = 'ఈ ఐడీ నంబరు ఈసరికే వాడకంలో ఉంది';
$string['imagealt'] = 'బొమ్మ వివరం';
$string['import'] = 'దిగుమతి చెయ్యి';
$string['importdata'] = 'కోర్సు డేటాను దిగుమతి చెయ్యి';
$string['importdataexported'] = '’నుండి’ కోర్సు నుండి డేటాను జయప్రదంగా ఎగుమతి చేసాం.<br />ఇక, మీ ’కు’ కోర్సులోకి దిగుమతిని కానివ్వండి.';
$string['importdatafinished'] = 'దిగుమతి అయిపోయింది! మీ కోర్సుకు పదండి';
$string['importdatafrom'] = 'డేటాను దిగుమతి చేసుకొనేందుకు ఓ కోర్సును చూడండి: ';
$string['inactive'] = 'అచేతనంగా';
$string['include'] = 'చేర్చు';
$string['includeallusers'] = 'వాడుకరులందరినీ చేర్చు';
$string['includecoursefiles'] = 'కోర్సు దస్త్రాలను చేర్చు';
$string['includecourseusers'] = 'కోర్సు వాడుకరులను చేర్చు';
$string['included'] = 'చేర్చాం';
$string['includelogentries'] = 'లాగ్ ఎంట్రీలను చేర్చు';
$string['includemodules'] = 'మాడ్యూళ్ళను చేర్చు';
$string['includemoduleuserdata'] = 'మాడ్యూలు వాడుకరి డేటాను చేర్చు';
$string['includeneededusers'] = 'అవసరమైన వాడుకరులను చేర్చు';
$string['includenoneusers'] = 'వాడుకరులెవరినీ చేర్చవద్దు';
$string['includeroleassignments'] = 'పాత్ర పంపకాలను చేర్చు';
$string['includesitefiles'] = 'ఈ కోర్సులో వాడిన సైటు దస్త్రాలను కలుపు';
$string['includesubcategories'] = 'ఉపవర్గాలను చేర్చండి';
$string['includeuserfiles'] = 'వాడుకరి దస్త్రాలను చేర్చు';
$string['increasesections'] = 'విభాగాల సంఖ్యను పెంచండి';
$string['indicator:accessesafterend'] = 'ముగింపు తేదీ తర్వాత కోర్సు ప్రాప్తి';
$string['indicator:accessesafterend_help'] = 'కోర్సు ముగింపు తేదీ తర్వాత విద్యార్ధి కోర్సును చేరుకున్నట్లయితే ఈ సూచిక ప్రతిబింబిస్తుంది.';
$string['indicator:accessesbeforestart'] = 'ప్రారంభ తేదీకి ముందు కోర్సు ప్రాప్యత చేయబడింది';
$string['indicator:accessesbeforestart_help'] = 'కోర్సు ప్రారంభ తేదీకి ముందు విద్యార్ధి కోర్సును యాక్సెస్ చేస్తే ఈ సూచిక ప్రతిబింబిస్తుంది.';
$string['indicator:anywrite'] = 'ఏదైనా వ్రాసే చర్య';
$string['indicator:anywrite_help'] = 'ఈ సూచిక విద్యార్ధి తీసుకున్న ఏ వ్రాత (submit) చర్యను సూచిస్తుంది.';
$string['indicator:anywriteincourse'] = 'ఏదైనా కోర్సులో కోర్సు రాయండి';
$string['indicator:anywriteincourse_help'] = 'ఈ సూచీ ఏ కోర్సు సూచీలోనూ విద్యార్థిని తీసుకున్న ఏదైనా వ్రాత (సమర్పించడం) చర్యను సూచిస్తుంది.';
$string['indicator:completeduserprofile'] = 'వినియోగదారు ప్రొఫైల్ పూర్తయింది';
$string['indicator:completeduserprofile_help'] = 'విద్యార్థి వారి వినియోగదారు ప్రొఫైల్ పూర్తి చేసుకున్నట్లు ఈ సూచిక సూచిస్తుంది.';
$string['indicator:completionenabled'] = 'పూర్తి ట్రాకింగ్ ప్రారంభించబడింది';
$string['indicator:completionenabled_help'] = 'ఈ సూచిక కోసం పూర్తి పర్యవేక్షణ ప్రారంభించబడినట్లు సూచిస్తుంది.';
$string['indicator:nostudent'] = 'విద్యార్థులు లేరు';
$string['indicator:nostudent_help'] = 'ఈ కోర్సు విద్యార్థులను కలిగి లేదని ఈ సూచిక ప్రతిబింబిస్తుంది.';
$string['indicator:noteacher'] = 'ఉపాధ్యాయులు లేరు';
$string['indicator:noteacher_help'] = 'ఈ సూచీ ఈ కోర్సుకు ఉపాధ్యాయులు లేదని ప్రతిబింబిస్తుంది.';
$string['indicator:potentialcognitive'] = 'కోర్సు సంభావ్య కాగ్నిటివ్ లోతు';
$string['indicator:potentialcognitive_help'] = 'ఈ సూచీ కోర్సు కార్యకలాపాల్లో పాల్గొనే విద్యార్థి చేరుకునే సంభావ్య కాగ్నిటివ్ లోతు ఆధారంగా ఉంటుంది.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'కోర్సు సంభావ్య సామాజిక వెడల్పు';
$string['indicator:potentialsocial_help'] = 'ఈ సూచీ కోర్సు కార్యకలాపాలలో పాల్గొనే విద్యార్థి చేరుకునే సంభావ్య సామాజిక వెడల్పు ఆధారంగా ఉంటుంది.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'చర్యలు మొత్తం చదవండి';
$string['indicator:readactions_help'] = 'ఈ సూచిక విద్యార్ధి తీసుకున్న చదివే (వీక్షణ) చర్యల సంఖ్యను సూచిస్తుంది.';
$string['indicator:userforumstracking'] = 'వాడుకరి ఫోరమ్స్ ట్రాకింగ్';
$string['indicator:userforumstracking_help'] = 'విద్యార్థి ఈ ఫోరమ్లో ట్రాకింగ్ను ప్రారంభించాడో లేదో సూచిస్తుంది.';
$string['info'] = 'సమాచారం';
$string['institution'] = 'సంస్థ';
$string['instudentview'] = 'విద్యార్థి దర్శకంలో';
$string['interests'] = 'ఆసక్తులు';
$string['interestslist'] = 'ఆసక్తుల జాబితా';
$string['interestslist_help'] = 'మీ ఆసక్తులను రాయండి. ఆసక్తుల మధ్య కామా నుంచండి. ఈ ఆసక్తులను మీ ప్రవర పేజీలో ట్యాగులుగా చూపిస్తాం.';
$string['invalidemail'] = 'తప్పుడు ఈమెయిలు చిరునామా';
$string['invalidlogin'] = 'తప్పుడు లాగిన్, మళ్ళీ ప్రయత్నించండి';
$string['invalidusername'] = 'వాడుకరిపేరులో ఇంగ్లీషు చిన్నబడి (లోయరుకేసు) అక్షరాలు, అండరుస్కోరు (_), హైఫను (-), పీరియడు (.), యట్ గుర్తు (@) మాత్రమే ఉండవచ్చు  ';
$string['invalidusernameupload'] = 'తప్పుడు వాడుకరిపేరు';
$string['ip_address'] = 'ఐపీ ఆడ్రసు';
$string['jump'] = 'దూకు';
$string['jumpto'] = 'ఇక్కడికి దూకు...';
$string['keep'] = 'ఉంచేయ్';
$string['langltr'] = 'భాష దిశ ఎడమ-నుంచి-కుడికి';
$string['langrtl'] = 'భాష దిశ కుడి-నుంచి-ఎడమకు';
$string['language'] = 'భాష';
$string['languagegood'] = 'ఈ భాషా ప్యాకు తాజాగా ఉంది :-)';
$string['last'] = 'చివరి';
$string['lastaccess'] = 'చివరిగా వచ్చినది';
$string['lastcourseaccess'] = 'కోర్సుకు చివరిగా ప్రాప్యత';
$string['lastedited'] = 'చివరిగా సవరించినది';
$string['lastip'] = 'చివరి IP చిరునామా';
$string['lastlogin'] = 'చివరిగా లాగినైనది';
$string['lastmodified'] = 'చివరిగా మార్చినది';
$string['lastname'] = 'ఇంటిపేరు';
$string['lastnamephonetic'] = 'ఇంటిపేరు - శబ్ద';
$string['lastsiteaccess'] = 'సైట్కు చివరిగా ప్రాప్యత';
$string['lastyear'] = 'గత సంవత్సరం';
$string['latestlanguagepack'] = 'ఇట్టీవలి భాషాప్యాకు కోసం moodle.org లో చూడండి';
$string['layouttable'] = 'లేఔట్ పట్టిక';
$string['leavetokeep'] = 'ప్రస్తుత సంకేతపదాన్ని ఉంచేసేందుకు దీన్ని ఖాళీగా వదిలెయ్యండి';
$string['legacylogginginuse'] = 'ఈ సైట్ ప్రస్తుతం లెగసీ లాగ్ స్టోర్కు రాయడం ప్రారంభించింది. ఈ లాగ్ స్టోర్కు రాయడం నిలిపివేయబడింది. దయచేసి "ప్రామాణికం" లేదా "బాహ్య" వంటి మద్దతు గల లాగ్ స్టోర్కు వ్రాయండి.';
$string['legacythemeinuse'] = 'మీ బ్రౌజరు మరీ పాతది కావడం చేత, దానికి చేతనైన స్థాయిలో ఈ సైటును  చూపిస్తున్నాం.';
$string['license'] = 'లైసెన్సు';
$string['licenses'] = 'లైసెన్స్';
$string['liketologin'] = 'ఓ పూర్తి వాడుకరి ఖాతాతో లాగిన్ అవుతారా?';
$string['list'] = 'జాబితా';
$string['listfiles'] = '{$a} లోని దస్త్రాల జాబితా';
$string['listofallpeople'] = 'ప్రజలందరి జాబితా';
$string['listofcourses'] = 'కోర్సుల జాబితా';
$string['loading'] = 'లోడ్';
$string['loadinghelp'] = 'లోడ్ అవుతోంది ...';
$string['local'] = 'స్థానిక';
$string['localplugins'] = 'స్థానిక ప్లగిన్‍లు';
$string['localpluginsmanage'] = 'స్థానిక ప్లగిన్లను నిర్వహించు';
$string['location'] = 'స్థలం';
$string['locktimeout'] = 'ఒక లాక్ కోసం ఎదురు చూస్తూ ఆపరేషన్ సమయం ముగిసింది';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'మీరు {$a} గా లాగిన్ అయి ఉన్నారు';
$string['loggedinasguest'] = 'సైటులో మీరు ప్రస్తుతం అతిథిగా ఉన్నారు ';
$string['loggedinnot'] = 'మీరు లాగినై లేరు.';
$string['login'] = 'లాగినవండి';
$string['login_failure_logs'] = 'విఫలమైన లాగిన్ల లాగ్ ';
$string['loginactivity'] = 'లాగిన్ కార్యాచరణ';
$string['loginalready'] = 'మీరు ఈసరికే లాగిన్ అయి ఉన్నారు';
$string['loginas'] = 'ఇలా లాగినండి: ';
$string['loginaspasswordexplain'] = '<p>ఈ విశేషాన్ని వాడాలంటే ప్రత్యేకించిన "loginas password" ను వాడాలి.<br />అది మీకు తెలీకపోతే, మీ సర్వరు నర్వాహకుణ్ణి అడగండి.</p>';
$string['loginguest'] = 'అతిథిగా లాగినవండి';
$string['loginsite'] = 'సైటులోకి లాగినవండి';
$string['loginsteps'] = 'కోర్సుల పూర్తి అనుమతి కావాలంటే ఓ రెణ్ణిమిషాలు సమయం వెచ్చించి, ఈ వెబ్ సైటులో ఓ ఖాతాను తెరవండి.
విడివిడిగా ప్రతీ కోర్సుకూ మరో "ప్రవేశపు కీ" అవసరం కావచ్చు, అయితే అది ఇప్పుడే మీకు అక్కరలేదు లెండి. కింది అంగలు చూడండి:
<ol>
<li>మీ వివరాలతో <a href="{$a}">కొత్త ఖాతా</a> ఫారాన్ని నింపండి.</li>
<li>వెంటనే మీ ఈమెయిలు అడ్రసుకు ఒక ఈమెయిలు వస్తుంది.</li>
<li>దాన్ని చదివి, అందులో ఉన్న లింకును నొక్కండి.</li>
<li>మీ ఖాతా నిర్ధారింపబడి, మిమ్మల్ని లాగిన్ చేస్తుంది.</li>
<li>ఆపైన, మీరు చేరదలచిన కోర్సును ఎంచుకోండి.</li>
<li>మిమ్మల్ని "ప్రవేశపు కీ" కావాలని అడిగితే - మీ ఉపాధ్యాయుదు మీకిచ్చిన కీని వాడండి. దాంతో మీరు కోర్సులోకి చేరుతారు.</li>
<li>అప్పుడిక మీరు కోర్సు మొత్తాన్నీ చూడవచ్చు. ఆపైన మీరు లాగిన్ అయ్యేందుకు మీ వాడుకరిపేరు, సంకేతపదాన్ని ఇచ్చి (ఈ పేజీలో ఉన్న ఫారములో), లాగిన్ అయితే సరిపోతుంది; మీరు చేరిన కోర్సులన్నిటినీ చూడవచ్చు.</li>
</ol>';
$string['loginstepsnone'] = '<p>హలో!</p>
<p>కోర్సుల్లో పూర్తి ప్రవేశం కావాలంటే మీరో ఖాతాను సృష్టించుకోవాలి.</p>
<p>మీరు చెయ్యాల్సిందల్లా, ఓ వాడుకరిపేరు, ఓ సంకేతపదాన్నీ తయారుచేసుకుని ఈ పేజీలో ఇవ్వడమే!</p>
<p>ఒకవేళ మీ వాడుకరిపేరును ఈవరకే ఎవరైనా తీసుకొని ఉంటే మీరు మరోదాన్ని ఎంచుకోవాల్సి ఉంటుంది.</p>';
$string['loginto'] = '{$a} లోకి లాగినవండి';
$string['logout'] = 'లాగౌటవండి';
$string['logoutconfirm'] = 'నిజంగానే లాగౌటవుతారా?';
$string['logs'] = 'లాగ్‍లు';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">ఇంకా</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">ఇంకా</a> ]';
$string['lookback'] = 'వెనక్కి చూడు';
$string['mailadmins'] = 'నిర్వాహకులకు తెలియజేయి';
$string['mailstudents'] = 'విద్యార్థులకు చెప్పు';
$string['mailteachers'] = 'ఉపాధ్యాయులకు చెప్పు';
$string['maincoursepage'] = 'ముఖ్య కోర్సు పేజీ';
$string['makeafolder'] = 'ఫోల్డరు సృష్టించు';
$string['makeavailable'] = 'లభ్య పరచు';
$string['makeeditable'] = '\'{$a}\' ను వెబ్‍సర్వరు ప్రాసెసుల ద్వారా (ఉదాహరణకు అపాచీ) మార్పుచేర్పులు చేసే వీలు కలిగిస్తే, అప్పుడు ఈ దస్త్రాన్ని ఈ పేజీ నుంచే నేరుగా మార్చవచ్చు';
$string['makethismyhome'] = 'దీన్ని నా డిఫాల్టుపేజీగా చెయ్యి';
$string['makeunavailable'] = 'అందుబాటులో లేదు';
$string['manageblocks'] = 'బ్లాకులు';
$string['managecategorythis'] = 'ఈ వర్గంలో నిర్వహించండి';
$string['managecourses'] = 'కోర్సులను నిర్వహించు';
$string['managedatabase'] = 'డేటాబేసు';
$string['managedataformats'] = 'డేటా ఫార్మాట్లను నిర్వహించండి';
$string['manageeditorfiles'] = 'ఎడిటరు వాడే దస్త్రాలను నిర్వహించు';
$string['managefilters'] = 'వడపోతలు';
$string['managemodules'] = 'మాడ్యూళ్ళు';
$string['manageroles'] = 'పాత్రలు, అనుమతులు';
$string['markallread'] = 'అన్నీ చదివినట్లు గుర్తించు';
$string['markedthistopic'] = 'ఈ టాపిక్కు వర్తమాన టాపిక్కుగా హైలైటయింది';
$string['markthistopic'] = 'ఈ టాపిక్కును వర్తమాన టాపిక్కుగా హైలైటు చెయ్యి';
$string['matchingsearchandrole'] = '\'{$a->search}\' ని {$a->role} నీ సరిపోలుస్తున్నాం';
$string['maxareabytesreached'] = 'ఫైలు (లేదా పలు ఫైళ్ళు మొత్తం పరిమాణం) ఈ ప్రాంతంలో మిగిలిన స్థలం కంటే పెద్దది.';
$string['maxfilesize'] = 'కొత్త ఫైళ్లు కు గరిష్ట పరిమాణం: {$ a}';
$string['maxfilesreached'] = 'ఈ అంశానికి మీకు గరిష్టంగా {$a} ఫైలు (లు) అటాచ్ చెయ్యడానికి అనుమతించబడతాయి';
$string['maximumchars'] = 'గరిష్ఠంగా {$a} కారెక్టర్లు';
$string['maximumgrade'] = 'గరిష్ఠ గ్రేడు';
$string['maximumgradex'] = 'గరిష్ఠ గ్రేడు: {$a}';
$string['maximumshort'] = 'గరిష్ఠ';
$string['maximumupload'] = 'గరిష్ఠ ఎక్కింపు వేగం';
$string['maximumupload_help'] = 'ఈ సెట్టింగు ద్వారా ఈ కోర్సులోకి ఎక్కించదగ్గ గరిష్ఠ దస్త్రంసైజును నిర్ణయించవచ్చు. ఈ సైజు, నిర్వాహకుడు నిర్ణయించిన సైటువ్యాప్త సెట్టింగుకు లోబడి ఉంటుంది. వ్యాపకాల మాడ్యూళ్లకు కూడా గరిష్ఠ ఎక్కింపు సైజు సెట్టింగు ఉంటుంది. దీనిద్వారా దస్త్రం సైజును మరింతగా నియంత్రించవచ్చు.';
$string['maxnumberweeks'] = 'గరిష్ట విభాగాల సంఖ్య';
$string['maxnumberweeks_desc'] = 'గరిష్ట విభాగాల సంఖ్య విలువ డ్రాప్ డౌన్ మెను (  నిర్దిష్ట ఆకృతులకు మాత్రమే వర్తిస్తుంది).';
$string['maxnumcoursesincombo'] = 'బ్రౌజ్ <a href="{$a->link}">{$a->numberofcourses} courses</a>.';
$string['maxsize'] = 'గరిష్ఠ సైజు: {$a}';
$string['maxsizeandareasize'] = 'కొత్త ఫైళ్ళు కు గరిష్ట పరిమాణం : {$a->size}, మొత్తం పరిమితి : {$a->areasize}';
$string['maxsizeandattachments'] = 'కొత్త ఫైళ్ళు కు గరిష్ట పరిమాణం: {$a->size}, గరిష్ట అటాచ్మెంట్లు: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'కొత్త ఫైళ్ళు కు గరిష్ట పరిమాణం: {$a->size},  గరిష్ట అటాచ్మెంట్లు: {$a->attachments}, మొత్తం పరిమితి : {$a->areasize}';
$string['memberincourse'] = 'కోర్సులో ఉన్న జనం';
$string['message'] = 'సందేశం';
$string['messagebody'] = 'సందేశ పాఠ్యం';
$string['messagedselectedusers'] = 'ఎంచుకున్న వాడుకరులకు సందేశం పంపించాం, గ్రాహకుల జాబితాను రీసెట్ చేసాం.';
$string['messagedselectedusersfailed'] = 'ఎంచుకున్న వాడుకరులకు సందేశం పంపించడంలో ఏదో లోపం దొర్లింది. కొందరికి ఈమెయిలు అందిఇ ఉండవచ్చు.';
$string['messageprovider:availableupdate'] = 'నవీకరణకు అందుబాటులో ఉన్న నోటిఫికేషన్లు';
$string['messageprovider:backup'] = 'బ్యాకప్ నోటిఫికేషన్లు';
$string['messageprovider:badgecreatornotice'] = 'చిహ్నముల సృస్టికర్త యొక్క ప్రకటనలు';
$string['messageprovider:badgerecipientnotice'] = 'చిహ్నముల పొందెవాని యొక్క ప్రకటనలు';
$string['messageprovider:competencyplancomment'] = 'ఒక అభ్యాస ప్రణాళికపై వ్యాఖ్యానించింది';
$string['messageprovider:competencyusercompcomment'] = 'ఒక యోగ్యతపై వ్యాఖ్య పోస్ట్ చేయబడింది';
$string['messageprovider:courserequestapproved'] = 'కోర్సు సృష్టి అభ్యర్థనను ఆమోదపరచిన నోటిఫికేషన్';
$string['messageprovider:courserequested'] = 'కోర్సు సృష్టికి అభ్యర్థన నోటిఫికేషన్';
$string['messageprovider:courserequestrejected'] = 'కోర్సు సృష్టి అభ్యర్థన యొక్క తిరస్కరణ నోటిఫికేషన్';
$string['messageprovider:errors'] = 'సైటులో ముఖ్యమైన లోపాలు';
$string['messageprovider:errors_help'] = 'నిర్వాహకుడు తెలుసుకోవాల్సిన ముఖ్యమైన లోపాలు కొన్ని ఉన్నాయి.';
$string['messageprovider:insights'] = 'ప్రిడిక్షన్ మోడల్ల ద్వారా అంతర్దృష్టులు సృష్టించబడ్డాయి';
$string['messageprovider:instantmessage'] = 'వాడుకరుల మధ్య వ్యక్తిగత సందేశాలు';
$string['messageprovider:instantmessage_help'] = 'ఈ సైటులోని ఇతర వాడుకరులు మీకు నేరుగా పంపే సందేశాలను ఏం చెయ్యాలో ఈ విభాగంలో కాన్ఫిగరు చేసుకోవచ్చు.';
$string['messageprovider:notices'] = 'చిన్న సమస్యల గురించి నోటీసులు';
$string['messageprovider:notices_help'] = 'నిర్వాహకునికి చూడాలనే ఆసక్తి కలిగించే నోటీసులు';
$string['messageselect'] = 'ఈ వాడుకరిని సందేశ గ్రాహకునిగా ఎంచుకోండి';
$string['messageselectadd'] = 'ఓ సందేశం పంపు';
$string['middlename'] = 'మధ్య పేరు';
$string['migratinggrades'] = 'గ్రేడ్లను తరలిస్తున్నాం';
$string['min'] = 'ని.';
$string['mins'] = 'ని.లు';
$string['minute'] = 'నిమిషం';
$string['minutes'] = 'నిమిషాలు';
$string['miscellaneous'] = 'ఇతరాలు';
$string['missingcategory'] = 'ఒక వర్గాన్ని ఎంచుకోవాలి';
$string['missingdescription'] = 'వివరం వదిలేసారు';
$string['missingemail'] = 'ఈమెయిలు చిరునామా ఇవ్వలేదు';
$string['missingfirstname'] = 'పేరు ఇవ్వలేదు';
$string['missingfromdisk'] = 'ఫ్రమ్ డిస్క్ ఇవ్వలేదు';
$string['missingfullname'] = 'పూర్తి పేరు ఇవ్వలేదు';
$string['missinglastname'] = 'ఇంటిపేరు ఇవ్వలేదు';
$string['missingname'] = 'పేరు ఇవ్వలేదు';
$string['missingnewpassword'] = 'కొత్త సంకేతపదం ఇవ్వలేదు';
$string['missingpassword'] = 'సంకేతపదం ఇవ్వలేదు';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA సవాలు ఫీల్డు ఇవ్వలేదు';
$string['missingreqreason'] = 'కారణం ఇవ్వలేదు';
$string['missingshortname'] = 'పొట్తిపేరు ఇవ్వలేదు';
$string['missingshortsitename'] = 'సైటు పొట్టిపేరు ఇవ్వలేదు';
$string['missingsitedescription'] = 'సైటు వివరం ఇవ్వలేదు';
$string['missingsitename'] = 'సైటు పేరు ఇవ్వలేదు';
$string['missingstrings'] = 'అనువదించని పదాలు, పదబంధాల కోసం చూడు';
$string['missingstudent'] = 'ఏదో ఒకదాన్ని తప్పనిసరిగా ఎంచుకోవాలి';
$string['missingsummary'] = 'సారాంశం ఇవ్వలేదు';
$string['missingteacher'] = 'ఏదో ఒకదాన్ని తప్పనిసరిగా ఎంచుకోవాలి';
$string['missingurl'] = 'URL ఇవ్వలేదు';
$string['missingusername'] = 'వాడుకరిపేరు కనబడలేదు';
$string['moddoesnotsupporttype'] = 'నెలలు';
$string['modhide'] = 'దాచు';
$string['modified'] = 'మార్చబడింది';
$string['modshow'] = 'చూపించు';
$string['moduleintro'] = 'వివరం';
$string['modulesetup'] = 'మాడ్యూలు పట్టికలను సెటప్పు చేస్తున్నాం';
$string['modulesuccess'] = '{$a} పట్టికలను సరిగ్గా సెటప్పు చేసాం';
$string['modulesused'] = 'మాడ్యూల్ వాడినవి';
$string['modvisible'] = 'అందుబాటు';
$string['modvisible_help'] = 'లభ్యత \'కోర్సు పేజీలో చూపించు\' అని సెట్ చేసినట్లయితే, సూచించే లేదా వనరు విద్యార్థులకు అందుబాటులో ఉంటుంది (సెట్ చేయగల ఏవైనా ప్రాప్యత పరిమితులకు లోబడి) <br> <br>
లభ్యత \'విద్యార్థుల నుండి దాచు\' కు సెట్ చేయబడితే, దాచిన కార్యాచరణలను (డిఫాల్ట్ గా, గురువు లేదా నాన్-ఎడిటింగ్ గురువు పాత్రలతో ఉన్న వినియోగదారులు) వీక్షించడానికి అనుమతి ఉన్న వినియోగదారులకు మాత్రమే కార్యాచరణ లేదా వనరు అందుబాటులో ఉంటుంది.';
$string['modvisiblehiddensection'] = 'అందుబాటు';
$string['modvisiblehiddensection_help'] = 'లభ్యత \'విద్యార్థుల నుండి దాచు\' కు సెట్ చేయబడితే, దాచిన కార్యాచరణలను (డిఫాల్ట్గా, టీచర్ లేదా నాన్-ఎడిటింగ్ గురువు పాత్రతో ఉన్న వినియోగదారులు) వీక్షించడానికి అనుమతి ఉన్న వినియోగదారులకు మాత్రమే కార్యాచరణ లేదా వనరు అందుబాటులో ఉంటుంది. <br> <br>
కోర్సు అనేక కార్యకలాపాలు లేదా వనరులను కలిగి ఉంటే, కోర్సు పేజీ \'లభ్యమవుతుంది కాని కోర్సు పేజీలో చూపబడదు\' లభ్యత సెట్ చేయడం ద్వారా సరళీకృతం చేయబడవచ్చు. ఈ సందర్భంలో, కార్యకలాపాలకు లేదా వనరుకు లింక్ తప్పనిసరిగా ఒక పేజీ వనరు నుండి తప్పనిసరిగా అందించాలి. ఈ చర్య ఇప్పటికీ గ్రేడ్బుక్ మరియు ఇతర నివేదికలలో జాబితా చేయబడుతుంది.';
$string['modvisiblewithstealth'] = 'అందుబాటు';
$string['modvisiblewithstealth_help'] = 'లభ్యత \'కోర్సు పేజీలో చూపించు\' అని సెట్ చేసినట్లయితే, సూచించే లేదా వనరు విద్యార్థులకు అందుబాటులో ఉంటుంది (సెట్ చేయగల ఏవైనా ప్రాప్యత పరిమితులకు లోబడి) <br> <br>
లభ్యత \'విద్యార్థుల నుండి దాచు\' కు సెట్ చేయబడితే, దాచిన కార్యాచరణలను (డిఫాల్ట్గా, గురువు లేదా నాన్-ఎడిటింగ్ గురువు పాత్రలతో ఉన్న వినియోగదారులు) వీక్షించడానికి అనుమతి ఉన్న వినియోగదారులకు మాత్రమే కార్యాచరణ లేదా వనరు అందుబాటులో ఉంటుంది. <br> <br>
కోర్సు అనేక కార్యకలాపాలు లేదా వనరులను కలిగి ఉంటే, కోర్సు పేజీ \'లభ్యమవుతుంది కానీ కోర్సు పేజీలో చూపబడదు\' లభ్యత సెట్ చేయడం ద్వారా సరళీకృతమవుతుంది. ఈ సందర్భంలో, కార్యకలాపాలకు లేదా వనరుకు లింక్ తప్పనిసరిగా ఒక పేజీ వనరు నుండి తప్పనిసరిగా అందించాలి. ఈ చర్య ఇప్పటికీ గ్రేడ్బుక్ మరియు ఇతర నివేదికలలో జాబితా చేయబడుతుంది.';
$string['month'] = 'నెల';
$string['months'] = 'నెలలు';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'ఈ పేజీ కోసం Moodle Docs';
$string['moodlelogo'] = 'మూడ్లె లోగో';
$string['moodlerelease'] = 'Moodle విడుదల';
$string['moodleversion'] = 'Moodle వెర్షను';
$string['more'] = 'మరింత';
$string['morehelp'] = 'మరింత సహాయం';
$string['moreinfo'] = 'మరింత సమాచారం';
$string['moreinformation'] = 'లోపం గురించి మరింత సమాచారం';
$string['morenavigationlinks'] = 'మరింత...';
$string['moreprofileinfoneeded'] = 'మీ గురించి ఇంకాస్త చెప్పండి';
$string['mostrecently'] = 'ఇట్టీవల';
$string['move'] = 'తరలించు';
$string['movecategoriessuccess'] = '{$a->count} అను వర్గమును \'{$a->to}\' వర్గములోకి జయప్రదంగా జరిగించబడినది';
$string['movecategoriestotopsuccess'] = '{$a->count} వర్గమును టాప్ స్థాయికి విజయవంతంగా తరలించబడింది';
$string['movecategorycontentto'] = 'దీనిలోకి తరలించు: ';
$string['movecategorysuccess'] = '{$a->moved}\' వర్గమును \'{$a->to }\' వర్గములోకి విజయవంతంగా తరలించబడింది';
$string['movecategoryto'] = 'వర్గాన్ని ఇక్కడికి తరలించు:';
$string['movecategorytotopsuccess'] = '\'{$a->moved}\' వర్గమును టాప్ స్థాయికి విజయవంతంగా తరలించబడింది';
$string['movecontent'] = '{$a} తరలించు';
$string['movecontentstoanothercategory'] = 'అంశాలను వేరే వర్గానికి తరలించు';
$string['movecoursemodule'] = 'వనరు తరలించు';
$string['movecoursesection'] = 'విభాగం తరలించు';
$string['movecourseto'] = 'కోర్సును ఇక్కడికి తరలించు: ';
$string['movedown'] = 'కిందికి జరుపు';
$string['movefilestohere'] = 'దస్త్రాలను ఇక్కడికి తరలించు';
$string['movefull'] = '{$a} ను ఈ స్థానానికి తరలించు';
$string['movehere'] = 'ఇక్కడికి తరలించు';
$string['moveleft'] = 'ఎదమవైపుకు జరుపు';
$string['moveright'] = 'కుడివైపుకు జరుపు';
$string['movesection'] = '{$a} విభాగాన్ని తరలించు';
$string['moveselectedcategoriesto'] = 'ఎంపిక వర్గం  తరలించు';
$string['moveselectedcoursesto'] = 'ఎంచుకున్న కోర్సులను ఇక్కడికి తరలించు: ';
$string['movetoanotherfolder'] = 'మరో ఫోల్డరులోకి తరలించు';
$string['moveup'] = 'పైకి జరుపు';
$string['mustchangepassword'] = 'కొత్త సంకేతపదం ప్రస్తుతం ఉన్నదానికంటే భిన్నంగా ఉండాలి';
$string['mustconfirm'] = 'మీ లాగిన్‍ను నిర్ధారించాల్సి ఉంది';
$string['mycourses'] = 'నా కోర్సులు';
$string['myfiles'] = 'నా గోప్య దస్త్రాలు ';
$string['myfilesmanage'] = 'నా గోప్య దస్త్రాలను నిర్వహించు';
$string['myhome'] = 'నా హోమ్';
$string['mymoodledashboard'] = 'My Moodle డ్యాషుబోర్డు';
$string['myprofile'] = 'నా ప్రవర';
$string['name'] = 'పేరు';
$string['namedfiletoolarge'] = '\'{$a->filename}\' ఫైల్ చాలా పెద్దదిగా ఉంది మరియు అప్లోడ్ చేయబడదు';
$string['nameforlink'] = 'మీరు ఈ లింక్ ను ఏమని పిలవాలి అనుకుంటున్నారు?';
$string['nameforpage'] = 'పేరు';
$string['navigation'] = 'నేవిగేషను';
$string['needed'] = 'ఆవశ్యకం';
$string['networkdropped'] = 'మీ ఇంటర్నెట్ కనెక్షన్ నమ్మదగని లేదా మేము అంతరాయం కలిగించిందని మేము కనుగొన్నాము. <br />
దయచేసి మీ కనెక్షన్ మెరుగుపరుస్తుంది వరకు మార్పులు సరిగా సేవ్ చేయబడవని తెలుసుకోండి.';
$string['never'] = 'ఎల్లప్పుడూ వద్దు';
$string['neverdeletelogs'] = 'లాగ్‍లను ఎప్పుడూ తొలగించవద్దు';
$string['new'] = 'కొత్త';
$string['newaccount'] = 'కొత్త ఖాతా';
$string['newactivityname'] = 'చర్య కోసం క్రొత్త పేరు {$a}';
$string['newcourse'] = 'కొత్త కోర్సు';
$string['newpassword'] = 'కొత్త సంకేతపదం';
$string['newpassword_help'] = 'కొత్త సంకేతపదాన్ని ఇవ్వండి. పాతదాన్నే ఉంచుకోవాలనుకుంటే ఖాళీగా వదిలెయ్యండి';
$string['newpasswordfromlost'] = '<strong>గమనిక:</strong> పోయిన సంకేతపదాన్ని తిరిగి పొందే ప్రాసెస్‍లో భాగంగా పంపిన రెండు ఈమెయిళ్ళలోని <strong>రెండో</strong> దానిలో మీ <strong>ప్రస్తుత సంకేతపదం</strong> వచ్చి ఉండాలి. ఈ తెరనుండి ముందుకు పోయే ముందు, మీ కొత్త సంకేతపదం వచ్చిందని నిర్హ్దారించుకోండి.';
$string['newpasswordtext'] = '{$a->firstname} గారూ,

Your account password at \'{$a->sitename}\' లోని మీ ఖాతా సంకేతపదాన్ని మార్చి మీకో తాత్కాలిక సంకేతపదాన్ని ఇచ్చాం.has been reset and you have been issued with a new temporary password. Your current login information is now: username: {$a->username} password: {$a->newpassword} Please go to this page to change your password: {$a->link} In most mail programs, this should appear as a blue link which you can just click on. If that doesn\'t work, then cut and paste the address into the address line at the top of your web browser window. Cheers from the \'{$a->sitename}\' administrator, {$a->signoff}';
$string['newpicture'] = 'కొత్త బొమ్మ';
$string['newpicture_help'] = 'కొత్త బొమ్మను చేర్చేందుకు, బొమ్మను వెతికి, ఎంచుకుని  (JPG లేదా PNG ఫార్మాటుల్లో), తరువాత "ప్రవరను తాజాకరించు" లింకును నొక్కండి. బొమ్మ 100x100 పిక్సెళ్ళ సైజుకు క్రాపు చేయబడుతుంది.';
$string['newpictureusernotsetup'] = 'అన్ని అవసరమైన ప్రొఫైల్ సమాచారం సేవ్ చెయ్యబడిన తర్వాత ప్రొఫైల్ చిత్రాన్ని జోడించగలరు.';
$string['newsectionname'] = 'విభాగం {$a} కోసం క్రొత్త పేరు';
$string['newsitem'] = 'వార్తాంశం';
$string['newsitems'] = 'వార్తాంశాలు';
$string['newsitemsnumber'] = 'చూపించాల్సిన వార్తాంశాలు';
$string['newsitemsnumber_help'] = 'కోర్సుపేజీలోని వార్తల బ్లాకులో ఎన్ని ఇటీవలి ఐటములుండాలో ఈ సెట్టింగు నిర్ణయిస్తుంది. "0 వార్తల ఐటములు" అని ఇస్తే, వార్తల బ్లాకును అసలే చూపించం.';
$string['newuser'] = 'కొత్త వాడుకరి';
$string['newusernewpasswordsubj'] = 'కొత్త వాడుకరి ఖాతా';
$string['newusernewpasswordtext'] = '{$a->firstname} గారూ,

\'{$a->sitename}\' లో మీకో కొత్త ఖాతాను సృష్టించి, మీకో తాత్కాలిక సంకేతపదాన్ని ఇచ్చాం.

మీ ప్రస్తుత లాగిన్ సమాచరం ఇది:
వాడుకరి పేరు:
{$a->username}
సంకేతపదం:
{$a->newpassword} (మొదటిసారి లాగిన్ కాగానే మీ సంకేతపదాన్ని మార్చుకోవాలి)

\'{$a->sitename}\' ను వాడేందుకు, {$a->link} వద్ద లాగినవండి

చాలా మెయిలు ప్రోగ్రాముల్లో ఇది నొక్కగలిగే నీలపు లింకుగా కనిపిస్తుంది. అది పనిచెయ్యకపోతే, దీన్ని కాపీ చేసి, మీ బ్రౌజరు అడ్రసుపట్టీలో అతికించండి.

\'{$a->sitename}\' నిర్వాహకుని శుభాకాంక్షలతో,
{$a->signoff}';
$string['newusers'] = 'కొత్త వాడుకరులు';
$string['newwindow'] = 'కొత్త విండో';
$string['next'] = 'తరువాతి';
$string['nextsection'] = 'తరువాతి విభాగం';
$string['no'] = 'వద్దు';
$string['noblockstoaddhere'] = 'ఈ పేజీలో చేర్చదగిన బ్లాకులు లేవు';
$string['nobody'] = 'ఎవరూ లేరు';
$string['nochange'] = 'మార్పు లేదు';
$string['nocomments'] = 'వ్యాఖ్యలు లేవు';
$string['nocourses'] = 'కోర్సుల్లేవు';
$string['nocoursesfound'] = '\'{$a}\' పదాలు కలిగిన కోర్సూళేమీ కనబడలేదు';
$string['nocoursestarttime'] = 'కోర్సు ప్రారంభ సమయం లేదు';
$string['nocoursesyet'] = 'ఈ వర్గంలో కోర్సులేమీ లేవు';
$string['nodstpresets'] = 'Daylight Savings Time అనుకూలతను నిర్వాహకుడు చేతనం చెయ్యలేదు.';
$string['nofilesselected'] = 'రీస్టోరు చేసేందుకు దస్త్రాలనేమీ ఎంచుకోలేదు';
$string['nofilesyet'] = 'మీ కోర్సులోకి ఇంకా దస్త్రాలేమీ ఎక్కించలేదు';
$string['nofiltersapplied'] = 'ఫిల్టర్లు వర్తించబడలేదు';
$string['nograde'] = 'గ్రేడు లేదు';
$string['nohelpforactivityorresource'] = 'ఈ వనరు లేదా కార్యాచరణకు సంబంధించిన సహాయం లేదు';
$string['noimagesyet'] = 'మీ కోర్సులోకి ఇంకా బొమ్మళేమీ ఎక్కించలేదు';
$string['nologsfound'] = 'లాగ్‍లేమీ దొరకలేదు';
$string['nomatchingusers'] = '\'{$a}\' తో సరిపోలే వాడుకరులెవరూ దొరకలేదు';
$string['nomorecourses'] = 'సరిపోలే కోర్సులు ఇంకేమీ దొరకలేదు';
$string['nomoreidnumber'] = 'ఘర్షణలను నివారించేందుకు గాను, ఐడీనంబరును వాడటం లేదు.';
$string['none'] = 'ఏమీలేదు';
$string['noneditingteacher'] = 'ఎడిటు చెయ్యలేని ఉపాధ్యాయుడు';
$string['noneditingteacherdescription'] = 'ఎడిటు చెయ్యలేని ఉపాధ్యాయులు విద్యార్థులకు బోధించగలరు, గ్రేడ్లూ వెయ్యగలరు. పనులను మార్చలేరు.';
$string['nonstandard'] = 'అప్రామాణిక';
$string['nopendingcourses'] = 'ఆమోదం కోసం వేచి ఉన్న కోర్సులేమీ లేవు';
$string['nopotentialadmins'] = 'సంభావ్య నిర్వాహకులెవరూ లేరు';
$string['nopotentialcreators'] = 'సంభావ్య కోర్సు రూపకర్తలెవరూ లేరు';
$string['nopotentialstudents'] = 'సంభావ్య విద్యార్థులెవరూ లేరు';
$string['nopotentialteachers'] = 'సంభావ్య ఉపాధ్యాయులెవరూ లేరు';
$string['norecentactivity'] = 'ఇటీవలి కార్యకలాపమేమీ లేదు';
$string['noreplybouncemessage'] = 'మీరో జవాబివ్వవద్దు ఈమెయిలుకు జవాబిచ్చారు. ఏదైనా చర్చావేదిక టపాకు జవాబివ్వబోతే, {$a} వేదికలను వాడి జవాబివ్వండి.

మీ మెయిలు కంటెంటు ఇది:';
$string['noreplybouncesubject'] = '{$a} - బౌన్సైన మెయిలు.';
$string['noreplyname'] = 'ఈ ఈమెయిలుకు జవాబివ్వవద్దు';
$string['noresetrecord'] = 'రీసెట్ అభ్యర్థన సంఖ్య రికార్డు లేదు. దయచేసి ఒక కొత్త పాస్వర్డ్ రీసెట్ అభ్యర్థనను ప్రారంభించండి.';
$string['noresults'] = 'ఫలితాల్లేవు';
$string['normal'] = 'మామూలు';
$string['normalfilter'] = 'మామూలు వెతుకులాట';
$string['nosite'] = 'సైటు స్థాయి కోర్సు కనబడలేదు';
$string['nostudentsfound'] = '{$a} ఏమీ కనబడలేదు';
$string['nostudentsingroup'] = 'ఈ గుంపులో ఇంకా విద్యార్థులెవరూ లేరు';
$string['nostudentsyet'] = 'ఈ కోర్సులో ఇంకా విద్యార్థులెవరూ చేరలేదు';
$string['nosuchemail'] = 'అలాంటి ఈమెయిలు అడ్రసేదీ లేదు';
$string['notavailable'] = 'లేదు';
$string['notavailablecourse'] = '{$a} లభ్యమవుటలేదు';
$string['noteachersyet'] = 'ఈ కోర్సులో ఇంకా ఉపాధ్యాయులెవరూ లేరు';
$string['notenrolled'] = '{$a} ఈ కోర్సులో చేరలేదు.';
$string['notenrolledprofile'] = 'ఈ వాడుకరి ఈ కోర్సులో ఇంకా చేరలేదు కాబట్టి, ఈ ప్రవర అందుబాటులో లేదు.';
$string['noteusercannotrolldatesoncontext'] = '<strong>గమనిక:</strong> ఈ బ్యాకప్పును రీస్టోరు చేసేటపుడు తేదీలను రోలు చెయ్యగలిగడాన్ని అచేతనం చేసాం. ఎందుకంటే, మీకా అనుమతులు లేవు కాబట్టి. ';
$string['noteuserschangednonetocourse'] = '<strong>గమనిక:</strong>
వాడుకరి డేటాను రీస్టోరు చేసేటపుడు (పనులు, ఫైళ్ళు, సందేశాల్లో) కోర్సు వాడుకరులను రీస్టోరు చెయ్యాలి. ఈ సెట్టింగును మీకోసం మార్చాం.';
$string['nothingnew'] = 'మీ గత లాగిన్ తరవాత కొత్తగా జరిగిందేమీ లేదు';
$string['nothingtodisplay'] = 'చూపించడానికేమీ లేదు';
$string['notice'] = 'గమనిక';
$string['noticenewerbackup'] = 'ఈ బ్యాకప్పు ఫైలును Moodle {$a->backuprelease} ({$a->backupversion}) ను వాడి సృష్టించాం. అది ప్రస్తుతం స్థాపించబడి ఉన్న Moodle {$a->serverrelease} ({$a->serverversion}) కంటే కొత్తది.
ఇది కొంత తేడా చేసే అవకాశం ఉంది. ఎంచేతంటే, బ్యాకప్ ఫైళ్ళ బ్యాక్‍వర్డు కంపాటిబిలిటీకి గ్యారంటీ ఇవ్వలేం.';
$string['notifications'] = 'గమనింపులు (నోటిఫికేషన్లు)';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, వాడుకరి: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'మీరీ లాగ్‍లను {$a}/course/report/log/index.php?id=1&chooselog=1&modid=site_errors వద్ద చూడవచ్చు.';
$string['notifyloginfailuresmessagestart'] = 'మీకు కిందటిసారి కబురు పంపిన తరువాత {$a}  వద్ద జరిగిన విఫల లాగిన్ ప్రయత్నాల జాబితా ఇది';
$string['notifyloginfailuressubject'] = '{$a} :: విఫల లాగిన్‍ల గమనింపు';
$string['notincluded'] = 'చేర్చనివి';
$string['notingroup'] = 'సారీ, ఈ కార్యకలాపాన్ని చూడాలంటే, మీరా గుంపులో భాగమై ఉండాలి.';
$string['notpublic'] = 'సార్వజనికం కాదు!';
$string['nousersfound'] = 'వాడుకరులెవరూ దొరకలేదు';
$string['nousersmatching'] = '\'{$a}\' తో సరిపోలే వాడుకరులెవరూ దొరకలేదు';
$string['nousersyet'] = 'ఇంకా వాడుకరులెవరూ లేరు';
$string['novalidcourses'] = 'చూపించేందుకు సరైన కోర్సులేమీ లేవు';
$string['now'] = 'ఇప్పుడు';
$string['numattempts'] = '{$a} విఫల లాగిన్ ప్రయత్నాలు';
$string['numberofcourses'] = 'కోర్సులు సంఖ్య';
$string['numberweeks'] = 'వారాలు/టాపిక్కుల సంఖ్య';
$string['numday'] = '{$a} రోజు';
$string['numdays'] = '{$a} రోజులు';
$string['numhours'] = '{$a} గంటలు';
$string['numletters'] = '{$a} అక్షరాలు';
$string['numminutes'] = '{$a} నిమిషాలు';
$string['nummonth'] = '{$a} నెల';
$string['nummonths'] = '{$a} నెలలు';
$string['numseconds'] = '{$a} సెకండ్లు';
$string['numviews'] = '{$a} వీక్షణాలు';
$string['numweek'] = '{$a} వారం';
$string['numweeks'] = '{$a} వారాలు';
$string['numwords'] = '{$a} పదాలు';
$string['numyear'] = '{$a} సంవత్సరం';
$string['numyears'] = '{$a} సంవత్సరాలు';
$string['ok'] = 'సరే';
$string['oldpassword'] = 'ప్రస్తుత సంకేతపదం';
$string['olduserdirectory'] = 'ఇది పాత వాడుకరుల డైరెక్టరీ, ఇక దీని అవసరం లేదు. దీన్ని నిక్షేపంగా తొలగించవచ్చు. దీనిలో ఉన్న దస్త్రాలను కొత్త వాడుకరుల డైరెక్టరీలోకి కాపీ చేసేసాం.';
$string['optional'] = 'ఐచ్ఛికం';
$string['options'] = 'ఎంపికలు';
$string['order'] = 'వరుస';
$string['originalpath'] = 'అసలైన మార్గం';
$string['orphanedactivitiesinsectionno'] = 'అనాథ కార్యకలాపాలు (విభాగం {$a})';
$string['other'] = 'ఇతర';
$string['outline'] = 'స్థూలంగా';
$string['outlinereport'] = 'స్థూల నివేదిక';
$string['page'] = 'పేజీ';
$string['pagea'] = 'పేజీ {$a}';
$string['pageheaderconfigablock'] = '%fullname% లో బ్లాకును కాన్ఫిగరు చేస్తున్నాం';
$string['pagepath'] = 'పేజీ పాత్';
$string['pageshouldredirect'] = 'ఈ పేజీ ఆటోమాటిగ్గా దారి మళ్ళించాలి. ఏమీ జరక్కపోతే, కింద ఉన్న కొనసాగించు లింకును నొక్కండి.';
$string['parentcategory'] = 'మాతృ వర్గం';
$string['parentcoursenotfound'] = 'మాతృ కోర్సు కనబడలేదు!';
$string['parentfolder'] = 'మాతృ ఫోల్డరు';
$string['participants'] = 'పాల్గోలుదార్లు';
$string['participantslist'] = 'పాల్గోలుదార్ల జాబితా';
$string['participationratio'] = 'పాల్గోలు నిష్పత్తి';
$string['participationreport'] = 'పాల్గోలు నివేదిక';
$string['password'] = 'సంకేతపదం';
$string['passwordchanged'] = 'సంకేతపదం మార్చబడింది';
$string['passwordconfirmchange'] = 'సంకేతపదం మార్పును ధ్రువీకరించండి';
$string['passwordextlink'] = 'పోయిన్ మీ సంకేతపదాన్ని తిరిగి తెచ్చేందుకు కింది లింకు ఇచ్చాం. ఇది మిమ్మలి Moodle బైటకు తీసుకుపోతుంది.';
$string['passwordforgotten'] = 'మరచిపోయిన సంకేతపదం';
$string['passwordforgotteninstructions'] = 'మీ వివరాలు ముందు మా డేటాబేసులో కనబడాలి. మీ వాడుకరిపేరుగానీ,  <strong>లేదా</strong>  మీ ఈమెయిలు చిరునామాగానీ సంబంధిత పెట్టెలో ఇవ్వండి. రెండూ ఇవ్వాల్సిన పని లేదు.';
$string['passwordforgotteninstructions2'] = 'మీ సంకేతపదాన్ని మార్చేందుకు, మీ వాడుకరిపేరుగానీ, మీ ఈమెయిలు అడ్రసుగానీ ఇవ్వండి. ఆ వివరాలు మా డేటాబేసులో ఉంటే, ఎలా లాగిన్ అవ్వాలో వివరిస్తూ మీకో ఈమెయిలు పంపిస్తాం.';
$string['passwordnohelp'] = 'పోయిన మీ సంకేతపదాన్ని వెతికేందుకు సహాయమేమీ అందుబాటులో లేదు. మీ Moodle నిర్వాహకుణ్ణి సంప్రదించండి.';
$string['passwordrecovery'] = 'సరే, లాగిన్ అవడంలో నాకు సాయం చెయ్యండి';
$string['passwordsdiffer'] = 'ఈ సంకేతపదాలు సరిపోలడం లేదు';
$string['passwordsent'] = 'సంకేతపదాన్ని పంపించాం';
$string['passwordsenttext'] = '<p>మీ అడ్రసు, {$a->email} కు ఒక ఈమెయిలు పంపించాం.</p>  <p><b>మీ కొత్త సంకేతపదం కోసం మీ ఈమెయిలు చూడండి</b></p>  <p>కొత్త సంకేతపదం ఆటోమాటిగ్గా తయారు చేసినది. అంచేత దాన్ని<a href="{$a->link}">తేలిగ్గా గుర్తుపెట్టుకునే విధంగా మార్చుకోండి</a>.</p>';
$string['passwordset'] = 'మీ పాస్వర్డ్ సెట్ చేయబడింది.';
$string['path'] = 'పాత్';
$string['pathnotexists'] = 'మీ సర్వరులో ఈ పాత్ లేదు';
$string['pathslasherror'] = 'పాత్ స్లాష్‍తో అంతం కాదు!!';
$string['paymentinstant'] = 'కింది బొత్తాన్ని నొక్కి, నిమిషాల్లో డబ్బు చెల్లించి చేరిపోండి!';
$string['paymentpending'] = '	
(<small><b><u>{$a}</u></b> పెండింగు</small>)';
$string['paymentrequired'] = 'ఈ కోర్సులో చేరాలంటే డబ్బు చెల్లించాలి.';
$string['payments'] = 'చెల్లింపులు';
$string['paymentsorry'] = 'డబ్బు చెల్లించినందుకు మీకు నెనరులు! దురదృష్టవశాత్తూ, మీ చెల్లింపు ఇంకా పూర్తిగా ప్రాసెస్ కాలేదు, అంచేత
"{$a->fullname}" కోర్సులో ప్రవేశించేందుకు మిమ్మల్ని నమోదు చెయ్యలేదు. కొద్ది క్షణాల తరువాత కోర్సులో ప్రవెసించేందుకు మళ్ళీ ప్రయత్నించండి. అప్పటికీ ఇబ్బంది ఉంటే, "{$a->fullname}". కు గనీ, సైటు నిర్వాహకునికి గానీ తెలియపరచండి.';
$string['paymentthanks'] = 'డబ్బు చెల్లించినందుకు మీకు నెనరులు! మీకిప్పుడు మీ కోర్సులో ప్రవేశం లభించింది: <br />"{$a}"';
$string['pendingrequests'] = 'పెండింగులో ఉన్న అభ్యర్ధనలు';
$string['periodending'] = 'పెండింగులో ఉన్న సమయం ({$a})';
$string['perpage'] = 'పేజీకి';
$string['perpagea'] = 'పేజీకి: {$a}';
$string['personal'] = 'వ్యక్తిగతం';
$string['personalprofile'] = 'వ్యక్తిగత ప్రవర';
$string['phone'] = 'ఫోను';
$string['phone1'] = 'ఫోను';
$string['phone2'] = 'మొబైలు ఫోను';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = '{$a} బొమ్మ';
$string['pictureofuser'] = 'వాడుకరి బొమ్మ';
$string['pleaseclose'] = 'ఈ విండోను ఇక మూసెయ్యండి.';
$string['pleasesearchmore'] = 'మరికొన్నిటికోసం వెతకండి';
$string['pleaseusesearch'] = 'వెతుకులాటను వాడండి';
$string['plugin'] = 'ప్లగిన్';
$string['plugincheck'] = 'ప్లగిన్ పరిశీలన';
$string['plugindeletefiles'] = 'డేటాబేసులో ఈ ప్లగిన్, \'{$a->name}\'  కు చెందిన డేటా అంతటినీ తొలగించాం. ఈ ప్లగిన్ తనను తాను తిరిగి స్థాపించుకోకుండా, ఈ డైరెక్టరీని సర్వరు నుంచి తొలగించాలి: {$a->directory}';
$string['pluginsetup'] = 'ప్లగిన్ పట్టికలను సెటప్ చెయ్యడం';
$string['policyaccept'] = 'నాకర్థమైంది, సమ్మతిస్తున్నాను';
$string['policyagree'] = 'ఈ సైటును  వాడుకోవాలంటే, ఈ విధానాన్ని సమ్మతించాలి. సమ్మతిస్తున్నారా?';
$string['policyagreement'] = 'సైటు విధాన ఒప్పందం';
$string['policyagreementclick'] = 'సైటు విధాన ఒప్పందానికి లింకు';
$string['popup'] = 'పాపప్';
$string['popupwindow'] = 'దస్త్రాన్ని కొత్త విండోలో తెరువు';
$string['popupwindowname'] = 'పాపప్ విండో';
$string['post'] = 'టపా';
$string['posts'] = 'టపాలు';
$string['potentialadmins'] = 'సంభావ్య నిర్వాహకులు';
$string['potentialcreators'] = 'సంభావ్య కోర్సు రూపకర్తలు';
$string['potentialstudents'] = 'సంభావ్య విద్యార్థులు';
$string['potentialteachers'] = 'సంభావ్య ఉపాధ్యాయులు';
$string['preferences'] = 'అభిరుచులు';
$string['preferredlanguage'] = 'కోరుకున్న భాష';
$string['preferredtheme'] = 'కోరుకున్న థీము';
$string['preprocessingbackupfile'] = 'బ్యాకప్పు దస్త్రాన్ని ప్రిప్రాసెసింగు చేస్తున్నాం';
$string['prev'] = 'గత';
$string['preview'] = 'మునుజూపు';
$string['previeworchoose'] = 'మునుజూడండి, లేదా ఓ థీమును ఎంచుకోండి';
$string['previous'] = 'గత';
$string['previouslyselectedusers'] = 'ఇంతకుముందు ఎంచిపెట్టుకున్న వాడుకరులు \'{$a}\' తో సరిపోలడం లేదు';
$string['previoussection'] = 'గత విభాగం';
$string['primaryadminsetup'] = 'నిర్వాహక ఖాతాను సెటప్ చెయ్యండి';
$string['private_files_handler'] = 'యూజర్ యొక్క ప్రైవేట్ ఫైల్స్ నిల్వ స్థలంలో ఇ-మెయిల్కు జోడింపులను నిల్వ చేయండి.';
$string['private_files_handler_name'] = 'ప్రైవేట్ ఫైళ్లకు ఇమెయిల్';
$string['privatefiles'] = 'ప్రైవేట్ ఫైల్లు';
$string['privatefilesmanage'] = 'ప్రైవేట్ ఫైళ్లను నిర్వహించండి';
$string['proceed'] = 'కొనసాగండి';
$string['profile'] = 'ప్రవర';
$string['profilenotshown'] = 'కనీసం ఒక్క కోర్సులోనైనా చేరనంతవరకు, ఈ ప్రవర వివరం చూపించం.';
$string['publicprofile'] = 'బహిరంగ ప్రవర';
$string['publicsitefileswarning'] = 'గమనిక: ఇక్కడ ఉంచిన దస్త్రాలను ఎవరైనా చూడవచ్చు';
$string['publicsitefileswarning2'] = 'గమనిక: ఇక్కడ ఉంచిన దస్త్రాలను URL తెలిసిన (లేదా ఊహించగలిగిన) ఎవరైనా చూడవచ్చు. భద్రత కోసం రీస్టోరు అవగానే, బ్యాకప్పు దస్త్రాలను తొలగించడం మంచిది. ';
$string['publicsitefileswarning3'] = 'గమనిక: ఇక్కడ ఉంచిన దస్త్రాలను URL తెలిసిన (లేదా ఊహించగలిగిన) ఎవరైనా చూడవచ్చు.<br />భద్రత రీత్యా, బ్యాకప్పు దస్త్రాలను backupdata ఫోల్డరులో మాత్రమే భద్రపరచాలి. ';
$string['question'] = 'ప్రశ్న';
$string['questionsinthequestionbank'] = 'ప్రశ్నావళిలోని ప్రశ్నలు';
$string['quotausage'] = 'మీ {$a->total} పరిమితి యొక్క {$a->used} పరిమితిని మీరు ప్రస్తుతం ఉపయోగించారు.';
$string['readinginfofrombackup'] = 'బ్యాకప్పు నుండి సమాచారాన్ని చదువుతున్నాం';
$string['readme'] = 'README';
$string['recentactivity'] = 'ఇటీవలి కార్యకలాపాలు';
$string['recentactivityreport'] = 'ఇటీవలి కార్యకలాపాల పూర్తి నివేదిక...';
$string['recipientslist'] = 'గ్రాహకుల జాితా';
$string['recreatedcategory'] = '{$a} వర్గాన్ని తిరిగి సృష్టించాం';
$string['redirect'] = 'దారిమళ్ళింపు';
$string['reducesections'] = 'విభాగాల సంఖ్య తగ్గించండి';
$string['refresh'] = 'తాజాకరించు';
$string['refreshingevents'] = 'ఘటనలను తాజాకరిస్తున్నాం';
$string['registration'] = 'Moodle నమోదు';
$string['registrationcontact'] = 'ప్రజలనుంచి సంపర్కం';
$string['registrationcontactno'] = 'లేదు, సైటు జాబితాలో నాకు సంప్రదించు ఫారము అక్కరలేదు';
$string['registrationcontactyes'] = 'సరే, భావి మూడిలర్లు నన్ను సంప్రదించేందుకు వీలుగా ఒక ఫారము ఇవ్వండి';
$string['registrationemail'] = 'ఈమెయిలు గమనింపులు';
$string['registrationinfo'] = '<p>ఈ పేజీ, మీ Moodle సైటును moodle.org లో నమోదు చేసుకునే వీలును కలిపిస్తుంది. నమోదు ఉచితం.
నమోదు చేసుకోవడంలో ప్రధాన ప్రయోజనం ఏంటంటే.. Moodle కొత్త విడుదలలు, భద్రతా వార్తలువంటి ముఖ్యమైన వార్తలను పంపించే మయిలింగు క్జాబితాకు మిమ్మల్ని చేరుస్తాం. </p>
<p>డిఫాల్టుగా, మీ సమాచారాన్ని గోప్యంగా ఉంచుతాం, ఎవరికీ అమ్మడం గానీ, ఇవ్వడంగానీ చెయ్యం. ఈ సమాచారాన్ని సేకరించడంలో ఏకైక ఉద్దేశమేంటంటే.. సపోర్టు కోసం, Moodle  సమాజపు గణాంకచిత్రాన్ని తయారుచెయ్యడం, అంతే. </p>
<p>కావాలనుకుంటే, మీ సైటు పేరు, దేశం, URL లను Moodle సైట్ల బహిరంగా జాబితాకు చేర్చవచ్చు.</p>
<p>కొత్త నమోదులన్నీ మానవికంగా పరిశీలించిన తరువాతే జాఅబితాకు చేర్చబడతాయి. ఒకసారి చేర్చాక, ఈ ఫారాన్ని తిరిగి సమర్పించడం ద్వారా, ఎప్పుడైనా మీ సమాచారాన్ని తాజాకరించుకోవచ్చు (బహిరంగా జాబితాలో మీ సమాచారాన్ని కూడా).</p> ';
$string['registrationinfotitle'] = 'నమోదు సమాచారం';
$string['registrationsend'] = 'నమోదు సమాచారాన్ని Moodle.org కు పంపించు';
$string['registrationyes'] = 'ఔను, ముఖ్యమైన అంశాల గురించి నాకు తెలియపరచు';
$string['reject'] = 'తిరస్కరించు';
$string['rejectdots'] = 'తిరస్కరించు...';
$string['reload'] = 'మళ్ళీ లోడు చెయ్యి';
$string['remoteappuser'] = 'రిమోటు {$a} వాడుకరి';
$string['remove'] = 'తీసెయ్యి';
$string['removeadmin'] = 'నిర్వాహకుని తీసెయ్యి';
$string['removecreator'] = 'కోర్సు రూపకర్తను తీసెయ్యి';
$string['removestudent'] = 'విద్యార్థిని తీసెయ్యి';
$string['removeteacher'] = 'ఉపాధయాయుని తీసెయ్యి';
$string['rename'] = 'పేరుమార్చు';
$string['renamefileto'] = '<b>{$a}</b> పేరు మార్చు:';
$string['report'] = 'నివేదిక';
$string['reports'] = 'నివేదికలు';
$string['repositories'] = 'భాండారాలు';
$string['requestcourse'] = 'కోర్సు గురించి అభ్యర్ధించు';
$string['requestedby'] = 'అడిగినవారు:';
$string['requestedcourses'] = 'అడిగిన కోర్సులు';
$string['requestreason'] = 'కోర్సు అడగటానికి కారణం';
$string['required'] = 'ఆవశ్యకం';
$string['requirespayment'] = 'కోర్సులో ప్రవేశించాలంటే డబ్బు చెల్లించాలి';
$string['reset'] = 'రీసెట్ చెయ్యి';
$string['resetcomponent'] = 'విడిభాగం';
$string['resetcourse'] = 'కోర్సును రీసెట్ చెయ్యి';
$string['resetinfo'] = 'ఏదైనా కోర్సునుండి వాడుకరి డేటాను పూర్తిగా తీసెయ్యడానికి (పనులు, ఇతర సెట్టింగులను అలాగే ఉంచుతూనే), ఈ పేజీని వాడవచ్చు. కింది ఐటములను ఎంచుకుని, ఈ పేజీని పంపిస్తే, ఎంచుకున్న వాడుకరి డేటాను ఈ కోర్సు నుంచి శాశ్వతంగా తొలగిస్తారని గుర్తించండి. ';
$string['resetnotimplemented'] = 'రీసెట్ ను అమలు చెయ్యలేదు';
$string['resetrecordexpired'] = 'మీరు ఉపయోగించే పాస్వర్డ్ రీసెట్ లింక్ {$a} నిమిషాల కంటే పాతది మరియు గడువు ఆయీపొయింది. దయచేసి ఒక కొత్త పాస్వర్డ్ రీసెట్ అభ్యర్థనను ప్రారంభించండి.';
$string['resetstartdate'] = 'రీసెట్ ప్రారంభ తేదీ';
$string['resetstatus'] = 'స్థితి';
$string['resettask'] = 'టాస్కు';
$string['resettodefaults'] = 'డిఫాల్టులకు రీసెట్ చెయ్యి';
$string['resortcourses'] = 'క్రమీకరించు కోర్సులు';
$string['resource'] = 'వనరు';
$string['resourcedisplayauto'] = 'ఆటోమాటిగ్గా';
$string['resourcedisplaydownload'] = 'దించుకోలును బలిమి చెయ్యి';
$string['resourcedisplayembed'] = 'ఇముడ్చు';
$string['resourcedisplayframe'] = 'ఫ్రేములో';
$string['resourcedisplaynew'] = 'కొత్త విండో';
$string['resourcedisplayopen'] = 'తెరువు';
$string['resourcedisplaypopup'] = 'పాపప్పులో';
$string['resources'] = 'వనరులు';
$string['resources_help'] = 'వనరు రకాల ద్వారా ఏ రకమైన జాలకంటెంటునైనా కోర్సులో పెట్టవచ్చు.';
$string['restore'] = 'రీస్టోరు చెయ్యి';
$string['restorecancelled'] = 'రీస్టోరు రద్దు చెయ్యబడింది';
$string['restorecannotassignroles'] = 'రీస్టోరు పాత్రలను పంచాల్సి ఉంది, కానీ మీకా అనుమతులు లేవు';
$string['restorecannotcreateorassignroles'] = 'రీస్టోరు ద్వారా పాత్రను సృష్టించడం లేదా ఆపాదించడం చెయ్యాల్సి ఉంది, కానీ మీకా అనుమతి లేదు.';
$string['restorecannotcreateuser'] = 'రీస్టోరు ద్వారా \'{$a}\' వాడుకరిని బ్యాకప్పు దస్త్రం నుండి సృష్టించాల్సి ఉంది, కానీ మీకా అనుమతి లేదు.';
$string['restorecannotoverrideperms'] = 'రీస్టోరు చెయ్యాలంటే ఓవెర్‍రైడు అనుమతి ఉండాలి, కానీ మీకా అనుమతి లేదు.';
$string['restorecoursenow'] = 'ఈ కోర్సును ఇప్పుడే రీస్టోరు చెయ్యి!';
$string['restoredaccount'] = 'రీస్టోరైన ఖాతా';
$string['restoredaccountinfo'] = 'ఈ ఖాతా వేరే సర్వరు నుంచి దిగుమతీ చేసుకోబడింది. దాని సంకేతపదం పోయింది. ఈమెయిలు ద్వారా కొత్త సంకేతపదాన్ని పెట్టేందుకు, "కొనసాగించు" నొక్కండి.';
$string['restorefinished'] = 'రీస్టోరు జయప్రదంగా ముగిసింది';
$string['restoreto'] = 'ఇక్కడ రీస్టోరు చెయ్యి:';
$string['restoretositeadding'] = 'హెచ్చరిక: సైటు మొదటిపేజీకి రీస్టోరు చెయ్యబోతున్నారు - దానికి డేటాను చేర్చి!';
$string['restoretositedeleting'] = 'హెచ్చరిక: సైటు మొదటిపేజీకి  రీస్టోరు చెయ్యబోతున్నారు - ముందు అందులోని డేటాను తీసేసి!';
$string['restoreuserconflict'] = 'వాడుకరి \'{$a}\' ని బ్యాకప్పు దస్త్రం నుంచి రీస్టోరు చేసేటపుడు ఘర్షణ ఏర్పడుతుంది';
$string['restoreuserinfofailed'] = 'వాడుకరి డేటాను రీస్టోరు చేసే అనుమతి మీకు లేనందువలన, రీస్టోరు ప్రాసెస్సు అగిపోయింది.';
$string['restoreusersprecheck'] = 'వాడుకరి డేటాను పరిశీలిస్తున్నాం';
$string['restoreusersprecheckerror'] = 'వాడుకరి డేటాను పరిశీలించేటపుడు కొన్ని సమస్యలు తలెత్తాయి';
$string['restricted'] = 'నిరోధించబడింది';
$string['returningtosite'] = 'ఈ వెబ్‍సైటుకు తిరిగి వస్తున్నారా? ';
$string['returntooriginaluser'] = 'తిరిగి {$a} వెళ్ళండి';
$string['revert'] = 'రివర్టు చెయ్య';
$string['role'] = 'పాత్ర';
$string['roleassignments'] = 'పాత్ర నియమించడం';
$string['rolemappings'] = 'పాత్ర మ్యాపింగులు';
$string['rolerenaming'] = 'పాత్ర పేరు మార్చడం';
$string['rolerenaming_help'] = 'ఈ సెట్టింగు ద్వారా పాత్రల కనిపించే పేర్లను మార్చుకోవచ్చు. కనిపించే పేరు మాత్రమే మారుతుంది - పాత్ర అనుమతులు మారవు. కొత్త పేర్లు కోర్సు పాల్గోలుదారుల పేజీలోను, కోర్సులోనే ఇతర చోట్లా కనిపిస్తాయి. కోర్సు మేనేజరుగా నిర్వాహకుడు ఎంచుకున్న పాత్ర పేరు మారిస్తే, ఆ కొత్త పేరు కోర్సు జాబితాల్లో కూడా కనిపిస్తుంది.';
$string['roles'] = 'పాత్రలు';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'RSS ఇటీవలి కృతుల సంఖ్య';
$string['rsserror'] = 'RSS డేటాను చదవడంలో లోపం దొర్లింది';
$string['rsserrorauth'] = 'మీ RSS లింకులో సరైన ఆథెంటికేషను టోకెను లేదు.';
$string['rsserrorguest'] = 'ఈ ఫీడ్ డేటా యాక్సెస్ అతిథి యాక్సెస్ ఉపయోగిస్తుంది, కానీ అతిధి డేటా చదవడానికి అనుమతి లేదు. ఒక చెల్లుబాటు అయ్యే వినియోగదారుగా ఈ ఫీడ్ నుండి వచ్చే అసలు స్థానమును (URL) సందర్శించండి మరియు అక్కడ నుండి ఒక కొత్త RSS లింక్ ను పొందండి.';
$string['rsskeyshelp'] = 'భద్రత మరియు గోప్యత నిర్ధారించడానికి, RSS ఫీడ్ URL లో ఒక ప్రత్యేక టోకెన్ కలిగి ఉంటుంది. వాటితో యూజర్ గుర్తిస్తుంది. ఇది RSS ఫీడ్లు యాక్సెస్ లేదా మూడిల్ యొక్క ప్రాంతాలను ప్రాప్యత నుండి ఇతర వినియోగదారులను నిరోధిస్తుంది. </p><p> మీరు మొదటిసారి ఒక RSS Feed ఉత్పత్తి చేసే మూడిల్ విస్తీర్ణం ను యాక్సెస్ చేస్తే ఈ టోకెన్ స్వయంచాలకంగా సృష్టించబడుతుంది. మీరు ఒక విధంగా మీ RSS Feed టోకెన్  రాజీపడినట్టు భావిస్తే. ఇక్కడ రీసెట్ లింక్ క్లిక్ చేయడం ద్వారా కొత్తది అభ్యర్థించవచ్చు. మీ ప్రస్తుత RSS ఫీడ్ URL అప్పుడు చెల్లనిది   అవుతుంది  అని దయచేసి గమనించండి.';
$string['rsstype'] = 'ఈ పనికి RSS ఫీడు';
$string['saveandnext'] = 'భద్రపరచి తరువాతిది చూపించు';
$string['savechanges'] = 'మార్పులను భద్రపరచు';
$string['savechangesanddisplay'] = 'భద్రపరచి చూపించు';
$string['savechangesandreturntocourse'] = 'భద్రపరచి కోర్సుకు తిరిగి వెళ్ళు';
$string['savecomment'] = 'వ్యాఖ్యను భద్రపరచు';
$string['savedat'] = 'ఈ సమయానికి భద్రపరచాం:';
$string['savepreferences'] = 'అభిరుచులను భద్రపరచు';
$string['saveto'] = 'ఇక్కడ భద్రపరచు: ';
$string['scale'] = 'కొలమానం';
$string['scale_help'] = 'ఏదైనా పనిలో పనితీరును కొలిచేందుకు, గ్రేడింగు చేసేందుకు కొలమానం ఉపయోగపడతుంది. అదొక విలువలతో కూడిన అంకెల జాబితా. విలువలు రుణాత్మక విలువ నుంచి ధనాత్మక విలువ వైపుగా, కామాలతో విడదీయబడి ఉంటాయి. ఉదాహరణకు, "అస్సలు బాగాలేదు, ఏమంత బాగాలేదు, ఫరవాలేదు, బాగుంది, చాలా బాగుంది, బ్రహ్మాండం!"';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'కొలమానాలు';
$string['scalescustom'] = 'కస్టమ్ కొలమానాలు';
$string['scalescustomcreate'] = 'కొత్తకొలమానాన్ని చేర్చు';
$string['scalescustomno'] = 'కొత్త కొలమానాలేమీ సృష్టించలేదు';
$string['scalesstandard'] = 'ప్రామాణిక కొలమానాలు';
$string['scalestandard'] = 'ప్రామాణిక కొలమానం';
$string['scalestandard_help'] = 'సైటు వ్యాప్తంగా అన్ని కోర్సులకూ ఒక ప్రామాణిక కొలమానం ఉంది.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'స్వీయ కొలమానాలను సృష్టించేందుకు, మీ కోర్సు నిర్వహణ మెనూలోని ’కొలమానాలు...’ లింకును వాడండి.';
$string['scalestip2'] = 'స్వీయ కొలమానాలను సృష్టించేందుకు, మీ కోర్సు నిర్వహణ మెనూలోని గ్రేడ్లు లింకును నొక్కి, తరువాత మార్చు, కొలమానాలును ఎంచుకోండి.';
$string['schedule'] = 'షెడ్యూలు';
$string['screenshot'] = 'తెరపట్టు';
$string['search'] = 'వెతుకు';
$string['search_help'] = 'ఒకటో రెండో, లేదా ఇంకా ఎక్కువో పదాల కోసం పాఠ్యంలో మామూలుగా వెతికేందుకు, ఒకదాని కొకదానికి మధ్య ఖాళీలుంచి అన్నటినీ టైపించండి. రెండు కారెక్టర్ల కంటే పెద్దవైన పదాలన్నిటినీ వాడుతాం.

మెరుగైన వెతుకులాట కోసం, వెతుకు పెట్టెలో ఏమీ టైపించకుండా, వెతుకు బొత్తాన్ని నొక్కండి; మెరుగైన వెతుకు ఫారానికి తీసుకువెళ్తుంది.';
$string['searchagain'] = 'మళ్ళీ వెతుకు';
$string['searchbyemail'] = 'ఈమెయిలు చిరునామా ప్రకారం వెతుకు';
$string['searchbyusername'] = 'వాడుకరిపేరు ప్రకారం వెతుకు';
$string['searchcourses'] = 'కోర్సులలో వెతుకు';
$string['searchoptions'] = 'వెతుకులాట వికల్పాలు';
$string['searchresults'] = 'వెతుకులాట ఫలితాలు';
$string['sec'] = 'సె.';
$string['seconds'] = 'సెకండ్లు';
$string['secondstotime172800'] = '2 రోజులు';
$string['secondstotime259200'] = '3 రోజులు';
$string['secondstotime345600'] = '4 రోజులు';
$string['secondstotime432000'] = '5 రోజులు';
$string['secondstotime518400'] = '6 రోజులు';
$string['secondstotime604800'] = '1 వారం';
$string['secondstotime86400'] = '1 రోజు';
$string['secretalreadyused'] = 'సంకేతపదం మార్పు లింకుని ఈసరికే వాడారు, సంకేతపదాన్ని మార్చలేదు. ';
$string['secs'] = 'సె.';
$string['section'] = 'విభాగం';
$string['sectionname'] = 'విభాగం పేరు';
$string['sections'] = 'విభాగాలు';
$string['seealsostats'] = 'ఇవి కూడా చూడండి: గణాంకాలు';
$string['selctauser'] = 'ఒక వినియోగదారుని ఎంచుకోండి';
$string['select'] = 'ఎంచు';
$string['selectacategory'] = 'దయచేసి వర్గాన్ని ఎంచుకోండి';
$string['selectacountry'] = 'ఒక దేశాన్ని ఎంచుకోండి';
$string['selectacourse'] = 'ఒక కోర్సును ఎంచుకోండి';
$string['selectacoursesite'] = 'ఒక కోర్సు లేదా సైట్ ఎంచుకోండి';
$string['selectagroup'] = 'ఒక బృందాన్ని ఎంచుకోండి';
$string['selectall'] = 'అన్నీ ఎంచుకోండి';
$string['selectamodule'] = 'ఓ పని మాడ్యూలును ఎంచుకోండి ';
$string['selectanaction'] = 'ఒక చర్య ఎంచుకోండి';
$string['selectanoptions'] = 'ఒక ఎంపికను ఎంచుకోండి';
$string['selectaregion'] = 'ఒక ప్రాంతాన్ని ఎంచుకోండి';
$string['selectcategorysort'] = 'ఏ వర్గములను మీరు క్రమము చేయదలచుకున్నారు?';
$string['selectcategorysortby'] = 'వర్గములను మీరు ఎలా క్రమము చేయదలచుకున్నారు?';
$string['selectcoursesortby'] = 'కోర్సులను మీరు ఎలా క్రమము చేయదలచుకున్నారు?';
$string['selectdefault'] = 'డిఫాల్టును ఎంచుకోమ్ది';
$string['selectedcategories'] = 'ఎంపిక చేయబడ్డ వర్గంలు';
$string['selectedfile'] = 'దస్త్రాన్ని ఎంచుకోండి';
$string['selectednowmove'] = '{$a} దస్త్రాలను తరలించడానికి ఎంచుకున్నారు. ఇప్పుడు గమ్యస్థానపు ఫోల్డరుకు వెళ్ళి, ’దస్త్రాలను ఇక్కడికి తరలించు’ లింకును నొక్కండి';
$string['selectfiles'] = 'దస్త్రాలను ఎంచుకోండి';
$string['selectfiltertype'] = 'ఎంచు';
$string['selectmoduletoviewhelp'] = 'సహాయం వీక్షించడానికి ఒక చర్య లేదా వనరు ఎంచుకోండి.

త్వరగా జతచేయుటకు ఒక చర్య లేదా వనరు పేరు మీద డబుల్ క్లిక్ చేయండి.';
$string['selectnos'] = 'అన్నిటికీ ’వద్దు’ ను ఎంచుకోండి';
$string['selectperiod'] = 'అవధిని ఎంచుకోండి';
$string['senddetails'] = 'నా వివరాలను ఈమెయిలు ద్వారా పంపించు';
$string['separate'] = 'విడదీయి';
$string['separateandconnected'] = 'విడివిడి, అనుసంధాన జ్ఞానార్జన పద్ధతులు';
$string['separateandconnectedinfo'] = 'విడివిడిగా, కలివిడిగా  జ్ఞానార్జన చేసే సిద్ధాంతంపై ఆధారపడిన కొలమానం. మనం చూచే, వినే వాటిని గురించి తెలుసుకునే, మూల్యాంకనం చేసే రెండు పద్ధతులను ఈ సిద్ధాంతం వివరిస్తుంది.<ul><li><strong>విడివిడిగా నేర్చుకొనేవారు</strong> ఉద్వేగరహితంగా, ఎంత ఆబ్జెక్టివుగా ఉండేవీలుంటుందో అంత ఆబ్జెక్టివుగానూ ఉంటారు. ఇతరులతో చర్చించేటపుడు, తర్కాన్ని వాడి అవతలివారి వాదనలో రంధ్రాలను వెతుకుతూ, తమ వాదాన్ని సమర్ధించుకోజూస్తారు. </li> <li><strong>అనుసంధానిత నేర్చుకొనేవారు</strong> ఇతరుల పట్ల సున్నితంగా ఉంటారు. సహానుభూతితో అవతలివారి దృష్టికోణం నుంచి చూసి విషయాలను అర్థం చేసుకొనేందుకుగాను, వారి ఆలోచనలతో అనుసంధానమయ్యేందుకుగాను, వారి మాటలు వింటూ, సందేహాలు అడుగుతూ ఉంటారు. ఇతరులు జ్ఞానాన్ని పొందేందుకు దోహదపడిన అనుభవాలను పంచుకుని తామూ నేర్చుకొంటారు.</li></ul>';
$string['servererror'] = 'సర్వర్తో కమ్యూనికేట్ చేసే సమయంలో లోపం సంభవించింది';
$string['serverlocaltime'] = 'సర్వరు స్థానిక సమయం';
$string['setcategorytheme'] = 'వర్గపు థీమును సెట్ చెయ్యి';
$string['setpassword'] = 'పాస్వర్డ్ సెట్ చెయ్యండి';
$string['setpasswordinstructions'] = 'మీ క్రొత్త పాస్వర్డ్ ను నమోదు మరియు పునరావృతం చేయండి, అప్పుడు " సెట్ పాస్వర్డ్" ను క్లిక్ చెయ్యండి.  <br /> మీ క్రొత్త పాస్వర్డ్వ సేవ్  అవుతుంది, మరియు మీరు లాగిను అవుతారు.';
$string['settings'] = 'సెట్టింగులు';
$string['shortname'] = 'పొట్టిపేరు';
$string['shortnamecollisionwarning'] = '[*] = ఈ పొట్టిపేరు ఈ సరికే వేరే కోర్సుకు వాడకంలో ఉంది. ఆమోదం పొందాక దీన్ని మార్చాల్సి ఉంటుంది.';
$string['shortnamecourse'] = 'కోర్సు పొట్టిపేరు';
$string['shortnamecourse_help'] = 'కోర్సు పొట్టిపేరును నేవిగేషనులో చూపించబడుతుంది.  కోర్సుకు సంబంధించిన ఈ మెయిలు సందేశాల విషయంలోనూ ఇది చూపించబడుతుంది.';
$string['shortnametaken'] = 'పొట్టిపేరును వేరే కోర్సుకు వాడుతున్నారు ({$a})';
$string['shortnameuser'] = 'వాడుకరి పొట్టిపేరు';
$string['shortsitename'] = 'సైటు పొట్టిపేరు (ఉదా: ఒకే పదం)';
$string['show'] = 'చూపించు';
$string['showactions'] = 'చర్యలను చూపించు';
$string['showadvancededitor'] = 'ఉన్నత';
$string['showadvancedsettings'] = 'ఉన్నత సెట్టింగులను చూపించు';
$string['showall'] = 'అన్ని {$a} లనూ చూపించు';
$string['showallcourses'] = 'కోర్సులన్నిటినీ చూపించు';
$string['showallusers'] = 'వాడుకరులందరినీ చూపించు';
$string['showblockcourse'] = 'బ్లాకును కలిగి ఉన్న కోర్సుల జాబితా చూపించు';
$string['showcategory'] = 'చూపు {$a}';
$string['showcomments'] = 'వ్యాఖ్యలను చూపించు/దాచు';
$string['showcommentsnonjs'] = 'వ్యాఖ్యలు చూపు';
$string['showdescription'] = 'కోర్సు పేజీ లో ఉన్న వివరణని ప్రదర్శించండి';
$string['showdescription_help'] = 'ప్రారంభించబడి ఉంటే, పైన వివరణ కేవలం కార్యాచరణ లేదా రిసోర్స్ కు లింక్ క్రింద కోర్సు పేజీ ప్రదర్శించబడుతుంది.';
$string['showgrades'] = 'విద్యార్థులకు గ్రేడ్‍బుక్‍ను చూపించు';
$string['showgrades_help'] = 'కోర్సులోని చాలా పనులు గ్రేడులిచ్చేందుకు వీలు కల్పిస్తాయి. కోర్సు నిర్వహణ బ్లాకులోని గ్రేడులు లింకు ద్వారా, ఒక విద్యార్థి, కోర్సులో తన గ్రేడులన్నిటినీ  చూడగలుగుతారా అనేది ఈ సెట్టింగు నిర్ణయిస్తుంది.';
$string['showingacourses'] = 'అన్ని {$a} కోర్సులు చూపడము';
$string['showingxofycourses'] = 'కోర్సులు {$a->start} నుంచి {$a->end} యొక్క {$a->total} కోర్సులను చూపడము';
$string['showlistofcourses'] = 'కోర్సుల జాబితాను చూపిమ్చు';
$string['showmodulecourse'] = 'ఈ పని కలిగి ఉన్న కోర్సుల జాబితాను చూపించు: ';
$string['showonly'] = 'ఇవి మాత్రమే చూపించు:';
$string['showperpage'] = 'పేజీకి {$a} చూపించు';
$string['showrecent'] = 'ఇటీవలి పనులను చూపించు';
$string['showreports'] = 'పని నవేదికలను చూపించు';
$string['showreports_help'] = 'ప్రతీ పాల్గోలుదారు కోర్సులో చేసిన పనిని చూపించే పని నివేదికలుంటాయి. చర్చావేదికల్లో రాసిన టపాలు, సమర్పించిన ఎసైనుమెంట్లూ వంటివాటి జాబితాలతో పాటు, ఈ నివేదికల్లో ప్రవేశపు లాగ్‍లు కూడా ఉంటాయి. విద్యార్థి తన ప్రవర పేజీ ద్వారా తన పొఅని నివేదికలను చూసుకోగలుగుతారా లేదా అనేది ఈ సెట్టింగు నిర్ణయిస్తుంది.';
$string['showsettings'] = 'సెట్టింగులను చూపించు';
$string['showtheselogs'] = 'ఈ లాగ్‍లను చూపించు';
$string['showthishelpinlanguage'] = 'ఈ సహాయాన్ని ఈ భాఅషలో చూపించు: {$a}';
$string['since'] = 'ఇప్పటి నుండి:';
$string['sincelast'] = 'క్రితం లాగిన్ నుండి';
$string['site'] = 'సైటు';
$string['sitedefault'] = 'సైటు డిఫాల్టు';
$string['siteerrors'] = 'సైటు లోపాలు';
$string['sitefiles'] = 'సైటు దస్త్రాలు';
$string['sitefilesused'] = 'ఈ కోర్సులో వాడిన సైటు దస్త్రాలు ';
$string['sitehome'] = 'సైటు హోమ్';
$string['sitelegacyfiles'] = 'లెగసీ సైట్ ఫైళ్ళు';
$string['sitelogs'] = 'సైటు లాగ్‍లు';
$string['sitenews'] = 'సైటు వార్తలు';
$string['sitepages'] = 'సైటు పేజీలు';
$string['sitepartlist'] = 'పాల్గోలుదారుల జాబితా చూసేందుకు మీకు అనుమతి లేదు';
$string['sitepartlist0'] = 'సైటు పాల్గోలుదారుల జాబితా చూడాలంటే మీరు సైటు ఉపాధ్యాయుడై ఉండాలి';
$string['sitepartlist1'] = 'సైటు పాల్గోలుదారుల జాబితా చూడాలంటే మీరు ఉపాధ్యాయుడై ఉండాలి';
$string['sites'] = 'సైట్లు';
$string['sitesection'] = 'ఓ టాపిక్కి విభాగాన్ని చేర్చు';
$string['sitesettings'] = 'సైటు సెట్టింగులు';
$string['siteteachers'] = 'సైటు ఉపాధ్యాయులు';
$string['size'] = 'సైజు';
$string['sizeb'] = 'బైట్లు';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'తప్పించాం';
$string['skiptocategorylisting'] = 'వర్గం జాబితాలు దాటవేయు';
$string['skiptocoursedetails'] = 'వివరణాత్మక కోర్సు సమాచారం దాటవేయు';
$string['skiptocourselisting'] = 'కోర్సు జాబితాలు దాటవేయు';
$string['socialheadline'] = 'సామాజిక వేదిక - ఇట్టీవలి టాపిక్కులు';
$string['someallowguest'] = 'కొన్ని కోర్సులు అతిథులను అనుమతించే అవకాశం ఉంది';
$string['someerrorswerefound'] = 'కొంత సమాచారం కనబడతం లేదు, లేదా తప్పుగా ఉంది. వివరాల కోసం కింద చూడండి.';
$string['sort'] = 'క్రమీకరించు';
$string['sortby'] = 'ఇలా పేర్చు:';
$string['sortbyx'] = '{$a} ఆరోహణ వారీగా పేర్చు';
$string['sortbyxreverse'] = '{$a} అవరోహణ వారీగా పేర్చు';
$string['sorting'] = 'క్రమీకరించడం';
$string['sourcerole'] = 'మూలపు పాత్ర';
$string['specifyname'] = 'తప్పనిసరిగా మీరో పేరు ఇవ్వాలి';
$string['standard'] = 'ప్రామాణిక';
$string['starpending'] = '([*] = కోర్సు ఆమోదం కోసం వేచి ఉంది)';
$string['startdate'] = 'కోర్సు మొదలయ్యే తేదీ';
$string['startdate_help'] = 'వీక్లీ ఫార్మాట్ లో  కోర్సు మొదటి వారం ఎప్పుడు మొదలౌతుందో ఈ సెట్టింగు నిర్ణయిస్తుంది. కోర్సు పనుల లాగ్‍లు అందుబాటులోకి వచ్చే సమీప తేదీని కూడా ఇది నిర్ణయిస్తుంది.

మీరు కోర్సును రీసెట్ చేసి, ఈ తేదీని మార్చినట్లయితే, కోర్సులోని అన్ని తేదీలు కొత్త ప్రారంభ తేదీకి సంబంధించి మార్చబడతాయి.';
$string['startdatewithtaskenabled'] = 'కోర్సు అందుబాటులోకి వచ్చే తేదీ';
$string['startdatewithtaskenabled_help'] = 'కోర్సు విద్యార్థులకు కనిపించే తేదీ. ఈ తేదీకి ముందు, వారు కోర్సును యాక్సెస్ చేయలేరు.

వీక్లీ ఫార్మాట్ లో  కోర్సు కోసం మొదటి వారం ప్రారంభాన్ని కూడా ఈ తేదీయే నిర్ణయిస్తుంది మరియు కోర్సు కార్యకలాపాల లాగ్‌ల ప్రారంభ తేదీ. మీరు కోర్సును రీసెట్ చేసి, ఈ తేదీని మార్చినట్లయితే, కోర్సులోని అన్ని తేదీలు కొత్త ప్రారంభ తేదీకి సంబంధించి తరలించబడతాయి.';
$string['startingfrom'] = 'మొదలయ్యే తేదీ:';
$string['startsignup'] = 'కొత్త ఖాతాను సృష్టించు';
$string['state'] = 'రాష్ట్రం/ప్రాంతం';
$string['statistics'] = 'గణాంకాలు';
$string['statisticsgraph'] = 'గణాంకాల గ్రాఫు';
$string['stats'] = 'గణాంకాలు';
$string['statslogins'] = 'లాగిన్‍లు';
$string['statsmodedetailed'] = 'వివరమైన (వాడుకరి) దృశ్యం';
$string['statsmodegeneral'] = 'సాధారన దృశ్యం';
$string['statsnodata'] = 'ఆ కోర్సు, కాలావధుల జోడీలో డేటా ఏమీ లేదు';
$string['statsnodatauser'] = 'ఆ కోర్సు, వాడుకరి, కాలావధుల జోడీలో డేటా ఏమీ లేదు';
$string['statsoff'] = 'ప్రస్తుతం గణాంకాలు చేతనంగా లేవు';
$string['statsreads'] = 'వీక్షణలు';
$string['statsreport1'] = 'లాగిన్‍లు';
$string['statsreport10'] = 'వాడుకరి కార్యకలాపం';
$string['statsreport11'] = 'అత్యంత చురుకైన కోర్సులు';
$string['statsreport12'] = 'అత్యంత చురుకైన కోర్సులు (వెయిటెడ్)';
$string['statsreport13'] = 'అత్యంత పాల్గోలు కోర్సులు (ప్రవేశాలు)';
$string['statsreport14'] = 'అత్యథికంగా పాల్గొన్న కోర్సులు (టపాలు/వీక్షణలు)';
$string['statsreport2'] = 'వీక్షణలు (అన్ని పాత్రలు)';
$string['statsreport3'] = 'టపాలు (అన్ని పాత్రలు)';
$string['statsreport4'] = 'మొత్తం కార్యకలాపం (అన్ని పాత్రలు)';
$string['statsreport5'] = 'మొత్తం కార్యకలాపం (వీక్షణలు, టపాలు)';
$string['statsreport7'] = 'వాడుకరి కార్యకలాపం (వీక్షణలు, టపాలు)';
$string['statsreport8'] = 'వాడుకరులందరి వ్యాపకం';
$string['statsreport9'] = 'లాగిన్‍లు (సైటు కోర్సు)';
$string['statsreportactivity'] = 'మొత్తం కార్యకలాపం (అన్ని పాత్రలూ)';
$string['statsreportactivitybyrole'] = 'మొత్తం కార్యకలాపం (వీక్షణలు, టపాలు)';
$string['statsreportforuser'] = 'కొరకు';
$string['statsreportlogins'] = 'లాగిన్‍లు';
$string['statsreportreads'] = 'వీక్షణలు (అన్ని పాత్రలూ)';
$string['statsreporttype'] = 'నివేదిక రకం';
$string['statsreportwrites'] = 'టపాలు (అన్ని పాత్రలూ)';
$string['statsstudentactivity'] = 'విద్యార్థి కార్యకలాపం';
$string['statsstudentreads'] = 'విద్యార్థి వీక్షణలు';
$string['statsstudentwrites'] = 'విద్యార్థి టపాలు';
$string['statsteacheractivity'] = 'ఉపాధ్యాయుని కార్యకలాపం';
$string['statsteacherreads'] = 'ఉపాధ్యాయుని వీక్షణలు';
$string['statsteacherwrites'] = 'ఉపాధ్యాయుని టపాలు';
$string['statstimeperiod'] = 'కాలావధి - చివరి:';
$string['statsuniquelogins'] = 'ప్రత్యేక లాగిన్‍లు';
$string['statsuseractivity'] = 'మొత్తం కార్యకలాపం';
$string['statsuserlogins'] = 'లాగిన్‍లు';
$string['statsuserreads'] = 'వీక్షణలు';
$string['statsuserwrites'] = 'టపాలు';
$string['statswrites'] = 'టపాలు';
$string['status'] = 'స్థితి';
$string['statuscritical'] = 'క్లిష్టమైన';
$string['statuserror'] = 'లోపం';
$string['statusinfo'] = 'సమాచారం';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'ఏదో తెలియని';
$string['statuswarning'] = 'హెచ్చరిక';
$string['stringsnotset'] = 'కింది వాక్యాలు {$a} లో నిర్వచింపబడి లేవు';
$string['studentnotallowed'] = 'సారీ, మీరీ కోర్సులో \'{$a}\' లాగా ప్రవేశించలేరు';
$string['students'] = 'విద్యార్థులు';
$string['studentsandteachers'] = 'విద్యార్థులు, ఉపాధ్యాయులు';
$string['subcategories'] = 'ఉపవర్గాలు';
$string['subcategory'] = 'ఉపవర్గం';
$string['subcategoryof'] = '{$a} యొక్క ఉపవర్గం';
$string['subject'] = 'విషయం';
$string['submit'] = 'పంపించు';
$string['success'] = 'జయప్రదం';
$string['summary'] = 'సారాంశం';
$string['summary_help'] = 'సారాంశమేంటంటే, టాపిక్కులోగానీ, వారంలోగానీ, పనులకు విద్యార్థిని ఆయత్తపరచే చిన్న పాఠ్యం. కోర్సుపేజీలో, విభాగం పేరు కింద ఈ పాఠ్యాన్ని చూపిస్తాం.';
$string['summaryof'] = '{$a} యొక్క సారాంశం';
$string['supplyinfo'] = 'మరిన్ని వివరాలు';
$string['suspended'] = 'తాత్కాలికంగా తొలగించబడింది';
$string['suspendedusers'] = 'తాత్కాలికంగా తొలగించబడిన వినియోగదారులు';
$string['switchdevicedefault'] = 'స్టాండర్డ్ థీమ్ కు మారండి';
$string['switchdevicerecommended'] = 'మీ పరికరముకు సిఫార్సు చేసిన థీమ్ కు మారండి';
$string['switchrolereturn'] = 'తిరిగి నా మామూలు పాత్రకు ';
$string['switchroleto'] = 'పాత్రను మార్చు..';
$string['tag'] = 'ట్యాగు';
$string['tagalready'] = 'ఈ ట్యాగు ఈసరికే ఉంది';
$string['tagmanagement'] = 'ట్యాగులు చేర్చు/తొలగించు ...';
$string['tags'] = 'ట్యాగులు';
$string['targetrole'] = 'లక్ష్యం పాత్ర';
$string['teacheronly'] = '{$a} కోసం మాత్రమే';
$string['teacherroles'] = '{$a} పాత్రలు';
$string['teachers'] = 'ఉపాధ్యాయులు';
$string['textediting'] = 'టెక్స్ట్ ఎడిటర్';
$string['texteditor'] = 'ప్రామాణిక వెబ్ ఫారములను వాడు';
$string['textformat'] = 'ప్లెయిన్ టెక్స్టు ఆకృతి';
$string['thanks'] = 'నెనరులు';
$string['theme'] = 'థీము';
$string['themes'] = 'థీములు';
$string['themesaved'] = 'కొత్త థీమును భద్రపరచాం';
$string['therearecourses'] = '{$a} కోర్సులు ఉన్నాయి';
$string['thereareno'] = 'ఇ కోర్సులో కొత్త {$a} లేవు';
$string['thiscategory'] = 'ఈ వర్గం';
$string['thiscategorycontains'] = 'ఈ వర్గంలో ఇవి ఉన్నాయి:';
$string['time'] = 'సమయం';
$string['timecreatedcourse'] = 'కోర్సు యొక్క సమయాన్ని రూపొందించినవారు.';
$string['timezone'] = 'సమయమండలం';
$string['to'] = 'కు';
$string['tocontent'] = '"{$a}" అంశం కు';
$string['tocreatenewaccount'] = 'కొత్త ఖాతాను సృష్టించండి';
$string['today'] = 'ఈరోజు';
$string['todaylogs'] = 'ఇవ్వాళ్టి లాగ్‍లు';
$string['toeveryone'] = 'ప్రతీ ఒక్కరికీ';
$string['toomanybounces'] = 'ఆ ఈమెయిలు చిరునామా బోలెడన్ని సార్లు బౌన్సయింది. కొనసాగాలంటే దాన్ని <b>మార్చి తీరాలి</b>.';
$string['toomanytoshow'] = 'చూపించలేనంతమంది వాడుకరులున్నారు.';
$string['toomanyusersmatchsearch'] = '\'{$a->search}\' కు సరిపోలే వాడుకరులు చాలా మంది ఉన్నారు ({$a->count}) ';
$string['toomanyuserstoshow'] = 'చూపించడానికి చాలామంది వాడుకరులున్నారు ({$a}) ';
$string['toonly'] = '{$a} కు మాత్రమే';
$string['top'] = 'పైకి';
$string['topic'] = 'టాపిక్';
$string['topichide'] = 'ఈ టాపిక్కును {$a} కు కనబడకుండా దాచు';
$string['topicoutline'] = 'టాపిక్ స్థూలదృష్టి';
$string['topicshow'] = '{$a} కు ఈ టాపిక్కును చూపించు';
$string['toplevelcategory'] = 'ఉన్నత స్థాయి వర్గం';
$string['total'] = 'మొత్తం';
$string['totopofsection'] = '"{$a}" యొక్క ఉన్నత స్థాయి విభాగం';
$string['trackforums'] = 'చర్చావేదిక గమనింపు';
$string['trackforumsno'] = 'వద్దు: నేను చూసిన టపాల గమనిస్తూ ఉండొద్దు';
$string['trackforumsyes'] = 'సరే: నా కోసం కొత్త టపాలను హైలైటు చేసిపెట్టు';
$string['trysearching'] = 'లేకపోతే వెతికి చూడండి.';
$string['turneditingoff'] = 'ఎడిటింగును ఆఫ్ చెయ్యి';
$string['turneditingon'] = 'ఎడిటింగును ఆన్ చెయ్యి';
$string['undecided'] = 'నిర్ణయించుకోని';
$string['unfinished'] = 'అసంపూర్ణ';
$string['unknowncategory'] = 'తెలియని వర్గం';
$string['unknownerror'] = 'తెలియని తప్పు';
$string['unlimited'] = 'అపరిమిత';
$string['unpacking'] = '{$a} ను పొట్లాం నుంచి బయటికి తీస్తున్నాం ';
$string['unsafepassword'] = 'సంకేతపదం భద్రమైనది కాదు -మరోటి ప్రయత్నించండి';
$string['untilcomplete'] = 'పూర్తయ్యే వరకూ';
$string['unusedaccounts'] = '{$a} రోజుల కంటే ఎక్కువగా వాడకుండా ఉన్న ఖాతాలను ఆటోమాటిగ్గా కోర్సు నుంచి బైటికి పంపిస్తాం.';
$string['unzip'] = 'అన్‍జిప్పు చెయ్యి';
$string['unzippingbackup'] = 'బ్యాకప్పును అన్‍జిప్పు చేస్తున్నాం';
$string['up'] = 'పైకి';
$string['update'] = 'తాజాకరించు';
$string['updated'] = '{$a} ను తాజాకరించాం';
$string['updatemymoodleoff'] = 'ఈ పేజీని కస్టమైజు చెయ్యడం ఆపు';
$string['updatemymoodleon'] = 'ఈ పేజీని కస్టమైజు చెయ్యి';
$string['updatemyprofile'] = 'ప్రవరను తాజాకరించు';
$string['updatesevery'] = 'ప్రతీ {$a} సెక్ండ్లకోసారి తాజాకరిస్తుంది';
$string['updatethis'] = 'ఈ {$a} ను తాజాకరించు';
$string['updatethiscourse'] = 'ఈ కోర్సును తాజాకరించు';
$string['updatinga'] = 'తాజాకరిస్తున్నాం: {$a}';
$string['updatingain'] = '{$a->what} ను {$a->in} లో తాజాకరిస్తున్నాం';
$string['upload'] = 'ఎక్కించు';
$string['uploadafile'] = 'దస్త్రాన్ని ఎక్కించు';
$string['uploadcantwrite'] = 'దస్త్రాన్ని డిస్కుమీద రాయడం విఫలమైంది';
$string['uploadedfile'] = 'దస్త్రాన్ని జయప్రదంగా ఎక్కించాం';
$string['uploadedfileto'] = '{$a->file} ను  {$a->directory} లోకి ఎక్కించాం';
$string['uploadedfiletoobig'] = 'సారీ, ఆ దస్త్రం మరీ పెద్దది (పరిమితి {$a} బైట్లు)';
$string['uploadextension'] = 'PHP ఎక్స్టెన్షన్ వల్ల  ఫైల్ అప్‌లోడ్ ఆగిపోయింది';
$string['uploadfailednotrecovering'] = '{$a->name} అనే దస్త్రంతో ఉన్న ఇబ్బంది కారణంగా దస్త్రం ఎక్కింపు ఆగిపోయింది.<br /> ఇబ్బందుల లాగ్ ఇది:<br />{$a->problem}<br />రికవరు కావడం లేదు.';
$string['uploadfilelog'] = '{$a} దస్త్రం కోసం ఎక్కింపు లాగ్';
$string['uploadformlimit'] = 'అప్‌లోడ్ చేయబడిన ఫైల్ {$a} ఫారమ్ ద్వారా సెట్ చేయబడిన గరిష్ట పరిమాణ పరిమితిని మించిపోయింది';
$string['uploadlabel'] = 'శీర్షిక:';
$string['uploadlimitwithsize'] = '$ a-> contextname} అప్లోడ్ పరిమితి ({$ a-> displaysize})';
$string['uploadnewfile'] = 'కొత్త దస్త్రాన్ని ఎక్కించు';
$string['uploadnofilefound'] = 'దస్త్రమేదీ దొరకలేదు - అసలు మీరు ఎక్కించాల్సిన దస్త్రాన్ని ఎంచుకున్నారా?';
$string['uploadnotallowed'] = 'ఎక్కింపులకు అనుమతి లేదు';
$string['uploadnotempdir'] = 'ఓ తాత్కాలిక ఫోల్డరు మిస్సైంది';
$string['uploadoldfilesdeleted'] = 'మీ ఎక్కింపు స్థలంలోని పాత దస్త్రాలను తొలగించాం';
$string['uploadpartialfile'] = 'దస్త్రాన్ని పాక్షికంగానే ఎక్కించబడింది';
$string['uploadproblem'] = 'దస్త్రం \'{$a}\' ను ఎక్కిస్తూండగా ఏదో తెలీని సమస్య ఎదురైంది. (అది మరీ పెద్దది గానీ కాదు గదా?) ';
$string['uploadrenamedchars'] = 'తప్పుడు కారెక్టర్లుండటం చేత, దస్త్రం పేరును {$a->oldname} నుండి {$a->newname} కు మార్చాం.';
$string['uploadrenamedcollision'] = 'దస్త్రం పేరులో ఘర్షణ ఉండటం చేత, దస్త్రం పేరును {$a->oldname} నుండి {$a->newname} కు మార్చాం.';
$string['uploadserverlimit'] = 'ఎక్కించిన దస్త్రం, సర్వరు పెట్టిన గరిష్ఠ సైజు పరిమితిని దాటేసింది';
$string['uploadthisfile'] = 'ఈ దస్త్రాన్ని ఎక్కించు';
$string['url'] = 'URL';
$string['used'] = 'వాడినది';
$string['usedinnplaces'] = '{$a} స్థలాల్లో వాడబడింది';
$string['user'] = 'వాడుకరి';
$string['useractivity'] = 'పని';
$string['userconfirmed'] = '{$a} ధ్రువీకరించబడింది';
$string['userdata'] = 'వాడుకరి డేటా';
$string['userdeleted'] = 'ఈ వాడుకరి ఖాతా తొలగించబడింది';
$string['userdescription'] = 'వివరం';
$string['userdescription_help'] = 'ఈ పెట్టెలో మీగురించి కొంత రాసుకోవచ్చు. ఆనక అది మీ ప్రవర పేజీలో అందరూ చూసేలా కనిపిస్తుంది. ';
$string['userdetails'] = 'వాడుకరి వివరాలు';
$string['userfiles'] = 'వాడుకరి దస్త్రాలు';
$string['userlist'] = 'వాడుకరుల జాబితా';
$string['username'] = 'వాడుకరిపేరు';
$string['usernameemail'] = 'యూజర్ పేరు లేదా ఇమెయిల్';
$string['usernameemailmatch'] = 'ఈ వాడుకరిపేరు, సంకేతపదమూ ఒకే వాడుకరికి చెందినవి కావు';
$string['usernameexists'] = 'ఈ వాడుకరిపేరు ఈసరికే ఉంది, ఇంకోటి ఎంచుకోండి';
$string['usernamelowercase'] = 'ఇంగ్లీషు భాషలోని చిన్నబడి అక్షరాలు మాత్రమే వాడాలి';
$string['usernamenotfound'] = 'ఈ వాడుకరిపేరు డేటాబేసులో కనబడలేదు';
$string['usernameoremail'] = 'వాడుకరిపేరుగానీ, ఈమెయిలు చిరునామాగానీ ఇవ్వండి';
$string['usernotconfirmed'] = '{$a} ను నిర్ధారించలేకపోయాం';
$string['userpic'] = 'వాడుకరి బొమ్మ';
$string['users'] = 'వాడుకరులు';
$string['userselectorautoselectunique'] = 'వెతుకులాటలో ఒకేఒక్క వాడుకరి దొరికితే, ఆటోమాటిగ్గా వారిని ఎంచుకో';
$string['userselectorpreserveselected'] = 'ఎంచుకున్న వాడుకరులు, వెతుకులాటకు సంబంధం లేకపోయినా ఉంచేయి ';
$string['userselectorsearchanywhere'] = 'ఎక్కడైనా';
$string['usersnew'] = 'కొత్త వాడుకరులు';
$string['usersnoaccesssince'] = 'ఇంత కాలంగా సుప్తంగా ఉన్నరు: ';
$string['userswithfiles'] = 'దస్త్రాలు కలిగిన వాడుకరి';
$string['useruploadtype'] = 'వాడుకరి ఎక్కింపు రకం: {$a}';
$string['userzones'] = 'వాడుకరి జోన్లు';
$string['usetheme'] = 'థీమ్ ఉపయోగించండి';
$string['usingexistingcourse'] = 'ఈసరికే ఉన్న కోర్సును వాడుతున్నాం';
$string['valuealreadyused'] = 'ఈ విలువను ఈసరికే వాడాం.';
$string['version'] = 'వెర్షను';
$string['view'] = 'చూపించు';
$string['viewallcourses'] = 'కోర్సులన్నిటినీ చూపించు';
$string['viewallcoursescategories'] = 'అన్ని కోర్సులు, వర్గాలను చూపించు';
$string['viewallsubcategories'] = 'అన్ని ఉపవర్గాలుగా వీక్షించండి';
$string['viewfileinpopup'] = 'దస్త్రాన్ని పాపప్ విండోలో చూపించు';
$string['viewing'] = 'చూడటం';
$string['viewmore'] = 'ఎక్కువగా వీక్షించగలరు';
$string['viewprofile'] = 'ప్రవరను చూపించు';
$string['views'] = 'దర్శకాలు';
$string['viewsolution'] = 'పరిష్కారాన్ని చూపించు';
$string['visible'] = 'కనిపిస్తుంది';
$string['visible_help'] = 'ఏదైనా కోర్సు కోర్సుల జాబితాలో కనిపించాలా లేదా అనేది ఈ సెట్టింగు నిర్ణయిస్తుంది. ఉపాధ్యాయులు, నిర్వాహకులు తప్పించి, వాడుకరులకు కోర్సులోకి ప్రవేశము లేదు. ';
$string['visibletostudents'] = '{$a} కు కనిపిస్తుంది';
$string['warning'] = 'హెచ్చరిక';
$string['warningdeleteresource'] = 'హెచ్చరిక: {$a} ను ఒక వనరులో ఉదహరించారు. ఆ వనరను తాజాకరిస్తారా?';
$string['webpage'] = 'వెబ్ పేజీ';
$string['week'] = 'వారం';
$string['weekhide'] = '{$a} నుండి ఈ వారాన్ని దాచు';
$string['weeklyoutline'] = 'వారపు స్థూలదృష్టి';
$string['weeks'] = 'వారాలు';
$string['weekshow'] = 'ఈ వారాన్ని {$a} కు చూపించండి';
$string['welcometocourse'] = '{$a} కు స్వాగతం';
$string['welcometocoursetext'] = '{$a->coursename} కు స్వాగతం!

మీ ప్రవర పేజీని పూర్తి చేసి ఉండకపోతే, చెయ్యండి. మీ గురించి మరింత తెలుసుకోవడానికి వీలౌతుంది:

{$a->profileurl}';
$string['whatforlink'] = 'ఈ లింక్  ఏమి చేయాలి అని అనుకుంటున్నారు?';
$string['whatforpage'] = 'మీరు వచనం ను  ఏమి చేయాలి అని అనుకుంటున్నారు?';
$string['whatisyourage'] = 'మీ వయస్సు ఎంత?';
$string['whattocallzip'] = 'ఈ zip దస్త్రానికి పేరేం పెడతారు?';
$string['whattodo'] = 'ఏం చెయ్యాలి';
$string['wheredoyoulive'] = 'మీరు ఏ దేశస్తులు?';
$string['whyisthisrequired'] = 'ఇది ఎందుకు అవసరం?';
$string['windowclosing'] = 'ఈ విండో ఆటోమాటిగ్గా మూసుకుపోవాలి. అలా కాకపోతే, ఇప్పుడు మూసెయ్యండి.';
$string['withchosenfiles'] = 'ఎంచుకున్న దస్త్రాలతో';
$string['withdisablednote'] = '{$a} (నిలిపివేయబడింది)';
$string['withoutuserdata'] = 'వాడుకరి డేటా లేకుండా';
$string['withselectedusers'] = 'ఎంచుకున్న వాడుకరులతో...';
$string['withuserdata'] = 'వాడుకరి డేటాతో';
$string['wordforstudent'] = 'విద్యార్థి  కోసం మీ  సలహా';
$string['wordforstudenteg'] = 'ఉదాహరణకు విద్యార్థి, పార్టిసిపెంట్ మొదలైనవి';
$string['wordforstudents'] = 'విద్యార్థి  కోసం మీ  సలహా';
$string['wordforstudentseg'] = 'ఉదా: విద్యార్థులు, పాల్గోలుదార్లు వగైరా';
$string['wordforteacher'] = 'ఉపాధ్యాయుడు కు మీ పదం';
$string['wordforteachereg'] = 'ఉదా: ఉపాధ్యాయుడు, బోధకుడు, శిక్షకుడు వగైరా';
$string['wordforteachers'] = 'ఉపాధ్యాయులు కు మీ పదం';
$string['wordforteacherseg'] = 'ఉదా: ఉపాధ్యాయులు, బోధకులు, శిక్షకులు వగైరా';
$string['writingblogsinfo'] = 'బ్లాగుల సమాచారాన్ని రాస్తున్నాం';
$string['writingcategoriesandquestions'] = 'వర్గాలు, ప్రశ్నలను రాస్తున్నాం';
$string['writingcoursedata'] = 'కోర్సు డేటాను రాస్తున్నాం';
$string['writingeventsinfo'] = 'ఘటనల సమాచారాన్ని రాస్తున్నాం';
$string['writinggeneralinfo'] = 'సాధారణ సమాచారాన్ని రాస్తున్నాం';
$string['writinggradebookinfo'] = 'గ్రేడ్‍బుక్ సమాచారాన్ని రాస్తున్నాం';
$string['writinggroupingsgroupsinfo'] = 'గ్రూపింగు-గుంపుల సమాచారాన్ని రాస్తున్నాం';
$string['writinggroupingsinfo'] = 'గ్రూపింగుల సమాచారాన్ని రాస్తున్నాం';
$string['writinggroupsinfo'] = 'గుంపుల సమాచారాన్ని రాస్తున్నాం';
$string['writingheader'] = 'శీర్షాన్ని రాస్తున్నాం';
$string['writingloginfo'] = 'లాగ్‍ల సమాచారాన్ని రాస్తున్నాం';
$string['writingmessagesinfo'] = 'సందేశాల సమాచారాన్ని రాస్తున్నాం';
$string['writingmoduleinfo'] = 'మాడ్యూళ్ళ సమాచారాన్ని రాస్తున్నాం';
$string['writingscalesinfo'] = 'కొలమానాల సమాచారాన్ని రాస్తున్నాం';
$string['writinguserinfo'] = 'వాడుకరుల సమాచారాన్ని రాస్తున్నాం';
$string['wrongpassword'] = 'ఈ వాడుకరిపేరుకు సరిపోలని సంకేతపదం';
$string['year'] = 'సంవత్సరం';
$string['years'] = 'సంవత్సరాలు';
$string['yes'] = 'ఔను';
$string['youareabouttocreatezip'] = 'వీటితో కూడిన ఓ zip దస్త్రాన్ని తయారుచెయ్యబోతున్నారు:';
$string['youaregoingtorestorefrom'] = 'మీరు దీనికి రీస్టోరు ప్రాసెస్సును మొదలుపెట్టబోతున్నారు:';
$string['youneedtoenrol'] = 'ఆ పని చెయ్యాలంటే మీరు ఈ కోర్సులో ప్రవేశం పొందాలి';
$string['yourlastlogin'] = 'మీ గత లాగిన్ సమయం: ';
$string['yourself'] = 'స్వయంగా మీరే';
$string['yourteacher'] = 'మీ {$a}';
$string['yourwordforx'] = '\'{$a}\' కు మీ పదం';
$string['zippingbackup'] = 'బ్యాకప్పును జిప్పు చేస్తున్నాం';
