<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_o365', language 'te', version '4.3'.
 *
 * @package     local_o365
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acp_healthcheck'] = 'ఆరోగ్య పరీక్ష';
$string['acp_maintenance'] = 'నిర్వహణ ఉపకరణాలు';
$string['acp_maintenance_debugdata'] = 'డీబగ్ డేటా ప్యాకేజీని సృష్టించండి';
$string['acp_maintenance_debugdata_desc'] = 'ఇది మీరు కలిగి ఉన్న సమస్యలను పరిష్కరించడంలో డెవలపర్లకు సహాయపడటానికి మీ Moodle మరియు ఆఫీస్ 365 పర్యావరణం గురించి వివిధ సమాచారాన్ని కలిగి ఉన్న ప్యాకేజీని ఇది సృష్టిస్తుంది. ఒక డెవలపర్ అభ్యర్థించినట్లయితే, ఈ ఉపకరణాన్ని అమలు చేసి, ఫలిత ఫైల్ను డౌన్లోడ్ చేయండి. గమనిక: ఈ ప్యాకేజీ సున్నితమైన టోకెన్ డేటాను కలిగి లేనప్పటికీ, మీరు ఈ ఫైల్ను పబ్లిక్గా పోస్ట్ చేయరాదని లేదా అవిశ్వాస పార్టీకి పంపించమనకూడదని మేము కోరుతున్నాము.';
$string['acp_maintenance_desc'] = 'ఈ సాధనాలు కొన్ని సాధారణ సమస్యలను పరిష్కరించడానికి మీకు సహాయపడతాయి.';
$string['acp_maintenance_warning'] = 'హెచ్చరిక: ఇవి ఆధునిక ఉపకరణాలు. దయచేసి మీరు ఏమి చేస్తున్నారో అర్థం చేసుకుంటే మాత్రమే వాటిని వాడండి.';
$string['acp_parentsite_desc'] = 'షేర్డ్ Moodle కోర్సు డేటా కోసం సైట్.';
$string['acp_parentsite_name'] = 'Moodle';
$string['acp_tenants_actions'] = 'చర్యలు';
$string['acp_tenants_add'] = 'కొత్త  టెనంట్ జోడించండి';
$string['acp_tenants_errornotsetup'] = 'దయచేసి అదనపు అద్దెదారులను జోడించే ముందుగా ప్లగిన్ సెటప్ ప్రాసెస్ని పూర్తి చేయండి.';
$string['acp_tenants_hosttenant'] = 'హోస్ట్ టెనంట్: {$a}';
$string['acp_tenants_intro'] = '<b> మల్టిటేన్సీసీ వర్క్స్: </ b> <br /> బహుళ ఆఫీసు 365 అద్దెదారులు మీ Moodle సైట్ను యాక్సెస్ చేయడానికి అనుమతిస్తుంది. <br /> <br />
    ఎలా ఏర్పాటు చేసుకోవాలో ఇక్కడ ఉంది:
    <Ol>
        <li> OpenID Connect ప్రామాణీకరణ ప్లగ్ఇన్ ఉపయోగించని నిర్వాహకుడిగా Moodle కు లాగిన్ అవ్వండి. </ li>
        <li> Moodle లో OpenID Connect ప్రామాణీకరణ ప్లగ్ఇన్ ను ఆపివేయి. (<a href="{$a}/admin/settings.php?section=manageauths"> ప్రామాణీకరణ ప్లగిన్ల నిర్వహణ పేజీ </a> ను ఉపయోగించండి.) </ Li>
        <li> Azure AD కు నావిగేట్ చేయండి మరియు మీరు Moodle కోసం కాన్ఫిగర్ చేసిన అనువర్తనాన్ని కనుగొనండి. </ li>
        <li> అజూర్ AD అనువర్తనంలో మల్టీటెన్సిన్ను ఎనేబుల్ చేసి మార్పులు సేవ్ చేసుకోండి. </ li>
        <li> మీరు అద్దెకు తీసుకునే ప్రతి కస్టమర్కు, "న్యూ టెనాంట్ను జోడించు" క్లిక్ చేసి, మీరు ఎనేబుల్ చేయాలనుకున్న అద్దెదారు నుండి నిర్వాహకుని ఖాతాతో లాగిన్ అవ్వండి. </ li>
        <li> మీకు కావలసిన అన్ని అద్దెదారులను మీరు జోడించిన తర్వాత, Moodle లో OpenID Connect ప్రామాణీకరణ ప్లగ్ఇన్ను పునఃప్రారంభించండి. </ li>
        <li> మీరు పూర్తి చేసారు! భవిష్యత్తులో అదనపు అద్దెదారులను చేర్చడానికి, "న్యూ టెన్టెంట్ను జోడించు" బటన్ను క్లిక్ చేసి ఆ అద్దెదారు నుండి నిర్వాహకుని ఖాతాతో లాగిన్ అవ్వండి. </ Li>
    </ Ol>
    <b> ముఖ్యమైన గమనిక: </ b> అజూర్ AD మల్టీటెన్సిన్ను అన్ని కార్యాలయ 365 అద్దెదారులు మీ అప్లికేషన్ను ఆక్సెస్ చెయ్యడానికి అనుమతించేటప్పుడు అనుమతిస్తుంది. ఇక్కడ అద్దెదారులను జోడించడం వలన మీరు ఆకృతీకరించిన అద్దెదారులకు Moodle యాక్సెస్ను పరిమితం చేయగలుగుతారు. <b> అజూర్ AD లో మల్టీటేన్సీన్ను నిలిపివేయడానికి ముందు ఈ జాబితా నుండి అన్ని అద్దెదారులను తీసివేస్తే లేదా Moodle లో OpenID కనెక్ట్ ప్రామాణీకరణను ఎనేబుల్ చేస్తే, మీ Moodle సైట్ అన్ని Office 365 అద్దెదారులకు అందుబాటులో ఉంటుంది. </ b>';
$string['acp_tenants_none'] = 'మీరు ఏ అద్దెదారులను కాన్ఫిగర్ చేయలేదు. మీరు అజూర్ AD లో మల్టీటేన్సీన్ని ప్రారంభించి ఉంటే, మీరు Office 365 వినియోగదారులకు Moodle సైట్ ఓపెన్ కావచ్చు.';
$string['acp_tenants_revokeaccess'] = 'ప్రాప్యతను ఉపసంహరించు';
$string['acp_tenants_tenant'] = 'అద్దెదారు';
$string['acp_tenants_title'] = 'పలుస్వాధీనాలు';
$string['acp_tenants_title_desc'] = 'Office 365 నుండి Moodle కు బహుళస్థాయి యాక్సెస్ను సెటప్ చేయడానికి ఈ పేజీ మీకు సహాయపడుతుంది.';
$string['acp_tenantsadd_desc'] = 'అదనపు కౌలుదారుకు యాక్సెస్ మంజూరు చేయడానికి, దిగువ బటన్ను క్లిక్ చేసి, క్రొత్త అద్దెదారు యొక్క నిర్వాహకుని ఖాతాను ఉపయోగించి Office 365 కు లాగిన్ చేయండి. కొత్త కౌలుదారు జాబితా చేయబడిన అదనపు అద్దెదారుల జాబితాకు మీరు తిరిగి వస్తారు. మీరు అప్పుడు కొత్త అద్దెదారుతో Moodle ఉపయోగించగలుగుతారు.';
$string['acp_tenantsadd_linktext'] = 'Office 365 లాగిన్ పేజీకి వెళ్లండి';
$string['acp_userconnections'] = 'వినియోగదారు కనెక్షన్లు';
$string['acp_userconnections_column_actions'] = 'చర్యలు';
$string['acp_userconnections_column_muser'] = 'Moodle వినియోగదారు';
$string['acp_userconnections_column_o365user'] = 'ఆఫీస్ 365 వాడుకరి';
$string['acp_userconnections_column_status'] = 'కనెక్షన్ స్థితి';
$string['acp_userconnections_column_usinglogin'] = 'లాగిన్ ఉపయోగించి';
$string['acp_userconnections_filtering_muserfullname'] = 'Moodle వినియోగదారు పూర్తి పేరు';
$string['acp_userconnections_filtering_musername'] = 'Moodle వినియోగదారు పేరు';
$string['acp_userconnections_filtering_o365username'] = 'ఆఫీస్ 365 వినియోగదారు పేరు';
$string['acp_userconnections_manualmatch_details'] = 'ఒకే పేజీ 365 వినియోగదారుతో ఒకే Moodle యూజర్తో సరిపోలడానికి ఈ పేజీ మిమ్మల్ని అనుమతిస్తుంది.';
$string['acp_userconnections_manualmatch_error_muserconnected'] = 'Moodle వినియోగదారు ఇప్పటికే ఒక Office 365 వినియోగదారుకు కనెక్ట్ చేయబడ్డారు';
$string['acp_userconnections_manualmatch_error_muserconnected2'] = 'Moodle వినియోగదారు ఇప్పటికే ఒక Office 365 యూజర్ (2)';
$string['acp_userconnections_manualmatch_error_musermatched'] = 'Moodle వినియోగదారు ఇప్పటికే Office 365 వినియోగదారుకు సరిపోలడం జరిగింది';
$string['acp_userconnections_manualmatch_error_o365userconnected'] = 'ఆఫీస్ 365 యూజర్ ఇప్పటికే మరొక Moodle వినియోగదారుకు అనుసంధానించబడి ఉంది';
$string['acp_userconnections_manualmatch_error_o365usermatched'] = 'ఆఫీస్ 365 యూజర్ ఇప్పటికే మరొక Moodle వినియోగదారుకు సరిపోతుంది';
$string['acp_userconnections_manualmatch_musername'] = 'Moodle వినియోగదారు';
$string['acp_userconnections_manualmatch_o365username'] = 'ఆఫీస్ 365 వినియోగదారు పేరు';
$string['acp_userconnections_manualmatch_title'] = 'మాన్యువల్ యూజర్ మ్యాచ్';
$string['acp_userconnections_manualmatch_uselogin'] = 'ఆఫీసు 365 తో లాగిన్ అవ్వండి';
$string['acp_userconnections_table_connected'] = 'కనెక్ట్';
$string['acp_userconnections_table_disconnect'] = 'డిస్కనెక్ట్';
$string['acp_userconnections_table_disconnect_confirmmsg'] = 'ఇది Office 365 నుండి Moodle వినియోగదారు "{$a}" ను డిస్కనెక్ట్ చేస్తుంది. కొనసాగించడానికి క్రింది లింక్ను క్లిక్ చేయండి.';
$string['acp_userconnections_table_match'] = 'మ్యాచ్';
$string['acp_userconnections_table_matched'] = 'ఇప్పటికే ఉన్న వినియోగదారుతో సరిపోలడం. <br /> పూర్తయ్యే కోసం వేచి ఉంది.';
$string['acp_userconnections_table_noconnection'] = 'కనెక్షన్ లేదు';
$string['acp_userconnections_table_synced'] = 'Azure AD నుండి సమకాలీకరించబడింది. <br /> ప్రారంభ లాగిన్ కోసం వేచి ఉంది.';
$string['acp_userconnections_table_unmatch'] = 'Unmatch';
$string['acp_userconnections_table_unmatch_confirmmsg'] = 'ఇది ఆఫీసు 365 నుండి Moodle వినియోగదారు "{$a}" ను అన్మ్యాచ్ చేస్తుంది. కొనసాగించడానికి క్రింది లింక్ను క్లిక్ చేయండి';
$string['acp_usermatch'] = 'వినియోగదారు సరిపోలిక';
$string['acp_usermatch_desc'] = 'ఈ సాధనం మీరు Moodle వినియోగదారులను Office 365 వినియోగదారులకు సరిపోల్చడానికి అనుమతిస్తుంది. మీరు Moodle వినియోగదారులను మరియు సంబంధిత Office 365 వినియోగదారులను కలిగి ఉన్న ఒక ఫైల్ను అప్లోడ్ చేస్తారు మరియు ఒక క్రాన్ పని డేటాను ధృవీకరిస్తుంది మరియు మ్యాచ్ను సెటప్ చేస్తుంది';
$string['acp_usermatch_matchqueue'] = 'దశ 2: మ్యాచ్ క్యూ';
$string['acp_usermatch_matchqueue_clearall'] = 'అన్నింటినీ క్లియర్ చేయండి';
$string['acp_usermatch_matchqueue_clearerrors'] = 'క్లియర్ లోపాలు';
$string['acp_usermatch_matchqueue_clearqueued'] = 'క్లియర్ చేయి క్లియర్ చేయబడింది';
$string['acp_usermatch_matchqueue_clearsuccess'] = 'క్లియర్ విజయవంతమైనది';
$string['acp_usermatch_matchqueue_column_muser'] = 'Moodle యూజర్పేరు';
$string['acp_usermatch_matchqueue_column_o365user'] = 'ఆఫీస్ 365 యూజర్పేరు';
$string['acp_usermatch_matchqueue_column_openidconnect'] = 'OpenID కనెక్ట్';
$string['acp_usermatch_matchqueue_column_status'] = 'స్థితి';
$string['acp_usermatch_matchqueue_desc'] = 'ఈ పట్టిక మ్యాచ్ ఆపరేషన్ యొక్క ప్రస్తుత స్థితిని చూపుతుంది. </ P> గమనిక: </ b> ఈ పేజీ డైనమిక్గా నవీకరించబడదు, ప్రస్తుత స్థితిని వీక్షించడానికి ఈ పేజీని రిఫ్రెష్ చేయండి.';
$string['acp_usermatch_matchqueue_empty'] = 'మ్యాచ్ క్యూ ప్రస్తుతం ఖాళీగా ఉంది. క్యూకు వినియోగదారులను జోడించడానికి ఎగువ ఫైల్ పిక్కర్ ఉపయోగించి డేటా ఫైల్ను అప్లోడ్ చేయండి';
$string['acp_usermatch_matchqueue_status_error'] = 'లోపం: {$a}';
$string['acp_usermatch_matchqueue_status_queued'] = 'క్యూలో';
$string['acp_usermatch_matchqueue_status_success'] = 'విజయవంతమైన';
$string['acp_usermatch_upload'] = 'దశ 1: క్రొత్త మ్యాచ్లను అప్లోడ్ చేయండి';
$string['acp_usermatch_upload_desc'] = '<br /> <br /> ఈ ఫైల్ ప్రతి పంక్తికి మూడు అంశాలను కలిగి ఉన్న సాధారణ సాదా-టెక్స్ట్ CSV ఫైల్ అయి ఉండాలి: Moodle యూజర్ పేరు, ఆఫీస్ 365 వినియోగదారు పేరు మరియు 1 లేదా 0 OpenID కనెక్ట్ లేదా ఒక అనుసంధాన ఖాతాకు వాడుకదారుల authenticaton పద్ధతి మార్చడానికి. ఏ శీర్షికలు లేదా అదనపు డేటాను చేర్చవద్దు. <br /> ఉదాహరణకు: <pre> moodleuser1, bob.smith@example.onmicrosoft.com, 1 <br /> moodleuser2, john.doe@example.onmicrosoft.com , 0 </ pre>';
$string['acp_usermatch_upload_err_badmime'] = '{$a} రకంకి మద్దతు లేదు. దయచేసి సాదా-టెక్స్ట్ CSV ని అప్లోడ్ చేయండి.';
$string['acp_usermatch_upload_err_data'] = 'లైన్ # {$a} చెల్లని డేటాను కలిగి ఉంది. CSV ఫైల్లోని ప్రతి పంక్తికి రెండు అంశాలను కలిగి ఉండాలి: Moodle వినియోగదారు పేరు మరియు Office 365 వినియోగదారు పేరు.';
$string['acp_usermatch_upload_err_fileopen'] = 'ప్రాసెస్ కోసం ఫైల్ను తెరవడం సాధ్యం కాలేదు. మీ Moodledata డైరెక్టరీలో అనుమతులు సరిగ్గా ఉన్నాయా?';
$string['acp_usermatch_upload_err_nofile'] = 'క్యూకి జోడించడానికి ఏ ఫైల్ స్వీకరించబడలేదు.';
$string['acp_usermatch_upload_submit'] = 'క్యూ సరిపోల్చడానికి డేటా ఫైల్ను జోడించండి';
$string['cachedef_groups'] = 'Office 365 గ్రూప్ డేటా ను నిల్వ చేస్తుంది.';
$string['calendar_event'] = 'వివరాలను వీక్షించండి';
$string['calendar_setting'] = 'Outlook క్యాలెండర్ సమకాలీకరణను ప్రారంభించండి';
$string['calendar_site'] = 'సైట్ వైడ్  క్యాలెండర్';
$string['calendar_user'] = 'వ్యక్తిగత (వినియోగదారుడి) క్యాలెండర్';
$string['erroracpauthoidcnotconfig'] = 'దయచేసి ముందుగా auth_oidc లో అనువర్తన ఆధారాలను సెట్ చేయండి.';
$string['erroracpcantgettenant'] = 'OneDrive URL ను పొందడం సాధ్యం కాలేదు, దయచేసి మాన్యువల్ గా నమోదు చేయండి.';
$string['erroracplocalo365notconfig'] = 'దయచేసి మొదట local_o365 ను కాన్ఫిగర్ చేయండి.';
$string['errorcouldnotrefreshtoken'] = 'టోకెన్ రిఫ్రెష్ చేయలేకపోయింది';
$string['errorhttpclientbadtempfileloc'] = 'ఫైల్ను నిల్వ చేయడానికి తాత్కాలిక స్థానాన్ని తెరవలేకపోయాము.';
$string['errorhttpclientnofileinput'] = 'httpclient::put లో ఎటువంటి ఫైల్ పారామీటర్ లేదు';
$string['erroro365apibadcall'] = 'API కాల్లో లోపం.';
$string['erroro365apibadcall_message'] = 'API కాల్లో లోపం: {$a}';
$string['erroro365apibadpermission'] = 'అనుమతి కనుగొనబడలేదు';
$string['erroro365apicouldnotcreatesite'] = 'సైట్ సృష్టించడం లో సమస్య.';
$string['erroro365apicoursenotfound'] = 'కోర్సు కనుగొనబడలేదు.';
$string['erroro365apiinvalidmethod'] = 'చెల్లని httpmethod apicall కు పంపించబడింది';
$string['erroro365apiinvalidtoken'] = 'చెల్లని లేదా గడువు ముగిసిన టోకెన్.';
$string['erroro365apinoparentinfo'] = 'పేరెంట్ ఫోల్డర్ సమాచారాన్ని కనుగొనలేకపోయాము';
$string['erroro365apinotimplemented'] = 'ఇది భర్తీ చేయాలి.';
$string['erroro365apinotoken'] = 'ఇవ్వబడిన వనరు మరియు వాడుకరికి టోకెన్ను కలిగి ఉండకపోయినా, ఒకటి పొందలేకపోయినా. యూజర్ రిఫ్రెష్ టోకెన్ గడువు ముగిసినదా?';
$string['erroro365apisiteexistsnolocal'] = 'సైట్ ఇప్పటికీ, స్థానిక రికార్డ్ను కనుగొనలేకపోయింది.';
$string['errorusermatched'] = 'Office 365 అకౌంట్ "{$a->aadupn}" ఇప్పటికే Moodle వినియోగదారుతో "{$a->username}" తో సరిపోతుంది. కనెక్షన్ను పూర్తి చేయడానికి, దయచేసి మొదట Moodle యూజర్గా లాగిన్ అవ్వండి మరియు Microsoft బ్లాక్లోని సూచనలను అనుసరించండి';
$string['eventapifail'] = 'API వైఫల్యం';
$string['eventcalendarsubscribed'] = 'క్యాలెండర్కు సభ్యత్వాన్ని పొందారు';
$string['eventcalendarunsubscribed'] = 'క్యాలెండర్ నుండి సభ్యత్వాన్ని తొలగించారు';
$string['healthcheck_fixlink'] = 'దాన్ని పరిష్కరించడానికి ఇక్కడ క్లిక్ చేయండి.';
$string['healthcheck_ratelimit_result_disabled'] = 'రేట్ పరిమితి లక్షణాలు నిలిపివేయబడ్డాయి.';
$string['healthcheck_ratelimit_result_notice'] = 'పెరిగిన Moodle సైట్ లోడ్ని నిర్వహించడానికి స్వల్ప థ్రొలింగ్ ప్రారంభించబడింది. <br /> <br /> అన్ని Office 365 ఫీచర్లు ఫంక్షనల్గా ఉన్నాయి, ఆఫీసు 365 సేవల అంతరాయాన్ని నివారించడానికి ఇది కొద్దిగా అభ్యర్థనలను చేస్తుంది. ఒకసారి Moodle చర్య తగ్గుతుంది, ప్రతిదీ సాధారణ స్థితికి చేరుతుంది. <br /> (స్థాయి {$a->level} / {$a->timestart} ప్రారంభించబడింది)';
$string['healthcheck_ratelimit_result_passed'] = 'ఆఫీస్ 365 API కాల్స్ పూర్తి వేగంతో అమలు చేస్తున్నాయి.';
$string['healthcheck_ratelimit_result_warning'] = 'గణనీయమైన Moodle సైట్ లోడ్ను నిర్వహించడానికి పెరిగిన థొరొలింగ్ ప్రారంభించబడింది. <br /> అన్ని ఆఫీసు 365 లక్షణాలు ఇప్పటికీ పనిచేస్తున్నాయి, అయితే Office 365 అభ్యర్ధనలు పూర్తి కావడానికి ఎక్కువ సమయం పట్టవచ్చు. Moodle సైట్ కార్యాచరణ తగ్గిపోయిన తర్వాత, ప్రతిదీ సాధారణ స్థితికి చేరుతుంది. <br /> (స్థాయి {$a-> level} / {$a->timestart} ప్రారంభించబడింది)';
$string['healthcheck_ratelimit_title'] = 'API థ్రొట్టింగ్';
$string['help_user_appassign'] = 'దరఖాస్తు సహాయం వినియోగదారులకు అప్పగించండి';
$string['help_user_appassign_help'] = 'ఇది అప్పటికే కేటాయించబడకపోతే, ఈ Moodle ఇన్స్టలేషన్ కోసం సృష్టించబడిన Azure అప్లికేషన్కు కేటాయించాల్సిన Moodle ఖాతాలతో సరిపోలే అన్ని Azure AD ఖాతాలకు కారణం అవుతుంది.';
$string['help_user_create'] = 'ఖాతాల సహాయం సృష్టించండి';
$string['help_user_create_help'] = 'ఇది లింక్డ్ Azure యాక్టివ్ డైరెక్టరీలో ప్రతి వినియోగదారు నుండి Moodle లో వినియోగదారులను సృష్టిస్తుంది. ప్రస్తుతం Moodle ఖాతాలను కలిగి లేని వినియోగదారులు మాత్రమే ఖాతాలను సృష్టించగలరు. కొత్త ఖాతాలను వారి Office 365 ఆధారాలను Moodle కు లాగిన్ చేయండి (OpenID Connect ప్రామాణీకరణ ప్లగ్ఇన్ ఉపయోగించి) మరియు అన్ని Office 365 / Moodle ఇంటిగ్రేషన్ లక్షణాలను ఉపయోగించగలదు.';
$string['help_user_delete'] = 'ఖాతాల సహాయం తొలగించు';
$string['help_user_delete_help'] = 'Azure ఆక్టివ్ డైరెక్టరీలో తొలగించబడినట్లుగా మార్క్ చేసినట్లయితే ఇది Moodle నుండి వాడుకరులను తొలగిస్తుంది. Moodle ఖాతా తొలగించబడుతుంది మరియు అన్ని సంబంధిత యూజర్ సమాచారం Moodle నుండి తీసివేయబడుతుంది. జాగ్రత్త!';
$string['help_user_match'] = 'సంబంధిత ఖాతాల సహాయం';
$string['help_user_match_help'] = 'ఇది లింక్డ్ Azure యాక్టివ్ డైరెక్టరీలో ప్రతి వినియోగదారుని చూస్తుంది మరియు Moodle లో యూజర్తో వాటిని సరిదిద్దడానికి ప్రయత్నించండి. ఈ మ్యాచ్ Azure AD మరియు Moodle లో యూజర్ పేర్ల ఆధారంగా ఉంది. మ్యాచ్లు కేస్-ఇన్సంటెటివ్గా ఉంటాయి మరియు Office 365 కౌలుదారుని విస్మరిస్తాయి. ఉదాహరణకు, Moodle లో "BoB.SmiTh" "bob.smith@example.onmicrosoft.com" కు సరిపోతుంది. సరిపోలిన వినియోగదారులు వారి Moodle మరియు ఆఫీస్ ఖాతాలను కనెక్ట్ చేస్తారు మరియు అన్ని Office 365 / Moodle ఇంటిగ్రేషన్ లక్షణాలను ఉపయోగించగలరు. దిగువ సెట్టింగ్ ప్రారంభించబడితే తప్ప వినియోగదారు ప్రమాణీకరణ పద్ధతి మారదు.';
$string['help_user_matchswitchauth'] = 'సరిపోలిన ఖాతాల సహాయం మారండి';
$string['help_user_matchswitchauth_help'] = 'దీనికి ఎనేబుల్ చెయ్యడానికి పైన అమర్చిన "మ్యాచ్ పూర్వపు Moodle వినియోగదారులకు" అవసరం. ఒక వినియోగదారు సరిపోలినప్పుడు, ఈ సెట్టింగ్ను ప్రారంభించడం వలన వారి ప్రమాణీకరణ పద్ధతి ఓపెన్ ID కనెక్ట్కు మారుతుంది. అప్పుడు వారు వారి ఆఫీసు 365 ఆధారాలతో Moodle కు లాగిన్ చేయగలరు. గమనిక: మీరు ఈ సెట్టింగ్ను ఉపయోగించాలనుకుంటే OpenID Connect ప్రామాణీకరణ ప్లగ్ఇన్ ప్రారంభించబడిందని నిర్ధారించుకోండి.';
$string['help_user_photosync'] = 'సమకాలీకరణ 365 ప్రొఫైల్ ఫోటోలు (క్రాన్) సహాయం';
$string['help_user_photosync_help'] = 'ఇది అన్ని వినియోగదారుల యొక్క Moodle ప్రొఫైల్ ఫోటోలను వారి Office 365 ప్రొఫైల్ ఫోటోలతో సమకాలీకరించడానికి కారణం అవుతుంది.';
$string['help_user_photosynconlogin'] = 'సమకాలీకరణ Office 365 ప్రొఫైల్ ఫోటోలు (లాగిన్) సహాయం';
$string['help_user_photosynconlogin_help'] = 'ఇది వినియోగదారు యొక్క లాగ్ ఇన్ చేసినప్పుడు వారి Office 365 ప్రొఫైల్ ఫోటోతో సమకాలీకరించడానికి వినియోగదారు యొక్క Moodle ప్రొఫైల్ ఫోటోకి కారణం అవుతుంది.';
$string['o365:manageconnectionlink'] = 'కనెక్షన్ లింక్ని నిర్వహించండి';
$string['o365:manageconnectionunlink'] = 'కనెక్షన్ అన్లింక్ని నిర్వహించండి';
$string['o365:managegroups'] = 'సమూహాలను నిర్వహించండి';
$string['o365:viewgroups'] = 'సమూహాలను వీక్షించండి';
$string['personal_calendar'] = 'వ్యక్తిగత';
$string['pluginname'] = 'మైక్రోసాఫ్ట్ ఆఫీస్ 365 ఇంటిగ్రేషన్';
$string['settings_o365china'] = 'ఆఫీస్ & nbsp; 365 ఫర్ చైనా';
$string['settings_o365china_details'] = 'మీరు చైనా ఫర్ ఆఫీస్ & nbsp; 365 ను ఉపయోగిస్తుంటే దీన్ని తనిఖీ చేయండి.';
$string['settings_odburl'] = 'వ్యాపారం URL కోసం OneDrive';
$string['settings_odburl_details'] = 'వ్యాపారం కోసం OneDrive ను ప్రాప్యత చేయడానికి ఉపయోగించిన URL. ఇది మీ అజూర్ AD అద్దెదారు ద్వారా సాధారణంగా నిర్ణయించబడుతుంది. ఉదాహరణకు, మీ Azure AD అద్దెదారు "contoso.onmicrosoft.com" అయితే, ఇది ఎక్కువగా "contoso-my.sharepoint.com". డొమైన్ పేరుని మాత్రమే నమోదు చేయండి, http: // లేదా https: // ను చేర్చవద్దు';
$string['settings_odburl_error'] = 'వ్యాపారం కోసం మీ OneDrive ను మేము గుర్తించలేకపోయాము. <br /> దయచేసి "ఆఫీస్ 365 షేర్పాయింట్ ఆన్లైన్" మీ రిజిస్టర్డ్ అప్లికేషన్కు Azure AD లో చేర్చబడిందో లేదో నిర్ధారించుకోండి.';
$string['settings_odburl_error_graph'] = 'మేము వ్యాపారం కోసం మీ OneDrive ను గుర్తించలేకపోయాము, దయచేసి మానవీయంగా నమోదు చేయండి. ఇది సాధారణంగా మీరు OneDrive ను ప్రాప్యత చేయడానికి ఉపయోగించే URL ను ఉపయోగించడం ద్వారా నిర్ణయించబడుతుంది.';
$string['settings_options_usersync'] = 'వినియోగదారు సమకాలీకరణ';
$string['settings_options_usersync_desc'] = 'క్రింది సెట్టింగ్లు Office 365 మరియు Moodle మధ్య వినియోగదారు సమకాలీకరణను నియంత్రిస్తాయి.';
$string['settings_photoexpire'] = 'ప్రొఫైల్ ఫోటో రిఫ్రెష్ సమయం';
$string['settings_photoexpire_details'] = 'ప్రొఫైల్ ఫోటోలు రిఫ్రెష్ ముందు వేచి గంటల సంఖ్య. ఎక్కువ సమయం పనితీరును పెంచుతుంది.';
$string['settings_sds_coursecreation'] = 'కోర్సు సృష్టి';
$string['settings_sds_coursecreation_desc'] = 'SDS లో సమాచారం ఆధారంగా  మూడుల్ లో  కోర్సు  రూపొందించడం ఈ ఎంపికలను    ఎంపికలు నియంత్రిస్తాయి.';
$string['settings_sds_coursecreation_enabled'] = 'కోర్సులు సృష్టించండి';
$string['settings_sds_coursecreation_enabled_desc'] = 'ఈ పాఠశాలలకు కోర్సులను సృష్టించండి.';
$string['settings_sds_enrolment_enabled'] = 'వినియోగదారులను నమోదు చేయండి';
$string['settings_sds_enrolment_enabled_desc'] = 'ఎస్.డి.ఎస్ నుండి సృష్టించబడిన కోర్సులు లోకి విద్యార్థులను మరియు ఉపాధ్యాయులను నమోదుచేయండి.';
$string['settings_sds_intro_desc'] = 'పాఠశాల డేటా సమకాలీకరణ ("SDS") సాధనం అజీర్ AD లోకి బాహ్య SIS సిస్టమ్స్ నుండి Moodle లోకి దిగుమతి చేసిన సమాచారాన్ని సమకాలీకరించడానికి మిమ్మల్ని అనుమతిస్తుంది. <a href="https://sis.microsoft.com/" target="_blank"> మరింత తెలుసుకోండి </a> <br /> <br /> పాఠశాల డేటా సమకాలీకరణ విధానం Moodle క్రాన్లో 3 గంటలకు సర్వర్ సమయం. ఈ షెడ్యూల్ను మార్చడానికి, దయచేసి <a href="{$a}"> షెడ్యూల్డ్ విధుల నిర్వహణ పేజీని సందర్శించండి. <br /> <br />';
$string['settings_sds_intro_previewwarning'] = '<div class = "alert"> <b> ఇది పరిదృశ్యం లక్షణం </ b> <br /> పరిదృశ్యం లక్షణాలు ఉద్దేశించిన పని చేయకపోవచ్చు లేదా హెచ్చరిక లేకుండా విరిగిపోవచ్చు. దయచేసి జాగ్రత్తతో కొనసాగండి. </ Div>';
$string['settings_sds_noschools'] = '<div class = "alert alert-info"> పాఠశాల డేటా సమకాలీకరణలో మీరు ఏ పాఠశాలలు అందుబాటులో లేవు. </ div>';
$string['settings_sds_profilesync'] = 'ప్రొఫైల్ డేటా సమకాలీకరణ';
$string['settings_sds_profilesync_desc'] = 'ఈ ఎంపికలు SDS డేటా మరియు Moodle మధ్య సమకాలీకరించే నియంత్రణ డేటా డేటా.';
$string['settings_secthead_advanced'] = 'ఆధునిక సెట్టింగులు';
$string['settings_secthead_advanced_desc'] = 'ఈ సెట్టింగులు ప్లగిన్ సూట్ యొక్క ఇతర లక్షణాలను నియంత్రిస్తాయి. జాగ్రత్త! ఇవి అనాలోచిత ప్రభావాలను కలిగిస్తాయి.';
$string['settings_secthead_coursesync'] = 'కోర్సు సమకాలీకరణ';
$string['settings_secthead_coursesync_desc'] = 'ఈ క్రింది సెట్టింగ్లు ఆఫీసు 365 మరియు Moodle మధ్య సమన్వయాన్ని నియంత్రించడం.';
$string['settings_serviceresourceabstract_detect'] = 'గుర్తించడం';
$string['settings_serviceresourceabstract_detecting'] = 'గుర్తిస్తోంది ...';
$string['settings_serviceresourceabstract_empty'] = 'దయచేసి విలువను నమోదు చేయండి లేదా సరైన విలువను గుర్తించడానికి ప్రయత్నించడానికి "గుర్తించు" క్లిక్ చేయండి.';
$string['settings_serviceresourceabstract_error'] = 'సెట్టింగ్ని కనుగొనడంలో లోపం సంభవించింది. దయచేసి మానవీయంగా సెట్ చేయండి.';
$string['settings_serviceresourceabstract_invalid'] = 'ఈ విలువ ఉపయోగకరమని అనిపించడం లేదు.';
$string['settings_serviceresourceabstract_nocreds'] = 'దయచేసి మొదటి అప్లికేషన్ క్రెడెన్షియల్లను సెట్ చేయండి.';
$string['settings_serviceresourceabstract_valid'] = '{$a} ఉపయోగపడేది.';
$string['settings_setup_step1'] = '1/3 దశ: అజూర్ AD తో Moodle నమోదు చేయండి';
$string['settings_setup_step1_continue'] = '<b> మీరు మీ దరఖాస్తు ID మరియు కీ ఎంటర్ చేసిన తర్వాత, కొనసాగించడానికి పేజీ దిగువన "మార్పులను సేవ్ చేయి" క్లిక్ చేయండి. </ br> <br /> <br / >';
$string['settings_setup_step1_credentials_end'] = 'గమనిక: ఈ సెట్టింగులు OpenID Connect ధృవీకరణ ప్లగ్ఇన్ లో సేవ్ చేయబడతాయి. అధునాతన లాగిన్ అమర్పులను కన్ఫిగర్ చెయ్యడానికి, <a href="{$a->oidcsettings} "> OpenID Connect సెట్టింగ్ల పేజీ </a> <br /> <br />';
$string['settings_setup_step1_desc'] = 'అజూర్కి (<a href="https://portal.azure.com"> https://portal.azure.com"> https://portal.azure.com </a>) కు వెళ్ళండి, "అజూర్ ఆక్టివ్ డైరెక్టరీ", ఆపై "అనువర్తన నమోదులు" మరియు క్రింది సమాచారం ఉపయోగించి Moodle కోసం ఒక అనువర్తనాన్ని నమోదు చేయండి. దయచేసి ఈ సమాచారం అజూర్లో ఎంటర్ చేసి సరిగ్గా ఉన్నట్లు నిర్ధారించుకోండి  చిన్న తేడాలు కార్యాచరణను విచ్ఛిన్నం చేస్తాయి.';
$string['settings_setup_step1clientcreds'] = '<br /> నమోదు చేసుకున్న తరువాత, అజూర్లో దరఖాస్తు కోసం ఒక కీని సృష్టించండి. మీకు కీ ఉన్నది, అజూర్ నుండి అప్లికేషన్ ID మరియు కీని క్రింది ఫీల్డ్ లలో కాపీ చేయండి.';
$string['settings_setup_step2'] = 'దశ 2/3: కనెక్షన్ పద్ధతిని ఎంచుకోండి';
$string['settings_setup_step2_desc'] = 'ఆఫీస్ 365 ఇంటిగ్రేషన్ సూట్ అజూర్కు ఎలా కనెక్ట్ అయ్యేటట్లు ఈ విభాగం మిమ్మల్ని అనుమతిస్తుంది. "అప్లికేషన్ యాక్సెస్" ఉపయోగించి లేదా మీరు "సిస్టమ్" వినియోగదారుగా మీరు అంకితం చేసిన వినియోగదారు తరపున కమ్యూనికేషన్ను తయారు చేయవచ్చు.';
$string['settings_setup_step3'] = 'దశ 3/3: అడ్మిన్ సమ్మతి & amp; అదనపు సమాచారం';
$string['settings_setup_step3_desc'] = 'ఈ ఆఖరి దశ కొన్ని అజూర్ అనుమతులను ఉపయోగించడానికి నిర్వాహకుడి అనుమతిని ఇవ్వడానికి మిమ్మల్ని అనుమతిస్తుంది మరియు మీ Office 365 పర్యావరణం గురించి కొంత అదనపు సమాచారాన్ని సేకరిస్తుంది. <br /> <br />';
$string['settings_switchauthminupnsplit0'] = 'Office 365 కు మారడానికి కనీస అస్పష్ట యూజర్ పేరు పొడవు';
$string['settings_switchauthminupnsplit0_details'] = 'మీరు "ఆఫీసు 365 ధృవీకరణకు మారడానికి వినియోగదారులను స్విచ్" చేస్తే, ఇది స్విచ్ చేయబడిన అద్దెదారు (@ example.onmicrosoft.com భాగం) లేకుండా వినియోగదారు పేర్లకు కనీస పొడవును సెట్ చేస్తుంది. ఇది "అడ్మిన్" లాంటి సాధారణ పేర్లతో ఖాతాలను మార్చకుండా ఉండటానికి సహాయపడుతుంది, ఇవి తప్పనిసరిగా మూడ్లె మరియు అజూర్ AD లో లేనివి కావు.';
$string['settings_tools_tenants'] = 'టెనంట్స్';
$string['settings_tools_tenants_details'] = 'అదనపు Office 365 అద్దెదారులకు యాక్సెస్ నిర్వహించండి.';
$string['settings_tools_tenants_linktext'] = 'అదనపు అద్దెదారులను కన్ఫిగర్ చేయండి';
$string['settings_userconnections'] = 'కనెక్షన్లు';
$string['settings_userconnections_details'] = 'మూడ్లె మరియు ఆఫీస్ 365 వినియోగదారుల మధ్య కనెక్షన్లను సమీక్షించండి మరియు నిర్వహించండి.';
$string['settings_userconnections_linktext'] = 'వినియోగదారు కనెక్షన్ను నిర్వహించండి';
$string['settings_usermatch'] = 'వినియోగదారు సరిపోలిక';
$string['settings_usermatch_details'] = 'ఈ సాధనం ఒక కస్టమ్ అప్లోడ్ డేటా ఫైల్ ఆధారంగా Office 365 వినియోగదారులతో Moodle యూజర్లకు సరిపోలడానికి మిమ్మల్ని అనుమతిస్తుంది.';
$string['settings_usersynccreationrestriction'] = 'వినియోగదారు సృష్టి పరిమితి';
$string['settings_usersynccreationrestriction_details'] = 'ప్రారంభించబడితే, పేర్కొన్న Azure AD ఫీల్డ్ కోసం పేర్కొన్న విలువను కలిగి ఉన్న వినియోగదారులు మాత్రమే వినియోగదారు సమకాలీకరణ సమయంలో సృష్టించబడతారు.';
$string['settings_usersynccreationrestriction_o365group'] = 'ఆఫీస్ 365 గ్రూప్ సభ్యత్వం';
$string['spsite_group_contributors_desc'] = 'కోర్సు కోసం ఫైల్లను నిర్వహించడానికి ప్రాప్యత కలిగిన వినియోగదారులందరూ {$a}';
$string['task_calendarsyncin'] = 'Moodle కు o365 ఈవెంట్లను సమకాలీకరించండి';
$string['task_processmatchqueue'] = 'మ్యాచింగ్ ప్రాసెస్ని ప్రాసెస్ చేయండి';
$string['task_processmatchqueue_err_museralreadymatched'] = 'Moodle యూజర్ ఇప్పటికే Office 365 వినియోగదారుకు సరిపోలుతున్నాడు.';
$string['task_processmatchqueue_err_museralreadyo365'] = 'Moodle వినియోగదారు ఇప్పటికే Office 365 కి కనెక్ట్ చేయబడింది.';
$string['task_processmatchqueue_err_nomuser'] = 'ఈ వినియోగదారు పేరుతో Moodle యూజర్ కనుగొనబడలేదు.';
$string['task_processmatchqueue_err_noo365user'] = 'ఈ వినియోగదారు పేరుతో Office 365 యూజర్ కనుగొనబడలేదు.';
$string['task_processmatchqueue_err_o365useralreadyconnected'] = 'Office 365 వినియోగదారు ఇప్పటికే Moodle వినియోగదారుకు కనెక్ట్ చేయబడ్డాడు.';
$string['task_processmatchqueue_err_o365useralreadymatched'] = 'ఆఫీస్ 365 యూజర్ ఇప్పటికే ఒక Moodle వినియోగదారుకు సరిపోలని ఉంది.';
$string['task_sds_sync'] = 'SDS తో సమకాలీకరించండి';
$string['task_syncusers'] = 'Azure AD తో వినియోగదారులను సమకాలీకరించండి.';
$string['ucp_calsync_availcal'] = 'అందుబాటులో ఉన్న మూడ్లె క్యాలెండర్లు';
$string['ucp_calsync_desc'] = 'తనిఖీ చేసిన క్యాలెండర్లు మూడ్లె నుండి మీ Outlook క్యాలెండర్కు సమకాలీకరించబడతాయి.';
$string['ucp_calsync_title'] = 'Outlook క్యాలెండర్ సమకాలీకరణ సెట్టింగ్లు';
$string['ucp_connection_desc'] = 'మీరు ఆఫీసుకి ఎలా కనెక్ట్ చేస్తారో ఇక్కడ కాన్ఫిగర్ చేయవచ్చు & nbsp; 365. Office 365 లక్షణాలను ఉపయోగించడానికి, మీరు Office 365 ఖాతాకు కనెక్ట్ చేయాలి. దిగువ వివరించిన విధంగా ఇది సాధించవచ్చు.';
$string['ucp_connection_disconnected'] = 'మీరు Office 365 కి కనెక్ట్ కాలేదు';
$string['ucp_connection_linked'] = 'మీ మూడ్లె మరియు ఆఫీస్ 365 ఖాతాలను లింక్ చేయండి';
$string['ucp_connection_linked_active'] = 'మీరు Office 365 ఖాతాకు "{$a}" కు లింక్ చేయబడ్డారు.';
$string['ucp_connection_linked_desc'] = 'మీ మూడ్లె మరియు Office 365 ఖాతాలను లింక్ చేయడం ద్వారా మీరు Moodle కు లాగ్ ఇన్ ఎలా మార్చకుండానే Office 365 Moodle ఫీచర్లను ఉపయోగించడానికి అనుమతిస్తుంది. <br /> క్రింది లింకుపై క్లిక్ చేయడం ద్వారా మీరు ఆఫీసు 365 కు ఒకేసారి లాగిన్ అయ్యేలా పంపుతారు, ఆ తర్వాత మీరు ఇక్కడకు తిరిగి వస్తారు. మీరు మీ Moodle ఖాతాకు ఏవైనా ఇతర మార్పులను చేయకుండా Office 365 లక్షణాలను ఉపయోగించగలరు - మీరు ఎప్పుడైనా ఎల్లప్పుడూ Moodle కు లాగ్ ఇన్ అవుతారు.';
$string['ucp_connection_linked_migrate'] = 'లింక్ చేసిన ఖాతాకు మారండి.';
$string['ucp_connection_linked_start'] = 'మీ Moodle ఖాతాను Office 365 ఖాతాకు లింక్ చేయండి.';
$string['ucp_connection_linked_stop'] = 'Office 365 ఖాతా నుండి మీ Moodle ఖాతాని అన్లింక్ చేయండి.';
$string['ucp_connection_options'] = 'కనెక్షన్ ఐచ్ఛికాలు:';
$string['ucp_connection_start'] = 'ఆఫీస్కు కనెక్ట్ చేయండి & nbsp; 365';
$string['ucp_connection_status'] = 'ఆఫీస్ & nbsp; 365 కనెక్షన్:';
$string['ucp_connection_stop'] = 'Office నుండి డిస్కనెక్ట్ చేయండి & nbsp; 365';
$string['ucp_connectionstatus'] = 'కనెక్షన్ స్థితి';
$string['ucp_features'] = 'ఆఫీస్ & nbsp; 365 ఫీచర్లు';
$string['ucp_features_intro'] = 'మీరు Office & nbsp; 365 తో Moodle ను మెరుగుపరచడానికి ఉపయోగించే లక్షణాల జాబితా క్రింద ఉంది.';
$string['ucp_features_intro_notconnected'] = 'మీరు Office & nbsp; 365 కి కనెక్ట్ చేయబడే వరకు వీటిలో కొన్ని అందుబాటులో ఉండకపోవచ్చు.';
$string['ucp_general_intro'] = 'ఇక్కడ మీరు ఆఫీస్కు మీ కనెక్షన్ని నిర్వహించవచ్చు & nbsp; 365.';
$string['ucp_general_intro_notconnected_nopermissions'] = 'Office & nbsp; 365 కు కనెక్ట్ చేయడానికి మీరు మీ సైట్ నిర్వాహకుడిని సంప్రదించాలి.';
$string['ucp_index_calendar_desc'] = 'ఇక్కడ మీరు మీ మూడ్లె మరియు Outlook క్యాలెండర్ల మధ్య సమకాలీకరణను అమర్చవచ్చు. మీరు Moodle క్యాలెండర్ ఈవెంట్లను Outlook కు ఎగుమతి చేయవచ్చు మరియు Moodle లోకి Outlook ఈవెంట్లను తీసుకురావచ్చు.';
$string['ucp_index_calendar_title'] = 'Outlook క్యాలెండర్ సమకాలీకరణ సెట్టింగ్లు';
$string['ucp_index_connection_desc'] = 'మీరు ఆఫీసుకు కనెక్ట్ ఎలా ఆకృతీకరించాలి & nbsp; 365.';
$string['ucp_index_connection_title'] = 'ఆఫీస్ & nbsp; 365 కనెక్షన్ సెట్టింగులు';
$string['ucp_index_connectionstatus_connect'] = 'కనెక్ట్ చేయడానికి ఇక్కడ క్లిక్ చేయండి.';
$string['ucp_index_connectionstatus_connected'] = 'మీరు ప్రస్తుతం Office & nbsp; 365 కి కనెక్ట్ చేయబడ్డారు';
$string['ucp_index_connectionstatus_disconnect'] = 'డిస్కనెక్ట్';
$string['ucp_index_connectionstatus_login'] = 'లాగిన్ అవ్వడానికి ఇక్కడ క్లిక్ చేయండి.';
$string['ucp_index_connectionstatus_manage'] = 'కనెక్షన్ని నిర్వహించండి';
$string['ucp_index_connectionstatus_matched'] = 'మీరు Office & nbsp; 365 వినియోగదారు <small> "{$ a}" </ small> తో సరిపోలడం జరిగింది. ఈ కనెక్షన్ను పూర్తి చేయడానికి, దయచేసి క్రింది లింకును క్లిక్ చేసి, Office & nbsp; 365 కు లాగిన్ చేయండి.';
$string['ucp_index_connectionstatus_notconnected'] = 'మీరు ప్రస్తుతం Office కి కనెక్ట్ చేయలేదు & nbsp; 365';
$string['ucp_index_connectionstatus_reconnect'] = 'కనెక్షన్ను రిఫ్రెష్ చేయండి';
$string['ucp_index_connectionstatus_title'] = 'కనెక్షన్ స్థితి';
$string['ucp_index_connectionstatus_usinglinked'] = 'మీరు ఆఫీస్ 365 ఖాతాకు లింక్ చేయబడ్డారు.';
$string['ucp_index_connectionstatus_usinglogin'] = 'మీరు ప్రస్తుతం Moodle కు లాగిన్ అవ్వడానికి Office 365 ఉపయోగిస్తున్నారు.';
$string['ucp_index_onenote_desc'] = 'OneNote అనుసంధానం మీరు మూడ్లితో Office & nbsp; 365 OneNote ను ఉపయోగించడానికి అనుమతిస్తుంది. మీరు OneNote ని ఉపయోగించి కేటాయింపులను పూర్తి చేయవచ్చు మరియు మీ కోర్సులు కోసం గమనికలను సులభంగా తీసుకోవచ్చు.';
$string['ucp_index_onenote_title'] = 'ఒక గమనిక';
$string['ucp_notconnected'] = 'దయచేసి ఇక్కడ సందర్శించడానికి ముందు Office & nbsp; 365 కి కనెక్ట్ చేయండి.';
$string['ucp_o365accountconnected'] = 'ఈ Office 365 ఖాతా ఇప్పటికే మరొక Moodle ఖాతాతో అనుసంధానించబడింది.';
$string['ucp_options'] = 'ఎంపికలు';
$string['ucp_status_disabled'] = 'కనెక్ట్ కాలేదు';
$string['ucp_status_enabled'] = 'Active';
$string['ucp_syncdir_both'] = 'Outlook మరియు Moodle రెండింటినీ నవీకరించండి';
$string['ucp_syncdir_in'] = 'Outlook నుండి మూడ్ల వరకు';
$string['ucp_syncdir_out'] = 'మూడ్లె నుండి ఔట్లుక్ వరకు';
$string['ucp_syncdir_title'] = 'సమకాలీకరణ ప్రవర్తన:';
$string['ucp_syncwith_title'] = 'సమకాలీకరించడానికి Outlook క్యాలెండర్ యొక్క పేరు:';
$string['ucp_title'] = 'ఆఫీస్ & nbsp; 365 / Moodle కంట్రోల్ ప్యానెల్';
$string['webservices_error_assignnotfound'] = 'అందుకున్న మాడ్యూల్ యొక్క అసైన్మెంట్ రికార్డు కనుగొనబడలేదు.';
$string['webservices_error_couldnotsavegrade'] = 'గ్రేడ్ను సేవ్ చేయలేకపోయింది.';
$string['webservices_error_invalidassignment'] = 'ఈ webservices ఫంక్షన్తో అందుకున్న అప్పగింత ID ఉపయోగించబడదు.';
$string['webservices_error_modulenotfound'] = 'అందుకున్న మాడ్యూల్ ఐడి కనుగొనబడలేదు.';
$string['webservices_error_sectionnotfound'] = 'కోర్సు విభాగం కనుగొనబడలేదు.';
