<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'te', version '4.3'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'క్యాటగిరీ చేర్చు';
$string['addcomment'] = 'వ్యాఖ్యను చేర్చు';
$string['addentry'] = 'కొత్త ఎంట్రీ చేర్చు';
$string['addingcomment'] = 'ఒక వ్యాఖ్యను చేర్చు';
$string['alias'] = 'కీ వర్డ్';
$string['aliases'] = 'కీ వర్డ్ (వర్డ్స్)';
$string['aliases_help'] = 'ప్రతి పదకోశం ఎంట్రీకి సంబంధిత పదాల జాబితా (లేదా మారుపేర్లు) ఉండవచ్చు. ఎంట్రీ ఆటో-లింక్ అయినట్లయితే, ఏ కీలక పదమైనా కూడా ఆటో-లింక్ చేయబడుతుంది.

ప్రతి కీవర్డ్ / కీలక పదం  ఒక కొత్త వరుసలో  ఎంటర్  చేయండి (కామాలతో వేరు చేయడం కాదు).';
$string['allcategories'] = 'అన్ని క్యాటగిరీలు';
$string['allentries'] = 'అన్నీ';
$string['allowcomments'] = 'ఎంట్రీలకు వ్యాఖ్యలను పోస్ట్ చేయడాన్ని అనుమతించు';
$string['allowcomments_help'] = 'ఇది ఎనేబుల్ చేసి ఉంటే , వ్యాఖ్యలను సృష్టించడానికి అనుమతి ఉన్న అందరూ  పదకోశం ఎంట్రీలకు వ్యాఖ్యలను జోడించగలరు.';
$string['allowduplicatedentries'] = 'డూప్లికేట్ ఎంట్రీలను అనుమతించు';
$string['allowduplicatedentries_help'] = 'ఇది ఎనేబుల్ చేసి ఉంటే , పలు ఎంట్రీలకు ఒకటే కాన్సెప్ట్ పేరు ఉండవచ్చు.';
$string['allowprintview'] = 'ప్రింట్ వ్యూ చూడడాన్ని అనుమతించు';
$string['allowprintview_help'] = 'ఇది ఎనేబుల్ చేసి ఉంటే , విద్యార్థులకు పదకోశాన్ని ప్రింట్ చేసుకునేందుకు అనువుగా ఉండే వెర్షన్ లింక్ ఇవ్వబడుతుంది.';
$string['andmorenewentries'] = 'మరియు {$a} మరిన్ని కొత్త ఎంట్రీలు.';
$string['answer'] = 'జవాబు';
$string['approvaldisplayformat'] = 'ఆమోదించబడిన  డిస్ప్లే ఫార్మాట్';
$string['approvaldisplayformat_help'] = 'పదకోశం ఎంట్రీలను అనుమతించేటప్పుడు మీరు మరో విధమైన డిస్ప్లే ఫార్మాట్ ఎంచుకోవచ్చు';
$string['approve'] = 'ఆమోదించు';
$string['areaattachment'] = 'అటాచ్ మెంట్లు';
$string['areaentry'] = 'నిర్వచనాలు';
$string['areyousuredelete'] = 'ఈ ఎంట్రీని  నిజంగా తొలగించాలనుకుంటున్నారా?';
$string['areyousuredeletecomment'] = 'ఈ వ్యాఖ్యను నిజంగా తొలగించాలనుకుంటున్నారా?';
$string['areyousureexport'] = 'ఈ ఎంట్రీను ఎగుమతి చేయాలనుకుంటున్నారా';
$string['ascending'] = 'ఆరోహణ';
$string['attachment'] = 'అటాచ్మెంట్';
$string['attachment_help'] = 'పదకోశం ఎంట్రీకు ఒకటి లేదా అంతకంటె ఎక్కువ ఫైళ్ళను జతచేసే అవకాశం ఉంది';
$string['author'] = 'రచయిత';
$string['authorview'] = 'రచయిత ఆధారంగా వెదుకు';
$string['back'] = 'వెనక్కి';
$string['cachedef_concepts'] = 'కాన్సెప్ట్ లింకింగ్';
$string['cantinsertcat'] = 'క్యాటగిరీ ను చేర్చలేకపోయాము';
$string['cantinsertrec'] = 'కొత్త రికార్డ్ చేర్చలేకపోయాము';
$string['cantinsertrel'] = 'రిలేషన్ క్యాటగిరీ ఎంట్రీ ఇన్సర్ట్ చెయ్యలేకపోయాము';
$string['casesensitive'] = 'ఈ ఎంట్రీ కేస్ సెన్సిటివ్';
$string['casesensitive_help'] = 'ఈ సెట్టింగ్,  ఒక ఎంట్రీకి ఆటో లింకింగ్ చేస్తున్నపుడు అప్పర్ కేస్ లేదా లోవర్ కేస్ కు సరిపోతుందా లేదా అనే విషయం విశదీకరిస్తుంది.';
$string['cat'] = 'క్యాటగిరీ';
$string['categories'] = 'క్యాటగిరీలు';
$string['category'] = 'క్యాటగిరీ';
$string['categorydeleted'] = 'క్యాటగిరీ తొలగింపబడింది';
$string['categoryview'] = 'క్యాటగిరీ ఆధారంగా వెదుకు';
$string['changeto'] = '{$a} కు మార్చు';
$string['cnfallowcomments'] = 'పదకోశం, ఎంట్రీలపై వ్యాఖ్యలు చేయడాన్ని డీఫాల్ట్ గా   అనుమతిస్తుందా నిర్వచించండి';
$string['cnfallowdupentries'] = 'డీఫాల్ట్ గా పదకోశం డూప్లికేట్ ఎంట్రీలను అనుమతిస్తుందా నిర్వచించండి';
$string['cnfapprovalstatus'] = 'ఒక విద్యార్థి పోస్ట్ చేసిన ఎంట్రీ యొక్క ఆమోదం స్థితి డీఫాల్ట్ గా ఉండాలా  నిర్వచించండి';
$string['cnfcasesensitive'] = 'ఒక ఎంట్రీ, లింక్ చేసినప్పుడు, డిఫాల్ట్గా కేస్ సెన్సిటివ్ అయి ఉండాలా అనే విషయాన్ని  నిర్వచించండి';
$string['cnfdefaulthook'] = 'పదకోశాన్ని  మొదటిసారి వీక్షించినప్పుడు చూపించడానికి డిఫాల్ట్  సెలక్షన్ / ఎంపికను  ఎంచుకోండి.';
$string['cnfdefaultmode'] = 'పదకోశాన్ని  మొదటిసారి వీక్షించినప్పుడు చూపించడానికి డిఫాల్ట్  ఫ్రేమ్ ను  ఎంచుకోండి.';
$string['cnffullmatch'] = 'ఒక ఎంట్రీ లింక్ చేసినపుడు చేసినపుడు డీఫాల్ట్ గా  టార్గెట్ టెక్స్ట్ యొక్క కేస్ తో సరిపోలేలా   ఉండాలా అనే విషయాన్ని  నిర్వచించండి';
$string['cnflinkentry'] = 'ఒక ఎంట్రీ  డీఫాల్ట్ గా  ఆటోమేటికల్లీ లింక్ చేసి ఉండాలా అనే విషయాన్ని  నిర్వచించండి';
$string['cnflinkglossaries'] = 'పదకోశం డీఫాల్ట్ గా  ఆటోమేటికల్లీ లింక్ చేసి ఉండాలా అనే విషయాన్ని  నిర్వచించండి';
$string['cnfrelatedview'] = 'ఆటోమేటిక్ లింకింగ్ మరియు ఎంట్రీ వీక్షణ కోసం ఉపయోగించాల్సిన డిస్ప్లే ఫార్మాట్ ను  /ప్రదర్శన ఆకృతిని ఎంచుకోండి.';
$string['cnfshowgroup'] = 'గ్రూప్ బ్రేక్ చూపించాలా వద్దా అనేది  నిర్దేశించండి.';
$string['cnfsortkey'] = 'క్రమబద్ధీకరించే కీ ని డీ ఫాల్ట్ గా ఎంచుకోండి';
$string['cnfsortorder'] = 'క్రమబద్ధీకరించే క్రమాన్ని డీ ఫాల్ట్ గా ఎంచుకోండి';
$string['cnfstudentcanpost'] = 'విద్యార్థులు డీ ఫాల్ట్ గా ఎంట్రీస్ పోస్ట్ చేయవచ్చా లేదా అనే అంశాన్ని విశదీకరించండి';
$string['cnftabs'] = 'ఈ పదకోశ ఫార్మాట్ కు కనిపించే ట్యాబ్స్ ను ఎంచుకోండి';
$string['comment'] = 'వ్యాఖ్య';
$string['commentdeleted'] = 'ఈ వ్యాఖ్య తొలగించబడింది.';
$string['comments'] = 'వ్యాఖ్యలు';
$string['commentson'] = 'పై వ్యాఖ్యలు';
$string['commentupdated'] = 'వ్యాఖ్య నవీకరించబడింది';
$string['completionentries'] = 'విద్యార్థులు తప్పనిసరిగా ఎంట్రీలు సృష్టించాలి';
$string['completionentriesdesc'] = 'విద్యార్థులు తప్పనిసరిగా కనీసం {$a} ఎంట్రీ / ఎంట్రీలు సృష్టించాలి';
$string['completionentriesgroup'] = 'ఎంట్రీలు కావాలి';
$string['concept'] = 'కాన్సెప్ట్';
$string['concepts'] = 'కానెస్ప్ట్లు';
$string['configenablerssfeeds'] = 'అన్ని పదకోశాలకూ RSS ఫీడ్ అవకాశాన్ని ఎనేబుల్ చేస్తుంది. కానీ మీరు ప్రతీ పదకోశానికీ  మాన్యువల్ గా ఫీడ్స్ ను టర్న్ ఆన్ చెయ్యాల్సి ఉంటుంది.';
$string['current'] = 'ప్రస్తుతం క్రమబద్ధీకరించినవి{$a}';
$string['currentglossary'] = 'ప్రస్తుత పదకోశం';
$string['date'] = 'తేదీ';
$string['dateview'] = 'తేదీ ఆధారంగా వెదుకు';
$string['defaultapproval'] = 'డిఫాల్ట్ చే ఆమోదించబడింది';
$string['defaultapproval_help'] = 'ఇక్కడ కాదు అని కనక  సెట్ చేసినట్టయితే  ఎంట్రీలు అందరికీ కనబడాలంటే ముందుగా టీచర్ యొక్క ఆమోదం ఉండాలి';
$string['defaulthook'] = 'డీఫాల్ట్ హుక్';
$string['defaultmode'] = 'డిఫాల్టు మోడ్';
$string['defaultsortkey'] = 'డిఫాల్టుగా అమర్చే / పేర్చే/ క్రమబద్ధీకరించే  కీ';
$string['defaultsortorder'] = 'డిఫాల్టుగా అమర్చే / పేర్చే/ క్రమబద్ధీకరించే వరుస';
$string['definition'] = 'నిర్వచనం';
$string['definitions'] = 'నిర్వచనాలు';
$string['deleteentry'] = 'ఎంట్రీని తొలగించు';
$string['deleteentrya'] = 'ఎంట్రీని తొలగించు: {$a}';
$string['deletenotenrolled'] = 'నమోదు కాబడని వాడుకరులచే రూపొందించబడిన  ఎంట్రీలను తొలగించండి';
$string['deletingcomment'] = 'వ్యాఖ్యను తొలగిస్తున్నాము';
$string['deletingnoneemptycategory'] = 'ఈ విభాగాన్ని/క్యాటగిరీని  తొలగించడం వలన దానిలో ఉన్న ఎంట్రీలు  తొలగిపోవు - అవి క్యాటగిరైజ్ చెయ్యబడనవిగా  గుర్తించబడతాయి.';
$string['descending'] = 'అవరోహణం';
$string['destination'] = 'దిగుమతి అయిన ఎంట్రీలు ఉన్న ప్రదేశం';
$string['destination_help'] = 'ప్రస్తుత పదకోశానికి లేదా కొత్త పదకోశానికి  ఎంట్రీలు జోడించవచ్చు లేదా దుగుమతి చేసుకోవచ్చు. ఎలా అయినా XML ఫైల్ లో విషయాన్ని అనుసరించి  ఓ కొత్త పదకోశం సృష్టించబడుతుంది.';
$string['disapprove'] = 'అనుమతిని రద్దుచేయి';
$string['displayformat'] = 'డిస్ప్లే ఫార్మాట్';
$string['displayformat_help'] = 'ఇవి 7  డిస్ప్లే / ప్రదర్శన ఫార్మాట్లు:

* సాధారణ , నిఘంటువు శైలి - రచయితల వివరాలు  ప్రదర్శించబడలేదు మరియు జోడింపులు  లింక్ లు  గా చూపించబడతాయి
* రచయిత వివరాలు లేని నిరంతర ఫార్మాట్  - ఎంట్రీలు ఒకదాని తరువాత మరొకటి ఏవిధమైన సెపరేషన్ లేకుండా కేవలం  ఎడిటింగ్  చిహ్నాలతో   ప్రదర్శించబడతాయి
* రచయితతో నిండినది  - రచయిత యొక్క డేటాను చూపించే ఫోరమ్-వంటి డిస్ప్లే ఫార్మాట్ మరియు  జోడింపులు లింక్ లు  గా చూపబడతాయి
* రచయిత లేకుండా పూర్తి - రచయిత వివరాలు లేకుందా  చూపించే ఫోరమ్-వంటి డిస్ప్లే ఫార్మాట్ మరియు  జోడింపులు లింక్ లు  గా చూపబడతాయి
* ఎన్సైక్లోపెడియా - "రచయితతో పూర్తిగా" కానీ జోడించిన చిత్రాలు ఇన్లైన్ గా  చూపబడతాయి
* ఎంట్రీ లిస్ట్ - కాన్సెప్ట్స్ లింక్ లుగా జాబితా చేయబడ్డాయి
* తరచుగా అడిగే ప్రశ్నలు - ప్రశ్న మరియు సమాధానాలు వరుసగా కాన్సెప్ట్  మరియు నిర్వచనంకు చేర్చబడతాయి';
$string['displayformatcontinuous'] = 'నిరంతరంగా రచయిత లేకుండా';
$string['displayformatdefault'] = 'డిస్ప్లే ఫార్మాట్ మాదిరిగా డిఫాల్ట్';
$string['displayformatdictionary'] = 'సాధారణ నిఘంటు శైలి';
$string['displayformatencyclopedia'] = 'ఎన్ సైక్లోపీడియా / సర్వ విద్యా సంగ్రహశాస్త్రము';
$string['displayformatentrylist'] = 'ఎంట్రీల జాబితా';
$string['displayformatfaq'] = 'తరచుగా అడిగే ప్రశ్నలు';
$string['displayformatfullwithauthor'] = 'రచయితతో నిండినది/పూర్తయ్యింది';
$string['displayformatfullwithoutauthor'] = 'రచయిత లేకుండా నిండినది/పూర్తయ్యింది';
$string['displayformats'] = 'డిస్ప్లే ఫార్మాట్';
$string['displayformatssetup'] = 'డిస్ప్లే ఫార్మాట్స్ సెట్ అప్';
$string['duplicatecategory'] = 'డూప్లికేట్ క్యాటగిరీ';
$string['duplicateentry'] = 'డూప్లికేట్ ఎంట్రీ';
$string['editalways'] = 'ఎల్లప్పుడూ  ఎడిటింగ్ కు అనుమతించు';
$string['editalways_help'] = 'ఈ సెట్టింగు, విద్యార్థులు తమ  ఎంట్రీలు ఎల్లప్పుడూ సవరించగలరా   లేదా కాన్ఫిగర్ చేయబడిన సవరణ సమయంలో  మాత్రమే (సాధారణంగా 30 నిమిషాలు)  వారి ఎంట్రీలను  సవరించవచ్చో నిర్దేశిస్తుంది.';
$string['editcategories'] = 'క్యాటగిరీలను సవరించండి';
$string['editentry'] = 'ఎంట్రీని సవరించండి';
$string['editentrya'] = 'ఎంట్రీని సవరించండి: {$a}';
$string['editingcomment'] = 'వ్యాఖ్యను సవరిస్తున్నాము';
$string['entbypage'] = 'ఒక పేజీలో వీక్షణకు వీలయ్యే  ఎంట్రీలు';
$string['entries'] = 'ఎంట్రీలు';
$string['entrieswithoutcategory'] = 'క్యాటగిరీ లేని ఎంట్రీలు';
$string['entry'] = 'ఎంట్రీ';
$string['entryalreadyexist'] = 'ఈ ఎంట్రీ ఇప్పటికే నమోదు అయి ఉంది';
$string['entryapproved'] = 'ఈ ఎంట్రీ ఆమోదించబడింది';
$string['entrydeleted'] = 'ఎంట్రీ తొలగించబడింది';
$string['entryexported'] = 'ఎంట్రీ దిగ్విజయంగా ఎగుమతిచేయబడింది';
$string['entryishidden'] = '( ఈ ఎంట్రీ ప్రస్తుతం దాచిఉంచబడింది)';
$string['entryleveldefaultsettings'] = 'ఏంట్రీ లెవల్ డీఫాల్ట్ సెట్టింగ్';
$string['entrysaved'] = 'ఈ ఎంట్రీ సేవ్ చేయబడింది';
$string['entryupdated'] = 'ఈ ఎంట్రీ నవీకరించబడింది';
$string['entryusedynalink'] = 'ఈ ఎంట్రీ ఆటోమేటిక్ గా లింక్ చేయబడాలి';
$string['entryusedynalink_help'] = 'నిర్వాహకునిచే సైట్-వ్యాప్త పదకోశం ఆటో లింకింగ్  ఎనేబుల్ చేసి ఉన్నట్లయితే మరియు ఈ చెక్ బాక్స్ టిక్ చేయబడి ఉన్నట్లయితే , కోర్సు అంతటా  ఆయా ఎంట్రీలు, ఆ  కాన్సెప్ట్లూ  మరియు పదబంధాలు ఉన్నచోటల్లా  లింక్ చేయబడతాయి.';
$string['errcannoteditothers'] = 'మీరు ఇతరుల ఎంట్రీలను ఎడిట్ చేయలేరు.';
$string['errconceptalreadyexists'] = 'ఇప్పటికే ఈ కాన్సెప్ట్ నమోదు అయ్యి ఉంది.ఈ పదకోశం డూప్లికేట్ ను అనుమతించదు.';
$string['errdeltimeexpired'] = 'సమయం మించిపోయింది. దీనిని మీరు తొలగించలేరు!';
$string['erredittimeexpired'] = 'ఈ ఎంట్రీ యొక్క ఎడిటింగ్ సమయం అయిపోయింది.';
$string['errorparsingxml'] = 'ఫైల్ను అన్వయించేటప్పుడు లోపాలు సంభవించాయి. ఇది చెల్లుబాటు అయ్యే XML సింటాక్స్ అని నిర్ధారించుకోండి.';
$string['eventcategorycreated'] = 'క్యాటగిరీ సృష్టించబడింది';
$string['eventcategorydeleted'] = 'క్యాటగిరీ తొలగించబడింది';
$string['eventcategoryupdated'] = 'క్యాటగిరీ నవీకరించబడింది';
$string['evententryapproved'] = 'ఎంట్రీ ఆమోదించబడింది';
$string['evententrycreated'] = 'ఎంట్రీ సృష్టించబడింది';
$string['evententrydeleted'] = 'ఎంట్రీ తొలగించబడింది';
$string['evententrydisapproved'] = 'ఎంట్రీ తిరస్కరించడమైనది';
$string['evententryupdated'] = 'ఎంట్రీ నవీకరించబడింది';
$string['evententryviewed'] = 'ఎంట్రీ వీక్షించబడింది';
$string['explainaddentry'] = 'ప్రస్తుత పదకోశంలో క్రొత్త ఎంట్రీని జోడించండి. <br /> కాన్సెప్ట్ మరియు నిర్వచనం ఫీల్ద్స్ తప్పనిసరిగా పూరించాలి.';
$string['explainall'] = 'అన్ని ఎంట్రీలను ఒకే పేజీలో చూపిస్తుంది';
$string['explainalphabet'] = 'ఈ సూచిక ఆధారంగా పదకోశాన్ని బ్రౌజ్ చేయండి';
$string['explainexport'] = 'దిగువ ఉన్న బటన్ క్లిక్ చేసి పదకోశ ఎంట్రీలను ఎగుమతి చేయండి. <br /> ఈ కోర్స్ లో లేదా మరేదైనా కోర్సు లోకి మీకు అవసరం అనిపించినపుడు దీనిని  దిగుమతిచేసుకోవచ్చు.</ P>  దయచేసి అటాచ్మెంట్లను (ఉదా. చిత్రాలు) మరియు రచయితల వివరాలను  ఎగుమతి చేయలేదని గమనించండి. </ P>';
$string['explainimport'] = 'మీరు దిగుమతి చేయాలనుకున్న ఫైల్ తప్పక పేర్కొనాలి  మరియు  ప్రాసెస్ యొక్క ప్రమాణాలను నిర్వచించండి. <P> మీ అభ్యర్థనను సమర్పించి ఫలితాలను సమీక్షించండి. </ P>';
$string['explainspecial'] = 'అక్షరంతో మొదలుకాని ఎంట్రీలను చూపిస్తుంది';
$string['exportedentry'] = 'ఎగుమతి చేయబడిన ఎంట్రీ';
$string['exportentries'] = 'ఎంట్రీలను ఎగుమతిచేయి';
$string['exportentriestoxml'] = 'ఎంట్రీలను XML ఫైల్ కు  ఎగుమతిచేయి';
$string['exportfile'] = 'ఎంట్రీలను ఫైల్ కు ఎగుమతి చెయ్యి';
$string['exportglossary'] = 'పదకోశాన్ని ఎగుమతి చెయ్యి';
$string['exporttomainglossary'] = 'ప్రధాన పదకోశానికి ఎగుమతి చెయ్యి';
$string['filetoimport'] = 'దిగుమతి చేసుకోవల్సిన ఫైలు';
$string['filetoimport_help'] = 'మీ కంప్యూటర్ లో నిక్షిప్తం అయి ఉన్న XML  ఫైల్ ను వెతికి ఎంపిక చేసి';
$string['fillfields'] = 'కాన్సెప్ట్ మరియు నిర్వచనం తప్పనిసరిగా రాయాలి.';
$string['filtername'] = 'పదకోశం ఆటో లింకింగ్';
$string['fullmatch'] = 'అన్ని పదాలు/అక్షరాలను సరిపోల్చు';
$string['fullmatch_help'] = 'ఈ సెట్టింగు మొత్తం పదాలను  మాత్రమే అనుసంధానించబడుతుందా/లింక్ చేస్తుందా లేదా అనేది  నిర్దేశిస్తుంది, ఉదాహరణకు, "నిర్మాణం" అనే పదకోశం ఎంట్రీ "నిర్మాణాత్మకమైన"  అనే పదం లోపల ఒక లింక్ ను  సృష్టించదు.';
$string['glossary:addinstance'] = 'ఓ కొత్త పదకోశాన్ని చేర్చు';
$string['glossary:approve'] = 'ఆమోదించు మరియు అమోదించబడిన ఎంట్రీలను రద్దు చేయు';
$string['glossary:comment'] = 'వ్యాఖ్యలను సృష్టించు';
$string['glossary:export'] = 'ఎంట్రీలను ఎగుమతి చేయండి';
$string['glossary:exportentry'] = 'ఒకే ఎంట్రీని ఎగుమతి చేయండి';
$string['glossary:exportownentry'] = 'మీ  యొక్క ఒకే ఎంట్రీని ఎగుమతి చేయండి';
$string['glossary:import'] = 'ఎంట్రీలను దిగుమతి చేయు';
$string['glossary:managecategories'] = 'క్యాటగిరీల నిర్వహణ';
$string['glossary:managecomments'] = 'వ్యాఖ్యల నిర్వహణ';
$string['glossary:manageentries'] = 'ఎంట్రీల నిర్వహణ';
$string['glossary:rate'] = 'ఎంట్రీలకు రేటింగ్ ఇవ్వు';
$string['glossary:view'] = 'పదకోశాన్ని వీక్షించు';
$string['glossary:viewallratings'] = 'ఒక్కొక్కరూ ఇచ్చిన రేటింగ్స్ ను వీక్షించండి';
$string['glossary:viewanyrating'] = 'ఎవరైనా అందుకున్న మొత్తం రేటింగ్స్ ను వీక్షించు';
$string['glossary:viewrating'] = 'ఇప్పటివరకూ వచ్చిన మొత్తం రేటింగ్స్ చూడండి';
$string['glossary:write'] = 'కొత్త ఎంట్రీలను సృష్టించండి';
$string['glossaryleveldefaultsettings'] = 'పదకోశ  స్థాయి డిఫాల్ట్ సెట్టింగులు';
$string['glossarytype'] = 'పదకోశం రకము';
$string['glossarytype_help'] = 'ఒక ప్రధాన పదకోశం అనేది ద్వితీయ పదకోశాల నుండి ఎంట్రీలను దిగుమతి చేయగల ఒక పదకోశం. ఒక కోర్సులో ఒక ప్రధాన పదకోశం  మాత్రమే ఉంటుంది. పదకోశం ఎంట్రీల  దిగుమతి అవసరం లేదు అనుకుంటే, కోర్సు లో అన్ని పదకోశాలు ద్వితీయ పదకోశాలయి ఉండవచ్చు.';
$string['guestnoedit'] = 'అతిథులకు  పదకోశాన్ని ఎడిట్ చేసే అనుమతి నిరాకరించడమైనది';
$string['importcategories'] = 'క్యాటగిరీలను దిగుమతి చేయండి';
$string['importedcategories'] = 'దిగుమతిచేయబడిన క్యాటగిరీలు';
$string['importedentries'] = 'దిగుమతిచేయబడిన ఎంట్రీలు';
$string['importentries'] = 'ఎంట్రీలను దిగుమతి చెయ్యి';
$string['importentriesfromxml'] = 'XML ఫైల్ నుంచి ఎంట్రీలను దిగుమతి చెయ్యి';
$string['includegroupbreaks'] = 'గ్రూప్ బ్రేక్ లను చేర్చు';
$string['indicator:cognitivedepth'] = 'కాగ్నిటివ్ / జిజ్ఞాస పదకోశం';
$string['indicator:cognitivedepth_help'] = 'పదకోశ యాక్టివిటీలో విద్యార్థి జిజ్ఞాస పై ఈ సూచిక ఆధారపడి ఉంది.';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'సోషల్ పదకోశం';
$string['indicator:socialbreadth_help'] = 'పదకోశ యాక్టివిటీలోని  సామాజిక అంశాలలో విద్యార్థి ఆసక్తి పై   ఈ సూచిక ఆధారపడి ఉంది.';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['isglobal'] = 'ఈ పదకోశం గ్లోబల్ పదకోశమా?';
$string['isglobal_help'] = 'ఒక గ్లోబల్ పదకోశంలోని  ఎంట్రీలు, ఆ పదకోశం ఉన్న కోర్సులోనే కాక  సైట్ అంతటా లింక్ చేయబడివుంటాయి, నిర్వాహకులు మాత్రమే పదకోశాన్ని  గ్లోబల్ అని  సెట్ చేయవచ్చు.';
$string['letter'] = 'అక్షరం';
$string['linkcategory'] = 'ఈ క్యాటగిరీను ఆటోమేటిక్ గా లింక్ చెయ్యి';
$string['linkcategory_help'] = 'పదకోశం ఆటోలింకింగ్ ఎనేబుల్ అయి ఉండి , ఈ సెట్టింగ్ కూదా ఎనేబుల్ అయి ఉంటే ,
క్యాటqగిరీ పేరు / వర్గీకరణ పేరు  కోర్సు యొక్క మిగిలిన భాగంలో  ఆటోమేటిక్ గా  లింక్ చేయబడుతుంది. వాడుకరులు  ఒక  క్యాటగిరీని / వర్గం పేరు లింక్  అనుసరిస్తే, వారిని  పదకోశం యొక్క "వర్గం ద్వారా బ్రౌజ్" / " క్యాటగిరీ ద్వారా వెదుకు" అనే  పేజీకి తీసుకువెళతారు.';
$string['linking'] = 'ఆటో లింకింగ్';
$string['mainglossary'] = 'ప్రధాన పదకోశం';
$string['maxtimehaspassed'] = 'క్షమించండి, ఈ వ్యాఖ్యను  ({$a}) ఎడిట్ చేయడానికి ఇచ్చిన సమయం మించిపోయింది!';
$string['modulename'] = 'పదకోశం';
$string['modulename_help'] = 'పదకోశం యాక్తివిటీ మాడ్యూల్  వాడుకరులకు  నిఘంటువు వంటి నిర్వచనాల జాబితాను సృష్టించడానికి మరియు నిర్వహించడానికి అవకాశం ఇస్తుంది  లేదా వనరులు లేదా సమాచారాన్ని సేకరించడానికి మరియు నిర్వహించడానికి వీలు కల్పిస్తుంది.

టీచర్ కు  పదకోశం ఎంట్రీలకు ఫైళ్ళను  జతచేయటానికి అనుమతిచ్చే అవకాశం ఉంది. జోడించిన చిత్రాలు ఎంట్రీలో  ప్రదర్శించబడతాయి. ఎంట్రీలను  అక్షర క్రమంలో లేదా క్యాటగిరీ / వర్గం, తేదీ లేదా రచయిత ద్వారా శోధించవచ్చు లేదా బ్రౌజ్ చేయవచ్చు. ఎంట్రీలు అప్రమేయంగా / డీఫాల్ట్ గా ఆమోదించబడవచ్చు లేదా  వీక్షించబడటానికి ముందు ప్రతి ఒక్కరికి  టీచర్ అనుమతి అవసరం.

పదకోశం ఆటో -లింకింగ్ ఫిల్టర్ ఎనేబుల్ చేయబడితే,  కోర్సులో కనిపించే ఎంట్రీలు ఆయా కాన్సెప్ట్ పదాలు మరియు / లేదా పదబంధాలకు   ఆటోమేటిక్ గా  లింక్ చేయబడతాయి.

ఒక టీచర్ ఎంట్రీల మీద వ్యాఖ్యలను అనుమతించగలరు. ఎంట్రీలు ఉపాధ్యాయులు లేదా విద్యార్థుల ద్వారా కూడా అంచనా వేయబడతాయి / రేటింగ్  (పీర్ మూల్యాంకనం). గ్రేడ్ బుక్ లో రికార్డ్ చేయబడిన తుది గ్రేడ్ను రూపొందించడానికి రేటింగ్లు సమగ్రంగా ఉంటాయి.

పదకోశం వల్ల  అనేక ఉపయోగాలు ఉన్నాయి:

* సహకార కీలక పదాల సమాహారం తయారీ వీలవుతుంది
* క్రొత్తగా చేరిన  విద్యార్థులు తమ పేరు మరియు వ్యక్తిగత వివరాలను జతచేసే ఒక యాక్టివిటీ అంటే   \'గెటింగ్ టు నొ \' అనే యాక్టివిటీగా వాడుకోవచ్చు
*  \'సులభ చిట్కాలు\' వనరుగా వాడుకోవచ్చు
* ఉపయోగకరమైన వీడియోలు, చిత్రాలు లేదా సౌండ్ ఫైల్స్ షేర్ చేసుకునే యాక్తివిటీ గా వాడుకోవచ్చు
* గుర్తుంచుకోవలసిన విషయాలు / కీలక సమాచారం  పునశ్చరణ  వనరు గా వాడుకోవచ్చు';
$string['modulename_link'] = 'mod/glossary/view';
$string['modulenameplural'] = 'పదకోశాలు';
$string['newentries'] = 'పదకోశంలోని కొత్త పదాలు';
$string['newglossary'] = 'కొత్త పదకోశం';
$string['newglossarycreated'] = 'కొత్త పదకోశాన్ని సృష్టించాం';
$string['newglossaryentries'] = 'కొత్త పదకోశ ఎంట్రీలు:';
$string['nocomment'] = 'వ్యాఖ్యలేవీ కనబడలేదు';
$string['nocomments'] = '(ఈ ఎంట్రీపై వ్యాఖ్యలేమీ కనబడలేదు)';
$string['noconceptfound'] = 'కాన్సెప్ట్ లేదా నిర్వచనం కనబడలేదు';
$string['noentries'] = 'ఈ విభాగంలో ఎంట్రీలేమీ కనబడలేదు';
$string['noentry'] = 'ఎంట్రీ ఏమీ కనబడలేదు';
$string['nopermissiontodelcomment'] = 'మీరు ఇతరుల వ్యాఖ్యలను తొలగించలేరు!';
$string['nopermissiontodelinglossary'] = 'ఈ పదకోశంలో మీరు వ్యాఖ్యలను జత చేయలేరు!';
$string['nopermissiontoviewresult'] = 'మీ యొక్క ఎంట్రీల ఫలితాలను మాత్రమే మీరు చూడగలరు';
$string['notapproved'] = 'పదకోశం ఎంట్రీ ఇంకా ఆమోదించబడలేదు.';
$string['notcategorised'] = 'క్యాటగరైజ్ చెయ్యబడలేదు';
$string['numberofentries'] = 'మొత్తం ఎంట్రీల సంఖ్య';
$string['onebyline'] = '(వరుసకు ఒకటే)';
$string['page-mod-glossary-edit'] = 'పదకోశం జోడించే /సవరించే  ఎంట్రీ పేజీ';
$string['page-mod-glossary-view'] = 'పదకోశం ఎడిట్ పేజీ చూడండి';
$string['page-mod-glossary-x'] = 'ఏదైనా పదకోశం యొక్క మాడ్యూల్ పేజీ';
$string['pluginadministration'] = 'పదకోశం నిర్వహణ';
$string['pluginname'] = 'పదకోశం';
$string['popupformat'] = 'పాప్ అప్  ఫార్మాట్';
$string['print'] = 'ప్రింట్';
$string['printerfriendly'] = 'ప్రింటింగ్ కు అనువైన వెర్షన్';
$string['printviewnotallowed'] = 'ప్రింట్ వ్యూ కు అనుమతి లేదు';
$string['privacy'] = 'ఫలితాల యొక్క గోప్యత';
$string['privacy:metadata:core_comments'] = 'పదకోశ నిర్వచనాలకు జోడించిన  వ్యాఖ్యల   వివరాలు core_tag system లో నిక్షిప్తం చేయబడతాయి.';
$string['privacy:metadata:core_files'] = 'పదకోశ నిర్వచనాలకు జోడించిన  ఫైల్స్  వివరాలు core_tag system లో నిక్షిప్తం చేయబడతాయి.';
$string['privacy:metadata:core_rating'] = 'పదకోశ ఎంట్రీలకు జోడించిన  రేటింగ్  వివరాలు core_tag system లో నిక్షిప్తం చేయబడతాయి.';
$string['privacy:metadata:core_tag'] = 'పదకోశ నిర్వచనాలకు జోడించిన ట్యాగుల వివరాలు core_tag system లో నిక్షిప్తం చేయబడతాయి.';
$string['privacy:metadata:glossary_entries'] = 'ఇచ్చిన పదకోశ యాక్టివిటీకి వాడుకరి జోడించిన ఎంట్రీల సమాచారం';
$string['privacy:metadata:glossary_entries:attachment'] = 'వాడుకరి జోడించిన  ఎంట్రీ యొక్క అటాచ్ మెంట్';
$string['privacy:metadata:glossary_entries:concept'] = 'వాడుకరి జోడించిన  ఎంట్రీ యొక్క కాన్సెప్ట్';
$string['privacy:metadata:glossary_entries:definition'] = 'వాడుకరి జోడించిన  ఎంట్రీ యొక్క నిర్వచనం';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'పదకోశ యాక్టివిటీ  ID';
$string['privacy:metadata:glossary_entries:timemodified'] = 'పదకోశ ఎంట్రీని వాడుకరి  ఎప్పుడు సవరించారో వివరాన్ని తెలిపే సమయ ముద్ర';
$string['privacy:metadata:glossary_entries:userid'] = 'ఈ పదకోశ ఎంట్రీని జోడిస్తున్న వాడుకరి యొక్క  ID';
$string['question'] = 'ప్రశ్న';
$string['rejectedentries'] = 'తిరస్కరించబడిన ఎంట్రీలు';
$string['rejectionrpt'] = 'తిరస్కరణ నివేదిక';
$string['removeallglossarytags'] = 'అన్ని పదకోశ ట్యాగులను తొలగించు';
$string['resetglossaries'] = 'నుంచి ఎంట్రీలను తొలగించు';
$string['resetglossariesall'] = 'అన్ని పదకోశాలనుంచి ఎంట్రీలను తొలగించు';
$string['rssarticles'] = 'ఇటీవలి RSS ఆర్టికల్స్ సంఖ్య';
$string['rssarticles_help'] = 'ఈ సెట్టింగ్, RSS ఫీడ్ కు జోడించబడే  పదకోశ ఎంట్రీల కాన్సెప్ట్ ల  సంఖ్య ను తెలుపుతుంది. సాధారణంగా 5 నుంచి 20 వరకు ఆమోదయోగ్యం.';
$string['rsssubscriberss'] = '\'{$a}\' కాన్సెప్త్స్ కు RSS ఫీడ్ చూపించు';
$string['rsstype'] = 'ఈ యాక్టివిటీ  RSS ఫీడ్';
$string['rsstype_help'] = 'ఈ యాక్టివిటీకి RSS ఫీడ్   ఎనేబుల్ చెయ్యాలంటే, ఫీడ్ కు జత చేయడానికి  రచయిత తో కూడిన  కాన్సెప్ట్స్ నూ లేదా రచయిత లేకుండా  కాన్సెప్ట్స్ ఐనా ఎంచుకోండి.';
$string['search:activity'] = 'పదకోశం-యాక్టివిటీ సమాచారం';
$string['search:entry'] = 'పదకోశం-ఎంట్రీలు';
$string['searchindefinition'] = 'మొత్తం టెక్స్ట్ ను శోధించు/వెదుకు';
$string['secondaryglossary'] = 'ద్వితీయ పదకోశం';
$string['showall'] = '\'ALL\'  లింక్ చూపండి';
$string['showall_help'] = 'ఇది ఎనేబుల్ చేసి ఉంటే వాడుకరులు పదకోశంలోని ఎంట్రీలన్నిటినీ ఒకేసారి  శోధించగలరు.';
$string['showalphabet'] = 'అక్షరాల లింక్ లు చూపండి';
$string['showalphabet_help'] = 'ఇది ఎనేబుల్ చేసి ఉంటే వాడుకరులు పదకోశాన్ని అక్షరాల ఆధారంగా శోధించగలరు.';
$string['showspecial'] = '\'Special\' లింక్ చూపండి';
$string['showspecial_help'] = 'ఇది ఎనేబుల్ చేసి ఉంటే వాడుకరులు పదకోశాన్ని @ మరియు  # అనే ప్రత్యేక గుర్తులను ఉపయోగించి కూడా పదకోశాన్ని శోధించగలరు.';
$string['sortby'] = 'ద్వారా క్రమబద్ధీకరించు';
$string['sortbycreation'] = 'సృష్టించిన  తేదీ ద్వారా';
$string['sortbylastupdate'] = 'చివరి నవీకరణ ద్వారా';
$string['sortchronogically'] = 'కాలానుక్రమంగా క్రమబద్ధీకరించు';
$string['special'] = 'స్పెషల్ లేదా ప్రత్యేకమైన';
$string['standardview'] = 'అక్షరం ఆధారంగా వెదుకు';
$string['studentcanpost'] = 'విద్యార్థులు ఎంట్రీలను జోడించవచ్చు';
$string['tagarea_glossary_entries'] = 'పదకోశం ఎంట్రీలు';
$string['tagsdeleted'] = 'పదకోశ ట్యాగులు తొలగించబడ్డాయి';
$string['totalentries'] = 'మొత్తం ఎంట్రీలు';
$string['usedynalink'] = 'పదకోశం ఎంట్రీలను ఆటోమేటిక్ గా లింక్ చెయ్యి';
$string['usedynalink_help'] = 'నిర్వాహకుడిచే సైట్-వ్యాప్తంగా  పదకోశం ఆటో-లింకింగ్  ఎనేబుల్ చేయబడి ఉన్నట్లయితే మరియు ఈ సెట్టింగ్ ఎనేబుల్ చేయబబడి ఉంటే, "కొత్త ఎంట్రీని జోడించు" అన్నపుడు  కోర్సు అంతటా  కాన్సెప్ట్  పదాలు మరియు పదబంధాలతో  ఆయా  ఎంట్రీలని ఆటోమేటిక్గా లింక్ చేసే ఆప్షన్ ను  కలిగి ఉంటుంది.';
$string['visibletabs'] = 'కనిపించే ట్యాబ్ లు';
$string['waitingapproval'] = 'అనుమతికోసం వేచిఉంది';
$string['warningstudentcapost'] = '( పదకోశం ప్రధాన పదకోశం కాకపోతేనే వర్తిస్తుంది)';
$string['withauthor'] = 'రచయితతో కూడిన కాన్సెప్ట్లు';
$string['withoutauthor'] = 'రచయితలు లేని కాన్సెప్ట్లు';
$string['writtenby'] = 'వీరిచే లేదా ద్వారా';
$string['youarenottheauthor'] = 'ఈ వ్యాఖ్య రచయిత  మీరు  కాదు కావున మీరు ఎడిట్ చెయ్యలేరు';
