<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'te', version '4.3'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'అనుమతి నిరాకరించడమైనది.';
$string['accountlocked'] = 'మీ ఖాతా లాక్ చేయబడింది. అన్‌లాక్ లింక్ ఇమెయిల్ ద్వారా పంపబడింది.';
$string['accounts'] = 'ఖాతాలు';
$string['accountunlocked'] = 'మీ ఖాతా అన్‌లాక్ చేయబడింది. మీరు లాగిన్ అవ్వవచ్చు.';
$string['addcategory'] = 'కేటగిరీను చేర్చు';
$string['additionalhtml'] = 'అదనపు HTML';
$string['additionalhtml_desc'] = 'మీరు ప్రతీ పేజీ లోనూ యాడ్ చేయదల్చుకున్న HTML వివరాలను ఈ సెట్టింగ్స్  తెలియచేస్తాయి. పేజీలోని HEAD ట్యాగ్  ఓపెన్ చేసిన వెనువంటనే లేదా ట్యాగ్ ను మూసివేసే ముందు, మీరు చేర్చదల్చుకున్న HTML ను సెట్ చేయవచ్చు. <br /> ఈ విధానం, మీరు ఎంచుకున్న థీమ్ ఏదైనా కూడా,  సులభంగా మీకు నచ్చిన హెడర్స్, ఫూటర్స్ చేర్చే అవకాశం లేదా గూగుల్ ఎనలిటిక్స్ వంటి అదనపు సర్వీసులను చేర్చే అవకాశం ఉంటుంది.';
$string['additionalhtml_heading'] = 'ప్రతీ పేజీలోనూ అదనపు HTML చేర్చబడుతుంది.';
$string['additionalhtmlfooter'] = 'BODY ట్యాగ్ మూసివేసే ముందు';
$string['additionalhtmlfooter_desc'] = 'ఇక్కడి కంటెంట్, ప్రతీ పేజీలోనూ  body ట్యాగును మూసివేసే ముందు జోడించబడుతుంది.';
$string['additionalhtmlhead'] = 'HEAD ట్యాగ్ లోపల';
$string['additionalhtmlhead_desc'] = 'ఇక్కడి కంటెంట్, ప్రతీ పేజీలోనూ  HEAD ట్యాగు కింద జోడించబడుతుంది.';
$string['additionalhtmltopofbody'] = 'BODY ట్యాగ్ తెరిచి ఉన్నపుడు';
$string['additionalhtmltopofbody_desc'] = 'ఇక్కడ ఇచ్చిన కంటెంటు ప్రతి పేజీలోనూ తెరిచే బాడీ ట్యాగు వెనువెంటనే చేరుతుంది.';
$string['admincategory'] = 'కేటగిరీ:{$a}';
$string['adminseesall'] = 'నిర్వాహకులు అన్నీ/అందరినీ చూడగలరు';
$string['adminseesallevents'] = 'నిర్వాహకులు అన్ని ఈవెంట్లను చూడండి / చూస్తారు/చూడగలరు';
$string['adminseesownevents'] = 'నిర్వాహకులు కూడా ఇతర వాడుకరుల వలెనే';
$string['advancedfeatures'] = 'అడ్వాన్స్ డ్  ఫీచర్లు';
$string['agedigitalconsentverification'] = 'సమ్మతి ధృవీకరణ యొక్క డిజిటల్ యుగం';
$string['agedigitalconsentverification_desc'] = 'స్వీయ-నమోదు వినియోగదారుల కోసం సైన్-అప్ పేజీని ప్రదర్శించే ముందు వయసు నిర్థారణ  సమ్మతి ధృవీకరణను ఎనేబుల్ చేస్తుంది. ఇది తల్లిదండ్రుల/సంరక్షకుల అనుమతి లేకుండా మైనర్లు సైన్ అప్ చేయకుండా మీ సైట్‌ను రక్షిస్తుంది. మరింత సహాయం కోసం <a target="_blank" href="{$a}">సపోర్ట్ కాంటాక్ట్</a> వివరాలు అందించబడ్డాయి.';
$string['ageofdigitalconsentmap'] = 'అనుమతి యొక్క డిజిటల్ యుగం';
$string['ageofdigitalconsentmap_desc'] = 'సమ్మతి యొక్క డిఫాల్ట్ డిజిటల్ యుగం మరియు ఏ దేశంలోనైనా డిఫాల్ట్ నుండి భిన్నంగా ఉన్న వయస్సు ఇక్కడ పేర్కొనవచ్చు. ప్రతి వయస్సును ఫార్మాట్తో కొత్త లైనులో ఎంటర్ చెయ్యండి: దేశం కోడ్, వయస్సు (కామాతో వేరు చేయబడుతుంది). దేశం కోడ్ స్థానంలో డిఫాల్ట్ వయస్సు * సూచించబడుతుంది. దేశం సంకేతాలు ISO 3166-2 లో పేర్కొనబడ్డాయి.';
$string['allcountrycodes'] = 'అన్ని దేశాల కోడ్ లు';
$string['allowattachments'] = 'అటాచ్ మెంట్ల జోడింపుకు అనుమతి ఇవ్వు';
$string['allowbeforeblock'] = 'ముందుగా అనుమతి పొందిన జాబితా ప్రాసెస్ చేయబడుతుంది.';
$string['allowbeforeblockdesc'] = 'డిఫాల్టుగా నైతే, నిరోధిత ఐపీ జాబితాలోని ఐపీలతో పోల్చి చూస్తాం. ఈ వికల్పాన్ని ఎంచుకుంటే, నిరోధిత జాబితా కంటే ముందు, అనుమతించబడిన జాబితాలోని ఐపీలతో పోల్చి చూస్తాం.';
$string['allowcategorythemes'] = 'కేటగిరీ నేపథ్యాలను అనుమతించండి';
$string['allowcohortthemes'] = 'సమూహాల థీమ్ లను అనుమతించు';
$string['allowcoursethemes'] = 'కోర్సు యొక్క నేపథ్యాలను అనుమతించండి';
$string['allowedemaildomains'] = 'అనుమతించబడిన ఇ మెయిల్ డొమైన్లు';
$string['allowediplist'] = 'అనుమతించబడిన ఐ.పీ. జాబితా';
$string['allowemailaddresses'] = 'ఇమెయిల్ డొమైన్లను అనుమతించబడినవి.';
$string['allowemojipicker'] = 'ఎమోజి పికర్';
$string['allowframembedding'] = 'ఫ్రేంలో పొందుపర్చడం';
$string['allowframembedding_help'] = 'బాహ్య సైట్లు ఫ్రేమ్లలో ఈ సైట్ యొక్క పొందుపరచడాన్ని అనుమతించు. ఈ ఫీచర్ ఎనేబుల్ భద్రతా కారణాల కోసం సిఫార్సు లేదు.';
$string['allowguestmymoodle'] = '';
$string['allowindexing'] = 'శోధన ఇంజిన్ల ద్వారా ఇండెక్సింగ్ని అనుమతించండి';
$string['allowindexing_desc'] = 'శోధన ఇంజిన్లను మీ సైట్కు సూచిక చేయడానికి అనుమతించాలో ఇది నిర్ణయిస్తుంది. "ఎక్కడికైనా" శోధన ఇంజిన్లను లాగిన్ మరియు సైన్అప్ పేజీలు సహా ప్రతిచోటా శోధించడానికి అనుమతిస్తుంది, అంటే ఫోర్స్ లాగిన్ తో ప్రారంభించబడిన సైట్లు ఇప్పటికీ ఇండెక్స్ చేయబడతాయి. సైన్అప్ పేజీలో వెతకడానికి స్పామ్ ప్రమాదాన్ని నివారించడానికి, "లాగిన్ మరియు సైన్అప్ పేజీలు మినహా" ప్రతిచోటా ఉపయోగించండి. "నోవేర్" సూచిక ఏ పేజీ సూచిక కాదు శోధన ఇంజిన్ చెబుతాను. ఇది సైట్ యొక్క శీర్షికలో మాత్రమే ట్యాగ్ అని గమనించండి. ఇది ట్యాగ్ను గౌరవించడానికి శోధన ఇంజిన్ వరకు ఉంది.';
$string['allowindexingeverywhere'] = 'అన్నిచోట్లా';
$string['allowindexingexceptlogin'] = 'లాగిన్ మరియు సైన్అప్ పేజీలు తప్ప ప్రతిచోటా';
$string['allowindexingnowhere'] = 'నోవేర్';
$string['allowobjectembed'] = 'EMBEDమరియుOBJECTట్యాగ్ లను అనుమతించు';
$string['allowthemechangeonurl'] = 'URL లో థీమ్ మార్పులను  అనుమతించండి';
$string['allowuserblockhiding'] = 'యూజర్లకు బ్లాకులను దాచే అనుమతి ఇవ్వు.';
$string['allowusermailcharset'] = 'యూజర్ కు తన కారెక్టరు సెట్‍ను ఎంచుకునే అనుమతి ఇవ్వు.';
$string['allowuserswitchrolestheycantassign'] = 'కేటాయింపు పాత్రలు లేకుండా వినియోగదారులను పాత్రలు మారడానికి అనుమతించు';
$string['allowuserthemes'] = 'వినియోగదారుని నేపథ్యాలను అనుమతించండి';
$string['alternativefullnameformat'] = 'ప్రత్యామ్నాయ పూర్తి పేరు ఫార్మాట్';
$string['alternativefullnameformat_desc'] = 'ఇది viewfullnames సామర్ధ్యంతో వినియోగదారులకు పేర్లు ఎలా చూపించబడుతుందో (నిర్వాహకులు, గురువు లేదా ఎడిటింగ్ కాని ఉపాధ్యాయుల పాత్రతో డిఫాల్ట్ వినియోగదారులు) ఎలా నిర్వచించాలి. "పూర్తి పేరు ఫార్మాట్" సెట్టింగులో ఉపయోగించగల ప్లేస్హోల్డర్లు.';
$string['always'] = 'ఎల్లప్పుడూ';
$string['appearance'] = 'సైట్ అప్పియరెన్స్ /సైట్ స్వరూపం';
$string['aspellpath'] = 'aspell పాత్';
$string['authentication'] = 'ప్రమాణీకరణ';
$string['authpreventaccountcreation'] = 'ప్రమాణీకరణ సమయంలో ఖాతా సృష్టించడాన్ని అడ్డుకో';
$string['authpreventaccountcreation_help'] = 'ఒక వినియోగదారు తెలియజేస్తుంది చేసినప్పుడు అసలే లేదు ఉంటే, సైట్ లో ఒక ఖాతాను ఆటోమెటిగ్గా సృష్టించారు ఉంటుంది. ఒక బాహ్య డేటాబేస్, అటువంటి LDAP వంటి, ప్రమాణీకరణ కోసం ఉపయోగించబడుతుంది, కానీ మీరు మాత్రమే ఉన్న ఖాతాతో వినియోగదారులకు సైట్ యాక్సెస్ పరిమితం అనుకుంటున్నారా ఉంటే, అప్పుడు ఈ ఐచ్చికం చేతనం చేయాలి. కొత్త ఖాతాల మానవీయంగా లేదా వినియోగదారులు ఫీచర్ అప్లోడ్ ద్వారా రూపొందించినవారు ఉంటుంది. ఈ సెట్టింగ్ MNET ప్రమాణీకరణ వర్తించదు గమనించండి.';
$string['authsettings'] = 'ప్రామాణీకరణను  నిర్వహించు';
$string['autolang'] = 'భాషను ఆటోమాటిగ్గా గుర్తించు';
$string['autologinguests'] = 'అతిథులను ఆటోమాటిగ్గా లాగిన్ చెయ్యి';
$string['availableto'] = 'అందుబాటులో ఉన్నవారు:';
$string['backgroundcolour'] = 'పారదర్శక రంగు';
$string['backup_shortname'] = 'బ్యాకప్ ఫైల్ పేరులో  కోర్సు పేరు ఉపయోగించండి';
$string['backup_shortnamehelp'] = 'బ్యాకప్ ఫైల్ పేరులో భాగంగా కోర్సు పేరు ఉపయోగించండి.';
$string['backups'] = 'బ్యాకప్పులు';
$string['badwordsconfig'] = 'చెడుమాటలను, కామాతో విడదీస్తూ, ఇవ్వండి. ';
$string['badwordsdefault'] = 'కస్టమ్ జాబితా ఖాళీగా ఉంటే, భాష ప్యాక్ నుండి ఒక డిఫాల్ట్ జాబితా ఉపయోగపడుతుంది.';
$string['badwordslist'] = 'కస్టమ్ చెడు పదాలు జాబితా';
$string['blockediplist'] = 'నిరోధిత ఐపీల జాబితా';
$string['blockinstances'] = 'సందర్భాలు';
$string['blockmultiple'] = 'బహుళ';
$string['blockprotect'] = 'సందర్భాలను రక్షించండి';
$string['blockprotect_help'] = 'మీరు బ్లాక్ యొక్క ఒక నిర్దిష్ట రకం లాక్, అప్పుడు ఎవరూ సందర్భాల్లో జోడించడానికి లేదా తొలగించడానికి చేయగలరు. (మీరు, కోర్సు యొక్క, మీరు సందర్భాల్లో సవరించడానికి అవసరమైతే మళ్లీ అన్లాక్ చేయవచ్చు.)

ఈ అనుకోకుండా తొలగించిన ఉంటే తిరిగి పొందడానికి కష్టంగా ఇది నావిగేషన్ మరియు సెట్టింగులను వంటి బ్లాక్స్ కాపాడటానికి ఇది ఉద్దేశించబడింది.';
$string['blocksettings'] = 'బ్లాకులను నిర్వహించు';
$string['blockunprotect'] = 'అరక్షితమైన';
$string['bloglevel'] = 'బ్లాగు దృశ్యత';
$string['bookmarkadded'] = 'పేజీకను చేర్చాం';
$string['bookmarkalreadyexists'] = 'ఈ పేజీకి మీరీసరికే పేజీకను పెట్టారు.';
$string['bookmarkdeleted'] = 'పేజీకను తొలగించాం.';
$string['bookmarkthispage'] = 'ఈ పేజీకి పేజీక పెట్టు';
$string['cacheapplication'] = 'అప్లికేషన్ క్యాచీ';
$string['cacheapplicationhelp'] = 'అంశాలు అన్ని వినియోగదారుల మధ్య పంచబడును మరియు ఒక TTL గడువు నిర్ణయించబడుతుంది.';
$string['cachejs'] = 'జావాస్క్రిప్టును కాషె చెయ్యి';
$string['cachejs_help'] = 'జావాస్క్రిప్ట్ చేజింగ్ మరియు కుదింపు గొప్పగా పేజీ లోడ్ పనితీరును మెరుగుపరుస్తుంది. అది గట్టిగా ఉత్పత్తి సైట్లు మద్దతిస్తుంది. డెవలపర్లు బహుశా ఈ ఫీచర్ డిసేబుల్ అనుకుంటున్నారా ఉంటుంది.';
$string['cacherequest'] = 'కాషెను అభ్యర్థించండి';
$string['cacherequesthelp'] = 'అభ్యర్థన పూర్తి అయినప్పుడు వినియోగదారు నిర్దిష్ట కాషె  గడువు ముగుస్తుంది. మనం స్టాటిక్ స్టోర్స్ ఉపయోగిస్తున్న ప్రాంతాల స్థానంలో రూపొందించబడింది.';
$string['cachesession'] = 'సెషన్ కాషె';
$string['cachesessionhelp'] = 'వినియోగదారు యొక్క సెషన్ ముగుస్తుంది ఉన్నప్పుడు గడువు ఆ వాడుకరి ప్రత్యేక కాష్. సెషన్ ఉబ్బు / జాతి తగ్గించడానికి రూపొందించిన.';
$string['cachesettings'] = 'కాషె యొక్క సెట్టింగులు.';
$string['caching'] = 'కాషింగ్';
$string['calendar_weekend'] = 'వారాంతపు రోజులు';
$string['calendarexportsalt'] = 'క్యాలెండర్ ఎగుమతి సాల్ట్';
$string['calendarsettings'] = 'క్యాలెండరు';
$string['calendartype'] = 'క్యాలెండర్ టైప్';
$string['calendartype_desc'] = 'మొత్తం సైట్ కోసం ఒక డిఫాల్ట్ క్యాలెండర్ రకం ఎంచుకోండి. ఈ సెట్టింగ్ కోర్సు సెట్టింగ్లు లేదా వారి వ్యక్తిగత ప్రొఫైల్ వినియోగదారులు విస్మరించవచ్చు.';
$string['cannotdeletemodfilter'] = 'మీరు  \'{$ a-> filter}\'ను అన్ఇన్స్టాల్ చేయలేరు అది \'{$ a-> module}\' మాడ్యూల్లో భాగంగా ఉంది.';
$string['cannotuninstall'] = '{$a} అన్ఇన్స్టాల్ సాధ్యం కాదు.';
$string['categoryemail'] = 'ఇమెయిల్';
$string['cfgwwwrootslashwarning'] = 'మీరు మీ config.php ఫైల్ లో తప్పుగా> wwwroot $ CFG- నిర్వచించారు. మీరు చివరిలో ఒక \'/\' పాత్ర ఉన్నాయి. దాన్ని తొలగించి, లేదా మీరు <a href=\'http://tracker.moodle.org/browse/MDL-11061\'> MDL-11061 </a> వంటి వింత దోషాలు సాధించగలదు దయచేసి.';
$string['cfgwwwrootwarning'] = 'మీరు మీ config.php ఫైల్ లో తప్పుగా> wwwroot $ CFG- నిర్వచించారు. ఇది మీరు ఈ పేజీ ప్రాప్తి చేయడానికి ఉపయోగిస్తున్నారు URL సరిపోలడం లేదు. అది సరి, లేదా మీరు <a href=\'http://tracker.moodle.org/browse/MDL-11061\'> MDL-11061 </a> వంటి వింత దోషాలు సాధించగలదు దయచేసి.';
$string['change'] = 'మార్చు';
$string['checkboxno'] = 'వద్దు';
$string['checkboxyes'] = 'ఔను';
$string['choosefiletoedit'] = 'సవరించే దస్త్రాన్ని ఎంచుకోండి';
$string['cleanup'] = 'శుద్ధిచెయ్యి';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'లోపం దొర్లింది, "{$a->option}" కు బదులు "{$a->value}" అనే తప్పు విలువ ఇచ్చారు';
$string['cliincorrectvalueretry'] = 'తప్పు విలువ, మళ్ళీ ప్రయత్నించండి';
$string['clistatusdisabled'] = 'స్థితి: అచేతనంగా ఉంది';
$string['clistatusenabled'] = 'స్థితి: చేతనంగా ఉంది';
$string['clistatusenabledlater'] = 'స్థితి: CLI నిర్వహణ మోడ్ ప్రారంభించబడుతుంది {$ a}';
$string['clitypevalue'] = 'విలువను టైపించండి';
$string['clitypevaluedefault'] = 'విలువను టైపించండి, డిఫాల్టు విలువ ({$a}) ను ఇచ్చేందుకు ఎంటరును నొక్కండి';
$string['cliunknowoption'] = 'Unrecognised ఎంపికలు:
  {$a}
దయచేసి --help ఎంపికను ఉపయోగించండి.';
$string['cliupgradefinished'] = 'కమాండ్ లైన్ నవీకరణ విజయవంతంగా పూర్తయింది.';
$string['cliupgradenoneed'] = 'ఇన్స్టాల్ వెర్షన్ {$ a} కు ఎటువంటి  నవీకరణ  అవసరం లేదు. ఏమైనప్పటికీ ధన్యవాదాలు!';
$string['cliyesnoprompt'] = 'y (అంటే ఔనని) గానీ, n (అంటే వద్దని) గానీ నొక్కండి';
$string['commentsperpage'] = 'ఒక్కో పేజీకి చూపించే వ్యాఖ్యలు';
$string['commonactivitysettings'] = 'సామాన్య సెట్టింగులు';
$string['commonfiltersettings'] = 'సామాన్య వడపోత సెట్టింగులు';
$string['commonsettings'] = 'సామాన్య సెట్టింగులు';
$string['componentinstalled'] = 'కాంపొనెంటును స్థాపించాం';
$string['computedfromlogs'] = '{$ A} నుండి లాగ్లను లెక్కించబడుతుంది.';
$string['condifmodeditdefaults'] = 'ఇక్కడ సెట్ చేయు విలువలు మీరు ఒక కొత్త కార్యాచరణ సృష్టించడానికి మీరు సూచించే సెట్టింగులు ఉపయోగించే డిఫాల్ట్ విలువలు.';
$string['confeditorhidebuttons'] = 'HTML ఎడిటర్ లో దాచి ఉండాలి బటన్లు ఎంచుకోండి.';
$string['configallcountrycodes'] = 'ఈ ఒక యూజర్ యొక్క ప్రొఫైల్ ఉదాహరణకు, వివిధ ప్రదేశాల్లో ఎంపిక కావచ్చు దేశాల జాబితా. ఖాళీ (డిఫాల్ట్) ప్రామాణిక ఆంగ్ల భాష ప్యాక్ లో countries.php జాబితా ఉపయోగిస్తారు ఉంటే. ఆ ISO 3166-1 నుండి జాబితా. లేకపోతే, మీరు, ఉదాహరణకు \'GB, FR, ES\' సంకేతాలు కామాతో వేరుపరచబడిన జాబితా\'లో పేర్కొనవచ్చు. మీరు ఇక్కడ కొత్త, కాని ప్రామాణిక సంకేతాలు జోడిస్తే, మీరు \'en\' మరియు మీ భాష ప్యాక్ లో countries.php వాటిని జోడించడానికి అవసరం.';
$string['configallowassign'] = 'మీరు ఎడమ వైపు పాత్రలు వ్యక్తులకు ఇతర వ్యక్తులు కాలమ్ పాత్రలు కొన్ని కేటాయించి అనుమతిస్తుంది';
$string['configallowattachments'] = 'ప్రారంభించబడి ఉంటే, సైట్ నుండి పంపిన ఇమెయిల్స్ బ్యాడ్జ్ల వంటి అటాచ్మెంట్లను కలిగి ఉంటాయి.';
$string['configallowcategorythemes'] = 'మీరు ఈ ప్రారంభిస్తే, అప్పుడు థీమ్స్ వర్గం స్థాయి సెట్ చేయవచ్చు. వారు ప్రత్యేకంగా వారి స్వంత థీమ్ సెట్ తప్ప ఈ అన్ని పిల్లల కేతగిరీలు మరియు కోర్సులు ప్రభావితం చేస్తుంది. హెచ్చరిక: సమర్ధించే వర్గం థీమ్స్ పనితీరును ప్రభావితం చేయవచ్చు.';
$string['configallowcoursethemes'] = 'మీరు ఇది అనుమతిస్తే, అప్పుడు కోర్సులు తమ సొంత థీమ్స్ అమర్చుటకు అనుమతించబడుతుంది. కోర్సు థీమ్స్ అన్ని ఇతర థీమ్ ఎంపికలను (సైట్, వినియోగదారు, లేదా సెషన్ థీమ్స్)  ఓవర్ రైడ్ చేయవచ్చు';
$string['configallowedemaildomains'] = 'అవుట్గోయింగ్ ఇమెయిల్లో "ఫ్రమ్" విభాగంలో వెల్లడి చేయటానికి అనుమతించబడే జాబితా ఇమెయిల్ డొమైన్లు. "ఖాళీ" యొక్క అప్రమేయం అన్ని అవుట్గోయింగ్ ఇమెయిల్లకు నో-ప్రత్యుత్తర చిరునామాను ఉపయోగిస్తుంది. వైల్డ్కార్డ్లను ఉపయోగించడం ఉదా. * .example.com example.com యొక్క సబ్డొమైన్ నుండి పంపిన ఇమెయిళ్ళను అనుమతిస్తుంది, కాని example.com కాదు. దీనికి ప్రత్యేక ఎంట్రీ అవసరం.';
$string['configallowemailaddresses'] = 'కొత్త ఈమెయిలు అడ్రసులు కొన్ని డొమెయిన్లకు మాత్రమే పరిమితమై ఉండాలని మీరు భావిస్తే, వాటిని ఇక్కడ ఇవ్వండి. అడ్రసుల మధ్య ఒక ఖాళీ ఉంచి ఇవ్వండి. ఇక్కడ ఇచ్చిన డొమయిన్న్లు కాక మిగతా అన్ని డొమెయిన్లు తిరస్కరించబడతాయి.ఉపడొమెయిన్లను అనుమతించేందుకు, ముందు ఒక ’.’ పెట్టి ఇవ్వండి. ఉదా: <strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = 'ఎనేబుల్ అతిథులు డాష్బోర్డ్ యాక్సెస్ చేయవచ్చు ఉంటే, లేకపోతే అతిథులు సైట్ ముందు పేజీకి మళ్లించే.';
$string['configallowobjectembed'] = 'ఒక డిఫాల్ట్ భద్రతా చర్యగా, సాధారణ వినియోగదారులు (ఇది ఇప్పటికీ సురక్షితంగా mediaplugins వడపోత ఉపయోగించి చేయవచ్చు అయితే) వారి HTML లో స్పష్టమైన పొందుపరిచి వస్తువును టాగ్లు ఉపయోగించి పాఠ్యాంశాల్లో (ఫ్లాష్ వంటి) మల్టీమీడియా పొందుపరచడానికి అనుమతి లేదు. మీరు అనుమతిస్తాయి అనుకుంటే ఈ టాగ్లు అప్పుడు ఈ ఎంపికను ఎనేబుల్.';
$string['configallowoverride'] = 'మీరు ఎడమ వైపు పాత్రలలో ప్రజలు కాలమ్ పాత్రలు కొన్ని భర్తీ చేయడానికి చేయవచ్చు';
$string['configallowoverride2'] = 'భర్తీ లేదా సామర్ధ్యం మూడ్లె / పాత్ర: safeoverride అనుమతించింది. ఇది పాత్ర (లు) ఎంచుకోండి ఈ సెట్టింగులను మాత్రమే సామర్ధ్యం మూడ్లె / పాత్ర గాని కలిగిన వినియోగదారులు వర్తించే ఎడమ కాలమ్ <br /> గమనిక లో ప్రతి పాత్ర ద్వారా భర్తీ చేయవచ్చు.';
$string['configallowswitch'] = 'ఒక వినియోగదారు వారు ఇప్పటికే ఉన్న పాత్రలను ఆధారంగా, కు మారవచ్చు పాత్రలు ఎంచుకోండి. ఈ పట్టిక లో ఒక ఎంట్రీ పాటు, ఒక వినియోగదారు మూడ్లె / పాత్ర కలిగి ఉండాలి: switchroles సామర్ధ్యం మారగలగడానికి దానిని మూడ్లె / కోర్సు ఆ పాత్రలు మారడం మాత్రమే సాధ్యం అని <br /> గమనిక:. వీక్షణ సామర్ధ్యం మరియు ఆ మూడ్లె / సైట్ లేదు: doanything సామర్ధ్యం, కాబట్టి ఈ పట్టికలో కొన్ని కాలమ్స్ నిలిపివేయబడ్డాయి.';
$string['configallowthemechangeonurl'] = 'ప్రారంభించబడితే, థీమ్ జోడించడం ద్వారా మార్చవచ్చు గాని? <br /> థీమ్ = ఏ మూడ్లె URL కు themename (ఉదా: mymoodlesite.com/?theme=afterburner) లేదా <br /> & థీమ్ = ఏ అంతర్గత మూడ్లె URL కు themename (ఉదా: mymoodlesite.com/course/view.php?id=2&theme=afterburner).';
$string['configallowuserblockhiding'] = 'మీరు వినియోగదారులు ఈ సైట్ అంతటా / షో వైపు బ్లాక్స్ దాచడానికి అనుమతిస్తాయి అనుకుంటున్నారా? ఈ ఫీచర్ ప్రతి ధ్వంసమయ్యే బ్లాక్ రాష్ట్ర గుర్తుంచుకోవడానికి Javascript మరియు కుకీలను ఉపయోగిస్తుంది మరియు వినియోగదారు యొక్క సొంత వీక్షణ ప్రభావితం చేస్తుంది.';
$string['configallowusermailcharset'] = 'ప్రారంభించబడితే, వినియోగదారులు వారి మెసేజింగ్ ప్రాధాన్యతలలో ఒక ఇమెయిల్ అక్షర సమితిని ఎంచుకోవచ్చు.';
$string['configallowuserswitchrolestheycantassign'] = 'డిఫాల్ట్, మూడ్లె / పాత్ర ద్వారా: వినియోగదారులు పాత్రలు మారడం కోసం అవసరం కేటాయించవచ్చు. ఈ సెట్టింగ్ని ప్రారంభించడం ఈ అవసరాన్ని తొలగిస్తుంది, మరియు అందుబాటులో పాత్రల్లో ఫలితాలు డౌన్ మెను మాత్రమే "పాత్ర పనులను అనుమతించండి" పట్టిక సెట్టింగులు ద్వారా సంకల్పం "స్విచ్ పాత్ర".
ఇది "పాత్ర పనులను అనుమతించు" పట్టికలో సెట్టింగులను వినియోగదారులు వారి ఇప్పటికే పాత్ర కంటే ఎక్కువ సామర్థ్యాలతో ఒక పాత్ర మారడానికి అనుమతిస్తుంది లేదు మద్దతిస్తుంది.';
$string['configallowuserthemes'] = 'మీరు ఈ ప్రారంభిస్తే, వినియోగదారులు వారి స్వంత నేపథ్యాలు సెట్ అనుమతించబడతారు. వాడుకరి ధీమ్స్ సైట్ థీమ్స్ (కానీ కోర్సు నేపథ్యాలు)';
$string['configallusersaresitestudents'] = 'సైట్ యొక్క మొదటి పేజీలో కార్యక్రమాలకోసం యూజర్లు విద్యార్థులు భావించవచ్చు? మీరు సమాధానం "అవును", అప్పుడు ఏ ధ్రువీకరించారు యూజర్ ఖాతా ఆ కార్యకలాపాలు లో ఒక విద్యార్థి పాల్గొనేందుకు అనుమతించబడతారు. మీరు సమాధానం ఉంటే "నో", అప్పుడు కనీసం ఒక కోర్సు లో ఇప్పటికే ఒక అభ్యర్థి ఎవరు వినియోగదారులు మాత్రమే ఆ ముందు పేజీ కార్యకలాపాలలో పాల్గొనడానికి చెయ్యగలరు. మాత్రమే నిర్వాహకులు మరియు ప్రత్యేకంగా కేటాయించిన ఉపాధ్యాయులు ఈ ముందు పేజీ కార్యకలాపాలకు ఉపాధ్యాయులు పనిచేస్తుంది.';
$string['configauthenticationplugins'] = 'మీరు ఉపయోగించడానికి మరియు failthrough వీరిని ఏర్పాట్లు అనుకుంటున్నారా ప్లగిన్లు ప్రమాణీకరణ ఎంచుకోండి.';
$string['configautolang'] = 'బ్రౌజరు ద్వారా డిఫాల్టు భాషను గుర్తించు. దీన్ని అచేతనం చేస్తే సైటు డిఫాల్టు విలువను వాడుతుంది.';
$string['configautologinguests'] = 'అతిథులుగా కోర్సుల్లోకి ప్రవేశించేవారిని ఆటోమాటిగ్గా అతిథులుగా లాగిన్ చెయ్యాలా?';
$string['configbloglevel'] = 'ఈ సెట్టింగ్ మీరు యూజర్ బ్లాగులు ఈ సైట్ చూడవచ్చు స్థాయి పరిమితం చేయడానికి అనుమతిస్తుంది. వారు కాదు వ్యూయర్ పోస్టర్ లేదా బ్లాగ్ పోస్ట్ రకాలు గరిష్ట సందర్భంలో పేర్కొనాలి గమనించండి. మీరు అన్ని వద్ద వాటిని వద్దు ఉంటే బ్లాగులు కూడా పూర్తిగా నిలిపివేయడం చేయవచ్చు.';
$string['configcalendarcustomexport'] = 'క్యాలెండర్ యొక్క కస్టమ్ తేదీ పరిధి ఎగుమతి ప్రారంభించు';
$string['configcalendarexportsalt'] = 'ఈ అనుకోని టెక్స్ట్ క్యాలెండర్ల ఎగుమతి ఉపయోగిస్తారు ప్రమాణీకరణ టోకెన్ల భద్రతా అభివృద్ధి కోసం ఉపయోగిస్తారు. మీరు ఈ హాష్ ఉప్పు మార్చుకుంటే అన్ని ప్రస్తుత టోకెన్ల ఆమోదయోగ్యం గమనించండి.';
$string['configcookiesecure'] = 'సర్వర్ మాత్రమే HTTPS సంబంధాలు అంగీకరించడం ఉంటే అది సురక్షిత కుకీలను పంపడం ఎనేబుల్ మద్దతిస్తుంది. ప్రారంభించబడితే వెబ్ సర్వర్ http అంగీకరించడం లేదు నిర్ధారించుకోండి: // లేదా https శాశ్వత మళ్లింపును ఏర్పాటు: // చిరునామా. చేసినప్పుడు <em> wwwroot </ em> చిరునామా https ప్రారంభం లేదు: // ఈ సెట్టింగ్ స్వయంచాలకంగా ఆపివేయబడింది.';
$string['configcountry'] = 'మీరు ఇక్కడ ఒక దేశం సెట్ ఉంటే, అప్పుడు ఈ దేశం కొత్త వాడుకరి ఖాతాలను డిఫాల్ట్గా ఎంచుకుంటారు. ఒక దేశం ఎంచుకోవడానికి బలవంతంగా, కేవలం ఈ సెట్ చేయకుండా వదిలి.';
$string['configcourseoverviewfilesext'] = 'అనుమతి కోర్సు సారాంశం ఫైళ్లు పొడిగింపులు యొక్క కామాతో వేరుపరచబడిన జాబితా\'లో.';
$string['configcourseoverviewfileslimit'] = 'ఒక కోర్సు సారాంశానికి జోడించే ఫైళ్లు గరిష్ట సంఖ్య.';
$string['configcourserequestnotify'] = 'కొత్త కోర్సు అభ్యర్థించిన వినియోగదారు టైప్ వాడుకరిపేరు తెలియజేయబడుతుంది.';
$string['configcourserequestnotify2'] = 'ఏదైనా కొత్త కోర్సు కావాలని అభ్యర్ధన వస్తే, ఈ వాడుకరులకు తెలియజేయబడుతుంది. కోర్సు అభ్యర్ధనలను ఆమోదించే అనుమతులు కలిగిన వాడుకరులు మాత్రమే ఈ జాబితాలో ఉంటారు.;';
$string['configcoursesperpage'] = 'ఎంటర్ కోర్సుల సంఖ్య ఒక కోర్సు ఫ్లాగింగ్ పేజీకి ప్రదర్శించబడుతుంది.';
$string['configcourseswithsummarieslimit'] = 'కోర్సులు గరిష్ట సంఖ్య సరళమైన ధన్యవాదాలు తిరిగి పడే ముందు సంగ్రహాలను సహా ఒక కోర్సు ఫ్లాగింగ్ ప్రదర్శించడానికి.';
$string['configcronclionly'] = 'ఒక వెబ్ బ్రౌజర్ నుండి క్రాన్ రన్నింగ్ అజ్ఞాత వాడుకరులను విశేష సమాచారం బహిర్గతం చేయవచ్చు. అందువలన ఇది మాత్రమే కమాండ్ లైన్ నుండి క్రాన్ అమలు చేయడానికి సిఫార్సు లేదా రిమోట్ యాక్సెస్ కోసం ఒక క్రాన్ పాస్వర్డ్ను సెట్.';
$string['configcronremotepassword'] = 'ఈ cron.php స్క్రిప్ట్ URL క్రింది ఫారమ్ను ఉపయోగించి పాస్వర్డ్ను సరఫరా లేకుండా ఒక వెబ్ బ్రౌజర్ నుండి అమలు కాదని అర్థం: <pre>
    http://site.example.com/admin/cron.php?password=opensesame
</pre> ఈ ఖాళీగా ఉంటే, పాస్వర్డ్ అవసరమవుతుంది.';
$string['configcurlcache'] = 'సెకన్లలో cURL cache కొరకు సమయాన్ని నిర్ధారించండి';
$string['configcustommenuitems'] = 'థీమ్ల ద్వారా చూపించటానికి మీరు ఇక్కడ ఒక అనుకూల మెనుని కన్ఫిగర్ చేయవచ్చు. ప్రతి లైనులో కొన్ని మెను టెక్స్ట్, లింక్ URL (ఐచ్చిక), టూల్టిప్ టైటిల్ (ఐచ్చిక) మరియు భాష కోడ్ లేదా కామాతో వేరు చేయబడిన సంకేతాల జాబితా (ఐచ్ఛికం, పేర్కొన్న భాష యొక్క వినియోగదారులకు లైన్ ప్రదర్శించడానికి మాత్రమే), పైపు అక్షరాలు. ఒక హైఫన్తో ప్రారంభమయ్యే లైన్లు మునుపటి ఉన్నత స్థాయి మెనూలో మెను ఐటెమ్లుగా కనిపిస్తాయి మరియు డివైడర్లు అవసరమయ్యే ఒకటి లేదా అంతకంటే ఎక్కువ # అక్షరాల లైన్ను జోడించడం ద్వారా ఉపయోగించవచ్చు. ఉదాహరణకి:
<Pre>
Moodle కమ్యూనిటీ | https: //moodle.org
-Moodle ఉచిత మద్దతు | https: //moodle.org/support
-Moodle డాక్స్ | http: //docs.moodle.org | మూడో డాక్స్
-జర్మన్ Moodle డాక్స్ | http: //docs.moodle.org/de | జర్మన్ లో |
- ###
-మడ్డీ అభివృద్ధి | https: //moodle.org/development
Moodle.com | http: //moodle.com/
</ Pre>';
$string['configcustomusermenuitems'] = 'మీరు (స్వయంచాలకంగా జోడించిన ఇది లాగ్ అవుట్ లింక్ మినహా) యూజర్ మెను యొక్క కంటెంట్లను ఆకృతీకరించవచ్చు. "Langstringname, componentname" రూపంలో లేదా ఒక PIX ఐకాన్ లేదా ఒక URL గాని సాదా టెక్స్ట్, 2) ఒక URL, మరియు 3) ఒక ఐకాన్) ఒక స్ట్రింగ్ పాత్రలు మరియు 1 కలిగి | ప్రతి లైన్ వేరు. Dividers అవసరమయ్యే చోట ఒకటి లేదా ఎక్కువ # అక్షరాలు ఒక లైన్ జోడించడం ద్వారా ఉపయోగించవచ్చు';
$string['configdbsessions'] = 'ప్రారంభించబడితే, ఈ సెట్టింగ్ ప్రస్తుత సెషన్స్ గురించి సమాచారాన్ని నిల్వ డేటాబేస్ ఉపయోగిస్తుంది. ఇప్పుడు ఈ సెట్టింగ్ని మార్చడాన్ని (మీరు సహా) ప్రస్తుత వినియోగదారులు లాగ్ అవుట్ గమనించండి. మీరు MySQL వాడుతుంటే my.cnf (లేదా my.ini) లో \'max_allowed_packet\' కనీసం 4M అని నిర్ధారించుకోండి. ఇతర సెషన్ డ్రైవర్లు config.php నేరుగా అమర్చవచ్చు, మరింత సమాచారం కోసం config-dist.php చూడండి. మీరు config.php ఫైల్ లో సెషన్ డ్రైవర్ పేర్కొనండి ఉంటే ఈ ఐచ్చికము అదృశ్యమవుతుంది.';
$string['configdebug'] = 'మీరు ఇది ఆన్ చేస్తే, PHP యొక్క error_reporting పెంచబడుతుంది. దాంతో మరింత హెచ్చరికలు  ముద్రించబడుతాయి. ఇది కేవలం డెవలపర్లకు మాత్రమే ఉపయోగపడుతుంది.';
$string['configdebugdisplay'] = 'ఇది ఆన్  చేస్తే, ఎర్రర్ రిపోర్టింగ్ HTML పేజీకి వెళతారు. ఇది అనుసరణీయం, కానీ సాధారణంగా XHTML, JS, కుకీలను మరియు HTTP పీఠికలను తొలగిస్తుంది. ఇది ఆఫ్ చేస్తే, మీ సర్వర్ లాగ్ కు అవుట్పుట్ పంపుతుంది. ఇది మేలైన డీబగ్గింగ్ ని సమ్మతిస్తుంది, PHP సెట్టింగ్ error_log ద్వార ఏ లాగ్ ఎక్కడ వెళ్ళాలో నియంత్రించవఛ్చు.';
$string['configdebugpageinfo'] = 'పేజీ సమాచారం ఆ పేజీ పాదంలో ప్రచురించాలనుకుంటే దీన్ని చేతనం చెయ్యండి';
$string['configdebugvalidators'] = 'మీరు పేజీ ఫుటరు లో బాహ్య వ్యాలిడేటర్కు సర్వర్లు లింక్లను కలిగి అనుకుంటే ఎనేబుల్. మీరు యూజర్ పేరు <em> w3cvalidator </ em> కొత్త యూజర్ సృష్టించడానికి, మరియు అతిథిగా ఎనేబుల్ చెయ్యాల్సి ఉంటుంది. ఈ మార్పులు ఉత్పత్తి సైట్లలో ఎనేబుల్ లేదు, సర్వర్కు అనధికార యాక్సెస్ అనుమతించే అవకాశం!';
$string['configdefaulthomepage'] = 'లాగినైన వాడుకరుల హోమ్ పేజీ ఎలా ఉండాలో ఇది నిర్ణయిస్తుంది';
$string['configdefaultrequestcategory'] = 'వాడుకరులు అడిగిన కొత్త కోర్సులు ఆటోమాటిగ్గా ఈ వర్గంలోకి చేరతాయి.';
$string['configdefaultrequestedcategory'] = 'ఆమోదించబడితే, అభ్యర్థించిన కోర్సులను  Default వర్గములొకి ఉంచాలి.';
$string['configdefaultuserroleid'] = 'మీరు లాగిన్ చేసిన పాత్రల యొక్క సామర్థ్యాలను సైట్ స్థాయి వద్ద, ADDITION లో వారు ఇచ్చిన ఏ ఇతర పాత్రలకు అయినా అందించిన అన్ని సామర్థ్యాలకు వినియోగదారులకు లాగిన్ చేయబడుతుంది. అప్రమేయత గల వినియోగదారు పాత్ర అప్రమేయం. మీరు సామర్థ్యాలను నిషేధించకపోతే ఇది ఇతర పాత్రలతో విభేదించబడదని గమనించండి, ఇది అన్ని వినియోగదారులకు కోర్సు స్థాయిలో కేటాయించలేని సామర్థ్యాలు (ఉదా. పోస్ట్ బ్లాగ్ ఎంట్రీలు, సొంత క్యాలెండర్ను నిర్వహించడం మొదలైనవి) అని నిర్ధారిస్తుంది.';
$string['configdeleteincompleteusers'] = 'ఈ కాలం తర్వాత, పాతవి పూర్తిగా సెటప్ కాని ఖాతాలు తొలగించబడతాయి';
$string['configdeleteunconfirmed'] = 'మీరు ఇమెయిల్ ధృవీకరణ ఉపయోగిస్తుంటే, ఈ లోపల కాలంలో, వినియోగదారుల  యొక్క స్పందన అంగీకరించబడుతుంది. ఈ కాలం తర్వాత, పాత ధ్రువీకరించని ఖాతాలు తొలగించబడతాయి.';
$string['configdenyemailaddresses'] = 'ప్రత్యేక డొమైన్ నుండి ఇమెయిల్ చిరునామాలను కాదనడానికి, ఇక్కడ అదే విధంగా వాటిని జాబిత  చేయండి. అన్ని ఇతర డొమైన్ లు అంగీకరించబడతాయి. ఉప డొమైన్లను కాదనడానికి \'.\' జోడించండి . ఉదా <strong>hotmail.com yahoo.co.uk. live.com</strong>';
$string['configdisableuserimages'] = 'వాడుకరులు తమ ప్రవర బొమ్మలను మార్చుకునే వీలును అచేతనం చెయ్యి';
$string['configdisplayloginfailures'] = 'విఫలమైన లాగిన్ గురించి ఎంపికయిన వినియోగదారులకు సమాచారాన్ని ప్రదర్శిస్తుంది';
$string['configdndallowtextandlinks'] = 'ప్రారంభించు లేదా ఫైళ్ళను డ్రాగ్ మరియు తగ్గిపోయిందని పాటు, ఒక కోర్సు పేజీ లో డ్రాగింగ్ మరియు టెక్స్ట్ మరియు లింకులు జారవిడిచిన సాధ్యం. Firefox లేదా వివిధ బ్రౌజర్లలో మధ్య టెక్స్ట్ లాగి అవిశ్వసనీయ గమనించండి మరియు డేటా అప్లోడ్, లేదా పాడైన టెక్స్ట్ అప్లోడ్ అవుతోంది దారితీయవచ్చు.';
$string['configdoclang'] = 'ఈ భాష డాక్యుమెంటేషన్ పేజీలకు లింకులు ఉపయోగించబడుతుంది.';
$string['configdocroot'] = 'ప్రతి పేజీ యొక్క ఫుటరు లింకులు \'ఈ పేజీకి మూడ్లె డాక్స్\' ద్వారా సందర్భం నిర్దిష్ట డాక్యుమెంటేషన్ అందించడం కోసం మూడ్లె డాక్స్ మార్గం నిర్వచిస్తుంది. ఫీల్డ్ ఖాళీగా వదిలేస్తే, లింకులు ప్రదర్శించబడుతుంది కాదు.';
$string['configdoctonewwindow'] = 'దీన్ని చేతనం చేస్తే, Moodle Docs యొక్క లింకులు వేరే విండోలో చూపబడతాయి.';
$string['configeditordictionary'] = 'సొంత భాష కోసం నిఘంటువు లేని Aspell వినియోగదారులకు   ఈ విలువ ఉపయోగించబడుతుంది.';
$string['configeditorfontlist'] = 'ఎడిటర్ యొక్క డ్రాప్ డౌన్ జాబితాలో కనిపించే  ఆ ఫాంట్లు ను ఎంపిక చేయి';
$string['configemailchangeconfirmation'] = 'వాడుకరులు తమ ప్రవరలోని ఈమెయిలు అడ్రసును మార్చుకునేటపుడు ఈమెయిలు నిర్ధారణ ఆవశ్యకం.';
$string['configemailfromvia'] = 'అవుట్గోయింగ్ ఇమెయిల్లో "ఫ్రం" విభాగంలో సమాచారాన్ని జోడించండి. ఇది ఈ ఇమెయిల్ నుండి వచ్చిన ఇమెయిల్ గ్రహీతకు తెలియచేస్తుంది మరియు యుద్ధ గ్రహీతలు అనుకోకుండా ఏ-సమాధానం లేని ఇమెయిల్ చిరునామాలకు సమాధానం ఇవ్వడానికి కూడా సహాయపడుతుంది.';
$string['configenableblogs'] = 'ఈ స్విచ్ వల్ల యావత్తు సైట్ వినియోగదారుల కు సొంత బ్లాగు కల్పిస్తుంది.';
$string['configenablecalendarexport'] = 'క్యాలెండర్ల ఎగుమతిని, క్యాలెండర్ల చందానూ చేతనం చెయ్యి.';
$string['configenablecomments'] = 'వ్యాఖ్యలను చేతనం చెయ్యి';
$string['configenablecourserequests'] = 'ఇది ఏ వాడుకరి అయినా కొత్త కోర్సులను సృష్టించమని అడిగే వీలును కలిగిస్తుంది.';
$string['configenabledevicedetection'] = 'థీమ్లు మరియు ఇతర లక్షణాల అప్లికేషన్ కోసం మొబైల్, స్మార్ట్ఫోన్లు, ట్యాబ్లెట్ లు లేదా డిఫాల్ట్ పరికరాలు (డెస్క్టాప్ PC లు, ల్యాప్టాప్లు, etc) ల  గుర్తింపును అనుమతిస్తుంది.';
$string['configenablemobilewebservice'] = 'అడిగినవారికి అధికారిక మూడ్లె అనువర్తనం లేదా ఇతర అనువర్తనం కోసం మొబైల్ సేవను ప్రారంభించండి. మరింత సమాచారం కోసం, చదవడానికి {$ a}';
$string['configenablerssfeeds'] = 'ప్రారంభించబడితే, RSS ఫీడ్లు వంటి బ్లాగులు, ఫోరమ్లు, డేటాబేస్ కార్యకలాపాలు మరియు తాత్పర్యాలు సైట్ అంతటా వివిధ లక్షణాలు, వెలువడతాయి. RSS కూడా ప్రత్యేక సూచించే గుణకాలు కోసం ప్రారంభించవలసిన అవసరం ఫీడ్లు గమనించండి.';
$string['configenablerssfeedsdisabled'] = 'RSS ఫీడ్లు అన్ని సైట్ లో నిలిపివేయబడ్డాయి ఎందుకంటే ఇది అందుబాటులో లేదు. వాటిని ఎనేబుల్ చెయ్యడానికి, అడ్మిన్ ఆకృతీకరణ కింద వేరియబుల్స్ సెట్టింగులను వెళ్ళండి.';
$string['configenablerssfeedsdisabled2'] = 'RSS ఫీడ్లు సర్వర్ స్థాయిలో ఆపివేయబడ్డాయి. మీరు మొదటి సర్వర్ / RSS వాటిని ఎనేబుల్ చెయ్యాలి.';
$string['configenablestats'] = 'మీరు ఇక్కడ \'అవును\' ఎంచుకుంటే, మూడ్ల cronjob లాగ్లను ప్రాసెస్ చేస్తుంది మరియు కొన్ని గణాంకాలను సేకరిస్తుంది. మీ సైట్లో ట్రాఫిక్ మొత్తం మీద ఆధారపడి, ఇది కొంచెం సమయం పడుతుంది. మీరు దీన్ని ప్రారంభిస్తే, మీరు మీ ప్రతి కోర్సులు గురించి లేదా ఆసక్తికరమైన సైట్లో కొన్ని ఆసక్తికరమైన గ్రాఫ్లు మరియు గణాంకాలను చూడగలుగుతారు.';
$string['configenabletrusttext'] = 'అప్రమేయంగా Moodle నిరంతరం పూర్తిగా శుభ్రం చేస్తుంది, ఇది వినియోగదారుల నుండి వచ్చిన ఏదైనా చెడ్డ స్క్రిప్ట్స్, మాధ్యమం మొదలైన వాటిని తీసివేస్తుంది. విశ్వసనీయ కంటెంట్ వ్యవస్థ జోక్యం లేకుండా వారి కంటెంట్లో ఈ అధునాతన లక్షణాలను చేర్చగల సామర్థ్యాన్ని విశ్వసిస్తున్న ప్రత్యేక వినియోగదారులకు ఒక మార్గం. ఈ సిస్టమ్ను ప్రారంభించడానికి, మీరు ఈ సెట్టింగును మొదట ప్రారంభించాలి, ఆపై విశ్వసనీయ కంటెంట్ అనుమతిని నిర్దిష్ట Moodle పాత్రకు మంజూరు చేయాలి. ఇటువంటి వినియోగదారులు సృష్టించిన లేదా అప్లోడ్ చేసిన పాఠం విశ్వసనీయంగా గుర్తించబడింది మరియు ప్రదర్శించడానికి ముందు శుభ్రం చేయబడదు.';
$string['configenablewebservices'] = 'వెబ్ సేవలు ఈ మూడ్లె లాగిన్ మరియు కార్యకలాపాలు నిర్వహించడానికి ఇతర వ్యవస్థలు ఎనేబుల్. అదనపు భద్రత కోసం ఈ ఫీచర్ మీరు నిజంగా అది ఉపయోగిస్తున్నారు తప్ప డిసేబుల్ చేయాలి.';
$string['configenablewsdocumentation'] = 'వెబ్ సేవలు డాక్యుమెంటేషన్ ఆటో తరం ఎనేబుల్. ఒక వినియోగదారు తన భద్రతా కీలు పేజీ {$ a} తన సొంత డాక్యుమెంటేషన్ యాక్సెస్ చేయవచ్చు. ఇది మాత్రమే ప్రారంభించబడింది ప్రోటోకాల్ల కోసం డాక్యుమెంటేషన్ ప్రదర్శిస్తుంది.';
$string['configerrorlevel'] = 'మీరు ప్రదర్శించబడుతుంది అనుకుంటే ఆ PHP హెచ్చరికలు మొత్తం ఎంచుకోండి. సాధారణ సాధారణంగా ఉత్తమ ఎంపిక ఉంది.';
$string['configexportlookahead'] = 'రోజులు ఎగుమతి సమయంలో ముందుకు చూడండి';
$string['configexportlookback'] = 'రోజులు ఎగుమతి సమయంలో తిరిగి చూడండి';
$string['configextendedusernamechars'] = '(వారి అసలు పేర్లు ప్రభావితం లేదు ఈ గమనించండి) విద్యార్థులు వాడుకరిపేర్లనందు ఏ అక్షరాలు ఉపయోగించడానికి అనుమతించే ఈ సెట్టింగ్ని ప్రారంభిస్తే. డిఫాల్ట్ యూజర్ పేర్లు, ఆల్ఫాన్యూమరిక్ చిన్న అక్షరాలు ఉండాలి (_) తక్కువగా పరిమితం "తప్పుడు" ఉంది, హైఫన్ (-), కాలం లేదా చిహ్నం (@) వద్ద (.).';
$string['configextramemorylimit'] = 'శోధన, బ్యాకప్ / పునరుద్ధరించడానికి లేదా క్రాన్ వంటి కొన్ని స్క్రిప్ట్ అధిక మెమరీ అవసరమవుతుంది. పెద్ద సైట్లకు ఎక్కువ విలువలను సెట్ చెయ్యండి.';
$string['configfilterall'] = 'శీర్షికలు, శీర్షికలు, నావిగేషన్ బార్ మరియు మొదలైనవితో సహా అన్ని తీగలను ఫిల్టర్ చేయండి. Multilang ఫిల్టర్ ఉపయోగించినప్పుడు ఈ ఎక్కువగా ఉపయోగపడుతుంది, లేకుంటే అది కేవలం తక్కువ లాభం కోసం మీ సైట్లో అదనపు లోడ్ సృష్టిస్తుంది.';
$string['configfiltermatchoneperpage'] = 'ఆటోమేటిక్ లింకింగ్ ఫిల్టర్లు పూర్తి పేజీలోని మొదటి సరిపోలే టెక్స్ట్ ఇన్స్టాన్స్ కోసం ఒకే లింక్ని మాత్రమే సృష్టిస్తుంది. మిగిలినవి విస్మరించబడుతున్నాయి.';
$string['configfiltermatchonepertext'] = 'ఆటోమేటిక్ లింకింగ్ ఫిల్టర్లు పేజీలోని ప్రతి అంశానికి సంబంధించిన మొదటి సరిపోలే టెక్స్ట్ ఇన్స్టాన్స్ కోసం ఒక లింక్ని మాత్రమే సృష్టిస్తుంది (ఉదా., రిసోర్స్, బ్లాక్) పేజీలో. మిగిలినవి విస్మరించబడుతున్నాయి. పేజీ అమరికకు ఒకదానికి <i> అవును </ i> ఉంటే ఈ సెట్టింగ్ విస్మరించబడుతుంది.';
$string['configfilteruploadedfiles'] = 'అన్ని HTML మరియు టెక్స్ట్ ఫైళ్ళను ఫిల్టర్లను ప్రదర్శించే ముందు ప్రాసెస్ చేయండి, HTML ఫైల్స్ లేదా ఏదీ ఎవ్వరూ అప్లోడ్ చేయలేరు.';
$string['configforcelogin'] = 'సాధారణంగా, సైట్ యొక్క మొదటి పేజీ మరియు కోర్సు జాబితాలు (కాని విద్యా కోర్సులు కాదు) సైట్కు లాగకుండా ప్రజలు చదవవచ్చు. మీరు సైట్లో ఏమీ చేయక ముందు ప్రజలు లాగిన్ చేయాలని మీరు బలవంతం చేయాలనుకుంటే, మీరు ఈ సెట్టింగ్ను ఎనేబుల్ చేయాలి.';
$string['configforceloginforprofiles'] = 'ఈ సెట్టింగు ప్రజలు ఏ యూజర్ యొక్క ప్రొఫైల్ను చూసేముందు నిజమైన (నాన్-అతిథి) ఖాతాగా లాగిన్ అయ్యేలా చేస్తుంది. మీరు ఈ సెట్టింగ్ని ఆపివేసినట్లయితే, కొందరు వినియోగదారులు తమ ప్రొఫైల్లో ప్రకటనలు (స్పామ్) లేదా ఇతర తగని కంటెంట్ను పోస్ట్ చేస్తారని మీరు కనుగొంటారు, ఇది మొత్తం ప్రపంచానికి అప్పుడు కనిపిస్తుంది.';
$string['configfrontpage'] = 'పైన ఎంచుకున్న అంశాలు సైట్ యొక్క మొదటి పేజీలో ప్రదర్శించబడతాయి.';
$string['configfrontpagecourselimit'] = 'కోర్సుల యొక్క గరిష్ట సంఖ్య';
$string['configfrontpagecourselimithelp'] = 'కోర్సు జాబితాలలో సైట్ యొక్క మొదటి పేజీలో ప్రదర్శించాల్సిన కోర్సుల గరిష్ఠ సంఖ్య.';
$string['configfrontpageloggedin'] = 'వినియోగదారు లాగిన్ అయినప్పుడు సైట్ యొక్క మొదటి పేజీలో ఎగువ ఎంచుకున్న అంశాలు ప్రదర్శించబడతాయి.';
$string['configfullnamedisplay'] = 'ఇవి పూర్తిగా ప్రదర్శించబడుతున్నప్పుడు ఎలా పేర్లు చూపించాలో వివరిస్తుంది. డిఫాల్ట్ విలువ, "లాంగ్వేజ్", దీనిని ప్రస్తుత భాష ప్యాక్లో "స్ట్రింగ్" ఫుల్నామేడ్స్ప్లేప్ "కి వదిలివేస్తుంది. కొన్ని భాషల్లో విభిన్న పేరు ప్రదర్శన కన్వెన్షన్లు ఉన్నాయి.

చాలా మోనో-భాషా సైట్ల కోసం అత్యంత సమర్థవంతమైన అమరిక "మొదటి పేరు చివరిపేరు", కానీ మీరు ఇంటిపేరులను పూర్తిగా దాచడానికి ఎంచుకోవచ్చు. ఉపయోగించగల ప్లేస్హోల్డర్లు: మొదటిపేరు, చివరిపేరు, మొదటి పేరుమానసిక, చివరిపేరు, శబ్ద, middlename, మరియు ఆల్టర్నేటనేమ్.';
$string['configgeoipfile'] = 'GeoLite2 సిటీ బైనరీ డేటా ఫైల్ యొక్క స్థానం. ఈ ఫైల్ మూడ్ల పంపిణీలో భాగం కాదు మరియు <a href="http://www.maxmind.com/"> MaxMind </a> నుండి వేరుగా పొందాలి. మీరు వాణిజ్య వెర్షన్ను కొనుగోలు చేయవచ్చు లేదా ఉచిత సంస్కరణను ఉపయోగించవచ్చు. కేవలం <a href="http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz"> డౌన్లోడ్ చేయండి http://geolite.maxmind.com/download/geoip/database/GeoLite2- City.mmdb.gz </a> దీన్ని మీ సర్వర్లో "{$ a}" డైరెక్టరీగా సంగ్రహించండి.';
$string['configgetremoteaddrconf'] = 'మీ సర్వర్ రివర్స్ ప్రాక్సీ వెనుక ఉంటే, రిమోట్ IP చిరునామాను కలిగి ఉండే HTTP శీర్షికలు విశ్వసనీయతను పేర్కొనడానికి మీరు ఈ సెట్టింగ్ను ఉపయోగించవచ్చు. అందుబాటులో ఉన్న మొదటిదాన్ని ఉపయోగించి శీర్షికలు చదవబడతాయి.';
$string['configgradebookroles'] = 'ఈ సెట్టింగును ఎవరు గ్రేడ్బుక్లో ఉన్నవారిని నియంత్రించటానికి మిమ్మల్ని అనుమతిస్తుంది. ఆ కోర్సు కోసం గ్రేడ్బుక్లో చూపించే కోర్సులో వినియోగదారులు ఈ పాత్రల్లో కనీసం ఒకదాన్ని కలిగి ఉండాలి.';
$string['configgradeexport'] = 'గ్రేడ్బుక్ ఎగుమతి ఫార్మాట్లు ఎగుమతి తరగతులు మీ ప్రాథమిక పద్ధతులు ఇవి ఎంచుకోండి. ఎంచుకున్న ప్లగిన్లు అప్పుడు ప్రతి గ్రేడ్ కోసం ఒక "చివరి ఎగుమతి" ఫీల్డ్ సెట్ మరియు ఉపయోగించడానికి ఉంటుంది. ఉదాహరణకు, ఇది ఎగుమతి చేసిన రికార్డులను "కొత్త" లేదా "అప్డేట్" గా గుర్తించబడవచ్చు. మీరు దీని గురించి ఖచ్చితంగా తెలియకపోతే, ప్రతిదానికైనా నిలిపివేయండి.';
$string['confighiddenuserfields'] = 'మీరు ఇతర ఉపాధ్యాయులు / నిర్వాహకులు కాకుండా ఇతర వినియోగదారుల నుండి దాచాలనుకుంటున్న యూజర్ సమాచారం ఖాళీలను ఎంచుకోండి. ఇది విద్యార్థి గోప్యతను పెంచుతుంది. బహుళ ఫీల్డ్లను ఎంచుకోవడానికి CTRL కీని నొక్కి ఉంచండి.';
$string['configidnumber'] = 'ఈ ఐచ్చికము ఐ డి నంబరు కొరకు యూజర్స్ అడగబడిందా, (బి) యూజర్లు ఒక ఐడి నంబర్ అడిగినప్పటికీ ఖాళీగా ఉంచవచ్చు లేదా (c) యూజర్లు ఒక ఐడి నంబర్ అడిగారు మరియు దానిని ఖాళీగా ఉంచకూడదు అని నిర్దేశిస్తుంది. . యూజర్ యొక్క ఐడి సంఖ్య ఇచ్చినట్లయితే వారి ప్రొఫైల్లో ప్రదర్శించబడుతుంది.';
$string['configintro'] = 'ఈ పేజీలో మీరు మీ సర్వర్లో సరిగా పనిచేయడానికి Moodle ని పని చేయడానికి సహాయపడే కాన్ఫిగరేషన్ వేరియబుల్స్ని పేర్కొనవచ్చు. దాని గురించి చాలా ఆందోళన చెందకండి - డిఫాల్ట్లు సాధారణంగా జరిమానా పని చేస్తాయి మరియు మీరు ఈ పేజీకి తర్వాత తిరిగి వచ్చి ఈ సెట్టింగులను మార్చుకోవచ్చు.';
$string['configintroadmin'] = 'ఈ పేజీలో మీరు మీ ప్రధాన నిర్వాహక ఖాతాని కన్ఫిగర్ చేయాలి, ఇది సైట్పై పూర్తి నియంత్రణను కలిగి ఉంటుంది. మీరు సురక్షితమైన వినియోగదారు పేరు మరియు పాస్వర్డ్ అలాగే చెల్లుబాటు అయ్యే ఇమెయిల్ చిరునామాను ఇవ్వాలని నిర్ధారించుకోండి. మీరు తర్వాత మరిన్ని నిర్వాహక ఖాతాలను సృష్టించవచ్చు.';
$string['configintrosite'] = 'ఈ పేజీ యొక్క మొదటి పేజీ మరియు పేరుని కాన్ఫిగర్ చెయ్యడానికి ఈ పేజీ మిమ్మల్ని అనుమతిస్తుంది. మీరు ఈ సెట్టింగులను ఎప్పుడైనా పరిపాలన మెనులు ఉపయోగించి మార్చడానికి తరువాత ఇక్కడ తిరిగి రావచ్చు.';
$string['configiplookup'] = 'మీరు లాగ్లలో ఉన్న IP చిరునామా (34.12.222.93 వంటివి) పై క్లిక్ చేసినప్పుడు, మీరు ఆ IP ఎక్కడ ఉన్నదో అన్నదానితో ఒక మాప్ ను చూపిస్తారు. మీరు ఎంచుకోవడానికి ఈ కోసం వివిధ ప్లగిన్లు ఉన్నాయి, ప్రతి ప్రయోజనాలు మరియు అప్రయోజనాలు కలిగి ఉంది.';
$string['configkeeptagnamecase'] = 'మీరు సృష్టించిన వినియోగదారులచే నమోదు చేయబడిన అసలు కేసింగ్ను ఉంచడానికి ట్యాగ్ పేర్లు కావాలనుకుంటే దీన్ని తనిఖీ చేయండి';
$string['configlang'] = 'మొత్తం సైట్ కోసం డిఫాల్ట్ భాషను ఎంచుకోండి. యూజర్లు భాష మెనూ లేదా వారి వ్యక్తిగత ప్రొఫైల్లో అమర్పు ఉపయోగించి ఈ సెట్టింగ్ను భర్తీ చేయవచ్చు.';
$string['configlanglist'] = 'మీరు Moodle యొక్క ఈ సంస్థాపనలో ఏదైనా భాష నుండి ఎంచుకోవడానికి వినియోగదారులను అనుమతించడానికి దీన్ని ఖాళీగా ఉంచండి. అయితే, మీకు కావాల్సిన భాషా కోడ్ల కామాతో వేరుచేయబడిన జాబితాను ఎంటర్ చేయడం ద్వారా మీరు భాష మెనుని తగ్గించవచ్చు. ఉదాహరణకు: en, es_es, fr, అది';
$string['configlangmenu'] = 'మీరు హోమ్ పేజీ, లాగిన్ పేజీ మొదలైనవి సాధారణ ప్రయోజన భాష మెనుని ప్రదర్శించాలనుకుంటున్నారా లేదా ఎంచుకోండి. ఇది వారి స్వంత ప్రొఫైల్లో ప్రాధాన్య భాషని సెట్ చేసే వినియోగదారు సామర్థ్యాన్ని ప్రభావితం చేయదు.';
$string['configlangstringcache'] = 'డేటా డైరెక్టరీలో సంకలనం చేసిన ఫైళ్ళలో అన్ని భాష తీగలను కాషింగ్ చేస్తుంది. మీరు Moodle ను అనువదించినా లేదా మూడ్ల సోర్స్ కోడ్లో తీగలను మార్చినట్లయితే, మీరు దీనిని ఆఫ్ చేయాలనుకోవచ్చు. లేకపోతే పనితీరు ప్రయోజనాలను చూడడానికి దాన్ని వదిలేయండి.';
$string['configlatinexcelexport'] = 'Excel ఎగుమతుల కోసం ఎన్కోడింగును ఎంచుకోండి';
$string['configlocale'] = 'ఒక sitewide లొకేల్ను ఎంచుకోండి - ఇది అన్ని భాషల సమూహాలకు తేదీలను ఫార్మాట్ మరియు భాషని భర్తీ చేస్తుంది (క్యాలెండర్లో రోజుల పేర్లు ప్రభావితం కానప్పటికీ). మీ ఆపరేటింగ్ సిస్టమ్లో ఈ లొకేల్ డేటా ఇన్స్టాల్ చేయాలి (ఉదా. Linux en_US.UTF-8 లేదా es_ES.UTF-8). చాలా సందర్భాలలో ఈ ఫీల్డ్ ఖాళీగా ఉండాలి.';
$string['configloglifetime'] = 'ఇది వినియోగదారు కార్యాచరణ గురించి లాగ్లను ఉంచాలని మీరు కోరుకుంటున్న సమయం యొక్క పొడవు నిర్దేశిస్తుంది. ఈ వయస్సు కంటే పాతవి లాగ్లు స్వయంచాలకంగా తొలగించబడతాయి. మీరు వాటిని అవసరమైన సందర్భంలో లాగ్లను సాధ్యమైనంతవరకు ఉంచడం ఉత్తమం, కానీ మీరు చాలా బిజీగా సర్వర్ను కలిగి ఉంటే మరియు పనితీరు సమస్యలను ఎదుర్కొంటుంటే, మీరు లాగ్ జీవితకాలాన్ని తగ్గించాలనుకోవచ్చు. గణాంకాలు సరిగా పనిచేయకపోవచ్చు ఎందుకంటే 30 కంటే తక్కువ విలువలు సిఫారసు చేయబడలేదు.';
$string['configlookahead'] = 'ఎన్ని రోజులు చూడాలి';
$string['configmailnewline'] = 'మెయిల్ సందేశాలలో ఉపయోగించే న్యూలైన్ అక్షరాలు. CRLF ప్రకారం RFC 822bis ప్రకారం, కొన్ని మెయిల్ సర్వర్లు LRL నుండి CRLF కు ఆటోమేటిక్ మార్పిడి చేస్తాయి, ఇతర మెయిల్ సర్వర్లు CRLF నుండి CRCRLF కు తప్పుగా మార్పిడి చేస్తాయి, ఇంకా ఇతరులు బేర్ LF తో మెయిల్లు (ఉదాహరణకు qmail) తిరస్కరించాయి. మీకు తగని ఇమెయిల్స్ లేదా డబుల్ న్యూలైన్లతో సమస్యలు ఉంటే ఈ సెట్టింగ్ని మార్చడానికి ప్రయత్నించండి.';
$string['configmaxbytes'] = 'సైట్కు అప్లోడ్ చేసిన ఫైళ్ళకు గరిష్ట పరిమాణాన్ని ఇది నిర్దేశిస్తుంది. ఈ సెట్టింగ్ PHP సెట్టింగులు post_max_size మరియు upload_max_filesize, అలాగే అపాచే సెట్టింగ్ LimitRequestBody ద్వారా పరిమితం. క్రమంగా, maxbytes కోర్సు లేదా కార్యాచరణ స్థాయిలో ఎంపిక చేయవచ్చు పరిమాణాల పరిధిని పరిమితం చేస్తుంది. \'సైట్ అప్లోడ్ పరిమితి\' ఎంచుకున్నట్లయితే, సర్వర్ అనుమతించిన గరిష్ట పరిమాణాన్ని ఉపయోగించబడుతుంది.';
$string['configmaxconsecutiveidentchars'] = 'పాస్ వర్డ్ లు వరుస సంఖ్యల అక్షరాల సంఖ్య కంటే ఎక్కువ ఉండకూడదు. ఈ చెక్ డిసేబుల్ చెయ్యడానికి 0 ను ఉపయోగించండి.';
$string['configmaxeditingtime'] = 'ఇది ఫోరమ్ పోస్టింగులు, గ్లోసరీ వ్యాఖ్యలు మొదలైనవాటిని తిరిగి సవరించడానికి సమయం కేటాయించే సమయం. సాధారణంగా 30 నిమిషాలు మంచి విలువ.';
$string['configmaxevents'] = 'ఎదురు చూడాల్సిన సంఘటనలు';
$string['configmaxusersperpage'] = 'వినియోగదారు సెలక్టర్లో సమూహం, బృందం, కోహోర్ట్, వెబ్ర్స్సేర్ మొదలైనవాటిలో ప్రదర్శించబడే వినియోగదారుల గరిష్ట సంఖ్య.';
$string['configmessaging'] = 'సైటు వాడుకరులు తమ మధ్య సందేశాలు పంపుకునే వ్యవస్థను చేతనం చెయ్యాలా?';
$string['configmessagingallowemailoverride'] = 'వారి ప్రొఫైల్లోని ఇమెయిల్ చిరునామా కాకుండా ఇమెయిల్ చిరునామాకు పంపిన ఇమెయిల్ సందేశ నోటిఫికేషన్లను వినియోగదారులకు అనుమతించండి';
$string['configmessagingdeletereadnotificationsdelay'] = 'జాగాను ఆదా చేసేందుకుగాను, చదివేసిన గమనింపులను తొలగించవచ్చు. గమనింఫును చదివేసిన తరవాత, ఎన్నాళ్ళకు వాటిని తొలగించవచ్చు?';
$string['configminpassworddigits'] = 'సంకేతపదాల్లో కనీసం ఇన్ని అంకెలు ఉండాలి.';
$string['configminpasswordlength'] = 'సంకేతపదాలు కనీసం ఇన్ని కారెక్టర్ల పొడవు ఉండాలి.';
$string['configminpasswordlower'] = 'సంకేతపదాల్లో కనీసం ఇన్ని లోవరు కేసు అక్షరాలు ఉండాలి.';
$string['configminpasswordnonalphanum'] = 'సంకేతపదాల్లో కనీసం ఇన్ని అక్షరాలు, అంకెలూ కాని కారెక్టర్లు ఉండాలి.';
$string['configminpasswordupper'] = 'సంకేతపదాల్లో కనీసం ఇన్ని అప్పరు కేసు అక్షరాలు ఉండాలి.';
$string['configmycoursesperpage'] = 'వినియోగదారుల యొక్క సొంత కోర్సులు ఏ జాబితాలో ప్రదర్శించడానికి కోర్సులు గరిష్ఠ సంఖ్య';
$string['configmymoodleredirect'] = 'ఈ సెట్టింగ్ నాన్-అడ్మినిస్టులు కోసం లాగిన్ చేయడానికి నా / నా దారికి దారి తీస్తుంది మరియు అగ్ర స్థాయి సైట్ నావిగేషన్ను / నాతో భర్తీ చేస్తుంది';
$string['configmypagelocked'] = 'ఈ సెట్టింగు డిఫాల్ట్ పేజీ ఏ కాని నాన్-అడ్మినిస్టులు సవరించిన నుండి నిరోధిస్తుంది';
$string['confignavcourselimit'] = 'వాడుకరులు లాగిన్ కానప్పుడూ, లేక వాళ్ళు ఏ కోర్సులోనూ చేరి ఉండకపోతేనూ, వాళ్ళకు చూపించే కోర్సుల సంఖ్యను పరిమితం చెయ్యి';
$string['confignavshowallcourses'] = 'కోర్సులలో నమోదు చేసుకున్న వినియోగదారులు నా కోర్సులు (వారు నమోదు చేస్తున్న జాబితా కోర్సులతో పాటు) నావిగేషన్లో కోర్సులను (అన్ని కోర్సులను జాబితా చేస్తారు) చూడవచ్చో ఈ సెట్టింగ్ నిర్ణయిస్తుంది.';
$string['confignavshowcategories'] = 'నావిగేషన్ బార్ మరియు నావిగేషన్ బ్లాక్స్లో కోర్సు కేతగిరీలు చూపించు. వినియోగదారు ప్రస్తుతం నమోదు చేసుకున్న కోర్సులతో ఇది సంభవించదు, అవి వర్గాల లేకుండా మైకేరీల క్రింద జాబితా చేయబడతాయి.';
$string['confignoreplyaddress'] = 'ఇమెయిళ్ళు కొన్నిసార్లు వినియోగదారు తరపున పంపబడతాయి (ఉదా. ఫోరమ్ పోస్ట్లు). మీరు ఇక్కడ పేర్కొన్న ఇమెయిల్ చిరునామా గ్రహీతలు నేరుగా వినియోగదారుకు ప్రత్యుత్తరమివ్వలేనప్పుడు (ఉదా. ఒక వ్యక్తి వారి చిరునామాను ప్రైవేట్గా ఉంచడానికి ఎంచుకున్నప్పుడు) ఆ సందర్భాలలో "నుండి" చిరునామాగా ఉపయోగించబడుతుంది. ఇమెయిల్ను పంపించేటప్పుడు ఈ సెట్టింగ్ను ఎన్వలప్ పంపేవారిగా కూడా ఉపయోగిస్తారు.';
$string['confignotifyloginfailures'] = 'లాగిన్ వైఫల్యాలను నమోదు చేసిపెడితే, ఈమెయిలు గమనికలు పంపించవచ్చు. ఈ గమనికలను చూడాల్సింది ఎవరు?';
$string['confignotifyloginthreshold'] = 'లాగిన్ వైఫల్యాల గురించిన గమనికలు చేతనంగా ఉంటే, ఒక వాడుకరి ద్వారా గానీ, ఒక ఐపీ అడ్రసు నుండి గానీ ఎన్ని లాగిన్ వైఫల్యాలను పంపించవచ్చు?';
$string['confignotloggedinroleid'] = 'సైట్ సందర్భంలో లాగిన్ చేయని వినియోగదారులు సైట్ సందర్భంలో వారికి ఈ పాత్రను అందించినట్లుగా వ్యవహరిస్తారు. గెస్ట్ దాదాపు మీరు ఇక్కడ ఏమి కావలసినది, కానీ మీరు తక్కువ లేదా మరింత నిర్బంధ పాత్రలు సృష్టించడానికి కావలసిన ఉండవచ్చు. పోస్ట్లను సృష్టించడం వంటి అంశాలకు ఇప్పటికీ యూజర్ సరిగ్గా లాగిన్ కావాలి.';
$string['configopentowebcrawlers'] = 'మీరు ఈ సెట్టింగ్ని ప్రారంభిస్తే, మీ సైట్ను అతిథిగా అందించడానికి Google అనుమతించబడుతుంది. అదనంగా, Google శోధన ద్వారా మీ సైట్కు వచ్చే వ్యక్తులు స్వయంచాలకంగా అతిథిగా లాగ్ ఇన్ అవుతారు. ఇది ఇప్పటికే అతిథి యాక్సెస్ అనుమతించే కోర్సులు పారదర్శక యాక్సెస్ మాత్రమే అందిస్తుంది గమనించండి.';
$string['configoverride'] = 'Config.php నిర్వచించారు';
$string['configpasswordpolicy'] = 'దీన్ని ప్రారంభించడం వలన Moodle ఒక చెల్లుబాటు అయ్యే పాస్వర్డ్ విధానానికి వ్యతిరేకంగా వినియోగదారు పాస్వర్డ్లను తనిఖీ చేస్తుంది. మీ విధానాన్ని పేర్కొనడానికి దిగువ సెట్టింగ్లను ఉపయోగించండి (మీరు దీన్ని \'నో\' కు సెట్ చేస్తే అవి విస్మరించబడతాయి).';
$string['configpasswordresettime'] = 'ఇది గడువు ముందే పాస్ వర్డ్ రీసెట్ అభ్యర్ధనను ధృవీకరించవలసిన సమయాన్ని ఇది నిర్దేశిస్తుంది. సాధారణంగా 30 నిమిషాలు మంచి విలువ.';
$string['configpathtodu'] = 'డు మార్గం. బహుశా / usr / bin / du వంటి ఏదో. మీరు దీనిని నమోదు చేస్తే, డైరెక్టరీ విషయాలను ప్రదర్శించే పుటలు చాలా ఫైళ్ళతో డైరెక్టరీల కోసం చాలా వేగంగా ఉంటాయి.';
$string['configperfdebug'] = 'మీరు దీన్ని ఆన్ చేస్తే, ప్రామాణిక థీమ్ యొక్క ఫుటరులో ప్రదర్శన సమాచారం ముద్రించబడుతుంది';
$string['configprofileroles'] = 'వినియోగదారు ప్రొఫైల్లు మరియు పాల్గొనే పేజీలో కనిపించే పాత్రల జాబితా.';
$string['configprofilesforenrolledusersonly'] = 'స్పామర్లు దుర్వినియోగం చేయడాన్ని నివారించడానికి, ఏ కోర్సులో ఇంకా నమోదు చేయని వినియోగదారుల ప్రొఫైల్ వివరణలు దాచబడ్డాయి. కొత్త వినియోగదారులు ఒక ప్రొఫైల్ వివరణను చేర్చడానికి ముందు కనీసం ఒక కోర్సులో నమోదు చేయాలి.';
$string['configprotectusernames'] = 'డిఫాల్ట్ గా forget_password.php యూజర్ నేమ్స్ లేదా ఇమెయిల్ చిరునామాలను ఊహించడం అనుమతించే ఏ సూచనలు ప్రదర్శించదు.';
$string['configproxybypass'] = 'ప్రాక్సీని దాటవేయడానికి (e.g., 192.168., .mydomain.com) కామాతో వేరు చేయబడిన హోస్ట్ నేమ్స్ లేదా IP ల యొక్క కామాతో వేరు చేయబడిన జాబితా';
$string['configproxyhost'] = 'ఇంటర్నెట్ను ఆక్సెస్ చెయ్యడానికి ఈ <b> సర్వర్ </ b> ఒక ప్రాక్సీ కంప్యూటర్ను (ఉదా. ఫైర్వాల్) ఉపయోగించడానికి అవసరమైతే, ఇక్కడ ప్రాక్సీ హోస్ట్ పేరును అందించండి. లేకపోతే ఖాళీగా వదలండి.';
$string['configproxypassword'] = 'అవసరమైతే ప్రాక్సీ ద్వారా ఇంటర్నెట్ను ప్రాప్యత చేయడానికి పాస్వర్డ్ అవసరం, ఖాళీగా ఉంటే ఏదీ (PHP వలయములుగా పొడిగింపు అవసరం).';
$string['configproxyport'] = 'ఈ సర్వర్ ప్రాక్సీ కంప్యూటర్ని ఉపయోగించాల్సిన అవసరమైతే, ఇక్కడ ప్రాక్సీ పోర్ట్ను అందించండి.';
$string['configproxytype'] = 'వెబ్ ప్రాక్సీ రకం (SOCKS5 మద్దతు కోసం PHP5 మరియు వలయములుగా పొడిగింపు అవసరం).';
$string['configproxyuser'] = 'అవసరమైతే ప్రాక్సీ ద్వారా ఇంటర్నెట్ను ప్రాప్యత చేయడానికి యూజర్పేరు అవసరం, ఖాళీగా ఉంటే (PHP వలయములుగా పొడిగింపు అవసరం).';
$string['configrecaptchaprivatekey'] = 'మీ మూడ్ల సర్వర్ మరియు రికాప్చా సర్వర్ మధ్య కమ్యూనికేట్ చేయడానికి ఉపయోగించే అక్షరాలు (రహస్య కీ) యొక్క స్ట్రింగ్. <a target="_blank" href="https://www.google.com/recaptcha"> Google reCAPTCHA </a> నుండి ReCAPTCHA కీలను పొందవచ్చు.';
$string['configrecaptchapublickey'] = 'సైన్అప్ రూపంలో reCAPTCHA మూలకాన్ని ప్రదర్శించడానికి ఉపయోగించే పాత్రల స్ట్రింగ్ (సైట్ కీ). <a target="_blank" href="https://www.google.com/recaptcha"> Google reCAPTCHA </a> నుండి ReCAPTCHA కీలను పొందవచ్చు.';
$string['configrequestedstudentname'] = 'అభ్యర్థించిన కోర్సుల్లో విద్యార్థి కోసం  ఉపయోగిస్తున్నారు .';
$string['configrequestedstudentsname'] = 'అభ్యర్థించిన కోర్సుల్లో విద్యార్థి కోసం  ఉపయోగిస్తున్నారు .';
$string['configrequestedteachername'] = 'అభ్యర్థించిన కోర్సుల్లో  ఉపాధ్యాయుల  కోసం   ఉపయోగిస్తున్నారు .';
$string['configrequestedteachersname'] = 'అభ్యర్థించిన కోర్సుల్లో  ఉపాధ్యాయుల  కోసం   ఉపయోగిస్తున్నారు .';
$string['configsectioninterface'] = 'ఇంటరుఫేసు';
$string['configsectionmail'] = 'మెయిలు';
$string['configsectionmaintenance'] = 'నిర్వహణ';
$string['configsectionmisc'] = 'ఇతరత్రా';
$string['configsectionoperatingsystem'] = 'ఆపరేటింగ్ సిస్టమ్';
$string['configsectionpermissions'] = 'అనుమతులు';
$string['configsectionrequestedcourse'] = 'కోర్సు అభ్యర్థనలు';
$string['configsectionsecurity'] = 'భద్రత';
$string['configsectionstats'] = 'గణాంకాలు';
$string['configsectionuser'] = 'వాడుకరి';
$string['configsecureforms'] = 'వెబ్ ఫారమ్లు డేటా అంగీకరించడం ఉన్నప్పుడు మూడ్లె ఒక అదనపు భద్రతా స్థాయి ఉపయోగించవచ్చు. ఈ ప్రారంభించినట్లయితే, అప్పుడు బ్రౌజర్ యొక్క HTTP_REFERER వేరియబుల్ ప్రస్తుత రూపం చిరునామా వ్యతిరేకంగా తనిఖీ. వినియోగదారు వారి వెబ్ ట్రాఫిక్ నుండి HTTP_REFERER వాదనను ఆకృతీకరించిన ఫైర్వాల్ (ఉదా ZoneAlarm) ఉపయోగించి ఉంటే చాలా కొన్ని సందర్భాలలో ఈ సమస్యలు కారణమవుతుంది. లక్షణాలు ఒక రూపం న \'కష్టం\' అందుకుంటున్నారు. మీ వినియోగదారులు లాగిన్ పేజీ సమస్యల ఉంటే అది పాస్వర్డ్ను దాడులు-క్రూరమైన శక్తి మీ సైట్ మరింత బహిరంగ వదిలి ఉండవచ్చు అయితే (ఉదాహరణకు) మీరు ఈ సెట్టింగ్ని ఆపివేస్తే అనుకోవచ్చు. సందేహం ఉంటే, \'అవును\' ఈ సెట్ వదిలి.';
$string['configsessioncookie'] = 'ఈ సెట్టింగ్ మూడ్లె సెషన్ల్లో ఉపయోగించే కుకీ పేరు customises. ఈ మూడ్లె అదే వెబ్ సైట్ లో అమలు కంటే ఎక్కువ ఒక కాపీని ఉన్నప్పుడు కుకీలను గందరగోళం నివారించేందుకు ఐచ్ఛిక, మరియు మాత్రమే ఉపయోగపడుతుంది.';
$string['configsessioncookiedomain'] = 'ఈ మీరు మూడ్లె కుకీలను నుండి అందుబాటులో ఉన్న డొమైన్ మార్చడానికి అనుమతిస్తుంది. ఈ మరొక సబ్డొమైన్ పై ఒక వెబ్ అప్లికేషన్ తో మూడ్లె సెషన్ సమాచారాన్ని భాగస్వామ్యం అవసరం మూడ్లె customisations (ఉదా ప్రమాణీకరణ లేదా నమోదు ప్లగిన్లు) ఉపయోగకరంగా ఉంది. <strong> హెచ్చరిక:. అది గట్టిగా డిఫాల్ట్ (ఖాళీ) ఈ సెట్టింగ్ వదిలి కి మద్దతిస్తుంది - ఒక తప్పుడు విలువ సైట్ కు లాగిన్ నిరోధిస్తుంది </ strong>';
$string['configsessioncookiepath'] = 'మీరు బ్రౌజర్ మూడ్లె కుకీలను పంపండి పేరు మార్చడానికి ఉంటే, మీరు మీ వెబ్ సైట్ యొక్క ఒక డైరెక్టరీని పేర్కొనండి ఈ సెట్టింగ్ను మార్చవచ్చు. లేకపోతే డిఫాల్ట్ \'/\' జరిమానా ఉండాలి.';
$string['configsessiontimeout'] = 'సందర్శకులు ఈ సైటులోకి లాగినయ్యాక, చాలాసేపు ఖాళీగా ఉంటే (పేజీలేమీ లోడు చెయ్యకుండా) వాళ్ళు ఆటోమాటిగ్గా లాగౌటయి పోతారు (వాళ్ళ సెషను ముగుస్తుంది). ఈ సమయం ఎంత ఉండాలి అనేదాన్ని ఈ చరరాశి నిశ్చయిస్తుంది.';
$string['configshowcommentscount'] = 'వ్యాఖ్యల సంఖ్యను చూపించు. వ్యాఖ్యల లింకును చూపించేందుకు మరొక క్వెరీ ఖర్చవుతుంది.';
$string['configshowicalsource'] = 'iCal యొక్క విశేషణాలకు వచ్చే అంత్యానుబంధం ఈవెంట్స్ చూపించు మూలం గురించిన సమాచారం.';
$string['configshowsiteparticipantslist'] = 'ఈ సైట్ విద్యార్థులు మరియు సైట్ ఉపాధ్యాయులు అన్ని సైట్ జాబితాలో జాబితా చేయబడుతుంది. ఈ సైట్ పాల్గొనేవారి జాబితాను చూడడానికి ఎవరు అనుమతించబడతారు?';
$string['configsitedefaultlicense'] = 'డిఫాల్టు సైటు లైసెన్సు';
$string['configsitedefaultlicensehelp'] = 'ఈ సైటులో కంటెంటును ప్రచురించేందుకు డిఫాల్టు లైసెన్సు';
$string['configsitemailcharset'] = 'ఈ సెట్టింగ్ సైట్ నుండి పంపిన అన్ని ఇమెయిల్లకు డిఫాల్ట్ అక్షర సమితిని నిర్దేశిస్తుంది.';
$string['configsitemaxcategorydepth'] = 'వర్గపు గరిష్ఠ లోతు';
$string['configsitemaxcategorydepthhelp'] = 'ఇది కేతగిరీలు లేదా కాంబో జాబితాను ప్రదర్శించేటప్పుడు విస్తరించిన బాల వర్గాల గరిష్ట లోతు. లోతైన స్థాయి కేతగిరీలు లింక్లుగా కనిపిస్తాయి మరియు వినియోగదారు వాటిని AJAX అభ్యర్థనతో విస్తరించవచ్చు.';
$string['configslasharguments'] = 'ఫైళ్ళు (చిత్రాలు, అప్లోడ్లు etc) \'స్లాష్ వాదనలు\' ఉపయోగించి స్క్రిప్ట్ ద్వారా అందించబడతాయి. ఈ పద్ధతి ఫైల్లను మరింత సులభంగా దురదృష్టవశాత్తు, కొన్ని PHP సర్వర్స్ ఈ పద్ధతి అనుమతించము వెబ్ బ్రౌజర్లు, ప్రాక్సీ సర్వర్లు మొదలైనవి కాష్ అనుమతిస్తుంది, కనుక మీరు ఇబ్బంది అప్లోడ్ ఫైళ్లు లేదా చిత్రాలు (ఉదా యూజర్ చిత్రాలు) చూడడంలో ఉంటే, ఈ సెట్టింగ్ని ఆపివేస్తే.';
$string['configsmartpix'] = 'ఈ తో, చిహ్నాలు ప్రస్తుత థీమ్, అప్పుడు అన్ని పేరెంట్ థీమ్స్, అప్పుడు Moodle / PIX ఫోల్డర్ శోధించే ఒక PHP స్క్రిప్ట్ ద్వారా అందిస్తారు. ఇది ఇతివృత్తాల్లోని ఇమేజ్ ఫైళ్లను నకిలీ చేయవలసిన అవసరాన్ని తగ్గిస్తుంది, కానీ స్వల్ప పనితీరును కలిగి ఉంటుంది.';
$string['configsmtpauthtype'] = 'ఇది smtp సర్వర్లో ఉపయోగించటానికి ధృవీకరణ రకాన్ని అమర్చుతుంది.';
$string['configsmtphosts'] = 'మెయిల్ పంపేందుకు Moodle వాడుకునే ఒకటి లేదా అంతకంటే ఎక్కువ స్థానిక SMTP సర్వర్ల పూర్తి పేరు ఇవ్వండి (ఉదా. \'Mail.a.com\' లేదా \'mail.a.com; mail.b.com\'). అప్రమేయ పోర్ట్ కాని (పోర్ట్ 25 కంటే ఇతరది) తెలుపుటకు, మీరు [సర్వర్] ను ఉపయోగించవచ్చు: [పోర్ట్] సింటాక్స్ (ఉదా. \'Mail.a.comcom8787\'). సురక్షిత కనెక్షన్ల కోసం, పోర్ట్ 465 సాధారణంగా SSL తో ఉపయోగించబడుతుంది, పోర్ట్ 587 సాధారణంగా TLS తో ఉపయోగించబడుతుంది, అవసరమైతే క్రింద భద్రతా ప్రోటోకాల్ను పేర్కొనండి. మీరు ఈ ఫీల్డ్ ఖాళీగా వదిలేస్తే, Moodle మెయిల్ పంపే PHP డిఫాల్ట్ పద్ధతిని ఉపయోగిస్తుంది.';
$string['configsmtpmaxbulk'] = 'SMTP సెషన్కు పంపిన సందేశాల గరిష్ఠ సంఖ్య. సందేశాలని పంపడం వేగవంతం కావచ్చు. ప్రతి ఇ-మెయిల్ కోసం కొత్త SMTP సెషన్ యొక్క 2 శక్తి కన్నా తక్కువ విలువలు.';
$string['configsmtpsecure'] = 'SMTP సర్వర్కు సురక్షిత కనెక్షన్ అవసరమైతే, సరైన ప్రోటోకాల్ రకం పేర్కొనండి.';
$string['configsmtpuser'] = 'మీరు పైన SMTP సర్వర్ను పేర్కొన్నట్లయితే మరియు సర్వర్కు ప్రామాణీకరణ అవసరం, ఆపై ఇక్కడ యూజర్పేరు మరియు పాస్వర్డ్ను నమోదు చేయండి.';
$string['configstartwday'] = 'వారపు ప్రారంభం';
$string['configstatsfirstrun'] = 'ఈ లాగ్లను <b> మొదటి సారి </ b> cronjob గణాంకాలు ప్రాసెస్ కోరుకుంటున్నారు ప్రాసెస్ చేయాలి ఎంతవరకు తిరిగి నిర్దేశిస్తుంది. మీరు ట్రాఫిక్ చాలా ఉన్నాయి మరియు షేర్డ్ హోస్టింగ్ ఉంటే, అది అమలు మరియు చాలా ఇంటెన్సివ్ వనరు కాలం పడుతుంది వంటి, చాలా దూరం వెళ్ళడానికి బహుశా ఒక మంచి ఆలోచన కాదు. (ఈ సెట్టింగ్ గమనించండి, 1 నెల = 28 రోజులు. గ్రాఫ్లు మరియు నివేదికలు ఉత్పత్తి లో, 1 నెల = 1 క్యాలెండర్ నెల.)';
$string['configstatsmaxruntime'] = 'గణాంకాలు చాలా ఇంటెన్సివ్ ఉండాలి, అది అమలు మరియు ఎంత కోసం ఉన్నప్పుడు పేర్కొనడానికి ఈ రంగంలో మరియు తరువాత ఒక కలయిక ఉపయోగించవచ్చు ప్రాసెస్.';
$string['configstatsmaxruntime2'] = 'చాలా ఇంటెన్సివ్ ఉంటుంది ప్రాసెసింగ్ గణాంకాలు, గణాంకాలు ఒక రోజు సేకరణ కోసం అనుమతి గరిష్ట సమయాన్ని పేర్కొనండి. ఒక క్రాన్ అమలు లో ప్రాసెస్ రోజుల గరిష్ట సంఖ్య 31 ఉంది.';
$string['configstatsmaxruntime3'] = 'ఇది గణాంకాల ప్రాసెసింగ్ సర్వర్పై పెద్ద లోడ్ ఉంచవచ్చని గుర్తుంచుకోండి, ఒక రోజు కోసం గణాంకాలను లెక్కించడానికి అనుమతించే గరిష్ట సమయాన్ని నిర్దేశిస్తుంది. ఒక క్రాన్లో ప్రాసెస్ చేయబడిన గరిష్ట సంఖ్యల సంఖ్య క్రింద పేర్కొనవచ్చు.';
$string['configstatsruntimedays'] = 'ఇది ప్రతి గణాంకాల అమలులో ప్రాసెస్ చేయబడిన గరిష్ట సంఖ్యలను నిర్దేశిస్తుంది. గణాంకాలు నవీకరించబడిన తర్వాత, ఒకరోజు మాత్రమే ప్రాసెస్ చేయబడుతుంది, కాబట్టి మీ సర్వర్ లోడ్ ఆధారంగా ఈ విలువను సర్దుబాటు చేయండి, చిన్న క్రాన్ మరణశిక్షలు అవసరమైతే దాన్ని తగ్గించడం.';
$string['configstatsruntimestart'] = 'స్టాటిస్టిక్స్ ప్రాసెసింగ్ చేసే క్రాన్జాబ్ ఏ సమయంలో ప్రారంభించాలి? ఒక సర్వర్లో బహుళ మూడ్ల సైట్లు ఉంటే వేర్వేరు సార్లు పేర్కొనడం సిఫార్సు చేయబడింది.';
$string['configstatsuserthreshold'] = 'ఈ సెట్టింగ్ గణాంకాలు గణనలో చేర్చవలసిన కోర్సు కోసం నమోదు చేయబడిన వినియోగదారుల కనీస సంఖ్యను నిర్దేశిస్తుంది.';
$string['configstrictformsrequired'] = 'ప్రారంభించబడి ఉంటే, వినియోగదారులు ఖాళీలు లేదా లైన్ బ్రేక్లను మాత్రమే అవసరమైన ఫారమ్ల్లో నమోదు చేయకుండా నిరోధించబడతారు.';
$string['configstripalltitletags'] = 'కార్యాచరణ మరియు వనరు పేర్లలో HTML ట్యాగ్లను అనుమతించడానికి ఈ సెట్టింగ్ను అన్చెక్ చేయండి.';
$string['configsupportemail'] = 'ఈ ఇమెయిల్ చిరునామా ఈ సైట్ యొక్క వినియోగదారులకు సాధారణ సహాయం అవసరమైనప్పుడు (ఉదాహరణకు, కొత్త వినియోగదారులు తమ సొంత ఖాతాలను రూపొందించినప్పుడు) అవసరమైనప్పుడు ప్రచురించబడుతుంది. ఈ ఇమెయిల్ ఖాళీగా ఉంటే, అటువంటి సహాయక ఇమెయిల్ చిరునామా అందించబడదు.';
$string['configsupportname'] = 'ఇది, వెబ్ అడ్రసు ద్వారాగానీ ఈమెయిలు ద్వారాగానీ సాధారణ సహాయాన్ని అందించే వ్యక్తి లేదా సంస్థ యొక్క పేరు';
$string['configsupportpage'] = 'ఈ వెబ్ చిరునామా ఈ సైట్ యొక్క వినియోగదారులకు సాధారణ సహాయం కావాల్సినప్పుడు (ఉదాహరణకు, కొత్త వినియోగదారులు వారి సొంత ఖాతాలను రూపొందించినప్పుడు) వెళ్లడానికి వీలుగా ప్రచురించబడుతుంది. ఈ చిరునామా ఖాళీగా ఉంటే, లింక్ ఏదీ సరఫరా చేయబడదు.';
$string['configtempdatafoldercleanup'] = 'ఎంచుకున్న సమయాన్ని దాటి పాత డేటా ఫోల్డర్ నుండి తాత్కాలిక డేటా ఫైళ్లను తొలగించండి.';
$string['configthemedesignermode'] = 'సాధారణంగా అన్ని థీమ్ చిత్రాలు మరియు శైలి షీట్లు నటనకు, ఒక చాలా కాలం బ్రౌజర్లలో మరియు సర్వర్ కాష్ ఉంటాయి. మీరు థీమ్లు రూపకల్పన లేదా కోడ్ అభివృద్ధి ఉంటే అప్పుడు మీరు బహుశా మీరు కాష్ వెర్షన్లు పనిచేశారు లేదు కాబట్టి ఈ మోడ్ చెయ్యాలనుకుంటున్నారా. హెచ్చరిక: ఈ అన్ని వినియోగదారులకు మీ సైట్ నెమ్మదిగా చేస్తుంది! ప్రత్యామ్నాయంగా, మీరు కూడా థీమ్ ఎంపిక పేజీ నుండి మానవీయంగా థీమ్ క్యాచీలు రీసెట్ చేయవచ్చు';
$string['configthemelist'] = 'ఏ చెల్లుబాటు అయ్యే థీమ్ ఉపయోగించవచ్చు అనుమతించే ఈ ఖాళీగా వదిలేయండి. మీరు థీమ్ మెను చిన్నదిగా అనుకుంటే, మీరు ఇక్కడ పేర్లు కామాతో వేరుపరచబడిన జాబితా\'లో (ఖాళీలతో వాడకండి!) పేర్కొనవచ్చు.
ఉదాహరణకు: ప్రామాణిక, orangewhite.';
$string['configtimezone'] = 'ప్రతి యూజర్ వారి ప్రొఫైల్ లో ఈ సెట్టింగ్ని అధిగమించవచ్చు - ఈ తేదీలను ప్రదర్శించడానికి డిఫాల్ట్ సమయమండలిని ఉంది. క్రాన్ పనులు మరియు ఇతర సర్వర్ సెట్టింగ్లను ఈ టైమ్జోన్లో పేర్కొనబడ్డాయి. ఇది "చెల్లని సమయ మండలిని" గా చూపిస్తుంది ఉంటే మీరు సెట్టింగ్ మార్చడానికి ఉండాలి';
$string['configuseblogassociations'] = 'కోర్సులను మరియు కోర్సు మాడ్యూల్స్తో ఎంట్రీలను అనుబంధించడం ద్వారా వినియోగదారులు వారి బ్లాగును నిర్వహించగలవా?';
$string['configusesitenameforsitepages'] = 'ప్రారంభించినట్లయితే సైట్ యొక్క చిన్నపేరుని స్ట్రింగ్ \'సైట్ పుటలు\' కాకుండా సైట్ పేజీకి నోడ్ కోసం నావిగేషన్లో ఉపయోగించబడుతుంది';
$string['configusetags'] = 'ట్యాగుల అంశాన్ని సైటు మొత్తం మీద';
$string['configvariables'] = 'చరరాశులు';
$string['configverifychangedemail'] = 'అనుమతించబడిన మరియు ఖచ్ఛితమైన ఇమెయిల్ డొమైన్ల సెట్టింగ్లను ఉపయోగించి మార్చిన ఇమెయిల్ చిరునామాల ధృవీకరణను ప్రారంభిస్తుంది. ఈ సెట్టింగ్ని నిలిపివేస్తే క్రొత్త వినియోగదారులను సృష్టించేటప్పుడు మాత్రమే డొమైన్లు అమలు చేయబడతాయి.';
$string['configvisiblecourses'] = 'మామూలుగా దాచిపెట్టిన వర్గాలను ప్రదర్శించబడుతుంది.';
$string['configwarning'] = 'ఈ సెట్టింగులను మార్చేటపుడు జాగ్రత్త - అనుచితమైన విలువలు సమస్యలకు దారితీయవచ్చు.';
$string['configyuicomboloading'] = 'ఈ ఐచ్ఛికాలు YUI లైబ్రరీల కొరకు మిశ్రమ ఫైలు లోడింగ్ ఆప్టిమైజేషన్ను ప్రారంభిస్తాయి. పనితీరు కారణాల కోసం ఉత్పత్తి సైట్లలో ఈ సెట్టింగ్ ప్రారంభించబడాలి.';
$string['confirmation'] = 'నిర్ధారణ';
$string['confirmdeletecomments'] = 'మీరు వ్యాఖ్యలను తొలగించబోతున్నారు. ఖాయమేనా? ';
$string['confirmed'] = 'నిర్ధారించబడింది';
$string['cookiesecure'] = 'భద్రమైన కూకీలు మాత్రమే';
$string['country'] = 'డిఫాల్టు దేశం';
$string['coursecolor'] = 'రంగు{$a}';
$string['coursecolorsettings'] = 'కోర్సు కార్డ్ రంగులు';
$string['coursecontact'] = 'కోర్సు సంపర్కాలు';
$string['coursecontact_desc'] = 'ఈ వివరణ కోర్సు వివరణలో ఎవరు కనిపించాలనే దాన్ని నియంత్రించడానికి మిమ్మల్ని అనుమతిస్తుంది. ఆ కోర్సు కోసం కోర్సు వివరణపై చూపించే కోర్సులో వినియోగదారులు ఈ పాత్రల్లో కనీసం ఒకదాన్ని కలిగి ఉండాలి.';
$string['coursecontactduplicates'] = 'కోర్సు యొక్క అన్ని కాంటాక్ట్ రోల్స్ ను చూపించు';
$string['coursegraceperiodafter'] = 'మునుపు కోర్సుల గ్రేస్ పీరియడ్';
$string['coursegraceperiodbefore'] = 'రాబోయే కోర్సుల గ్రేస్ పీరియడ్';
$string['courselistshortnames'] = 'విస్తరించిన కోర్సు యొక్క పేర్లు చూపించు';
$string['courselistshortnames_desc'] = 'ప్రారంభించబడితే, కోర్సుల జాబితాలో పూర్తి పేర్లకు అదనంగా కోర్సు చిన్న పేర్లు ప్రదర్శించబడతాయి. అవసరమైతే, విస్తరించిన కోర్సు పేర్లు భాష అనుకూలీకరణ లక్షణాన్ని ఉపయోగించి \'కోర్సుసులైడ్మేమేడ్ ప్లేజాబితా\' భాష స్ట్రింగ్ను సవరించడం ద్వారా అనుకూలీకరించవచ్చు.';
$string['coursemgmt'] = 'కోర్సులను, కేటగిరీలను  మేనేజ్ చేయు';
$string['courseoverview'] = 'కోర్సు స్థూలదృష్టి';
$string['coursepage'] = 'కోర్సు పేజీ';
$string['courserequestnotify'] = 'కోర్సు అభ్యర్ధన కబురు';
$string['courserequestnotifyemail'] = 'వాడుకరి {$a->user}, {$a->link} అనే కోర్సు కావాలని అభ్యర్ధించారు';
$string['courserequests'] = 'కోర్సు అభ్యర్ధనలు';
$string['courserequestspending'] = 'పెండింగులో ఉన్న కోర్సు అభ్యర్ధనలు';
$string['courses'] = 'కోర్సులు';
$string['coursesperpage'] = 'ఒక్కో పేజీకి ఉండే కోర్సులు';
$string['courseswithsummarieslimit'] = 'కోర్సుల యొక్క సారాంశముల పరిమితితో.';
$string['creatornewroleid'] = 'కొత్త కోర్సుల్లో రూపకర్త పాత్ర';
$string['creatornewroleid_help'] = 'కొత్త కోర్సును నిర్వహించే అనుమతి వాడుకరికి ఈసరికే లేకపోతే,  ఈ పాత్రను వాడి ఆ వాడుకరిని ఆటోమాటిగ్గా చేరుస్తాం.';
$string['cron'] = 'cron';
$string['cron_enabled'] = 'క్రాన్ ను ఎనేబుల్ చెయ్యి';
$string['cron_help'] = 'Cron.php స్క్రిప్ట్ ఫోరమ్ పోస్ట్ నోటిఫికేషన్ ఇమెయిల్స్ పంపడం వంటి వేర్వేరు షెడ్యూల్ వ్యవధిలో పనులను నిర్వహిస్తుంది. స్క్రిప్ట్ క్రమంగా అమలు చేయాలి - ప్రతి నిమిషం ఆదర్శంగా.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'క్రాన్ నడపడం కమాండ్ లైను ద్వారా మాత్రమే';
$string['cronerrorclionly'] = 'సారీ, ఈ పేజీకి అంతర్జాల అనుమతిని నిర్వాహకుడు అచేతనం చేసారు.';
$string['cronerrorpassword'] = 'సాఅరీ, ఈ పేజీని చూడటానికి మీరు సరైన సంకేతపదం ఇవ్వలేదు.';
$string['cronremotepassword'] = 'రిమోటు ప్రవేశం కోసం క్రోన్ సంకేతపదం';
$string['cronwarning'] = '<a href="{$a->url}">admin/cron.php script</a>  స్క్రిప్ట్  గడచిన {$a->actual} గా రన్ కాలేదు, ఇది ప్రతీ {$a->expected}కు రన్ కావాలి.';
$string['cronwarningcli'] = 'ఈ <code>admin/cli/cron.php</code> స్క్రిప్ట్ {$a->actual} రన్ కాలేదు, ఇది ప్రతీ  {$a->expected} కు రన్ అవ్వాలి.';
$string['cronwarningnever'] = '<code>admin/cli/cron.php</code> ఈ స్క్రిప్ట్ ఎప్పుడూ రన్ కాలేదు, ఇది ప్రతీ {$a->expected} కు రన్ అవ్వాలి.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">admin/cron.php script</a>  ఈ స్క్రిప్ట్ ఎప్పుడూ రన్ కాలేదు, ఇది ప్రతీ {$a->expected} కు రన్ అవ్వాలి.';
$string['ctyperequired'] = 'సైట్ పనితీరును మెరుగుపరచడానికి మరియు బహుభాషా అనుకూలతను అందించడానికి, ctype PHP పొడిగింపు ఇప్పుడు Moodle ద్వారా అవసరం.';
$string['curlcache'] = 'cURL కాషె TTL';
$string['curlrequired'] = 'మూడ్లె రిపోజిటరీలతో కమ్యూనికేట్ చేయడానికి, వలయములుగా PHP ఎక్స్టెన్షన్ ఇప్పుడు మూడ్లె ద్వారా అవసరం.';
$string['curlsecurityallowedport'] = 'అనుమతి పోర్టుల జాబితా వలయములుగా';
$string['curlsecurityallowedportsyntax'] = 'వలయములుగా పోర్ట్ చేయగల పోర్టు సంఖ్యల జాబితా. చెల్లునటువంటి ఎంట్రీలు పూర్ణ సంఖ్యలు మాత్రమే. ఒక కొత్త లైన్ లో ప్రతి ఎంట్రీని ఉంచండి. ఖాళీగా ఉంటే, అప్పుడు అన్ని పోర్టులు అనుమతించబడతాయి. సెట్ చేయబడితే, దాదాపు అన్ని సందర్భాల్లో, ప్రామాణిక HTTPS మరియు HTTP పోర్ట్లకు కనెక్ట్ చేయడానికి వలయములుగా 443 మరియు 80 రెండూ నిర్దేశించబడాలి.';
$string['curlsecurityblockedhosts'] = 'బ్లాక్ హోస్ట్ హోస్ట్స్ జాబితా';
$string['curlsecurityblockedhostssyntax'] = 'ఒక కొత్త లైన్ లో ప్రతి ఎంట్రీని ఉంచండి. చెల్లుబాటు అయిన ఎంట్రీలు పూర్తి IPv4 లేదా IPv6 చిరునామాలు (ఒకే హోస్ట్తో సరిపోలేవి 192.168.10.1, 0: 0: 0: 0: 0: 0: 0: 0: 0: 1, :: 1, fe80: లేదా CIDR సంజ్ఞామానం (231.54.211.0/20 లేదా fe80 :: / 64); లేదా పరిధిలోని చివరి గుంపుకు పరిధిని వర్తించే IP చిరునామాల (231.3.56.10-20 లేదా fe80 :: 1111-bbbb) పరిధి; లేదా డొమైన్ పేర్లు (స్థానిక హోస్ట్ లేదా ఉదాహరణ. లేదా వైల్డ్కార్డ్ డొమైన్ పేర్లు (* .example.com లేదా * .sub.example.com వంటివి). ఖాళీ పంక్తులు అనుమతించబడవు.';
$string['curlsecurityurlblocked'] = 'URL నిరోధించబడింది.';
$string['curltimeoutkbitrate'] = 'కనిష్ఠ cURL టైమౌట్ బిట్రేటు (Kbps)';
$string['curltimeoutkbitrate_help'] = 'పెద్ద క్రోమ్ అభ్యర్ధనల సమయంలో తగిన సమయాన్ని లెక్కించడానికి ఈ సెట్టింగ్ ఉపయోగించబడుతుంది. ఈ గణనలో భాగంగా ఒక HTTP HEAD అభ్యర్థన కంటెంట్ పరిమాణాన్ని నిర్ణయించడానికి తయారు చేయబడింది. ఈ అభ్యర్థన 0 చేస్తున్నప్పుడు ఈ అభ్యర్థన చేయకుండా నిలిపివేస్తుంది.';
$string['currenttheme'] = 'ప్రస్తుతపు థీమ్';
$string['customcheck'] = 'ఇతర పరిశీలనలు';
$string['custommenu'] = 'కస్టమ్ మెనూ';
$string['custommenuitems'] = 'కస్టమ్ మెనూ ఐటములు';
$string['customusermenuitems'] = 'వినియోగదారు మెను అంశాలు';
$string['datarootsecurityerror'] = '<p><strong> భద్రతా హెచ్చరిక! </ strong> </p><p> మీ dataroot డైరెక్టరీ తప్పు స్థానంలో ఉంది మరియు వెబ్కి బహిర్గతమవుతుంది. దీని అర్థం మీ ప్రైవేట్ ఫైల్లు ప్రపంచంలోని ఎవరికైనా అందుబాటులో ఉంటాయి మరియు వాటిలో కొన్ని మీ సైట్కు అనధికారిక నిర్వాహక ప్రవేశం పొందటానికి ఒక క్రాకర్చే ఉపయోగించబడుతుంది! </P>
<p> మీరు పబ్లిక్ వెబ్ డైరెక్టరీలో లేని క్రొత్త స్థానానికి dataroot డైరెక్టరీ ({$a}) ను <em> </>> <code> $ CFG-> dataroot </code> మీ config.php ప్రకారం. </p>';
$string['datarootsecuritywarning'] = 'మీ సైట్ ఆకృతీకరణ సురక్షితంగా ఉండకపోవచ్చు. దయచేసి మీ dataroot డైరెక్టరీ ({$a}) వెబ్ ద్వారా నేరుగా యాక్సెస్ చేయలేదని నిర్ధారించుకోండి.';
$string['dbsessions'] = 'సెషను సమాచారం కోసం డేటాబేసును వాడు';
$string['debug'] = 'డీబగ్ సందేశాలు';
$string['debugall'] = 'ALL: సముచితమైన అన్ని PHP డీబగ్ సందేశాలనూ చూపించు';
$string['debugdeveloper'] = 'DEVELOPER: డెవలపర్ల కోసం అదనపు Moodle సందేశాలు';
$string['debugdisplay'] = 'డీబగ్ సందేశాలను చూపించు';
$string['debugging'] = 'డీబగ్గింగు';
$string['debugminimal'] = 'MINIMAL: ఫాటల్ లోపాలను మాత్రమే చూపించు';
$string['debugnone'] = 'NONE: లోపాలు, హెచ్చరికలు వేటినీ చూఫించవద్దు';
$string['debugnormal'] = 'NORMAL: లోపాలు, హెచ్చరికలు, గమనికలను చూపించు';
$string['debugpageinfo'] = 'పేజీ సమాచారాన్ని చూపించు';
$string['debugsqltrace'] = 'SQL కాల్స్ యొక్క ఆరిజిన్ చూపించు';
$string['debugsqltrace1'] = 'కేవలం సింగిల్ కాలింగ్ లైన్ మాత్రమే చూపించు';
$string['debugsqltrace100'] = 'ఫుల్ stack ట్రేస్ చూపించు';
$string['debugsqltrace2'] = '2 లైన్ల stack ట్రేస్ చూపించు';
$string['debugsqltrace_desc'] = 'ఒకవేళ పూర్తిగా లేక పాక్షికంగా ఎనేబుల్ చేస్తే PHP stack ట్రేస్,  SQL కు ఒక కామెంట్ గా జోడించబడుతుంది.';
$string['debugstringids'] = 'భాషల్లో తీగలను యొక్క మూలం చూపించండి';
$string['debugstringids_desc'] = 'ఈ ఐచ్ఛికం అనువాదకులకి సహాయపడటానికి రూపొందించబడింది. ఈ ఐచ్చికాన్ని ఎనేబుల్ చేసినప్పుడు, మీరు అభ్యర్థన URL కు పారామితి తీగలను = 1 జతచేస్తే, అది అవుట్పుట్ అయిన ప్రతి స్ట్రింగ్ పక్కన ఉన్న భాష ఫైల్ మరియు స్ట్రింగ్ ఐడిని చూపిస్తుంది.';
$string['debugvalidators'] = 'వ్యాలిడేటర్ లింక్లను చూపించండి';
$string['defaultcity'] = 'డిఫాల్టు నగరం';
$string['defaultcity_help'] = 'కొత్త వాడుకరి ఖాతాలను సృష్టించేటపుడు,ఇక్కడ ఇచ్చిన నగరమే డిఫాల్టు నగరం అవుతుంది';
$string['defaultformatnotset'] = 'డిఫాల్ట్ కోర్సు ఫార్మాట్ని నిర్ధారించడంలో లోపం. దయచేసి సైట్ సెట్టింగ్లను తనిఖీ చేయండి.';
$string['defaulthomepage'] = 'యూజర్ల హోమ్ పేజీ';
$string['defaultrequestcategory'] = 'కోర్సు అభ్యర్ధనల డిఫాల్టు వర్గం';
$string['defaultsettinginfo'] = 'డిఫాల్టు: {$a}';
$string['defaultuserroleid'] = 'వాడుకరులందరి డిఫాల్టు పాత్ర';
$string['deleteincompleteusers'] = 'అసంపూర్ణమైన వినియోగదారులను  తర్వాత తొలగించవచ్చు.';
$string['deleteunconfirmed'] = 'పూర్తిగా సెటప్  కాని వినియోగదారులను తొలగించవచ్చు';
$string['deleteuser'] = 'వాడుకరిని తొలగించు';
$string['density'] = 'గాఢత';
$string['denyemailaddresses'] = 'తిరస్కరించబడిన ఈమెయిలు డొమెయిన్లు';
$string['development'] = 'డెవలప్మెంటు';
$string['devicedetectregex'] = 'పరికర గుర్తింపును సాధారణ వ్యక్తీకరణలను';
$string['devicedetectregex_desc'] = '<p> అప్రమేయంగా, మూడ్లె, టాబ్లెట్ (ఐప్యాడ్ ల, Android మాత్రలు) మరియు ఉత్తరదాయిత్వం (ఇంటర్నెట్ ఎక్స్ప్లోరర్ 6 వినియోగదారులు) రకం డిఫాల్ట్ పరికరాలు (డెస్క్టాప్ PC లు, ల్యాప్టాప్లు, etc), మొబైల్ (ఫోన్లు మరియు చిన్న చేతితో పట్టుకొనే పరికరాల) గుర్తించగలదు. థీమ్ సెలెక్టర్ ఈ అన్ని ప్రత్యేక నేపథ్యాలు దరఖాస్తు ఉపయోగించవచ్చు. ఈ సెట్టింగ్ అదనపు పరికరం రకాల గుర్తింపును అనుమతించే సాధారణ వ్యక్తీకరణలను (ఈ డిఫాల్ట్ రకాల ప్రాధాన్యత వహిస్తాయి). </ P> అనుమతిస్తుంది
<p> ఉదాహరణకు, మీరు సాధారణ వ్యక్తీకరణకు నమోదు కాలేదు \'/(MIDP-1.0|Maemo|Windows CE) /\' కొన్ని సాధారణంగా ఉపయోగించే ఫీచర్ ఫోన్ల తిరిగి విలువ \'featurephone\' జోడించడానికి గుర్తించడం. మీరు ఈ పరికరాల్లో ఉపయోగిస్తారు అని ఒక థీమ్ జోడించడానికి అనుమతించే థీమ్ సెలెక్టర్ \'featurephone\' జతచేస్తుంది. ఇతర ఫోన్లు ఇప్పటికీ మొబైల్ పరికరం రకం కోసం ఎంపిక థీమ్ ఉపయోగించడానికి ఉంటుంది. </ P>';
$string['devicedetectregexexpression'] = 'సాధారణ వ్యక్తీకరణ';
$string['devicedetectregexvalue'] = 'తిరిగి వఛ్హే వాల్యూ';
$string['devicetype'] = 'పరికరం రకం';
$string['devlibdirpresent'] = 'అభివృద్ధి లైబ్రరీలతో ఉన్న డైరెక్టరీలు, ముఖ్యంగా <em> / విక్రేత </em> మరియు <em> / node_modules </em>, ప్రజా సైట్లలో ఉండరాదు. మరిన్ని వివరాల కోసం <a href="{$a->moreinfourl} "> భద్రతా సమీక్ష నివేదిక </a> ను చూడండి.';
$string['disabled'] = 'డిసేబుల్ చేయబడింది';
$string['disableuserimages'] = 'యూజర్ ప్రొఫైల్ చిత్రాలు డిసేబుల్ చెయ్యండి';
$string['displayerrorswarning'] = 'PHP సర్వర్ సెట్టింగ్ <em> display_errors </em> ను ఉత్పాదన సైట్లలో సిఫారసు చేయలేదు ఎందుకంటే కొన్ని లోపం సందేశాలు మీ సర్వర్ గురించి సున్నితమైన సమాచారాన్ని బహిర్గతం చేస్తాయి.';
$string['displayloginfailures'] = 'లాగిన్ వైఫల్యాలను చూపించు';
$string['dndallowtextandlinks'] = 'డ్రాగ్ మరియు  డ్రాప్  టెక్స్ట్ / లింకుల అప్లోడ్';
$string['doclang'] = 'డాక్స్ కోసం భాష';
$string['docroot'] = 'Moodle డాక్స్ డాక్యుమెంట్ రూట్';
$string['doctonewwindow'] = 'కొత్త విండోలో తెరువు';
$string['doesnotfit'] = 'ఇమెయిల్ ప్రదర్శన సెట్టింగ్లు';
$string['doesnotfitdetail'] = 'Moodle ను వదిలిపెట్టిన ఇమెయిల్ కోసం సెట్టింగులను ప్రదర్శించు.';
$string['download'] = 'దింపుకోలు';
$string['durationunits'] = 'కాలపరిమితి యూనిట్లు';
$string['edithelpdocs'] = 'సహాయ డాక్యుమెంట్లను సవరించు';
$string['editlang'] = '<b>సవరించు</b>';
$string['editorbackgroundcolor'] = 'నేపథ్యపు రంగు';
$string['editordictionary'] = 'ఎడిటరు నిఘంటువు';
$string['editorfontfamily'] = 'ఖతి కుటుంబం';
$string['editorfontlist'] = 'ఖతుల జాబితా';
$string['editorfontsize'] = 'ఖతి సైజు';
$string['editorhidebuttons'] = 'దాచిన బొత్తాలు';
$string['editorkillword'] = 'Word ఫార్మాటు వడపోతకం';
$string['editorspelling'] = 'ఎడిటరు స్పెల్లింగు';
$string['editorspellinghelp'] = 'అక్షరక్రమ తనిఖీని ప్రారంభించండి లేదా నిలిపివేయండి. ప్రారంభించినప్పుడు, సర్వర్లో తప్పనిసరిగా <strong> aspell </strong> తప్పనిసరిగా వ్యవస్థాపించబడాలి.';
$string['editstrings'] = 'పదాలు లేక పదబంధాలను సవరించు';
$string['emailchangeconfirmation'] = 'ఈమెయిలు మార్పు నిర్ధారణ';
$string['emailfromvia'] = 'సమాచారం ద్వారా ఇమెయిల్';
$string['emoticonalt'] = 'ప్రత్యామ్నాయ టెక్స్టు';
$string['emoticoncomponent'] = 'బొమ్మ కాంపొనెంటు';
$string['emoticonimagename'] = 'బొమ్మ పేరు';
$string['emoticons'] = 'ఇమోటికాన్లు';
$string['emoticons_desc'] = 'మీ సైట్లో ఉపయోగించిన ఎమోటికాన్లు (లేదా స్మైలీలను) ఈ ఫారమ్ నిర్వచిస్తుంది. పట్టిక నుండి వరుసను తీసివేయడానికి, అవసరమైన ఖాళీలను ఏవైనా ఖాళీ విలువతో ఫార్మ్ సేవ్ చేయండి. కొత్త ఎమోటికాన్ను నమోదు చేయడానికి, గత ఖాళీ వరుసలో ఖాళీలను పూరించండి. అన్ని ఫీల్డ్లను డిఫాల్ట్ విలువలుగా రీసెట్ చేయడానికి, పై లింక్ను అనుసరించండి.

* టెక్స్ట్ (అవసరం) - ఈ టెక్స్ట్ ఎమోటికాన్ చిత్రంతో భర్తీ చేయబడుతుంది. కనీసం రెండు అక్షరాల పొడవు ఉండాలి.
* చిత్రం పేరు (అవసరం) - ఎమోటికాన్ ఇమేజ్ ఫైల్ పేరు పొడిగింపు లేకుండా, భాగం PIX ఫోల్డర్కు అనుగుణంగా ఉంటుంది.
* చిత్రం భాగం (అవసరం) - చిహ్నం అందించే భాగం.
* ప్రత్యామ్నాయ పాఠం (ఐచ్ఛికం) - ఎమోటికాన్ యొక్క ప్రత్యామ్నాయ టెక్స్ట్ యొక్క స్ట్రింగ్ ఐడెంటిఫైయర్ మరియు భాగం.';
$string['emoticonsreset'] = 'ఇమోటికాన్ల సెట్టింగును డిఫాల్టు విలువకు సెట్ చెయ్యి';
$string['emoticontext'] = 'టెక్స్టు';
$string['emptysettingvalue'] = 'ఖాళీ';
$string['enableblogs'] = 'బ్లాగులను ఎనేబుల్ చెయ్యి';
$string['enablecalendarexport'] = 'క్యాలెండరు ఎగుమతిని చేతనం చెయ్యి';
$string['enablecomments'] = 'వ్యాఖ్యలను చేతనం చెయ్యి';
$string['enablecourserequests'] = 'కోర్సు అభ్యర్ధ్గనలను చేతనం చెయ్యి';
$string['enabled'] = 'ఎనేబుల్ చెయ్యబడింది';
$string['enabledevicedetection'] = 'పరికర గుర్తింపును ప్రారంభించండి';
$string['enableglobalsearch'] = 'ప్రపంచ శోధనను ప్రారంభించండి';
$string['enableglobalsearch_desc'] = 'ప్రారంభించబడితే, డేటా షెడ్యూల్ చేయబడిన విధి ద్వారా ఇండెక్స్ చేయబడుతుంది మరియు సమకాలీకరించబడుతుంది.';
$string['enablegravatar'] = 'Gravatar ప్రారంభించండి';
$string['enablegravatar_help'] = 'ప్రారంభించబడినప్పుడు వినియోగదారు ఒక చిత్రం అప్లోడ్ చేయలేదు అంటే మూడ్లె Gravatar నుండి ఒక వినియోగదారు ప్రొఫైల్ చిత్రాన్ని పాందటానికి ప్రయత్నిస్తుంది';
$string['enablemobilewebservice'] = 'మొబైల్ పరికరాలకు వెబ్ సేవలు ప్రారంభించండి';
$string['enablerecordcache'] = 'రికార్డు కాషెను చేతనం చెయ్యి';
$string['enablerssfeeds'] = 'RSS వడ్డనలను చేతనం చెయ్యి';
$string['enablesearchareas'] = 'శోధన ప్రాంతాలను ప్రారంభించు';
$string['enablestats'] = 'గణాంకాలను చేతనం చెయ్యి';
$string['enabletrusttext'] = 'విశ్వసనీ కంటెంటును చేతనం చెయ్యి';
$string['enablewebservices'] = 'జాల సేవలను చేతనం చెయ్యి';
$string['enablewsdocumentation'] = 'జాలసేవల డాక్యుమెంటేషను';
$string['enrolinstancedefaults'] = 'చేరిక అనురూపపు డిఫాల్టులు';
$string['enrolinstancedefaults_desc'] = 'కొత్త కోర్సులో చేరికలకు డిఫాల్టు సెట్టింగులు';
$string['enrolmultipleusers'] = 'వాడుకరులు చేర్చు';
$string['environment'] = 'ఎన్విరాన్‍మెంటు';
$string['environmenterrortodo'] = 'ఈ Moodle వెర్షన్ను స్థాపించే ముందు పైనున్న అన్ని ఎన్విరాన్మెంట్ సమస్యలను (లోపాలు) పరిష్కరించాలి!';
$string['environmenterrorupgrade'] = 'హెచ్చరిక: మీరు ఈ మూడ్ల వెర్షన్ను అప్గ్రేడ్ చేయడానికి ముందు ఉన్న అన్ని పర్యావరణ సమస్యలను (లోపాలు) పరిష్కరించాలి! ఈ అవసరాలు తీయకుండానే అప్గ్రేడ్ డేటా నష్టం వంటి సమస్యలను కలిగిస్తుంది. అప్గ్రేడ్తో కొనసాగించాలనుకుంటున్నారా?';
$string['environmentmustfixsetting'] = 'PHP seTTiMgunu maarcaDaM tappanisari';
$string['environmentok'] = 'మీ సర్వరు ఎన్విరాన్మెంటు కనీస ఆవశ్యకాలన్నీ కలిగి ఉంది.';
$string['environmentrecommendcustomcheck'] = 'ఈ పరీక్ష విఫలమైతే, అది ఒక సమస్యను సూచిస్తున్నట్లే';
$string['environmentrecommendinstall'] = 'అత్యుత్తమ ఫలితాల కోసం స్థాపించి చేతనం చెయ్యాలి';
$string['environmentrecommendversion'] = '{$a->needed} వెర్షను ఉంటే మంచిది. మీరేమో {$a->current} వెర్షను వాడుతున్నారు';
$string['environmentrequirecustomcheck'] = 'ఈ టెస్ట్ ఉత్తీర్ణులు తప్పనిసరిగా కవాలి';
$string['environmentrequireinstall'] = 'స్థాపించి, చేతనం చెయ్యడం తప్పనిసరి';
$string['environmentrequireversion'] = '{$a->needed} వెర్షను తప్పనిసరి. మీరేమో {$a->current} వెర్షను వాడుతున్నారు';
$string['environmentsettingok'] = 'సిఫారసు అమరిక కనుగొనబడింది';
$string['environmentshouldfixsetting'] = 'PHP సెట్టింగ్ మారాలి.';
$string['environmentxmlerror'] = 'వాతావరణం డేటాను చదవడంలో లోపం ఉంది
({$a->error_code})';
$string['errordeletingconfig'] = 'ప్లగిన్ ఫర్ కాన్ఫిగరేషన్ రికార్డులను తొలగిస్తున్న సమయంలో ఒక దోషం ఏర్పడింది  \'{$a}\'.';
$string['errorsetting'] = 'ఈ సెట్టింగును భద్రపరచలేకపోయాం:';
$string['errorwithsettings'] = 'ఏదో లోపం కారణంగా కొన్ని సెట్టింగులను భద్రపరచలేకపోయాం.';
$string['eventshandlersinuse'] = 'మీ సిస్టమ్లో కింది ప్లగిన్లు ఈవెంట్స్ 1 API డీప్రికేటెడ్ హ్యాండ్లర్లను ఉపయోగిస్తున్నాయి: \'{$a}\'. దయచేసి ఈవెంట్స్ 2 API ని ఉపయోగించడానికి వాటిని నవీకరించండి. Https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers చూడండి.';
$string['everyonewhocan'] = '\'{$a}\' చెయ్యగలిగే ప్రతీ ఒక్కరూ';
$string['exceptions'] = 'మినహాయింపులు';
$string['execpathnotallowed'] = 'నిలిపివేయబడ్డాయి చేస్తోంది ఎక్జిక్యూటబుల్ మార్గాలను';
$string['experimental'] = 'ప్రయోగాత్మకం';
$string['experimentalsettings'] = 'ప్రయోగాత్మక సెట్టింగులు';
$string['extendedusernamechars'] = 'యూజర్ పొడిగించబడిన అక్షరాలను అనుమతించండి';
$string['extramemorylimit'] = 'అదనంగా PHP మెమొరీ పరిమితి';
$string['fatalsessionautostart'] = '<p> తీవ్రమైన ఆకృతీకరణ లోపం కనుగొనబడింది, సర్వర్ నిర్వాహకుడు తెలియజేయాలి దయచేసి. </ p> <p>సరిగా పనిచేసేలా, మూడ్లె నిర్వాహకుడు PHP సెట్టింగులు మార్చే అవసరం. </ p> <p> <code> session.auto_start </ code> తప్పక <code> ఆఫ్ ఈ సెట్టింగ్ <code> php.ini </ code> సవరించడం ద్వారా నియంత్రించబడుతుంది. </ p> <p> </ code> Apache / IIS <br /> ఆకృతీకరణ లేదా <code>.అమర్చవచ్చు</ code> సర్వర్ లో ఫైల్. </ p>';
$string['fileconversioncleanuptask'] = 'ఫైల్ మార్పిడుల కోసం తాత్కాలిక రికార్డుల శుభ్రత.';
$string['filecreated'] = 'కొత్త దస్త్రాన్ని సృష్టించాం';
$string['filestoredin'] = 'దస్త్రాన్ని ఈ ఫోల్డరులో భద్రపరచు:';
$string['filestoredinhelp'] = 'దస్త్రాన్ని భద్రపరచే చోట';
$string['filterall'] = 'అన్ని స్ట్రింగులనూ వడపోయి';
$string['filtermatchoneperpage'] = 'పేజీని  ఒక్కసారి మ్యాచ్  మరియు ఫిల్టర్ చెయ్యండి';
$string['filtermatchonepertext'] = 'టెక్స్ట్ ని  ఒక్కసారి   ఫిల్టర్  మరియు  మ్యాచ్ చెయ్యండి';
$string['filters'] = 'వడపోతలు';
$string['filtersettings'] = 'వడపోతలను నిర్వహించు';
$string['filtersettingsgeneral'] = 'సాధారణ వడపోత సెట్టింగులు';
$string['filteruploadedfiles'] = 'ఎక్కించిన దస్త్రాలను వడపోయి';
$string['forcelogin'] = 'వాడుకరులను తప్పనిసరిగా లాగిన్ అయ్యేలా చూడు';
$string['forceloginforprofileimage'] = 'వినియోగదారుల చిత్రాలను చూడడానికి లాగిన్  అయ్యేలా చేయండి';
$string['forceloginforprofileimage_help'] = 'ప్రారంభించబడి ఉంటే, వినియోగదారు  అన్ని నోటిఫికేషన్ ఇమెయిల్స్ లో ప్రొఫైల్ చిత్రాలు మరియు డిఫాల్ట్ యూజర్ చిత్రం వీక్షించడానికి వీలుగా ఖచ్చితంగా లాగ్ ఇన్ చేయాలి.';
$string['forceloginforprofiles'] = 'ప్రవరల కోసం వాడుకరులను తప్పనిసరిగా లాగిన్ అయ్యేలా చూడు';
$string['forcetimezone'] = 'డిఫాల్టు టైముజోన్ను బలవంతంగా అమలు చెయ్యి';
$string['formatuninstallwithcourses'] = '{$ ఒక-> లెక్క} ఉపయోగించి కోర్సులను {$ ఒక-> ఫార్మాట్} ఉన్నాయి. వారి ఫార్మాట్ {$ ఒక-> defaultformat} (ఈ సైట్ కోసం అప్రమేయ ఫార్మాట్) కు మార్చబడుతుంది. కొన్ని ఫార్మాట్-నిర్దిష్ట డేటా కోల్పోవచ్చు. మీరు కొనసాగాలని నిశ్చయించుకున్నారా?';
$string['frontpage'] = 'మొదటి పేజీ';
$string['frontpagebackup'] = 'మొదటి పేజీ బ్యాకప్పు';
$string['frontpagedefaultrole'] = 'డిఫాల్టు మొదటి పేజీ పాత్ర';
$string['frontpagefilters'] = 'మొదటి పేజీ వడపోతలు';
$string['frontpageloggedin'] = 'ఫ్రంట్ పేజీలో వస్తువులను లాగ్ ఇన్ చేసినప్పుడు';
$string['frontpageoverrides'] = 'ఫ్రంట్ పేజీలో అనుమతి ఔవర్రైడ్ చేస్తుంది';
$string['frontpagequestions'] = 'మొదటి పేజీ ప్రశ్నలు';
$string['frontpagerestore'] = 'మొదటి పేజీ రీస్టోరు';
$string['frontpageroles'] = 'మొదటి పేజీ పాత్రలు';
$string['frontpagesettings'] = 'మొదటి పేజీ సెట్టింగులు';
$string['fullnamedisplay'] = 'పూర్తి పేరు ఆకృతి';
$string['fullnamedisplayprivate'] = 'పూర్తిగా పేరు ఫార్మాట్ - ప్రైవేటు';
$string['gdrequired'] = 'GD పొడిగింపు ఇప్పుడు చిత్రం మార్పిడి ఫర్  Moodle ద్వారా అవసరం.';
$string['generalsettings'] = 'సాధారణ సెట్టింగులు';
$string['geoipfile'] = 'GeoIP నగర డేటా ఫైల్';
$string['getremoteaddrconf'] = 'లాగ్ ఇన్ IP అడ్రసు సోర్స్';
$string['globalsearch'] = 'గ్లోబల్ సెర్చ్';
$string['globalsearchmanage'] = 'ప్రపంచ శోధనని నిర్వహించండి';
$string['googlemapkey3'] = 'గూగుల్ మ్యాప్స్ API V3 కీ';
$string['googlemapkey3_help'] = 'మీరు IP చిరునామా లుక్అప్ విజువలైజేషన్ కోసం Google Maps ను ఉపయోగించడానికి ప్రత్యేక కీని నమోదు చేయాలి. <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank"> https://developers.google.com/ వద్ద ఉచితంగా కీ పొందవచ్చు మ్యాప్లు / డాక్యుమెంటేషన్ / జావాస్క్రిప్ట్ / ట్యుటోరియల్ # api_key </a>';
$string['gotofirst'] = 'మొట్టమొదటి తప్పిపోయిన స్ట్రింగ్ కు వెళ్ళండి';
$string['gradebook'] = 'గేడ్ బుక్';
$string['gradebookroles'] = 'గేడెడ్ పాత్రలు';
$string['gradeexport'] = 'ప్రాథమిక గ్రేడు ఎగుమతి పద్ధతులు';
$string['gravatardefaulturl'] = 'Gravatar డిఫాల్ట్ చిత్ర URL';
$string['gravatardefaulturl_help'] = 'Gravatar ఇచ్చిన యూజర్ కోసం చిత్రాన్ని కనుగొనలేకపోతే ప్రదర్శించడానికి డిఫాల్ట్ చిత్రాన్ని అవసరం. చిత్రం కోసం పూర్తి URL ను అందించండి. మీరు ఈ సెట్టింగ్ను ఖాళీగా వదిలేస్తే, Moodle మీరు చూసే పేజీకి సరైన డిఫాల్ట్ చిత్రాన్ని ఉపయోగించడానికి ప్రయత్నిస్తుంది. Gravatar అనేక కోడ్లను కలిగి ఉంది, ఇది <a href="https://en.gravatar.com/site/implement/images/#default-image"> డిఫాల్ట్ చిత్రాలను రూపొందించడానికి </a> ఉపయోగించబడుతుంది.';
$string['groupenrolmentkeypolicy'] = 'గుంపు చేరిక కీ విధానం';
$string['groupenrolmentkeypolicy_desc'] = 'ఈ మలుపు  ఒక చెల్లే పాస్వర్డ్ను విధానం వ్యతిరేకంగా మూడ్లె చెక్ సమూహం నమోదు కీలను చేస్తుంది';
$string['guestroleid'] = 'అతిథి యొక్క పాత్ర';
$string['guestroleid_help'] = 'ఈ పాత్ర అతిథి యూజర్ కు స్వయంచాలకంగా కేటాయించబడుతుంది. ఇది తాత్కాలికంగా అతిథి నమోదు ప్లగ్ఇన్ ద్వారా కోర్సు నమోదు ఆ చేరిన వినియోగదారులు కాదు కేటాయించిన.';
$string['helpadminseesall'] = 'నిర్వాహకుల అన్ని క్యాలెండర్ను ఈవెంట్లు లేదా తమను తాము దరఖాస్తు వారిలో చూస్తారు?';
$string['helpcalendarcustomexport'] = 'క్యాలెండర్ ఎగుమతుల్లో అనుకూల తేదీ పరిధి ఎగుమతి ఎంపికను ప్రారంభించండి. క్యాలెండర్ ఎగుమతులు తప్పక అమలు కావాలి.';
$string['helpexportlookahead'] = 'కస్టమ్ ఎగుమతి ఎంపిక కోసం ఎగుమతి సమయంలో ఈవెంట్స్ కోసం క్యాలెండర్ లుక్ భవిష్యత్తులో ఎన్ని రోజులు చేస్తుంది?';
$string['helpexportlookback'] = 'కస్టమ్ ఎగుమతి ఎంపిక కోసం ఎగుమతి సమయంలో ఈవెంట్స్ కోసం గతంలో ఎన్ని రోజులు క్యాలెండర్ చూడండి?';
$string['helpforcetimezone'] = 'మీరు వినియోగదారులను వారి సమయమండలిని వ్యక్తిగతంగా ఎంచుకోవడానికి లేదా ప్రతిఒక్కరికీ సమయ మండలిని నిర్బంధించవచ్చు.';
$string['helpshowicalsource'] = 'ప్రారంభించబడితే, iCal- దిగుమతి చేసిన ఈవెంట్లకు సబ్స్క్రిప్షన్ పేరు మరియు లింక్ చూపబడుతుంది.';
$string['helpsitemaintenance'] = 'ఉన్నతీకరణకు, ఇతర పనికి';
$string['helpstartofweek'] = 'ఏ రోజు క్యాలెండర్ లో వారం ప్రారంభమవుతుంది?';
$string['helpupcominglookahead'] = 'డిఫాల్ట్ ద్వారా  భవిష్యత్ లో  ఎన్ని రోజులు రాబోయే ఈవెంట్స్ క్యాలెండర్లో కనిపిస్తోంది.';
$string['helpupcomingmaxevents'] = 'డిఫాల్టుగా ఎన్ని (గరిష్ఠం) రాబోవు ఘటనలను వాడుకరులకు చూపించాలి?';
$string['helpweekenddays'] = 'వారంలోని ఏ రోజులను వారంతంగా భావించి, వేరే రంగులో చూపించాలి?';
$string['hiddenuserfields'] = 'వాడుకరి ఫీల్డులను దాచు';
$string['hidefromall'] = 'అన్ని వినియోగదారులను నుండి దాచడానికి';
$string['hidefromnone'] = 'ఏ ఒక్కరూ నుంచి దాచడానికి';
$string['hidefromstudents'] = 'విద్యార్ధులు నుండి దాచిపెట్టడానికి';
$string['htmleditor'] = 'HTML ఎడిటరు';
$string['htmleditorsettings'] = 'HTML ఎడిటర్ సెట్టింగ్లు';
$string['htmlsettings'] = 'HTML సెట్టింగులు';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP భద్రత';
$string['iconvrequired'] = 'ICONV పొడిగింపుకు ఇన్స్టాల్ అవసరమవుతుంది';
$string['ignore'] = 'పట్టించుకోకు';
$string['includemoduleuserdata'] = 'మాడ్యూల్లో వినియోగదారుని డేటాను చేర్చండి';
$string['incompatibleblocks'] = 'అనుకూలత లేని బ్లాక్స్';
$string['incompleteunicodesupport'] = 'MySQL లేదా MariaDB ప్రస్తుత సెటప్ \'utf8\' ను ఉపయోగిస్తోంది. ఈ పాత్ర సమితి కొన్ని ఎమోజిని కలిగి ఉన్న నాలుగు బైట్ అక్షరాలకు మద్దతు ఇవ్వదు. ఈ అక్షరాలు ఉపయోగించడానికి ప్రయత్నిస్తున్నప్పుడు ఒక రికార్డును నవీకరిస్తున్నప్పుడు లోపం ఏర్పడుతుంది మరియు డేటాబేస్కి పంపిన సమాచారం కోల్పోతుంది. దయచేసి మీ సెట్టింగులను \'utf8mb4\' కు మార్చడాన్ని పరిశీలించండి. పూర్తి వివరాలు కోసం డాక్యుమెంటేషన్ చూడండి.';
$string['indexdata'] = 'ఇండెక్స్ డేటా';
$string['indexinginfo'] = '\'గ్లోబల్ సెర్చ్ ఇండెక్సింగ్\' షెడ్యూల్ టాస్క్ ఉపయోగించి మీ సైటు యొక్క విషయాలను సూచించడానికి సిఫారసు చేయబడిన మార్గం.';
$string['installhijacked'] = 'అసలు IP అడ్రసు నుండి పూర్తి చేయాలి. సంస్థాపనా  క్షమించండి';
$string['installsessionerror'] = 'PHP సెషన్ ప్రారంభించడానికి చెయ్యలేరని, మీ బ్రౌజర్ కుకీలను అంగీకరిస్తున్నట్లు ధృవీకరించండి.';
$string['intlrecommended'] = 'Intl పొడిగింపు అటువంటి లొకేల్ తెలుసుకునే విభజన, అంతర్జాతీయమైన మద్దతు మెరుగుపర్చడానికి ఉపయోగిస్తారు.';
$string['intlrequired'] = 'అంతర్జాతీయీకరణ మద్దతును మెరుగుపరచడానికి Intl పొడిగింపు అవసరమవుతుంది, లొకేల్ అవేర్ సార్టింగ్ మరియు అంతర్జాతీయ డొమైన్ పేర్లు.';
$string['invalidagedigitalconsent'] = 'అనుమతి యొక్క డిజిటల్ యుగం చెల్లదు: {$a}';
$string['invalidforgottenpasswordurl'] = 'మర్చిపోయి పాస్వర్డ్ URL చెల్లుబాటు అయ్యే URL కాదు.';
$string['invalidsection'] = 'సరైన విభాగం కాదు.';
$string['invaliduserchangeme'] = 'వినియోగదారు పేరు "changeme" ప్రత్యేకించబడింది - మీరు దాని ద్వారా ఏ ఖాతాను సృష్టించలేరు.';
$string['ipblocked'] = 'ప్రస్తుతం ఈ సైటు అందుబాటులో లేదు.';
$string['ipblocker'] = 'IP నిరోధకం';
$string['ipblockersyntax'] = 'ఒక లైన్ లో ప్రతి ప్రవేశం ఉంచండి. చెల్లుబాటు అయ్యే ఎంట్రీలు ఒకే హోస్ట్కు సరిపోయే పూర్తి IP చిరునామా (ఇటువంటి <b> 192.168.10.1 </ b> వంటివి); లేదా పాక్షిక చిరునామా (<b> 192.168 </ b> వంటిది); లేదా CIDR సంజ్ఞామానం (<b> 231.54.211.0/20 </ b> వంటివి); లేదా పరిధి యొక్క చివరి భాగానికి పరిధిని వర్తించే IP చిరునామాలు (<b> 231.3.56.10-20 </ b> వంటివి). టెక్స్ట్ డొమైన్ పేర్లు (\'example.com\' వంటివి) కు మద్దతు లేదు. ఖాళీ పంక్తులు విస్మరించబడతాయి.';
$string['iplookup'] = 'IP అడ్రసు లుక్ అప్';
$string['iplookupgeoplugin'] = 'భౌగోళిక సమాచారాన్ని వెతకడానికి ప్రస్తుతం <a href="http://www.geoplugin.com"> జియోప్లగ్గిన్ </a> సేవ వాడుతున్నారు. మరింత ఖచ్చితమైన ఫలితాల కోసం మేము MaxMind GeoLite డేటాబేస్ యొక్క స్థానిక కాపీని ఇన్స్టాల్ చేయాలని సిఫార్సు చేస్తున్నాము.';
$string['iplookupinfo'] = 'డిఫాల్ట్గా, గూగుల్ ఐపి చిరునామాలను చూసేందుకు ఉచిత ఆన్లైన్ NetGeo (ది ఇంటర్నెట్ జియోగ్రాఫిక్ డేటాబేస్) సర్వర్ ఉపయోగిస్తుంది, దురదృష్టవశాత్తూ ఈ డేటాబేస్ ఇక నిర్వహించబడదు మరియు <em> క్రమరహితంగా తప్పు </ em> డేటాను తిరిగి పొందవచ్చు.
ఉచిత GeoLite2 సిటీ డాటాబేస్ యొక్క స్థానిక కాపీని MaxMind నుండి ఇన్స్టాల్ చేయటానికి ఇది సిఫార్సు చేయబడింది. <br />
IP చిరునామా స్థానం సాధారణ మ్యాప్లో లేదా Google మ్యాప్స్ ఉపయోగించి ప్రదర్శించబడుతుంది. దయచేసి Google ఖాతాను కలిగి ఉండటం మరియు ఇంటరాక్టివ్ మ్యాప్లను ఎనేబుల్ చెయ్యడానికి ఉచిత Google మ్యాప్స్ API కీ కోసం దరఖాస్తు అవసరం.';
$string['iplookupmaxmindnote'] = 'ఈ ఉత్పత్తిలో మాగ్ మాండ్ సృష్టించిన GeoLite2 డేటా, <a href="http://www.maxmind.com"> http://www.maxmind.com </a> నుండి అందుబాటులో ఉంటుంది.';
$string['ishttpswarning'] = 'HTTPS ను ఉపయోగించి మీ సైట్ సురక్షితం కాలేదని గుర్తించబడింది. పెరిగిన భద్రతకు మరియు ఇతర వ్యవస్థలతో మెరుగైన అనుసంధానం కోసం మీ సైట్ను HTTPS కు మార్చడానికి గట్టిగా సిఫార్సు చేయబడింది.';
$string['keeptagnamecase'] = 'టాగ్ పేరు కేసింగ్ కలిగి ఉంచేందుకు';
$string['lang'] = 'డిఫాల్టు భాష';
$string['langcache'] = 'CACHE భాషా మెనూ';
$string['langcache_desc'] = 'భాష మెనుని క్యాష్ చేయండి. ప్రారంభించబడితే, అందుబాటులో ఉన్న అనువాదాలు జాబితా కాష్ చేయబడింది. అంతర్నిర్మిత భాషా పధకాలను నిర్వహణా సాధనం ద్వారా భాష ప్యాక్ని ఇన్స్టాల్ చేసినప్పుడు లేదా తొలగించినప్పుడు కాష్ స్వయంచాలకంగా రిఫ్రెష్ అవుతుంది. మీరు మాన్యువల్గా కొత్త భాష ప్యాక్ను ఇన్స్టాల్ చేస్తే, కాష్ చేయబడిన జాబితాను రిఫ్రెష్ చేయడానికి అన్ని క్యాచీలు ఫీచర్ను మీరు ఉపయోగించాలి.';
$string['langlist'] = 'భాషా మెనూలోని భాషలు';
$string['langmenu'] = 'భాషా మెనూను చూపించు';
$string['langpackwillbeupdated'] = 'గమనిక: ఉన్నతీకరించేటపుడు, ప్రస్తుతం ఎంచుకోబడి ఉన్న భాషాప్యాకును Moodle తాజాకరిస్తుంది.';
$string['langstringcache'] = 'అన్ని భాష స్ట్రింగ్స్ CACHE';
$string['languagesettings'] = 'భాష సెట్టింగులు';
$string['latinexcelexport'] = 'Excel ఎన్ కోడింగ్';
$string['legacyfilesaddallowed'] = 'లెగసీ కోర్సు యొక్క ఫైళ్ళను జోడించడంలో అనుమతించండి';
$string['legacyfilesaddallowed_help'] = 'ఒక కోర్సులో లెగసీ కోర్సు యొక్క ఫైళ్ళను కలిగి ఉంటే, కొత్త ఫైళ్ళను మరియు ఫోల్డర్లను అది జోడించబడింది అనుమతిస్తాయి.';
$string['legacyfilesinnewcourses'] = 'కొత్త కోర్సులు ఉన్న లెగసీ కోర్సు ఫైళ్లు';
$string['legacyfilesinnewcourses_help'] = 'అప్రమేయంగా, లెగసీ కోర్సు ఫైల్స్ ప్రాంతాలు కేవలం అప్గ్రేడెడ్ కోర్సులు అందుబాటులో ఉన్నాయి. దయచేసి కార్యాచరణ బ్యాకప్ మరియు పునరుద్ధరణ వంటి కొన్ని లక్షణాలు ఈ సెట్టింగ్తో అనుకూలంగా లేవని దయచేసి గమనించండి.';
$string['libcurlwarning'] = 'ఇది libcurl కు CURLOPT_PROTOCOL మద్దతు లేదు అని గుర్తించబడింది. భద్రతా కారణాల దృష్ట్యా ఒక నవీనమైన libcurl సంస్థాపన సిఫార్సు చేయబడింది.';
$string['licensesettings'] = 'లైసెన్సు సెట్టింగులు';
$string['linkadmincategories'] = 'లింక్ అడ్మిన్ కేతగిరీలు';
$string['linkadmincategories_help'] = 'నిర్వాహక సెట్టింగ్ వర్గాలు నావిగేషన్లో లింక్లుగా ప్రదర్శించబడితే మరియు నిర్వాహక వర్గం పేజీలకు దారి తీస్తుంది.';
$string['linkcoursesections'] = 'ఎల్లప్పుడూ కోర్సు విభాగాలను లింక్ చేయండి.';
$string['linkcoursesections_help'] = 'కోర్సు విభాగాల కోసం ఎల్లప్పుడూ లింక్ను అందించడానికి ప్రయత్నించండి. కోర్సు విభాగాలు సాధారణంగా ఒక్కొక్క విభాగానికి ఒక్క విభాగాన్ని ప్రదర్శిస్తే, అవి కేవలం లింకులుగా మాత్రమే చూపించబడతాయి. ఈ సెట్టింగ్ ప్రారంభించబడితే, లింక్ ఎల్లప్పుడూ అందించబడుతుంది.';
$string['loading'] = 'లోడు చేస్తున్నాం';
$string['localetext'] = 'లోకల్ Sitewide';
$string['localstringcustomization'] = 'స్థానిక స్ట్రింగ్ లాభాల కోసం చేయు మార్పులు';
$string['location'] = 'స్థలం';
$string['locationsettings'] = 'స్థలం సెట్టింగులు';
$string['locked'] = 'లాక్ చేయబడింది';
$string['lockoutduration'] = 'ఖాతా వ్యాయామశాలను వ్యవధి';
$string['lockoutduration_desc'] = 'ఖాతా లాక్ ఆటోమేటిక్ గా ఈ వ్యవధి తర్వాత అన్లాక్.';
$string['lockoutemailbody'] = '';
$string['lockoutemailsubject'] = 'మీ ఖాతాను  లో {$ a}  లాక్ చేయబడింది';
$string['lockouterrorunlock'] = 'చెల్లుబాటులో లేని ఖాతాను అన్ లాక్ ఇన్ఫర్మేషన్ అందించబడిన.';
$string['lockoutthreshold'] = 'ఖాతా వ్యాయామశాలను ప్రవేశ ద్వారం';
$string['lockoutthreshold_desc'] = 'ఖాతా నిర్బంధం వల్ల విఫలమైంది లాగిన్ ప్రయత్నాలు సంఖ్య ఎంచుకోండి. ఈ ఫీచర్ సేవా తిరస్కరణ దాడులు వేధింపులకు ఉండవచ్చు.';
$string['lockoutwindow'] = 'ఖాతా వ్యాయామశాలను అబ్జర్వేషన్ విండో';
$string['lockoutwindow_desc'] = 'ఉన్నాయి ఉంటే వ్యాయామశాలను ప్రవేశ అబ్జర్వేషన్ సమయం, ఎటువంటి ప్రవేశ కౌంటర్ ఈ సమయం తర్వాత రీసెట్ చేయబడుతుంది ప్రయత్నాలు విఫలమయ్యాయి.';
$string['log'] = 'లాగ్‍లు';
$string['logguests'] = 'అతిథి సందర్శనలను లాగ్ చెయ్యి';
$string['logguests_help'] = 'ఈ సెట్టింగ్ అతిథి ఖాతా ద్వారా లాగింగ్ చర్యలను ప్రారంభిస్తుంది మరియు వినియోగదారులు లాగిన్ చేయబడదు. పనితీరు కారణాల కోసం హై ప్రొఫైల్ సైట్లు ఈ లాగింగ్ను డిసేబుల్ చెయ్యవచ్చు. ఉత్పత్తి సెట్టింగ్లలో ఈ సెట్టింగు ఎనేబుల్ చేసుకోవడం మంచిది.';
$string['loginpageautofocus'] = 'ఆటోఫోకస్లను లాగిన్ పేజీలో ఫారం';
$string['loginpageautofocus_help'] = 'ఈ ఎంపికను ప్రారంభించడం లాగిన్ పేజీ యొక్క వినియోగాన్ని మెరుగుపరుస్తుంది, కానీ స్వయంచాలకంగా దృష్టి పెట్టే ఫీల్డ్లు ప్రాప్యత సమస్యగా పరిగణించబడవచ్చు.';
$string['loglifetime'] = 'లాగ్‍లను ఇంత కాలం పాటు ఉంచు:';
$string['logo'] = 'లోగో';
$string['logo_desc'] = 'కొన్ని థీమ్స్ (కోర్ థీమ్స్ వంటివి) ద్వారా అలంకరించడానికి ఉపయోగించబడే పూర్తి లోగో. ఈ చిత్రం చాలా అధిక రిజల్యూషన్ ఉంటుంది ఎందుకంటే ఇది ఉపయోగం కోసం తగ్గించబడుతుంది (మరియు పనితీరుకు కాష్). వారు ఎక్కువగా ఉన్న వాటి కంటే విస్తృతమైన లోగోలు సాధారణంగా మంచి ఫలితాలు ఇస్తాయి. ఆకృతులు అంగీకరించబడ్డాయి: PNG మరియు JPG.';
$string['logocompact'] = 'కాంపాక్ట్ లోగో';
$string['logocompact_desc'] = 'ఎగువ అదే లోగో యొక్క కాంపాక్ట్ వెర్షన్, అటువంటి చిహ్నం, డాలు లేదా ఐకాన్ వంటి. చిత్రం కూడా చిన్న పరిమాణాల్లో స్పష్టంగా ఉండాలి. ఆకృతులు అంగీకరించబడ్డాయి: PNG మరియు JPG.';
$string['logossettings'] = 'లోగోస్';
$string['logstorenotrequired'] = 'Log స్టోర్ అవసరం లేదు';
$string['logstoressupported'] = 'ఈ నివేదికను మద్దతు ఇచ్చే  స్టోర్లలో లాగిన్ అవ్వండి.';
$string['longtimewarning'] = '<b>ఈ ప్రాసెసు చాలా సమయం తీసుకోవచ్చని గమనించండి.</b>';
$string['mailnewline'] = 'మయిల్లొ న్యూలైను క్యారెక్టర్లు';
$string['maintenancemode'] = 'నిర్వహణ మోడ్‍లో';
$string['maintenancemodeisscheduled'] = 'ఈ సైట్ {$ ఒక-> min} నిమిషాలు {$ ఒక-> sec} సెకన్లు లో నిర్వహణ మోడ్ స్విచ్ ఉంటుంది';
$string['maintenancemodeisscheduledlong'] = 'ఈ సైట్ నిర్వహణ మోడ్కు {$a->hour} గంటల {$a->min} నిమిషాల్లో {$a->sec} సెకన్లు';
$string['maintfileopenerror'] = 'నిర్వహణ దస్త్రాలను తెరవడంలో లోపం!';
$string['maintinprogress'] = 'నిర్వహణ జరుగుతూ ఉంది...';
$string['manageformats'] = 'కోర్సు ఫార్మాట్లు నిర్వహించడానికి';
$string['manageformatsgotosettings'] = 'డిఫాల్ట్ ఆకృతిని  లో {ఒక $}  ద్వారా మార్చవచ్చు';
$string['managelang'] = 'నిర్వహించు';
$string['manageqbehaviours'] = 'ప్రశ్న ప్రవర్తనలను నిర్వహించు';
$string['manageqtypes'] = 'ప్రశ్న రకాలను నిర్వహించు';
$string['maturity100'] = 'బీటా';
$string['maturity150'] = 'రిలీస్ క్యాండిడేట్';
$string['maturity200'] = 'స్థిర వెర్షన్';
$string['maturity50'] = 'ఆల్ఫా';
$string['maturityallowunstable'] = 'సూచన: మీరు --allow-అస్థిర ఎంపికను తో ఈ స్క్రిప్ట్ అమలు కావాలి';
$string['maturitycoreinfo'] = 'మా సైట్ ప్రస్తుతం అస్థిర "{$ a}" అభివృద్ధి కోడ్';
$string['maturitycorewarning'] = 'మీరు ఇన్స్టాల్ చేయబోతున్న లేదా అప్గ్రేడ్ చేయబోయే మూడ్ల యొక్క సంస్కరణ
అస్థిర "{$a}" అభివృద్ధి కోడ్ చాలా ఉత్పత్తిపై ఉపయోగపడదు
సైట్లు. మీరు కావాల్సినది కాకుంటే మీరు అప్డేట్ చేస్తున్నారని నిర్ధారించుకోండి
Moodle కోడ్ యొక్క STABLE శాఖ నుండి. మరిన్ని వివరాల కోసం Moodle డాక్స్ను చూడండి.';
$string['maxbytes'] = 'ఎక్కింపు దస్త్రం గరిష్ఠ సైజు';
$string['maxconsecutiveidentchars'] = 'వెంటవెంటనే వచ్చే ఒకే కారెక్టర్లు';
$string['maxeditingtime'] = 'పోస్ట్లను ఎడిట్ చెయ్యడానికి గరిష్ఠ సమయం';
$string['maxtimelimit'] = 'గరిష్ట కాలపరిమితి';
$string['maxtimelimit_desc'] = 'ఏ అవుట్ పుట్ ప్రదర్శించబడకుండా Moodle అనుమతించే గరిష్ట PHP అమలు సమయం పరిమితం చేయడానికి, ఇక్కడ సెకన్లలో ఒక విలువను నమోదు చేయండి. 0 అర్థం Moodle డిఫాల్ట్ ఆంక్షలు ఉపయోగిస్తారు. మీరు దాని స్వంత సమయ పరిమితితో ఫ్రంట్-ఎండ్ సర్వర్ను కలిగి ఉంటే, లాగ్లలో PHP లోపాలను స్వీకరించడానికి ఈ విలువను తక్కువగా సెట్ చేయండి. CLI స్క్రిప్ట్లకు వర్తించదు.';
$string['maxusersperpage'] = 'ఒక పేజీకి గరిష్ఠ వినియోగదారులు';
$string['mbstringrecommended'] = 'మీ సైట్ లాటిన్-కాని లాటిన్ భాషలకు మద్దతు ఇస్తుంటే, సైట్ పనితీరును మెరుగుపరచడానికి ఐచ్ఛిక MBSTRING లైబ్రరీని ఇన్స్టాల్ చేయడం మంచిది.';
$string['mediapluginavi'] = '.avi వడపోతను చేతనం చెయ్యి';
$string['mediapluginflv'] = '.flv వడపోతను చేతనం చెయ్యి';
$string['mediapluginimg'] = 'లింక్ చిత్రాల స్వీయ పొందుపరచడానికి ప్రారంభించండి';
$string['mediapluginmov'] = '.mov వడపోతను చేతనం చెయ్యి';
$string['mediapluginmp3'] = '.mp3 వడపోతను చేతనం చెయ్యి';
$string['mediapluginmpg'] = '.mpg వడపోతను చేతనం చెయ్యి';
$string['mediapluginogg'] = '.ogg వడపోతకాన్ని చేతనం చెయ్యి';
$string['mediapluginogv'] = '.ogv వడపోతకాన్ని చేతనం చెయ్యి';
$string['mediapluginram'] = '.ram వడపోతను చేతనం చెయ్యి';
$string['mediapluginrm'] = '.rm వడపోతను చేతనం చెయ్యి';
$string['mediapluginrpm'] = '.rpm వడపోతను చేతనం చెయ్యి';
$string['mediapluginswf'] = '.swf వడపోతను చేతనం చెయ్యి';
$string['mediapluginswfnote'] = 'ఒక డిఫాల్ట్ భద్రతా చర్యగా, సాధారణ వినియోగదారులు SWF ఫ్లాష్ ఫైళ్లు పొందుపరచడానికి అనుమతి చేయరాదు.';
$string['mediapluginwmv'] = '.wmv వడపోతను చేతనం చెయ్యి';
$string['mediapluginyoutube'] = '.YouTube లింకుల వడపోతను చేతనం చెయ్యి';
$string['messaging'] = 'సందేశాలు సిస్టమ్ ఎనేబుల్ చెయ్యి';
$string['messagingallowemailoverride'] = 'నోటిఫికేషన్ను మెయిల్ ఓవర్రైడు';
$string['messagingdeletereadnotificationsdelay'] = 'నోటిఫికేషన్లను తొలగించడానికి';
$string['minpassworddigits'] = 'డిజిట్లు';
$string['minpasswordlength'] = 'సంకేతపదం పొడవు';
$string['minpasswordlower'] = 'చిన్నబడి అక్షరాలు';
$string['minpasswordnonalphanum'] = 'అక్షరాలు ఆంకెలూ కాని కారెక్టర్లు';
$string['minpasswordupper'] = 'పెద్దబడి అక్షరాలు';
$string['misc'] = 'ఇతరత్రా';
$string['mnetrestore_extusers'] = '<strong> గమనిక: </strong> ఈ బ్యాకప్ ఫైల్లో రిమోట్ Moodle నెట్వర్క్ యూజర్ ఖాతాలు ఉన్నాయి, ఇది ప్రక్రియలో భాగంగా పునరుద్ధరించబడుతుంది.';
$string['mnetrestore_extusers_admin'] = '<strong> గమనిక: </strong> ఈ బ్యాకప్ ఫైల్ వేరొక Moodle ఇన్స్టాలేషన్ నుండి వచ్చి, రిమోట్ Moodle నెట్వర్క్ యూజర్ ఖాతాలను కలిగి ఉంది. పునరుద్ధరించే విధానం అన్ని వినియోగదారులకు Moodle నెట్వర్క్ హోస్ట్స్తో సరిపోలడానికి ప్రయత్నిస్తుంది. సరిపోలే కాదు ఆ స్వయంచాలకంగా అంతర్గత ధృవీకరణ (బదులుగా mnet ఒక) స్విచ్ అవుతుంది. పునరుద్ధరణ లాగ్ గురించి మీకు తెలియజేస్తుంది.';
$string['mnetrestore_extusers_mismatch'] = '<strong> గమనిక: </strong> ఈ బ్యాకప్ ఫైల్ వేరొక Moodle ఇన్స్టాలేషన్ నుండి ఉద్భవించింది మరియు పునరుద్ధరించడానికి విఫలమైన రిమోట్ Moodle నెట్వర్క్ యూజర్ ఖాతాలను కలిగి ఉంటుంది. ఈ ఆపరేషన్ మద్దతు లేదు. ఈ Moodle ఇన్స్టాలేషన్లో ఇది సృష్టించబడిందని మీరు భావిస్తే లేదా అవసరమైన అన్ని Moodle నెట్వర్క్ హోస్ట్లు కాన్ఫిగర్ చేయబడతాయని మీరు నిర్ధారిస్తారు, మీరు ఇప్పటికీ పునరుద్ధరణను ప్రయత్నించవచ్చు.';
$string['mnetrestore_extusers_noadmin'] = '<strong> గమనిక: </ strong> ఈ బ్యాకప్ ఫైల్ వేరొక Moodle ఇన్స్టాలేషన్ నుండి వచ్చి, రిమోట్ Moodle నెట్వర్క్ యూజర్ ఖాతాలను కలిగి ఉంది. ఈ రకమైన పునరుద్ధరణను అమలు చేయడానికి మీకు అనుమతి లేదు. సైట్ యొక్క నిర్వాహకుడిని సంప్రదించండి లేదా, ప్రత్యామ్నాయంగా, ఏదైనా యూజర్ సమాచారం (గుణకాలు, ఫైల్స్ ...) లేకుండా ఈ కోర్సును పునరుద్ధరించండి.';
$string['mnetrestore_extusers_switchuserauth'] = 'రిమోట్ Moodle నెట్వర్క్ యూజర్ {$a->username} ({$a->mnethosturl} నుండి వస్తోంది) స్థానిక {$ a->auth} ప్రమాణీకరించబడిన వినియోగదారుకి మారారు.';
$string['mobilenotconfiguredwarning'] = 'Moodle మొబైల్ ప్రారంభించబడలేదు.';
$string['modeditdefaults'] = 'వ్యాపకాల సెట్టింగులకు డిఫాల్టు విలువలు';
$string['modsettings'] = 'పనులను నిర్వహించు';
$string['modulesecurity'] = 'మాడ్యూలు భద్రత';
$string['multilangforceold'] = 'పాత multilang వాక్యనిర్మాణం ఫోర్స్: & lt; span & gt; lang & gt; తరగతి = "multilang" మరియు & lt లేకుండా;';
$string['mustenablestats'] = 'గణాంకాలను ఇంకా ఈ సైట్ చేతనము చేయబడెను లేదు.';
$string['mycoursesperpage'] = 'కోర్సుల సంఖ్య';
$string['mydashboard'] = 'సిస్టము డిఫాల్టు డ్యాషుబోర్డు';
$string['mymoodle'] = 'డాష్ బోర్డ్';
$string['mymoodleredirect'] = 'వాడుకరులు నా Moodle వాడటాన్ని తప్పనిసరి చెయ్యి';
$string['mypage'] = 'డిఫాల్టు నా Moodle పేజీ';
$string['mypagelocked'] = 'డిఫాల్టు పేజీని లాకు చెయ్యి';
$string['myprofile'] = 'డిఫాల్టు ప్రవర పేజీ';
$string['navadduserpostslinks'] = 'యూజర్ పోస్ట్ వీక్షించడానికి లింకులు జోడించండి';
$string['navadduserpostslinks_help'] = 'ప్రారంభించినట్లయితే, ప్రతి లింకును నావిగేషన్లో ప్రతి యూజర్కు జోడించబడుతుంటే వినియోగదారుని చర్చలు చూడటం మరియు వినియోగదారు సైట్లను లేదా నిర్దిష్ట కోర్సులు అంతటా ఫోరంలలో చేసిన పోస్ట్లను చూడటం.';
$string['navcourselimit'] = 'కోర్సు పరిమితి';
$string['navigationupgrade'] = 'ఈ నవీకరణ ఈ రెండు బ్లాకులను భర్తీ చేసే రెండు కొత్త నావిగేషన్ బ్లాక్స్ను పరిచయం చేస్తుంది: అడ్మినిస్ట్రేషన్, కోర్సులు, చర్యలు మరియు పాల్గొనేవారు. మీరు ఆ బ్లాక్లలో ఏదైనా ప్రత్యేక అనుమతులను సెట్ చేసినట్లయితే మీరు కోరుకున్నట్లు ప్రతిదానిని ప్రవర్తించేలా చూసుకోవాలి.';
$string['navshowallcourses'] = 'కోర్సులన్నిటినీ చూపించు';
$string['navshowcategories'] = 'కోర్సు వర్గాలను చూపించు';
$string['navshowfrontpagemods'] = 'ముందు పేజీ కార్యకలాపాలు పేజీకి సంబంధించిన లింకులో చూపించు';
$string['navshowfrontpagemods_help'] = 'ప్రారంభించబడితే, సైట్ పేజీల క్రింద నావిగేషన్లో ముందు పేజీ కార్యాచరణలు చూపబడతాయి.';
$string['navshowfullcoursenames'] = 'కోర్సు పూర్తి పేర్లు చూపు';
$string['navshowfullcoursenames_help'] = 'ప్రారంభించబడితే, కోర్సు పూర్తి పేర్లు చిన్న పేర్ల కంటే నావిగేషన్లో ఉపయోగించబడతాయి.';
$string['navshowmycoursecategories'] = 'నా కోర్సు వర్గాలు చూపుతుంది';
$string['navshowmycoursecategories_help'] = 'వినియోగదారుల్లో ఎనేబుల్ చేసిన కోర్సులు నా కోర్టు శాఖ కేతగిరీలు లో చూపబడుతుంది.';
$string['navsortmycoursessort'] = 'క్రమీకరించు నా కోర్సులు';
$string['navsortmycoursessort_help'] = 'ఈ కోర్సులను విధమైన ఆర్డర్ ప్రకారం నా కోర్సులు కింద ఇవ్వబడ్డాయి లేదో నిర్ణయిస్తుంది (అంటే సైట్ పరిపాలన> కోర్సులు సెట్ ఆర్డర్> కోర్సులు మరియు కేతగిరీలు నిర్వహించండి) లేదా అక్షర కోర్సు ఏర్పాటు ద్వారా.';
$string['never'] = 'నెవర్';
$string['neverdeleteruns'] = 'పరుగులను ఎన్నటికీ తొలగించవద్దు';
$string['newestdocindexed'] = 'సరిక్రొత్త పత్రం ఇండెక్స్ చేయబడింది';
$string['nobookmarksforuser'] = 'మీకు పేజీకలేమీ లేవు.';
$string['nodatabase'] = 'డేటాబేసు లేదు';
$string['nohttpsformobilewarning'] = 'ఇది చెల్లుబాటు అయ్యే ప్రమాణపత్రంతో HTTPS ను ప్రారంభించాలని సిఫార్సు చేయబడింది. ముందుగా సురక్షితమైన కనెక్షన్ను ఉపయోగించడానికి Moodle అనువర్తనం ఎల్లప్పుడూ ప్రయత్నిస్తుంది.';
$string['nomissingstrings'] = 'మిస్సింగు స్ట్రింగులేమీ లేవు';
$string['none'] = 'నన్';
$string['nonewsettings'] = 'ఏ కొత్త సెట్టింగ్లు ఈ నవీకరణ సమయంలో జోడించడం సాధ్యం కాదు';
$string['nonexistentbookmark'] = 'మీరడిగిన పేజీక అసలే లేదు.';
$string['noreplyaddress'] = 'రిప్లై అడ్రసు లేదు';
$string['noreplydomain'] = 'నో ప్రత్యుత్తరం మరియు డొమైన్';
$string['noreplydomaindetail'] = 'ప్రత్యుత్తరం మరియు ఆకృతీకరించిన డొమైన్లకు సెట్టింగులు';
$string['noresults'] = 'ఫలితాలేమీ దొరకలేదు.';
$string['noroles'] = 'పాత్రల్లేవు';
$string['nosupportedlogstore'] = 'మద్దతు గల logstore కనుగొనబడలేదు';
$string['notifications'] = 'వార్తలు';
$string['notifyloginfailures'] = 'లాగిన్ వైఫల్యాలను ఇక్కడికి ఈమెయిలు చెయ్యి:';
$string['notifyloginthreshold'] = 'ఈమెయిలు గమనింపులకు గుమ్మం (త్రెషోల్డ్)';
$string['notloggedinroleid'] = 'సందర్శకుల కోసం పాత్ర';
$string['numberofmissingstrings'] = '{$ a}';
$string['numberofstrings'] = 'స్ట్రింగ్స్ యొక్క మొత్తం సంఖ్య: {$a-> strings} <br /> తప్పిపోయింది: {$a-> missing} ({$a-> missingpercent} & nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'మీ సైట్ {$ a-> siteurl} లో OAuth సేవల {$a->issuer} యొక్క ఒక రిఫ్రెష్ టోకెన్ గడువు ముగిసింది. ఇది ఈ సేవను ఉపయోగించే ఏ ప్లగ్ఇన్ల కార్యాచరణను పరిమితం చేస్తుంది. ఈ సమస్యను పరిష్కరించడానికి, OAuth 2 సర్వీసులు కాన్ఫిగరేషన్ పేజీని సందర్శించండి మరియు ఈ సేవ కోసం పట్టిక వరుసలో "కనెక్ట్ సిస్టమ్ ఖాతా" చిహ్నాన్ని క్లిక్ చేయండి. ప్రతిసారీ OAuth సిస్టమ్ కోసం అదే సేవా ఖాతాను ఉపయోగించి ఖచ్చితంగా లాగిన్ అవ్వండి.';
$string['oauthrefreshtokenexpiredshort'] = 'మీ సైట్ {$a->siteurl} లో {$a->issuer} కోసం OAuth రిఫ్రెష్ టోకెన్ గడువు ముగిసింది.';
$string['onlynoreply'] = 'నో-ప్రత్యుత్తర చిరునామా నుండి మాత్రమే';
$string['opcacherecommended'] = 'PHP opcode చేజింగ్ పనితనం మెరుగుపరుస్తుంది మరియు మెమొరీ అవసరాలని తగ్గిస్తుంది, OPCache పొడిగింపు సిఫారసు చేయబడుతుంది మరియు పూర్తిగా మద్దతిస్తుంది.';
$string['opensslrecommended'] = 'ఐచ్ఛిక OpenSSL లైబ్రరీని ఇన్స్టాల్ చేయడం అత్యంత సిఫార్సు చేయబడింది - ఇది Moodle నెట్వర్కింగ్ కార్యాచరణను ప్రారంభిస్తుంది.';
$string['opensslrequired'] = 'OpenSSL PHP పొడిగింపు యిప్పుడు బలమైన క్రిప్టోగ్రఫిక్ సేవలను అందించటానికి మూడ్లె ద్వారా అవసరం.';
$string['opentowebcrawlers'] = 'Google ను స్వాగతిస్తూ';
$string['optionalmaintenancemessage'] = 'ఐచ్ఛిక నిర్వహణ సందేశం';
$string['order1'] = 'మొదటి';
$string['order2'] = 'సెకండ్';
$string['order3'] = 'మూడవ';
$string['order4'] = 'నాలుగో';
$string['outgoingmailconfig'] = 'అవుట్గోయింగ్ మెయిల్ కాన్ఫిగరేషన్';
$string['overridetossl'] = 'లాగిన్ల కోసం HTTPS ఇప్పుడు తీసివేయబడింది. ఈ సందర్భం ఇప్పుడు SSL కు బలవంతంగా ఉంది. ఈ హెచ్చరికను మీ wwwroot ను config.php లో https: // కు మార్చండి.';
$string['passwordchangelogout'] = 'పాస్వర్డ్ మార్పు తర్వాత బయటకు లాగ్ అవుట్ చేయడం.';
$string['passwordchangelogout_desc'] = 'ప్రారంభించబడితే, ఒక పాస్వర్డ్ మార్చబడినప్పుడు, అన్ని క్రొత్త సెషన్లు పేర్కొన్న వాటిలో కాకుండా అన్ని బ్రౌజర్ సెషన్లు రద్దు చేయబడతాయి. (సమూహ వినియోగదారు అప్లోడ్ ద్వారా ఈ సెట్టింగ్ పాస్ వర్డ్ మార్పులను ప్రభావితం చేయదు.)';
$string['passwordchangetokendeletion'] = 'పాస్వర్డ్ మార్పు తర్వాత వెబ్ సేవ యాక్సెస్ టోకెన్లను తీసివేయండి';
$string['passwordchangetokendeletion_desc'] = 'ప్రారంభించబడితే, పాస్వర్డ్ మార్చబడినప్పుడు, అన్ని వినియోగదారుల వెబ్ సేవా యాక్సెస్ టోకెన్లు తొలగించబడతాయి.';
$string['passwordpolicy'] = 'సంకేతపదం విధానం';
$string['passwordresettime'] = 'పాస్ వర్డ్ రీసెట్ అభ్యర్థనను ప్రామాణీకరించడానికి గరిష్ట సమయం';
$string['passwordreuselimit'] = 'పాస్వర్డ్ రొటేషన్ పరిమితిని';
$string['passwordreuselimit_desc'] = 'వినియోగదారు పాస్వర్డ్ను పునఃపరిశీలించే ముందు వారి పాస్వర్డ్ను తప్పనిసరిగా మార్చాలి. గతంలో ఉపయోగించే పాస్వర్డ్ల హ్యాష్లు స్థానిక డేటాబేస్ టేబుల్లో నిల్వ చేయబడ్డాయి. ఈ ఫీచర్ కొన్ని బాహ్య ధృవీకరణ ప్లగిన్లతో అనుకూలంగా ఉండకపోవచ్చు.';
$string['pathtodot'] = 'మార్గం డాట్';
$string['pathtodot_help'] = 'డాట్ చేయడానికి మార్గం. లైనక్స్లో ఇది / usr / bin / dot లాగా ఉంటుంది. విండోస్లో C: \\ Program Files (x86) \\ Graphviz2.38 \\ bin \\ dot.exe లాగా ఉంటుంది. Mac లో / ఆప్ట్ / స్థానిక / బిన్ / డాట్ లాగా ఉంటుంది. DOT ఫైల్స్ నుండి గ్రాఫిక్స్ని తయారు చేయటానికి, ఇక్కడ డాట్ ఎగ్జిక్యూటబుల్ మరియు పాయింట్ ను మీరు తప్పక సంస్థాపించాలి.';
$string['pathtodu'] = 'మార్గం డాట్';
$string['pathtogs'] = 'గోస్టుస్క్రిప్ట్ మార్గంలో.';
$string['pathtogs_help'] = 'చాలా లైనక్స్ సంస్థాపనలో, ఇది \'/ usr / bin / gs\' గా వదిలివేయబడుతుంది. విండోస్లో ఇది c: \\ gs \\ bin \\ gswin32c.exe \'లాగా ఉంటుంది (మార్గంలో ఖాళీలు లేవు - అవసరమైతే\' gswin32c.exe \'మరియు\' gsdll32.dll \'ఫైళ్లను ఒక కొత్త ఫోల్డర్కు మార్గంలో ఖాళీ లేకుండా)';
$string['pathtopgdump'] = 'మార్గం pg_dump చెయ్యడానికి';
$string['pathtopgdumpdesc'] = 'మీరు మీ సిస్టమ్పై ఒకటి కంటే ఎక్కువ pg_dump కలిగి ఉంటే మాత్రమే ఎంటర్ చెయ్యడం అవసరం (ఉదాహరణకు, మీరు పోస్ట్గ్రేస్గ్ల్ యొక్క ఒకటి కంటే ఎక్కువ వెర్షన్లను కలిగి ఉంటే)';
$string['pathtopgdumpinvalid'] = 'Pg_dump కు చెల్లని మార్గం - తప్పు మార్గంలో లేదా ఎక్జిక్యూటబుల్ కాదు';
$string['pathtopsql'] = 'Psql పాత్';
$string['pathtopsqldesc'] = 'మీరు మీ సిస్టమ్పై ఒకటి కంటే ఎక్కువ psql ను కలిగి ఉంటే మాత్రమే ఎంటర్ చెయ్యాలి (ఉదాహరణకు మీరు పోస్ట్గ్రేస్గ్ల్ ఒకటి కంటే ఎక్కువ వెర్షన్లను కలిగి ఉంటే)';
$string['pathtopsqlinvalid'] = 'PSql కు చెల్లని మార్గం - తప్పు మార్గంలో లేదా ఎక్జిక్యూటబుల్ కాదు';
$string['pathtopython'] = 'పైథాన్కు మార్గం';
$string['pathtopythondesc'] = 'మీ ఎక్జిక్యూటబుల్ పైథాన్ బైనరీకి మార్గం (పైథాన్ 2 మరియు పైథాన్ 3 రెండూ ఆమోదయోగ్యం).';
$string['pcreunicodewarning'] = 'ఇది యూనీకోడ్ అక్షరాలతో అనుసంధానించబడిన PCRE PHP ఎక్స్టెన్షన్ను ఉపయోగించడానికి గట్టిగా సిఫార్సు చేయబడింది.';
$string['perfdebug'] = 'ప్రదర్శన సమాచారం';
$string['performance'] = 'పెర్ఫార్మెన్స్';
$string['pgcluster'] = 'PostgreSQL క్లస్టర్';
$string['pgclusterdescription'] = 'కమాండ్ లైన్ ఆపరేషన్లకు PostgreSQL వెర్షన్ / క్లస్టర్ పారామితి. మీరు మీ సిస్టమ్లో ఒక పోస్ట్గ్రేస్గ్ల్ మాత్రమే కలిగివుంటే లేదా ఇది ఖచ్చితంగా తెలియకపోతే, దీన్ని ఖాళీగా వదిలేయండి.';
$string['phpfloatproblem'] = 'PHP ఫ్లోట్ సంఖ్యలను నిర్వహించడంలో ఊహించని సమస్య కనుగొనబడింది - {$a}';
$string['pleaserefreshregistration'] = 'మీ సైట్ నమోదు చేయబడింది. రిజిస్ట్రేషన్ చివరిగా నవీకరించబడింది {$a}. <br /> సైట్ రిజిస్ట్రేషన్ షెడ్యూల్ టాస్క్ మీ రిజిస్ట్రేషన్ తాజాగా ఉంచుతుంది. మీరు ఎప్పుడైనా మీ రిజిస్ట్రేషన్ని మానవీయంగా నవీకరించవచ్చు.';
$string['pleaserefreshregistrationnewdata'] = 'నమోదు సమాచారం మార్చబడింది. దయచేసి దీన్ని \'అప్డేట్ రిజిస్ట్రేషన్\' బటన్ ఉపయోగించి నిర్ధారించండి.';
$string['pleaserefreshregistrationunknown'] = 'మీ సైట్ నమోదు చెయ్యబడింది కానీ నమోదు తేదీ తెలియదు. దయచేసి మీ రిజిస్ట్రేషన్ రిజిస్ట్రేషన్ బటన్ను ఉపయోగించి రిజిస్ట్రేషన్ను అప్డేట్ చేయండి లేదా \'సైట్ రిజిస్ట్రేషన్\' షెడ్యూల్ టాస్క్ ఎనేబుల్ చేయబడిందని నిర్ధారించుకోండి, అందువల్ల మీ రిజిస్ట్రేషన్ స్వయంచాలకంగా నవీకరించబడుతుంది';
$string['plugin'] = 'ప్లగిన్';
$string['plugins'] = 'ప్లగిన్లు';
$string['pluginscheck'] = 'ప్లగిన్ ఆధారపడటం వంటి తనిఖీ';
$string['pluginscheckfailed'] = 'డిపెన్డెన్సీలు అయిన {$ ఒక-> pluginslist} కోసం విఫలమైన తనిఖీ';
$string['pluginschecktodo'] = 'మీరు ఈ మూడ్లె వెర్షన్ను ఇన్స్టాల్ చేయడానికి ముందు అన్ని ప్లగ్ఇన్ అవసరాలను తీసివేయాలి!';
$string['pluginsoverview'] = 'ప్లగిన్లు వివరణ';
$string['pluginsoverviewsee'] = 'మరిన్ని వివరాలకు <a href="{$a-> url} "> ప్లగిన్లను అవలోకనం </a> పేజీ చూడండి.';
$string['policysettings'] = 'విధాన సెట్టింగ్లు';
$string['privacyandpolicies'] = 'గోప్యత మరియు విధానాలు';
$string['privacysettings'] = 'గోప్యతా సెట్టింగ్లు';
$string['profilecategory'] = 'వర్గం';
$string['profilecategoryname'] = 'వర్గం పేరు (ప్రత్యేకంగా ఉండాలి)';
$string['profilecategorynamenotunique'] = 'ఈ వర్గం పేరు ఈసరికే వాడుకలో ఉంది';
$string['profilecommonsettings'] = 'సామాన్య సెట్టింగులు';
$string['profileconfirmcategorydeletion'] = 'ఈ విభాగంలో {$a} ఫీల్డ్ / లు ఉన్నాయి, ఇది ఎగువ విభాగానికి (లేదా అగ్ర వర్గం లో ఉంటే) తరలించబడుతుంది. <br /> మీరు ఇప్పటికీ ఈ వర్గాన్ని తొలగించాలనుకుంటున్నారా?';
$string['profileconfirmfielddeletion'] = 'ఈ క్షేత్రానికి / {{a}} వినియోగదారు రికార్డు / s లు తొలగించబడతాయి. <br /> మీరు ఇప్పటికీ ఈ ఫీల్డ్ని తొలగించాలనుకుంటున్నారా?';
$string['profilecreatecategory'] = 'ఓ కొత్త ప్రవర వర్గాన్ని సృష్టించు';
$string['profilecreatefield'] = 'ఓ కొత్త ప్రవర ఫీల్డును సృష్టించు:';
$string['profilecreatenewcategory'] = 'ఓ కొత్త వర్గాన్ని సృష్టిస్తున్నాం';
$string['profilecreatenewfield'] = 'ఒక కొత్త \'{$ a} యొక్క ప్రొఫైల్ రంగంలో సృష్టించుట';
$string['profiledefaultcategory'] = 'ఇతర ఫీల్డులు';
$string['profiledefaultchecked'] = 'డిఫాల్ట్గా ఎంచుకోబడింది';
$string['profiledefaultdata'] = 'డిఫాల్టు విలువ';
$string['profiledeletecategory'] = 'ఒక వర్గం తొలగించడం';
$string['profiledeletefield'] = 'తొలగిస్తున్నది ఫీల్డ్ {$a}\'';
$string['profiledescription'] = 'ఫీల్డు వివరం';
$string['profiledscript'] = 'ఈ స్క్రిప్ట్ లైవ్స్ చేయబడింది';
$string['profiledscriptview'] = 'ఈ స్క్రిప్ట్ కోసం ప్రొఫైలింగ్ సమాచారాన్ని వీక్షించండి';
$string['profileeditcategory'] = 'వర్గాన్ని సరిదిద్దుతున్నాం: {$a}';
$string['profileeditfield'] = 'ప్రవర ఫీల్డును సరిదిద్దుతున్నాం: {$a}';
$string['profilefield'] = 'ప్రవర ఫీల్డు';
$string['profilefieldcolumns'] = 'కాలమ్స్';
$string['profilefieldispassword'] = 'ఇది సంకేతపదం ఫీల్డా?';
$string['profilefieldlink'] = 'లింకు';
$string['profilefieldlink_help'] = 'ఒక లంకెగా టెక్స్ట్ అనుకరిస్తే, $$ టెక్స్ట్ భర్తీ చేయబడతాయి $$ కలిగిన ఒక URL ను ఎంటర్ చెయ్యండి. ఉదాహరణకు, ఒక లింక్ ఒక ట్విట్టర్ ID అనుకరిస్తే, http://twitter.com/$$ ఎంటర్.';
$string['profilefieldlinktarget'] = 'లింకు లక్ష్యం';
$string['profilefieldmaxlength'] = 'గరిష్ఠ నిడివి';
$string['profilefieldrows'] = 'అడ్డ వరుసలు';
$string['profilefields'] = 'వాడుకరి ప్రవర ఫీల్డులు';
$string['profilefieldsize'] = 'డిస్ప్లే సైజు';
$string['profileforceunique'] = 'డేటా ప్రత్యేకంగా ఉండాలా?';
$string['profileinvaliddata'] = 'తప్పుడు విలువ';
$string['profilelocked'] = 'ఈ ఫీల్డు లాక్ చెయ్యబడిందా?';
$string['profilemenudefaultnotinoptions'] = 'డిఫాల్టు విలువ వికల్పాల్లోది కాదు';
$string['profilemenunooptions'] = 'మెనూ వికల్పాలేమీ ఇవ్వలేదు';
$string['profilemenuoptions'] = 'మెనూ వికల్పాలు (వరుస కొకటి)';
$string['profilemenutoofewoptions'] = 'కనీసం 2 వికల్పాలు ఇవ్వాలి';
$string['profilename'] = 'పేరు';
$string['profilenofieldsdefined'] = 'ఫీల్డులు వేటినీ నిర్వచించలేదు';
$string['profilerequired'] = 'ఈ ఫీల్డు ఆవశ్యకమా?';
$string['profileroles'] = 'కనిపించే పాత్రలు ప్రొఫైల్';
$string['profilesforenrolledusersonly'] = 'చేరిన వాడుకరుల ప్రవరలు మాత్రమే.';
$string['profileshortname'] = 'పొట్టి పేరు (యునిగ్గా ఉండాలి)';
$string['profileshortnamenotunique'] = 'ఈ పొట్ట పేరు ఈసరికే వాడుకలో ఉంది';
$string['profilesignup'] = 'సైనప్ పేజీలో చూపించాలా?';
$string['profilespecificsettings'] = 'నిర్దిష్ట సెట్టింగులు';
$string['profilevisible'] = 'ఈ ఫీల్డు ఎవరెవరికి కనిపిస్తుంది?';
$string['profilevisible_help'] = '* కనిపించదు  నిర్వాహకులు మాత్రమే చూపబడుతుంది ప్రైవేట్ డేటా కోసం
* వినియోగదారు కనిపించే - యూజర్ మరియు నిర్వాహకులు మాత్రమే చూపబడుతుంది ప్రైవేట్ డేటా కోసం
* అందరికీ కనిపిస్తుంది.';
$string['profilevisibleall'] = 'అందరికీ కనిపిస్తుంది';
$string['profilevisiblenone'] = 'కనిపించదు';
$string['profilevisibleprivate'] = 'వాడుకరికి కనిపిస్తుంది';
$string['profiling'] = 'ప్రొఫైలింగ్';
$string['profilingallowall'] = 'నిరంతర ప్రొఫైలింగ్';
$string['profilingallowall_help'] = 'మీరు ఈ సెట్టింగ్ను ప్రారంభిస్తే, అప్పుడు, ఏ సమయంలో, మీరు మూడ్లె సెషన్ జీవితం పాటు అన్ని అమలు స్క్రిప్ట్స్ కోసం ప్రొఫైలింగ్ ఎనేబుల్ PROFILEALL పారామితి ఎక్కడైనా (PGC) ఉపయోగించవచ్చు. Analogously, మీరు ఆపడానికి PROFILEALLSTOP పారామితి ఉపయోగించవచ్చు.';
$string['profilingallowme'] = 'ఎంచుకొన్న ప్రొఫైలింగ్';
$string['profilingallowme_help'] = 'మీరు ఈ సెట్టింగ్ను ప్రారంభిస్తే, అప్పుడు, ఎంపిక, మీరు జరగవచ్చు స్క్రిప్ట్ కోసం PROFILEME పారామితి ఎక్కడైనా (PGC) మరియు వ్యక్తిత్వం ఉపయోగించవచ్చు. Analogously మీరు జరిగే ప్రొఫైలింగ్ నిరోధించడానికి DONTPROFILEME పారామితి ఉపయోగించవచ్చు.';
$string['profilingautofrec'] = 'స్వయంచాలక ప్రొఫైలింగ్';
$string['profilingautofrec_help'] = 'ఈ సెట్టింగ్ను కాన్ఫిగర్ చేయడం ద్వారా, కొన్ని అభ్యర్థన (యాదృచ్ఛికంగా, పేర్కొన్న ఫ్రీక్వెన్సీ ఆధారంగా - N యొక్క 1) ఎంచుకోబడుతుంది మరియు స్వయంచాలకంగా రూపొందించబడుతుంది, తదుపరి విశ్లేషణ కోసం ఫలితాలను నిల్వ చేస్తుంది. ప్రొఫైలింగ్ యొక్క ఈ మార్గాన్ని గమనించండి / మినహాయించు అమర్పులను గమనించండి. ఆటోమేటిక్ ప్రొఫైలింగ్ను నిలిపివేయడానికి దానిని 0 కు సెట్ చేయండి.';
$string['profilingenabled'] = 'ప్రొఫైలింగ్ ఎనేబుల్';
$string['profilingenabled_help'] = 'మీరు ఈ సెట్టింగ్ని ప్రారంభిస్తే, ఈ సైట్లో ప్రొఫైలింగ్ అందుబాటులో ఉంటుంది మరియు మీరు తదుపరి ఎంపికలను కాన్ఫిగర్ చేయడం ద్వారా దాని ప్రవర్తనను నిర్వచించగలుగుతారు.';
$string['profilingexcluded'] = 'ప్రొఫైలింగ్ తొలగించాయి';
$string['profilingexcluded_help'] = '\'ప్రొఫైలు ఈ\' సెట్టింగుచే నిర్వచించబడిన వాటి నుండి తీసివేయబడకుండా తొలగించబడే URL లు (కామాతో వేరు చేయబడినవి, సంపూర్ణ చీలిక wwwroot, పిలవదగినవి).';
$string['profilingimportprefix'] = 'దిగుమతి ఉపసర్గ ప్రొఫైలింగ్';
$string['profilingimportprefix_desc'] = 'సులభ గుర్తింపు కోసం, దిగుమతి చేయబడిన ప్రొఫైలింగ్ పరుగులు ఇక్కడ పేర్కొన్న విలువతో పూర్వం చేయబడతాయి.';
$string['profilingincluded'] = '';
$string['profilingincluded_help'] = 'స్వయంచాలకంగా రూపొందించబడిన URL ల (కామాతో వేరుచేయబడిన, సంపూర్ణ చీలిక wwwroot, కాల్ చేయదగిన) URL ల జాబితా. ఉదాహరణలు: /index.php, /course/view.php. ఏ వైఖరిని కూడా * వైల్డ్ఛార్ అంగీకరిస్తుంది. ఉదాహరణలు: / mod / forum / *, /mod/*/view.php.';
$string['profilinglifetime'] = '';
$string['profilinglifetime_help'] = 'మీరు పాత ప్రొఫైలింగ్ పరుగులు గురించి సమాచారం ఉంచాలని అనుకుంటున్నారా సమయం పేర్కొనండి. వృద్ధాప్యం క్రమానుగతంగా కత్తిరించబడుతుంది. ఇది \'రిఫరెన్స్ రన్\' గా గుర్తించబడిన ఏదైనా ప్రొఫైలింగ్ రన్ని మినహాయించిందని గమనించండి.';
$string['protectusernames'] = 'వాడుకరిపేర్లను కాపాడు';
$string['proxybypass'] = 'ప్రాక్సీ బైపాస్ ఆతిథ్య';
$string['proxyhost'] = 'ప్రాక్సీ హోస్టు';
$string['proxypassword'] = 'ప్రాక్సీ సంకేతపదం';
$string['proxyport'] = 'ప్రాక్సీ పోర్టు';
$string['proxytype'] = 'ప్రాక్సీ రకం';
$string['proxyuser'] = 'ప్రాక్సీ వాడుకరిపేరు';
$string['purgecaches'] = 'కాషెలన్నిటినీ ఖాళీ చెయ్యి';
$string['purgecachesconfirm'] = 'మూడ్లె థీమ్స్, జావాస్క్రిప్ట్, లాంగ్వేజ్ స్ట్రింగ్స్, వడపోత వచనం, RSS ఫీడ్లను మరియు లెక్కించిన డేటా యొక్క అనేక ఇతర ముక్కలను కాష్ చేయవచ్చు. ఈ క్యాచెస్ను తొలగించడం డేటాను పునరుద్ధరించడానికి సర్వర్ మరియు శక్తి బ్రౌజర్ల నుండి ఆ డేటాను తొలగిస్తుంది, అందువల్ల మీరు ప్రస్తుత కోడ్ ద్వారా ఉత్పత్తి చేయబడిన అత్యంత తాజా విలువలను చూస్తున్నారని మీరు నిర్ధారిస్తారు. క్యాషెస్ను ప్రక్షాళన చేయడంలో ఎలాంటి ప్రమాదం లేదు, అయితే సర్వర్ మరియు క్లయింట్లు క్రొత్త సమాచారాన్ని లెక్కించి, కాష్ చేస్తేనే మీ సైట్ కొద్దిసేపు నెమ్మదిగా కనిపిస్తుంది.';
$string['purgecachesfinished'] = 'కాషెలన్నిటినీ ఖాళీ చేసాం';
$string['query'] = 'ప్రశ్న';
$string['question'] = 'పశ్న';
$string['questionbehaviours'] = 'ప్రశ్న ప్రవర్తనలు';
$string['questioncwqpfscheck'] = 'ఒక క్విజ్లో ఒకటి లేదా అంతకంటే ఎక్కువ \'యాదృచ్ఛిక\' ప్రశ్నలు భాగస్వామ్య మరియు అన్షర్వెడ్ ప్రశ్న వర్గాల మిశ్రమం నుండి ప్రశ్నలను ఎంచుకోవడానికి ఏర్పాటు చేయబడ్డాయి. మరింత వివరణాత్మక నివేదిక <ahref="{$a->reporturl} "> ఇక్కడ ఉంది </a> మరియు Moodle డాక్స్ పేజీ <a href="{$a->docsurl}"> ఇక్కడ </a> చూడండి.';
$string['questioncwqpfsok'] = 'గుడ్. మీ క్విజెస్లో ఎటువంటి \'యాదృచ్చిక\' ప్రశ్నలు లేవు, అవి షేర్డ్ మరియు అన్షేర్డ్ ప్రశ్న వర్గాల మిశ్రమం నుండి ప్రశ్నలను ఎంచుకోవడానికి ఏర్పాటు చేయబడ్డాయి.';
$string['questiontype'] = 'ప్రశ్న రకం';
$string['questiontypes'] = 'ప్రశ్న రకాలు';
$string['quizattemptsupgradedmessage'] = 'మూడ్లె 2.1 లో ప్రశ్నలకు ఒక ప్రధాన నవీకరణ ఉంది. తరువాత రన్ అయ్యే డేటాబేస్ అప్గ్రేడ్ భాగాలను ఆలస్యం చేయడం సాధ్యపడింది. మూడ్లె 2.7 కు అప్గ్రేడ్ చేయడానికి ముందు, ఈ అప్గ్రేడ్ పూర్తవుతుంది.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA ప్రైవేటు కీ';
$string['recaptchapublickey'] = 'ReCAPTCHA పబ్లిక్ కీ';
$string['register'] = 'మీ సైట్ నమోదు చెయ్యండి';
$string['registration'] = 'నమోదు';
$string['registration_help'] = 'Moodle.org మీ సైట్ను నమోదు <a href="http://moodle.org/stats"> మూడ్లె ఉపయోగ గణాంకాలు </a> దోహదం మరియు కోర్సులను భాగస్వామ్యం చెయ్యలేరు, భద్రతా హెచ్చరిక నోటిఫికేషన్లు అందుకోవడానికి క్రమంలో మద్దతిస్తుంది <a href="http://moodle.net/"> Moodle.net </a>.';
$string['registrationwarning'] = 'మీ సైట్ ఇంకా నమోదు కాలేదు.';
$string['registrationwarningcontactadmin'] = 'మీ సైట్ ఇంకా నమోదు కాలేదు. దయచేసి మీ నిర్వాహకుడికి తెలియజేయండి.';
$string['releasenoteslink'] = 'మూడ్లె యొక్క ఈ వెర్షన్ గురించి సమాచారం కోసం, ఆన్లైన్ <a target="_blank" href="{$a}"> విడుదల </a> గమనికలు చూడండి';
$string['rememberusername'] = 'వినియోగదారు పేరును గుర్తుంచుకోండి';
$string['rememberusername_desc'] = 'మీరు యూజర్ లాగిన్ సమయంలో వినియోగదారు పేర్లతో శాశ్వత కుకీలను నిల్వ చేయాలనుకుంటే ప్రారంభించండి. అనుమతి లేకుండా ఉపయోగించినట్లయితే శాశ్వత కుకీలు గోప్యతా సమస్యగా పరిగణించబడవచ్చు.';
$string['reportsmanage'] = 'నివేదికలను నిర్వహించండి';
$string['requiredentrieschanged'] = '<strong> ముఖ్యమైనది - <br/> (ఈ హెచ్చరిక సందేశం మాత్రమే ఈ నవీకరణ సమయంలో ప్రదర్శించబడుతుంది) చదవండి దయచేసి </ strong> <br/> కారణంగా బగ్ను పరిష్కరించుటకు, \'అవసరం ఎంట్రీలు మరియు ఉపయోగించి డేటాబేస్ కార్యకలాపాలు ప్రవర్తన\' వీక్షణ సెట్టింగులు \'సెట్టింగులు ముందు అవసరమైన ఎంట్రీలు మారుతుంది. మార్పులు మరిన్ని వివరముల డేటాబేస్ మాడ్యూల్ ఫోరమ్ </a> చేసుకుంటాయి href="http://moodle.org/mod/forum/discuss.php?d=110928" <a న చదవవచ్చు . ఈ సెట్టింగులను భావిస్తున్నారు ప్రవర్తన కూడా <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank"> మూడ్లె డాక్స్ </a> న చదవవచ్చు.
<br/> <br/> ఈ మార్పు మీ వ్యవస్థ క్రింది డేటాబేస్ ప్రభావితం చేస్తుంది: (ఇప్పుడు ఈ జాబితా సేవ్, మరియు నవీకరణ తర్వాత, ఈ చర్యలు ఇప్పటికీ teacher అనుకున్నట్లు ఆ విధంగా పని ఉందని తనిఖీ చెయ్యండి.) <br/> <strong > {$ ఒక-> టెక్స్ట్} </ strong> <br/>';
$string['requiremodintro'] = 'సూచించే వివరణని అవసరమవుతుంది';
$string['requiremodintro_desc'] = 'ఎనేబుల్ ఉంటే, వినియోగదారులు ప్రతి సూచించే కోసం వివరణ ఎంటర్ బలవంతంగా చేయబడుతుంది.';
$string['requires'] = 'ఆవశ్యకం';
$string['restorecourse'] = 'కోర్సు పునరుద్ధరించు';
$string['restorernewroleid'] = 'కోర్సుల్లో restorers \'పాత్ర';
$string['restorernewroleid_help'] = 'క్రొత్తగా పునరుద్ధరించబడిన కోర్సును నిర్వహించేందుకు వినియోగదారుకు ఇప్పటికే అనుమతి లేకపోతే, వినియోగదారు ఈ పాత్రను స్వయంచాలకంగా కేటాయించి, అవసరమైతే చేరాడు. పునరుద్ధరణకర్తలు ప్రతి పునరుద్ధరించిన కోర్సును నిర్వహించకూడదనుకుంటే "ఏదీ కాదు" ఎంచుకోండి.';
$string['reverseproxy'] = 'రివర్స్ ప్రాక్సీ';
$string['riskconfig'] = 'వినియోగదారులు సైట్ ఆకృతీకరణ మరియు ప్రవర్తనను మార్చవచ్చు';
$string['riskconfigshort'] = 'ఆకృతీకరణ రిస్క్';
$string['riskdataloss'] = 'యూజర్లు కంటెంట్ లేదా సమాచారాన్ని పెద్ద మొత్తంలో నాశనం చేయబోవచ్చును';
$string['riskdatalossshort'] = 'డాటా  యొక్క నష్టం ప్రమాదాన్ని.';
$string['riskmanagetrust'] = 'వినియోగదారులు ఇతర వినియోగదారుల నమ్మకమైన సెట్టింగ్లను మార్చవచ్చు';
$string['riskmanagetrustshort'] = 'ట్రస్ట్ నిర్వహించండి';
$string['riskpersonal'] = 'వినియోగదారులు ఇతర వినియోగదారుల ప్రైవేట్ సమాచారాన్ని ప్రాప్యతను పొందడం కోసం కాలేదు';
$string['riskpersonalshort'] = 'Privacy రిస్క్';
$string['riskspam'] = 'వినియోగదారులు సైట్ వినియోగదారులు లేదా ఇతరులకు స్పామ్ పంపవచ్చు';
$string['riskspamshort'] = 'స్పామ్ రిస్క్';
$string['riskxss'] = 'వినియోగదారులు క్రాస్-సైట్ స్క్రిప్టింగ్ అనుమతించే ఫైళ్లు మరియు పాఠాలు జోడించడానికి కాలేదు (XSS)';
$string['riskxssshort'] = 'XSS రిస్క్';
$string['roleswithexceptions'] = '{$ ఒక-> పాత్రలు}, {$ ఒక-> మినహాయింపులు}';
$string['rssglobaldisabled'] = 'సర్వర్ డిసేబుల్ చెయ్యబడింది';
$string['save'] = 'భద్రపరచు';
$string['savechanges'] = 'మార్పులను భద్రపరచు';
$string['scssinvalid'] = 'SCSS కోడ్ చెల్లదు, విఫలమవుతుంది: {$ }';
$string['search'] = 'వెతుకు';
$string['searchallavailablecourses'] = 'శోధించదగిన కోర్సులు';
$string['searchallavailablecourses_desc'] = 'కొన్ని సందర్భాలలో ఎక్కువ సంఖ్యలో కోర్సులను శోధిస్తున్నప్పుడు శోధన ఇంజిన్ పని చేయకపోవచ్చు. మీరు నమోదు చేసిన కోర్సుల సంఖ్యను పరిమితం చేయాలంటే నమోదు చేయబడిన కోర్సులు మాత్రమే శోధించండి.';
$string['searchallavailablecourses_off'] = 'నమోదు చేయబడిన విద్యా కోర్సులు మాత్రమే శోధించండి';
$string['searchallavailablecourses_on'] = 'యూజర్ యాక్సెస్ చేయవచ్చు అన్ని కోర్సులు లోపల శోధించండి';
$string['searchalldeleted'] = 'అన్ని సూచిక చెయ్యబడిన విషయాలు తొలగించబడ్డాయి';
$string['searchareadisabled'] = 'శోధన ప్రాంతం నిలిపివేయబడింది';
$string['searchareaenabled'] = 'శోధన ప్రాంతం ప్రారంభించబడింది';
$string['searchareas'] = 'శోధన ప్రాంతాలు';
$string['searchdeleteindex'] = 'అన్ని సూచిక చేయబడిన విషయాలు తొలగించండి';
$string['searchengine'] = 'శోధన యంత్రము';
$string['searchindexactions'] = 'ఇండెక్స్ చర్యలు';
$string['searchindexdeleted'] = 'సూచిక తొలగించబడింది';
$string['searchindextime'] = 'సమయ పరిమితిని సూచిస్తుంది';
$string['searchindextime_desc'] = 'క్రొత్త కంటెంట్ పెద్ద మొత్తంలో ఇండెక్స్ చేస్తున్నప్పుడు, ఈ సమయ పరిమితిని చేరుకున్న తరువాత షెడ్యూల్ చేయబడిన పని నిలిపివేయబడుతుంది. ఇది పని పక్కన సారి కొనసాగుతుంది.';
$string['searchindexupdated'] = 'శోధన ఇంజిన్ విషయాలు నవీకరించబడ్డాయి';
$string['searchindexwhendisabled'] = 'డిసేబుల్ ఉన్నప్పుడు సూచిక';
$string['searchindexwhendisabled_desc'] = 'శోధన నిలిపివేయబడినప్పుడు శోధన సూచికను నిర్మించడానికి షెడ్యూల్ చేసిన పనిని అనుమతిస్తుంది. శోధన సౌకర్యం విద్యార్థులకు కనిపించే ముందే ఇండెక్స్ ను నిర్మించాలనుకుంటే ఇది ఉపయోగపడుతుంది.';
$string['searchinsettings'] = 'సెట్టింగుల్లో వెతుకు';
$string['searchlastrun'] = 'చివరి పరుగు (సమయం, # డాక్స్, # రికార్డులు, # విస్మరణలు)';
$string['searchnotavailable'] = 'శోధన అందుబాటులో లేదు';
$string['searchoptions'] = 'శోధన ఎంపికలు';
$string['searchpartial'] = '(ఇంకా పూర్తి సూచిక కాదు)';
$string['searchreindexed'] = 'అన్ని సైట్ కంటెంట్లను రీండ్సెక్సే చేయబడ్డాయి.';
$string['searchreindexindex'] = 'అన్ని సైట్ విషయాలను రీఇండిక్స్ చేయండి';
$string['searchresults'] = 'వెతుకులాట ఫలితాలు';
$string['searchsetupinfo'] = 'సెటప్ను శోధించండి';
$string['searchupdateindex'] = 'ఇండెక్స్ చెయ్యబడిన విషయాలు నవీకరించండి';
$string['sectionerror'] = 'విభాగం లోపం!';
$string['secureforms'] = 'మరొక రూపాంతరంలోని సెక్యూరిటీ ఉపయోగించండి';
$string['security'] = 'భద్రత';
$string['selectdevice'] = 'పరికరాన్ని ఎంచుకోండి';
$string['selectsearchengine'] = 'శోధన ఇంజిన్ను ఎంచుకోండి';
$string['selecttheme'] = '{$a} పరికరం కోసం థీమ్ ఎంచుకోండి .';
$string['server'] = 'సర్వరు';
$string['serverchecks'] = 'సర్వరు పరిశీలనలు';
$string['serverlimit'] = 'సర్వరు పరిమితి';
$string['sessionautostartwarning'] = '<p> సీరియస్ ఆకృతీకరణ లోపం గుర్తించబడింది, సర్వర్ నిర్వాహకుడు తెలియజేయాలి దయచేసి. </ p> <p> సరిగా ఆపరేట్, మూడ్లె నిర్వాహకుడు PHP సెట్టింగులు మార్చే అవసరం. </ p> <p> <code> session.auto_start </ code> తప్పక <code> ఆఫ్ ఈ సెట్టింగ్ <code> php.ini </ code> సవరించడం ద్వారా నియంత్రించబడుతుంది. </ p> <p> </ code> Apache / IIS <br /> ఆకృతీకరణ లేదా <code> .htaccess అమర్చవచ్చు </ code> సర్వర్ లో ఫైల్. </ p>';
$string['sessioncookie'] = 'కూకీ ఆదిపదం';
$string['sessioncookiedomain'] = 'కూకీ డొమెయిను';
$string['sessioncookiepath'] = 'కూకీ పాత్';
$string['sessionhandling'] = 'సెషను నిర్వహణ';
$string['sessiontimeout'] = 'టైమౌటు';
$string['settingfileuploads'] = 'ఫైలు అప్లోడ్, సాధారణ చర్య అవసరమైతే దయచేసి PHP ఆకృతీకరణ లో ఎనేబుల్.';
$string['settingmemorylimit'] = 'తగినంత మెమరీ కనుగొనబడింది,  దయచేసి. PHP సెట్టింగులు లో యెక్కువ మెమొరీను పరిమితి సెట్.';
$string['settingsafemode'] = 'Moodle సురక్షిత రీతిలో పూర్తిగా అనుకూలంగా లేదు, దయచేసి దీనిని ఆపివేయడానికి సర్వర్ నిర్వాహకుడిని అడగండి. సురక్షిత మోడ్ కింద Moodle నడుస్తున్న మద్దతు లేదు,మీరు ఇలా చేస్తే వివిధ సమస్యలను ఆశించాలి.';
$string['setupsearchengine'] = 'సెటప్ సెర్చ్ ఇంజిన్';
$string['showcommentscount'] = 'వ్యాఖ్యల సంఖ్యను చూపించు';
$string['showdetails'] = 'వివరాలు చూపించు';
$string['showuseridentity'] = 'వినియోగదారు గుర్తింపు చూపించండి.';
$string['showuseridentity_desc'] = 'వినియోగదారుల కోసం ఎంచుకోవడం లేదా శోధించడం, మరియు వినియోగదారుల జాబితాలను ప్రదర్శించేటప్పుడు, ఈ ఫీల్డ్స్ వారి పూర్తి పేరుతో పాటు చూపబడవచ్చు. Moodle / site కలిగిన వినియోగదారులకు ఖాళీలను మాత్రమే చూపబడతాయి: viewuseridentity capability; అప్రమేయంగా, ఉపాధ్యాయులు మరియు మేనేజర్లు. (మీరు మీ సంస్థలో తప్పనిసరిగా ఒకటి లేదా రెండు రంగాలను ఎంచుకుంటే ఈ ఐచ్ఛికం చాలా అర్థవంతంగా ఉంటుంది.)';
$string['simplexmlrequired'] = 'SimpleXML PHP ఎక్స్టెన్షన్ ఇప్పుడు మూడ్లె ద్వారా అవసరం.';
$string['sitemailcharset'] = 'క్యారెక్టరు సెట్';
$string['sitemaintenance'] = 'సైట్ నిర్వహణలో ఉన్నాము మరియు ప్రస్తుతం అందుబాటులో లేదు';
$string['sitemaintenancemode'] = 'నిర్వహణ మోడ్';
$string['sitemaintenanceoff'] = 'నిర్వహణ మోడ్ ను అచేతనం చేసాం, సైటు తిరిగి మామూలుగానే పనిచేస్తోంది';
$string['sitemaintenanceon'] = 'మీ సైటు ప్రస్తుతం నిర్వహణ మోడ్ లో ఉంది (నిర్వాహకులు మాత్రమే లాగిన్ కావచ్చు లేదా సైటును వాడవచ్చు)';
$string['sitemaintenanceoncli'] = 'మీ సైట్ CLI నిర్వహణ మోడ్ ప్రస్తుతం, ఏ వెబ్ యాక్సెస్ అనుమతి.';
$string['sitemaintenancewarning'] = 'మీ సైట్ ప్రస్తుతం నిర్వహణ మోడ్లో ఉంది (కేవలం నిర్వాహకులు లాగిన్ చేయగలరు). ఈ సైట్ను సాధారణ ఆపరేషన్కు తిరిగి పంపడానికి, <a href="maintenance.php"> నిర్వహణ మోడ్ను నిలిపివేయండి </a>.';
$string['sitemaintenancewarning2'] = 'మీ సైటు ప్రస్తుతం నిర్వహణ మోడ్ లో ఉంది (నిర్వాహకులు మాత్రమే లాగిన్ కాగలరు). సైటును తిరిగి మామూలు స్థితిలో పెట్టడానికి <a href="{$a}">నిర్వహణ మోడ్ ను అచేతనం చెయ్యండి</a>.';
$string['sitepolicies'] = 'సైటు విధానాలు';
$string['sitepolicy'] = 'సైట్ పాలసీ URL';
$string['sitepolicy_help'] = 'మీరు ఈ సైట్ ను ఉపయోగించే ముందు అన్ని నమోదిత యూజర్లు తప్పక చూడండి మరియు అంగీకరిస్తున్న ఒక సైట్ విధానం ఉంటే, ఇక్కడ URL ను పేర్కొనండి, లేకుంటే ఈ ఫీల్డ్ ను ఖాళీగా వదిలేయండి. ఈ సెట్టింగ్ ఏదైనా పబ్లిక్ URL ను కలిగి ఉంటుంది.';
$string['sitepolicyguest'] = 'అతిథులకు సైట్ పాలసీ URL';
$string['sitepolicyguest_help'] = 'మీరు ఈ సైట్ని ఉపయోగించే ముందు అన్ని అతిథులు తప్పక చూడండి మరియు అంగీకరిస్తున్న సైట్ విధానం ఉంటే, ఇక్కడ URL ని పేర్కొనండి, లేకుంటే ఈ ఫీల్డ్ను ఖాళీ చేయండి. ఈ సెట్టింగ్ ఏదైనా పబ్లిక్ URL ను కలిగి ఉంటుంది. గమనిక: లాగిన్ చేయని వినియోగదారుల ప్రాప్తి ఫోల్డెజిన్ సెట్టింగ్తో నిరోధించబడుతుంది.';
$string['sitepolicyhandler'] = 'సైట్ విధానం హ్యాండ్లర్';
$string['sitepolicyhandler_desc'] = 'సైట్ విధానాలకు వినియోగదారు ఒప్పందాలు నిర్వహించడానికి భాగం ఎంచుకోండి. డిఫాల్ట్ కోర్ హ్యాండ్లర్ రెండు ఇతర సెట్టింగులు \'సైట్పోలసి\' మరియు `సైట్పోలిసైగెస్ట్` ద్వారా నియంత్రించబడే సాధారణ కార్యాచరణను అందిస్తుంది. ప్రత్యామ్నాయ హ్యాండ్లర్లను అదనపు ప్లగిన్లు అందించి, సైట్ పాలసీల మరింత ఆధునిక నియంత్రణను అందిస్తాయి.';
$string['sitepolicyhandlercore'] = 'డిఫాల్ట్ (కోర్)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'ఎంపిక చేసినట్లయితే, సైట్ యొక్క మొదటి పేజీలో ఒక అంశం విభాగం ప్రదర్శించబడుతుంది.';
$string['slasharguments'] = 'స్లాష్ ఆర్గ్యుమెంట్స్ ఉపయోగించండి';
$string['slashargumentswarning'] = 'స్లాష్ వాదనలు ఉపయోగించడం ప్రారంభించబడిందని ఇది సిఫార్సు చేయబడింది. భవిష్యత్తులో అది అవసరం అవుతుంది. మరిన్ని వివరాల కోసం, <a href="https://docs.moodle.org/en/admin/environment/slasharguments"> స్లాష్ వాదనలు ఉపయోగించడం </a> చూడండి.';
$string['smartpix'] = 'స్మార్ట్ PIX శోధన';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP ప్రామాణీకరణ పద్ధతి';
$string['smtpdetail'] = 'ఇమెయిల్ పంపడం కోసం సాధారణ మెయిల్ ట్రాన్స్ఫర్ ప్రోటోకాల్ (SMTP) సెట్టింగులు.';
$string['smtphosts'] = 'SMTP హోస్ట్లు';
$string['smtpmaxbulk'] = 'SMTP సెషన్ లిమిట్';
$string['smtppass'] = 'SMTP పాస్వర్డ్ను';
$string['smtpsecure'] = 'SMTP సెక్యూరిటీ';
$string['smtpuser'] = 'యూజర్ పేరు';
$string['soaprecommended'] = 'ఐచ్ఛిక SOAP పొడిగింపును ఇన్స్టాల్ చేయడం వెబ్ సేవలు మరియు కొన్ని ప్లగిన్లకు ఉపయోగకరంగా ఉంటుంది.';
$string['sort_fullname'] = 'కోర్సు పూర్తి పేరు';
$string['sort_idnumber'] = 'కోర్సు ID సంఖ్య';
$string['sort_shortname'] = 'కోర్సు చిన్న పేరు';
$string['sort_sortorder'] = 'క్రమబద్ధీకరణ క్రమం';
$string['spellengine'] = 'ఇంజిన్ స్పెల్';
$string['spelllanguagelist'] = 'భాష జాబితాలో స్పెల్';
$string['splrequired'] = 'SPL PHP ఎక్స్టెన్షన్ ఇప్పుడు మూడ్లె ద్వారా అవసరం.';
$string['stats'] = 'గణాంకాలు';
$string['statsfirstrun'] = 'గరిష్ట ప్రాసెసింగ్ విరామం';
$string['statsmaxruntime'] = 'హై runtime';
$string['statsmoodleorg'] = 'గణాంకాలు';
$string['statsruntimedays'] = 'డేస్ ప్రక్రియ';
$string['statsruntimestart'] = 'అమలు';
$string['statsuserthreshold'] = 'యూజర్ ప్రవేశ';
$string['stickyblocks'] = 'sticky బ్లాక్స్';
$string['stickyblockscourseview'] = 'కోర్సు పేజీ';
$string['stickyblocksduplicatenotice'] = 'మీరు ఇక్కడ చేర్చిన ఏదైనా బ్లాక్ ఇప్పటికే ఒక నిర్దిష్ట పేజీలో ఉన్నట్లయితే, ఇది నకిలీలో దారి తీస్తుంది. <br /> పిన్ చేయబడిన బ్లాక్ మాత్రమే సవరించలేనిది, నకిలీ ఇప్పటికీ సవరించదగినదిగా ఉంటుంది.';
$string['stickyblocksmymoodle'] = 'నా Moodle';
$string['stickyblockspagetype'] = 'పేజీ రకం ఆకృతీకరించుటకు';
$string['strictformsrequired'] = 'అవసరం ఖాళీలను కఠినమైన ధ్రువీకరణ';
$string['stripalltitletags'] = 'అన్ని సూచించే పేర్ల నుండి HTML టాగ్లు తొలగించు';
$string['supportcontact'] = 'సపోర్ట్ Contact';
$string['supportemail'] = 'తోడ్పాటు ఈమెయిలు';
$string['supportname'] = 'తోడ్పాటు పేరు';
$string['supportpage'] = 'తోడ్పాటు పేజీ';
$string['suspenduser'] = 'యూజర్ ఖాతా సస్పెండ్';
$string['switchlang'] = 'Lang డైరెక్టరీ మారండి';
$string['systempaths'] = 'వ్యవస్థ మార్గాలు';
$string['tablenosave'] = 'పట్టిక మార్పులు పైన స్వయంచాలకంగా సేవ్ చేయబడతాయి.';
$string['tablesnosave'] = 'పట్టిక మార్పులు పైన స్వయంచాలకంగా సేవ్ చేయబడతాయి.';
$string['tabselectedtofront'] = 'టాబ్లతో ఉన్న పట్టికలలో, ప్రస్తుతం ఎంచుకున్న ట్యాబ్తో వరుస ముందు ఉంచాలి';
$string['tabselectedtofronttext'] = 'ముందు ఎంచుకున్న ట్యాబ్ వరుసలో ముందు తీసుకురండి';
$string['task_dbstats'] = 'డేటాబేసు';
$string['task_duration'] = 'వ్యవధి';
$string['task_result'] = 'ఫలితం';
$string['task_result:failed'] = 'విఫలం';
$string['task_starttime'] = 'ప్రారంభ సమయం';
$string['taskanalyticscleanup'] = 'విశ్లేషణలు శుభ్రపరిచేవి';
$string['taskautomatedbackup'] = 'స్వయంచాలక బ్యాకప్';
$string['taskbackupcleanup'] = 'శుభ్రమైన బ్యాకప్ పట్టికలు మరియు లాగ్లను';
$string['taskbadgescron'] = 'అవార్డు Badges';
$string['taskblogcron'] = 'బాహ్య బ్లాగులు సమకాలీకరించండి';
$string['taskcachecleanup'] = 'గడువు ముగిసిన కాష్ ఎంట్రీలు తొలగించు';
$string['taskcachecron'] = 'క్యాచీలు కోసం background ప్రాసెసింగ్';
$string['taskcalendarcron'] = 'క్యాలెండర్ ప్రకటనలను పంపండి';
$string['taskcheckforupdates'] = 'నవీకరణల కోసం తనిఖీ';
$string['taskcompletiondaily'] = 'ప్రారంభించిన పూర్తి గుర్తు';
$string['taskcompletionregular'] = 'సాధారణ పూర్తి డేటాను లెక్కించండి';
$string['taskcontextcleanup'] = 'శుభ్రపరిచే సందర్భములలో';
$string['taskcreatecontexts'] = 'తప్పిపోయిన సందర్భాలలో సృష్టించు';
$string['taskdeletecachetext'] = 'పాత టెక్స్ట్ కాష్ రికార్డులు తొలగించు';
$string['taskdeleteincompleteusers'] = 'అసంపూర్ణమైన వినియోగదారులను తొలగించండి';
$string['taskdeleteunconfirmedusers'] = 'ధ్రువీకరించని వినియోగదారులను తొలగించండి';
$string['taskeventscron'] = 'ఈవెంట్స్ కోసం background ప్రాసెసింగ్';
$string['taskfiletrashcleanup'] = 'శుభ్రపరిచే ఫైళ్ళను  శుభ్రపరచడం.';
$string['taskglobalsearchindex'] = 'గ్లోబల్ సెర్చ్ ఇండెక్సింగ్';
$string['taskglobalsearchoptimize'] = 'ప్రపంచ శోధన సూచిక ఆప్టిమైజేషన్';
$string['taskgradecron'] = 'Gradebook కోసం నేపధ్యం ప్రాసెసింగ్';
$string['tasklegacycron'] = 'ప్లగిన్లు లెగసీ క్రాన్ ప్రాసెసింగ్';
$string['taskmessagingcleanup'] = 'సందేశ కోసం నేపధ్యం ప్రాసెసింగ్';
$string['taskpasswordresetcleanup'] = 'శుభ్రపరిచే పాస్వర్డ్ను రీసెట్ ప్రయత్నాలు';
$string['taskplagiarismcron'] = 'Plagiarism ప్లగిన్లు background ప్రాసెసింగ్';
$string['taskportfoliocron'] = 'పోర్ట్ఫోలియో ప్లగిన్లు background ప్రాసెసింగ్';
$string['taskquestioncron'] = 'ప్రశ్న ఇంజిన్ కోసం background ప్రాసెసింగ్';
$string['taskrefreshsystemtokens'] = 'సర్వీస్ ఖాతాల కోసం OAuth టోకెన్లను రిఫ్రెష్ చేయండి';
$string['taskregistrationcron'] = 'సైట్ నమోదు';
$string['tasksendfailedloginnotifications'] = 'లాగిన్ విఫలమైంది ప్రకటనలను పంపండి';
$string['tasksendnewuserpasswords'] = 'కొత్త యూజర్ పాస్వర్డ్లను పంపండి';
$string['tasksessioncleanup'] = 'శుభ్రపరిచే పాత సెషన్స్';
$string['taskstatscron'] = 'గణాంకాలు నేపథ్య ప్రాసెసింగ్';
$string['tasktagcron'] = 'టాగ్లు కోసం నేపధ్యం ప్రాసెసింగ్';
$string['tasktempfilecleanup'] = 'కాలం చెల్లిన తాత్కాలిక ఫైళ్లను తొలగించు';
$string['tempdatafoldercleanup'] = 'తాత్కాలిక డేటా ఫైళ్లు కంటే పాత శుభ్రపరచండి';
$string['testsiteupgradewarning'] = 'మీరు ప్రస్తుతం అది సరిగా కమాండ్ లైన్ ఇంటర్ఫేస్ సాధనం ఉపయోగించడానికి అప్గ్రేడ్, {$ a} పరీక్ష సైట్ ఉపయోగించి';
$string['themedesignermode'] = 'థీమ్ డిజైనర్ మోడ్';
$string['themedesignermodewarning'] = 'థీమ్ డిజైనర్ మోడ్ ప్రారంభించబడింది. ఇది పనితీరును గణనీయంగా తగ్గిస్తుంది కాబట్టి ఇది ఉత్పత్తి సైట్లలో ప్రారంభించబడదు.';
$string['themelist'] = 'థీమ్ జాబితా';
$string['themenoselected'] = 'ఎంచుకోబడలేదు థీమ్';
$string['themeresetcaches'] = 'స్పష్టమైన థీమ్ క్యాచీలు';
$string['themeselect'] = 'థీమ్ మార్చు';
$string['themeselector'] = 'థీమ్ సెలెక్టర్';
$string['themesettings'] = 'థీము సెట్టింగులు';
$string['therewereerrors'] = 'మీ డేటాలో దోషాలు  ఉన్నాయి';
$string['thirdpartylibrary'] = 'గ్రంధాలయం';
$string['thirdpartylibrarylocation'] = 'స్థానాన్ని';
$string['thirdpartylibs'] = 'మూడవ పక్ష లైబ్రరీలను';
$string['timezone'] = 'డిఫాల్టు సమయ మండలం';
$string['timezoneforced'] = 'ఈ సైట్ నిర్వాహకుడు ద్వారా బలవంతంగా.';
$string['timezoneinvalid'] = 'చెల్లని టైమ్జోన్ "{$ a}"';
$string['timezoneisforcedto'] = 'అన్ని వినియోగదారులను బలవంతంగా ఉపయోగించాలి.';
$string['timezonenotforced'] = 'వాడుకరులు తమ స్వంత సమయ మండలాన్ని ఎంచుకోవచ్చు';
$string['timezonephpdefault'] = 'డిఫాల్ట్ PHP సమయ మండలిని ({$ a})';
$string['timezoneserver'] = 'సర్వర్ సమయ మండలిని ({$ a})';
$string['tlswarning'] = 'TLSv1.2 తో ఏ PHP/cURL పొడిగింపు మద్దతు కనుగొనబడలేదు. కొన్ని సేవలు పనిచేయకపోవచ్చు. ఇది మీ TLS లైబ్రరీలను అప్గ్రేడ్ చేయడానికి సిఫార్సు చేయబడింది.';
$string['tokenduration'] = 'వాడుకరి సృష్టించిన టోకెన్ వ్యవధి';
$string['tokenduration_desc'] = 'వినియోగదారుని వెబ్ సేవ టోకెన్ సృష్టించిన సమయం (మొబైల్ అనువర్తనం ద్వారా ఉదాహరణకు) చెల్లుబాటు అవుతుంది.';
$string['tokenizerrecommended'] = 'ఐచ్ఛిక PHP టోకెనైజర్ పొడిగింపును ఇన్స్టాల్ చేయడం సిఫార్సు చేయబడింది - ఇది Moodle నెట్వర్కింగ్ కార్యాచరణను మెరుగుపరుస్తుంది.';
$string['tools'] = 'అడ్మిన్ టూల్స్';
$string['toolsmanage'] = 'అడ్మిన్ టూల్స్ నిర్వహించండి';
$string['unattendedoperation'] = 'గమనింపబడని ఆపరేషన్';
$string['unbookmarkthispage'] = 'ఈ పేజీ Unbookmark';
$string['unicoderequired'] = 'యునికోడ్ ఫార్మాట్లో (యుటిఎఫ్ -8) మీ మొత్తం డేటాను మీరు నిల్వ చేయాల్సిన అవసరం ఉంది. కొత్త సంస్థాపనలు తప్పనిసరిగా యూనికోడ్గా వారి డిఫాల్ట్ అక్షర సమితిని కలిగి ఉన్న డేటాబేస్లలో ప్రదర్శించబడాలి. మీరు అప్గ్రేడ్ చేస్తే, మీరు UTF-8 మైగ్రేషన్ ప్రాసెస్ ను జరపాలి (అడ్మిన్ పేజీ చూడండి).';
$string['uninstallplugin'] = 'స్థాపనను తొలగించు';
$string['unlockaccount'] = 'ఖాతా అన్లాక్';
$string['unoconvwarning'] = 'మీరు ఇన్స్టాల్ చేసిన అన్కొన్ యొక్క సంస్కరణకు మద్దతు లేదు.';
$string['unsettheme'] = 'అన్సెట్ థీమ్';
$string['unsupported'] = 'అనుకూలత లేదు';
$string['unsupporteddbfileformat'] = 'మీ డేటాబేస్ ఫైల్ ఆకృతి వలె యాంటెలోప్ని ఉపయోగిస్తుంది. MySQL మరియు MariaDB లలో పూర్తి UTF-8 మద్దతు Barracuda ఫైల్ ఫార్మాట్ అవసరం. దయచేసి బార్కాడు ఫైల్ ఫార్మాట్కు మారండి. వివరాల కోసం డాక్యుమెంటేషన్ <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql పూర్తి యూనికోడ్ మద్దతు.> MySQL పూర్తి యూనికోడ్ మద్దతు </a> ను చూడండి.';
$string['unsupporteddbfilepertable'] = 'UTF-8 యొక్క పూర్తి మద్దతు కోసం MySQL మరియు MariaDB రెండింటిని మీ \'MySQL\' సెట్టింగు \'innodb_file_per_table\' కు \'ఆన్\' కు మార్చవలెను. మరింత వివరాల కొరకు డాక్యుమెంటేషన్ చూడండి.';
$string['unsupporteddblargeprefix'] = 'UTF-8 యొక్క పూర్తి మద్దతు కోసం MySQL మరియు MariaDB రెండింటిని మీ MySQL సెట్టింగు \'Innodb_large_prefix\' కు \'ON\' కు మార్చాలని మీరు కోరుతున్నారు. మరింత వివరాల కొరకు డాక్యుమెంటేషన్ చూడండి.';
$string['unsupporteddbstorageengine'] = 'ఉపయోగించబడుతున్న డేటాబేస్ స్టోరేజ్ ఇంజన్ ఇకపై మద్దతు లేదు.';
$string['unsupporteddbtablerowformat'] = 'మీ డేటాబేస్లో ఫైల్ ఫార్మాట్గా యాంటెలోప్ ఉపయోగించి పట్టికలు ఉన్నాయి. పట్టికలు బార్కాకస్ ఫైల్ ఫార్మాట్ కు మార్చాలని మీరు సిఫార్సు చేస్తారు. Barracuda కు InnoDB పట్టికలు మార్చడానికి ఒక సాధనం యొక్క వివరాల కోసం డాక్యుమెంటేషన్ <a href="https://docs.moodle.org/en/cli"> అడ్మినిస్ట్రేషన్ ద్వారా అడ్మినిస్ట్రేషన్ ద్వారా చూడండి.';
$string['unsupportedphpversion7'] = 'PHP వెర్షన్ 7 మద్దతు లేదు.';
$string['unsupportedphpversion71'] = 'PHP వెర్షన్ 7.1 మద్దతు లేదు.';
$string['unsupportedphpversion72'] = 'PHP వెర్షన్ 7.2 మద్దతు లేదు.';
$string['unsuspenduser'] = 'యూజర్ ఖాతా సక్రియం';
$string['updateaccounts'] = 'ఉన్న ఖాతాలను తాజాకరించు';
$string['updateautocheck'] = 'స్వయంచాలకంగా అందుబాటులోని నవీకరణల కోసం తనిఖీ';
$string['updateautocheck_desc'] = 'ప్రారంభించబడితే, మీ సైట్ స్వయంచాలకంగా మూడ్లె కోడ్ మరియు అన్ని అదనపు ప్లగిన్ల కోసం అందుబాటులో ఉన్న నవీకరణల కోసం తనిఖీ చేస్తుంది. కొత్త నవీకరణ అందుబాటులో ఉంటే, సైట్ నిర్వాహకులకు ఒక నోటిఫికేషన్ పంపబడుతుంది.';
$string['updateavailable'] = 'క్రొత్త Moodle వెర్షన్ అందుబాటులో ఉంది!';
$string['updateavailable_moreinfo'] = 'మరింత సమాచారం ...';
$string['updateavailable_release'] = 'Moodle {$ a}';
$string['updateavailable_version'] = 'Version';
$string['updateavailabledetailslink'] = 'మరిన్ని వివరాల కోసం {$a->url} చూడండి';
$string['updateavailableforplugin'] = 'మీ ప్లగిన్లు కొన్ని అందుబాటులో కొత్త వెర్షన్ ఉంది!';
$string['updateavailableinstall'] = 'ఈ అప్డేట్ ఇన్స్టాల్';
$string['updateavailableinstallall'] = 'అందుబాటులోని నవీకరణలను ఇన్స్టాల్ చేయండి ({$a})';
$string['updateavailableinstallallhead'] = 'అందుబాటులో ఉన్న నవీకరణలను సంస్థాపించుట';
$string['updateavailablenot'] = 'మీ మూడ్లె కోడ్ నవీనమై ఉంది!';
$string['updateavailablerecommendation'] = 'అన్ని తాజా భద్రత మరియు బగ్ పరిష్కారాలను పొందడానికి మీరు మీ సైట్ ను తాజా వెర్షన్కు అప్డేట్ చేస్తాం.';
$string['updatecomponent'] = 'కాంపొనెంటును తాజాకరించు';
$string['updateminmaturity'] = 'అవసరమైన కోడ్ పరిపక్వత';
$string['updateminmaturity_desc'] = 'అందుబాటులోని కోడ్ కనీసం ఎంచుకున్న పరిపక్వత స్థాయిని కలిగి ఉంటే మాత్రమే అందుబాటులో ఉన్న నవీకరణల గురించి తెలియజేయండి. వారి కోడ్ పరిపక్వత స్థాయిని ప్రకటించని ప్లగిన్ల కోసం నవీకరణలు ఎల్లప్పుడూ ఈ సెట్టింగ్తో సంబంధం లేకుండా నివేదించబడతాయి.';
$string['updatenotificationfooter'] = 'మీ మూడ్ల సైట్ {$a->siteurl} అందుబాటులో ఉన్న నవీకరణల కోసం స్వయంచాలకంగా తనిఖీ చేయడానికి కాన్ఫిగర్ చేయబడింది. మీరు సైట్ యొక్క నిర్వాహకుడిగా ఈ సందేశాన్ని స్వీకరిస్తున్నారు. అడ్మినిస్ట్రేషన్ బ్లాక్ యొక్క సైట్ నిర్వహణ విభాగంలో అందుబాటులో ఉండే నవీకరణల కోసం స్వయంచాలక తనిఖీలను మీరు డిసేబుల్ చెయ్యవచ్చు. మీరు మీ ప్రాధాన్యతల పేజీ ద్వారా ఈ సందేశాన్ని పంపిణీని అనుకూలీకరించవచ్చు.';
$string['updatenotifications'] = 'నవీకరణ ప్రకటనలను';
$string['updatenotificationsubject'] = 'మూడ్లె నవీకరణలు అందుబాటులో ఉన్నాయి ({$a -> siteurl})';
$string['updatenotifybuilds'] = 'కొత్త ఆధారమై గురించి తెలియజేయి';
$string['updatenotifybuilds_desc'] = 'ప్రారంభించబడి ఉంటే, ప్రస్తుత వెర్షన్ కోసం కొత్త బిల్డ్ అందుబాటులో ఉన్నప్పుడు మూడ్లె కోడ్ కోసం అందుబాటులో ఉన్న నవీకరణ కూడా నివేదించబడింది. ఇచ్చిన మూడ్ల వెర్షన్ యొక్క బిల్డ్స్ నిరంతర మెరుగుదలలు. వారు సాధారణంగా ప్రతి వారం విడుదల చేస్తారు. నిలిపివేస్తే, అందుబాటులో ఉన్న నవీకరణ మూడ్లె విడుదల యొక్క అధిక సంస్కరణ ఉన్నప్పుడే నివేదించబడుతుంది. ప్లగ్ఇన్ల కోసం తనిఖీలు ఈ సెట్టింగ్చే ప్రభావితం కావు.';
$string['upgradeerror'] = '{$a->version} కు {$a->plugin} అప్గ్రేడ్ తెలియని లోపం, కొనసాగుతుంది.';
$string['upgradeforumread'] = 'చదవని / చదవని ఫోరమ్ పోస్టులను ట్రాక్ చెయ్యడానికి Moodle 1.5 లో ఒక క్రొత్త ఫీచర్ జతచేయబడింది. <br /> ఈ కార్యాచరణను ఉపయోగించడానికి <a href="{$a}"> మీ పట్టికలను నవీకరించండి </a>.';
$string['upgradeforumreadinfo'] = 'రీడ్ / చదవని ఫోరమ్ పోస్టులను ట్రాక్ చేయడానికి ఒక కొత్త ఫీచర్ మూడ్లె 1.5 లో జతచేయబడింది. ఈ కార్యాచరణను ఉపయోగించడానికి మీరు ఇప్పటికే ఉన్న పోస్ట్ల కోసం అన్ని ట్రాకింగ్ సమాచారాన్ని మీ పట్టికలు అప్డేట్ చేయాలి. మీ సైట్ యొక్క పరిమాణంపై ఆధారపడి ఇది చాలా సమయం పడుతుంది (గంటలు) మరియు చాలా డేటాబేస్లో పన్ను విధించగలదు, కాబట్టి ఇది ఒక నిశ్శబ్ద కాలంలో దీన్ని ఉత్తమం. అయితే, మీ సైట్ ఈ నవీకరణ సమయంలో పనితీరును కొనసాగిస్తుంది మరియు వినియోగదారులు ప్రభావితం కాదు. మీరు ఈ ప్రక్రియను ప్రారంభించిన తర్వాత దానిని పూర్తి చెయ్యనివ్వండి (మీ బ్రౌజర్ విండోను తెరిచి ఉంచండి). అయితే, మీరు విండోను మూసివేయడం ద్వారా ప్రాసెస్ని ఆపినట్లయితే: చింతించకండి, మీరు ప్రారంభించవచ్చు. <br /> <br /> మీరు అప్గ్రేడ్ ప్రక్రియను ప్రారంభించాలనుకుంటున్నారా?';
$string['upgradekeyreq'] = 'అప్గ్రేడ్ కీ అవసరం';
$string['upgradekeyset'] = 'అప్గ్రేడ్ కీ (ఇది సెట్ చేయకుండా ఖాళీగా వదలండి)';
$string['upgradelogs'] = 'పూర్తి కార్యాచరణ కోసం, మీ పాత లాగ్లను అప్గ్రేడ్ చేయాలి. <a href="{$a}"> మరింత సమాచారం </a>';
$string['upgradelogsinfo'] = 'లాగ్లను నిల్వ చేయడంలో ఇటీవల చేసిన కొన్ని మార్పులు ఇటీవల జరిగింది. మీ పాత లాగ్లను ఒక్కొక్క కార్యాచరణ ఆధారంగా వీక్షించడానికి, మీ పాత లాగ్లను అప్గ్రేడ్ చేయాలి. మీ సైట్ మీద ఆధారపడి ఇది చాలా సమయం పట్టవచ్చు (ఉదా. అనేక గంటలు) మరియు చాలా పెద్ద సైట్ల కోసం డేటాబేస్లో చాలా పన్ను వేయవచ్చు. మీరు ఈ ప్రక్రియను ప్రారంభించిన తర్వాత దానిని పూర్తి చెయ్యనివ్వాలి (బ్రౌజర్ విండో ఓపెన్ ఉంచడం ద్వారా). చింతించకండి - లాగ్లను అప్గ్రేడ్ చేస్తున్నప్పుడు మీ సైట్ ఇతర వ్యక్తుల కోసం జరిమానా చేస్తుంది. <br /> <br /> మీరు ఇప్పుడు మీ లాగ్లను అప్గ్రేడ్ చేయాలనుకుంటున్నారా?';
$string['upgradepluginsfirst'] = 'ఇది మొదటి అన్ని అందుబాటులో నవీకరణలను ఇన్స్టాల్ మద్దతిస్తుంది';
$string['upgradepluginsinfo'] = 'ప్లగిన్లు నవీకరిస్తోంది';
$string['upgradepluginsinfo_help'] = 'మీ ప్లగిన్లలో కొన్నింటికి నవీకరణలు అందుబాటులో ఉన్నాయి. మూడ్లె డేటాబేస్ను అప్గ్రేడ్ చేయడానికి ముందు మీరు వాటిని అన్నిటినీ ఇన్స్టాల్ చేయాలి. మీ సైట్ ఆటోమేటిక్ అప్డేట్ విస్తరణకు మద్దతు ఇవ్వకపోతే, మీరు మీ సర్వర్ వద్ద మానవీయంగా కొత్త ప్లగ్ఇన్ సంస్కరణలను డౌన్లోడ్ చేసి ఇన్స్టాల్ చేసుకోవాలి.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'కొత్త సెట్టింగులు';
$string['upgradesettingsintro'] = 'మీ చివరి Moodle నవీకరణ సమయంలో దిగువ చూపిన సెట్టింగ్లు జోడించబడ్డాయి. డిఫాల్ట్లకు అవసరమైన మార్పులను చేసి, ఆపై & quot; మార్పులను సేవ్ చెయ్యి & quot; ఈ పేజీ దిగువన ఉన్న బటన్.';
$string['upgradestalefiles'] = 'కనుగొనబడింది మిక్స్డ్ మూడ్లె వెర్షన్లు నవీకరణ కొనసాగించలేదు';
$string['upgradestalefilesinfo'] = 'మూడ్లె కనీసం రెండు ప్రధాన వెర్షన్లు నుండి PHP స్క్రిప్ట్స్ మూడ్లె డైరెక్టరీ గుర్తించడమైనది ఎందుకంటే మూడ్లె నవీకరణ ప్రక్రియ పాజ్ చేయబడింది.

ఈ తరువాత ముఖ్యమైన సమస్యలు కారణం, అందువల్ల మూడ్లె డైరెక్టరీ మూడ్లె యొక్క ఒక వెర్షన్ కోసం మాత్రమే ఫైళ్లను కలిగి ఉండేలా చేయాలి మీరు కొనసాగించడానికి చేయవచ్చు.

క్రింది మీ మూడ్లె డైరెక్టరీ శుభ్రం చేయడానికి సిఫార్సు మార్గం:

* "Moodle_old" ప్రస్తుత మూడ్లె డైరెక్టరీ పేరు
* ఒక ప్రామాణిక మూడ్లె ప్యాకేజీ డౌన్లోడ్ గాని నుండి మాత్రమే ఫైళ్లు ఉన్న ఒక కొత్త మూడ్లె డైరెక్టరీ సృష్టించడానికి లేదా మూడ్లె Git రిపోజిటరీ నుండి
* కొత్త మూడ్లె డైరెక్టరీ "moodle_old" డైరెక్టరీ నుండి అసలు config.php ఫైల్ మరియు ప్రామాణికం కాని ప్లగిన్లు తరలించడానికి

మీరు ఒక క్లీన్ మూడ్లె డైరెక్టరీ ఉన్నప్పుడు, మూడ్లె నవీకరణ ప్రక్రియ పునఃప్రారంభించడానికి ఈ పేజీ రిఫ్రెష్.

ఈ హెచ్చరికను తరచుగా మూడ్లె యొక్క మునుపటి వెర్షన్ కంటే ఒక ప్రామాణిక మూడ్లె ప్యాకేజీ అన్జిప్ చేయడానికి కలుగుతుంది. ఈ చిన్న నవీకరణలు సరే అయితే, అది గట్టిగా ప్రధాన మూడ్లె నవీకరణలు కోసం ప్రోత్సహించరు.

ఈ హెచ్చరికను కూడా మీరు కేవలం ఆపరేషన్ పూర్తి కోసం వేచి, లేదా బహుశా తగిన శుభ్రంగా అప్ ఆదేశం అమలు మరియు ఆపరేషన్ను తిరిగి ఉండవచ్చు సందర్భంలో Git రిపోజిటరీ నుండి అసంపూర్ణ చెక్అవుట్ లేదా నవీకరణ ఆపరేషన్ ద్వారా కలుగుతుంది.

మీరు <a href="{$a}"> {$ a} </a> వద్ద నవీకరణ డాక్యుమెంటేషన్ మరింత సమాచారాన్ని పొందవచ్చు.';
$string['upgradestart'] = 'ఇప్పుడు Moodle డేటాబేస్ అప్గ్రేడ్';
$string['upgradesure'] = '<p> మీ Moodle ఫైళ్లు మార్చబడ్డాయి, మరియు మీరు మీ సర్వర్ను ఈ సంస్కరణకు స్వయంచాలకంగా అప్గ్రేడ్ చేయబోతున్నారు: </ p>
<P> <strong> {$ a} </ strong> </ p>
<p> ఒకసారి మీరు దీన్ని తిరిగి చేయలేరు. దయచేసి ఈ ప్రక్రియ చాలా కాలం పట్టవచ్చని గమనించండి. </ P>
<p> మీరు ఈ సర్వర్ను ఈ సంస్కరణకు అప్గ్రేడ్ చేయాలనుకుంటున్నారా? </ p>';
$string['upgradetimedout'] = 'ఉన్నతీకరణ టైమౌటయింది, మళ్ళీ మొదలెట్టండి.';
$string['upgradingdata'] = 'డేటాను ఉన్నతీకరిస్తున్నాం';
$string['upgradinglogs'] = 'లాగ్‍లను ఉన్నతీకరిస్తున్నాం';
$string['upgradingversion'] = 'కొత్త వెర్షనుకు ఉన్నతీకరిస్తున్నాం';
$string['upwards'] = 'నుండి';
$string['useblogassociations'] = 'అసోసియేషన్లు ఎనేబుల్ చెయ్యి';
$string['user'] = 'వాడుకరి';
$string['userbulk'] = 'మూకుమ్మడి వాడుకరి చర్యలు';
$string['userbulkdownload'] = 'వినియోగదారులను ఎగుమతి చేయండి';
$string['userdefaultpreferences'] = 'వినియోగదారు డిఫాల్ట్ ప్రాధాన్యతలను';
$string['userimagesdisabled'] = 'ప్రొఫైల్ వినియోగదారు చిత్రాలు డిసేబుల్ చెయ్యబడ్డాయి';
$string['userlist'] = 'వాడుకరుల జాబితాను శోధించు';
$string['userpolicies'] = 'వాడుకరి విధానాలు';
$string['userpreference'] = 'వాడుకరి అభిరుచి';
$string['userquota'] = 'వాడుకరి కోటా';
$string['users'] = 'వాడుకరులు';
$string['usesitenameforsitepages'] = 'సైట్ పేజీలకు సైట్ పేరు ఉపయోగించండి';
$string['usetags'] = 'ట్యాగు విశేషాన్ని చేతనం చెయ్యి';
$string['validateemptylineerror'] = 'ఖాళీ పంక్తులు చెల్లవు';
$string['validateerror'] = 'ఈ విలువ సరైనది కాదు:';
$string['validateerrorlist'] = 'ఈ ఎంట్రీలు చెల్లవు: {$a}';
$string['validateiperror'] = 'ఈ IP చిరునామాలు చెల్లవు: {$a}';
$string['verifychangedemail'] = 'ఈమెయిలు మార్చేటపుడు డొమెయిన్లను నియంత్రించు';
$string['warningcurrentsetting'] = 'తప్పుడు వర్తమాన విలువ: {$a}';
$string['warningiconvbuggy'] = 'ఐకాన్వీ లైబ్రరీ యొక్క మీ వెర్షన్ // IGNORE సవరణను మద్దతు ఇవ్వదు. మీరు చెల్లని UTF-8 అక్షరాలను కలిగిన తీగలను శుద్ధి చేయడానికి బదులుగా ఉపయోగించగల mbstring పొడిగింపును ఇన్స్టాల్ చేయాలి.';
$string['webproxy'] = 'వెబ్ ప్రాక్సీ';
$string['webproxyinfo'] = '';
$string['yuicomboloading'] = 'YUI కాంబో లోడ్';
$string['ziprequired'] = 'Zip PHP ఎక్స్టెన్షన్ ఇప్పుడు మూడ్లె అవసరాలకోసం, సమాచార జిప్ బైనరీలు లేదా PclZip లైబ్రరీ ఇకపై ఉపయోగించరు.';
